/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.discovery;

import com.google.api.server.spi.Client;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigWriter;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.discovery.AbstractDiscoveryProvider;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.services.discovery.Discovery;
import com.google.api.services.discovery.model.ApiConfig;
import com.google.api.services.discovery.model.ApiConfigs;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.api.services.discovery.model.RpcDescription;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;

public class ProxyingDiscoveryProvider
extends AbstractDiscoveryProvider {
    private final ApiConfigWriter configWriter;
    private final Discovery discovery;

    public ProxyingDiscoveryProvider(ImmutableList<com.google.api.server.spi.config.model.ApiConfig> apiConfigs, ApiConfigWriter configWriter) {
        this(apiConfigs, configWriter, ProxyingDiscoveryProvider.createDiscovery());
    }

    public ProxyingDiscoveryProvider(ImmutableList<com.google.api.server.spi.config.model.ApiConfig> apiConfigs, ApiConfigWriter configWriter, Discovery discovery) {
        super(apiConfigs);
        this.configWriter = configWriter;
        this.discovery = discovery;
    }

    @Override
    public RestDescription getRestDocument(String root, String name, String version) throws NotFoundException, InternalServerErrorException {
        try {
            return (RestDescription)((Object)this.discovery.apis().generateRest(new ApiConfig().setConfig(this.getApiConfigStringWithRoot(this.getApiConfigs(name, version), root))).execute());
        }
        catch (ApiConfigException | IOException e) {
            logger.log(Level.SEVERE, "Could not generate or cache discovery doc", e);
            throw new InternalServerErrorException("Internal Server Error", (Throwable)e);
        }
    }

    @Override
    public RpcDescription getRpcDocument(String root, String name, String version) throws NotFoundException, InternalServerErrorException {
        try {
            return (RpcDescription)((Object)this.discovery.apis().generateRpc(new ApiConfig().setConfig(this.getApiConfigStringWithRoot(this.getApiConfigs(name, version), root))).execute());
        }
        catch (ApiConfigException | IOException e) {
            logger.log(Level.SEVERE, "Could not generate or cache discovery doc", e);
            throw new InternalServerErrorException("Internal Server Error", (Throwable)e);
        }
    }

    @Override
    public DirectoryList getDirectory(String root) throws InternalServerErrorException {
        try {
            Map<ApiKey, String> configStrings = this.configWriter.writeConfig(ProxyingDiscoveryProvider.rewriteConfigsWithRoot(this.getAllApiConfigs(), root));
            ApiConfigs configs = new ApiConfigs();
            configs.setConfigs(Lists.newArrayList(configStrings.values()));
            return (DirectoryList)((Object)this.discovery.apis().generateDirectory(configs).execute());
        }
        catch (ApiConfigException | IOException e) {
            logger.log(Level.SEVERE, "Could not generate or cache directory", e);
            throw new InternalServerErrorException("Internal Server Error", (Throwable)e);
        }
    }

    private String getApiConfigStringWithRoot(ImmutableList<com.google.api.server.spi.config.model.ApiConfig> configs, String root) throws InternalServerErrorException, ApiConfigException {
        Map<ApiKey, String> configMap = this.configWriter.writeConfig(ProxyingDiscoveryProvider.rewriteConfigsWithRoot(configs, root));
        if (configMap.size() != 1) {
            logger.severe("config generation yielded more than one API");
            throw new InternalServerErrorException("Internal Server Error");
        }
        return (String)Iterables.getFirst(configMap.values(), null);
    }

    private static Discovery createDiscovery() {
        Client client = Client.getInstance();
        return new Discovery.Builder(client.getHttpTransport(), client.getJsonFactory(), null).build();
    }
}

