/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.config.model.Types;
import com.google.api.server.spi.types.DateAndTime;
import com.google.api.server.spi.types.SimpleDate;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;

public enum FieldType {
    STRING("string", null, "String"),
    INT8("integer", null, "Byte"),
    INT16("integer", null, "Short"),
    INT32("integer", "int32", "Integer"),
    INT64("string", "int64", "Long"),
    FLOAT("number", "float", "Float"),
    DOUBLE("number", null, "Double"),
    DATE("string", "date", "Date"),
    DATE_TIME("string", "date-time", "DateTime"),
    BOOLEAN("boolean", null, "Boolean"),
    BYTE_STRING("string", "byte", "Bytes"),
    ENUM("string", null, null),
    OBJECT("object", null, null),
    ARRAY("array", null, null);

    private final String discoveryType;
    private final String discoveryFormat;
    private final String collectionName;
    private static final ImmutableMap<Type, FieldType> TYPE_MAP;

    private FieldType(String discoveryType, String discoveryFormat, String collectionName) {
        this.discoveryType = discoveryType;
        this.discoveryFormat = discoveryFormat;
        this.collectionName = collectionName;
    }

    public String getDiscoveryType() {
        return this.discoveryType;
    }

    public String getDiscoveryFormat() {
        return this.discoveryFormat;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public static FieldType fromType(TypeToken<?> type) {
        FieldType ft = (FieldType)((Object)TYPE_MAP.get((Object)type.getRawType()));
        if (ft != null) {
            return ft;
        }
        if (Types.getArrayItemType(type) != null) {
            return ARRAY;
        }
        if (Types.isEnumType(type)) {
            return ENUM;
        }
        return OBJECT;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder().put(String.class, (Object)STRING).put(Short.class, (Object)INT16).put(Short.TYPE, (Object)INT16).put(Byte.class, (Object)INT8).put(Byte.TYPE, (Object)INT8).put(Character.class, (Object)STRING).put(Character.TYPE, (Object)STRING).put(Integer.class, (Object)INT32).put(Integer.TYPE, (Object)INT32).put(Long.class, (Object)INT64).put(Long.TYPE, (Object)INT64).put(Float.class, (Object)FLOAT).put(Float.TYPE, (Object)FLOAT).put(Double.class, (Object)DOUBLE).put(Double.TYPE, (Object)DOUBLE).put(Boolean.class, (Object)BOOLEAN).put(Boolean.TYPE, (Object)BOOLEAN).put(Date.class, (Object)DATE_TIME).put(DateAndTime.class, (Object)DATE_TIME).put(SimpleDate.class, (Object)DATE).put(byte[].class, (Object)BYTE_STRING);
        try {
            builder.put(FieldType.class.getClassLoader().loadClass("com.google.appengine.api.datastore.Blob"), (Object)BYTE_STRING);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        TYPE_MAP = builder.build();
    }
}

