/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.config.ApiConfigInconsistency;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiFrontendLimitsConfig {
    private int unregisteredUserQps;
    private int unregisteredQps;
    private int unregisteredDaily;
    private final Map<String, FrontendLimitsRule> rules;

    public ApiFrontendLimitsConfig() {
        this.rules = new LinkedHashMap<String, FrontendLimitsRule>();
        this.setDefaults();
    }

    public ApiFrontendLimitsConfig(ApiFrontendLimitsConfig original) {
        this.unregisteredUserQps = original.unregisteredUserQps;
        this.unregisteredQps = original.unregisteredQps;
        this.unregisteredDaily = original.unregisteredDaily;
        this.rules = new LinkedHashMap<String, FrontendLimitsRule>(original.rules);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiFrontendLimitsConfig) {
            ApiFrontendLimitsConfig config = (ApiFrontendLimitsConfig)o;
            return Iterables.isEmpty(this.getConfigurationInconsistencies(config));
        }
        return false;
    }

    public Iterable<ApiConfigInconsistency<Object>> getConfigurationInconsistencies(ApiFrontendLimitsConfig config) {
        return ApiConfigInconsistency.listBuilder().addIfInconsistent("frontendLimits.unregisteredUserQps", this.unregisteredUserQps, config.unregisteredUserQps).addIfInconsistent("frontendLimits.unregisteredQps", this.unregisteredQps, config.unregisteredQps).addIfInconsistent("frontendLimits.unregisteredDaily", this.unregisteredDaily, config.unregisteredDaily).addIfInconsistent("frontendLimits.rules", this.rules, config.rules).build();
    }

    public int hashCode() {
        return Objects.hash(this.unregisteredUserQps, this.unregisteredQps, this.unregisteredDaily, this.rules);
    }

    protected void setDefaults() {
        this.unregisteredUserQps = -1;
        this.unregisteredQps = -1;
        this.unregisteredDaily = -1;
    }

    public void setUnregisteredUserQps(int unregisteredUserQps) {
        this.unregisteredUserQps = unregisteredUserQps;
    }

    public int getUnregisteredUserQps() {
        return this.unregisteredUserQps;
    }

    public void setUnregisteredQps(int unregisteredQps) {
        this.unregisteredQps = unregisteredQps;
    }

    public int getUnregisteredQps() {
        return this.unregisteredQps;
    }

    public void setUnregisteredDaily(int unregisteredDaily) {
        this.unregisteredDaily = unregisteredDaily;
    }

    public int getUnregisteredDaily() {
        return this.unregisteredDaily;
    }

    public void addRule(String match, int qps, int userQps, int daily, String analyticsId) {
        this.rules.put(match, new FrontendLimitsRule(match, qps, userQps, daily, analyticsId));
    }

    public List<FrontendLimitsRule> getRules() {
        return new ArrayList<FrontendLimitsRule>(this.rules.values());
    }

    public static class FrontendLimitsRule {
        private final String match;
        private final int qps;
        private final int userQps;
        private final int daily;
        private final String analyticsId;

        public FrontendLimitsRule(String match, int qps, int userQps, int daily, String analyticsId) {
            this.match = match;
            this.qps = qps;
            this.userQps = userQps;
            this.daily = daily;
            this.analyticsId = analyticsId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FrontendLimitsRule) {
                FrontendLimitsRule rule = (FrontendLimitsRule)o;
                return Objects.equals(this.match, rule.match) && this.qps == rule.qps && this.userQps == rule.userQps && this.daily == rule.daily && Objects.equals(this.analyticsId, rule.analyticsId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.match, this.qps, this.userQps, this.daily, this.analyticsId);
        }

        public String getMatch() {
            return this.match;
        }

        public int getQps() {
            return this.qps;
        }

        public int getUserQps() {
            return this.userQps;
        }

        public int getDaily() {
            return this.daily;
        }

        public String getAnalyticsId() {
            return this.analyticsId;
        }
    }
}

