/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.jsonwriter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigWriter;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.jsonwriter.JacksonResourceSchemaProvider;
import com.google.api.server.spi.config.jsonwriter.ResourceSchemaProvider;
import com.google.api.server.spi.config.model.ApiAuthConfig;
import com.google.api.server.spi.config.model.ApiCacheControlConfig;
import com.google.api.server.spi.config.model.ApiClassConfig;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiFrontendLimitsConfig;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiNamespaceConfig;
import com.google.api.server.spi.config.model.ApiParameterConfig;
import com.google.api.server.spi.config.model.SchemaRepository;
import com.google.api.server.spi.config.model.Types;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class JsonConfigWriter
implements ApiConfigWriter {
    private static final double DEFAULT_LILY_DEADLINE = 65.0;
    public static final String MAP_SCHEMA_NAME = "JsonMap";
    public static final String ANY_SCHEMA_NAME = "_any";
    private final TypeLoader typeLoader;
    private final ApiConfigValidator validator;
    private final ResourceSchemaProvider resourceSchemaProvider = new JacksonResourceSchemaProvider();
    private static final ObjectMapper objectMapper = ObjectMapperUtil.createStandardObjectMapper();

    public JsonConfigWriter() throws ClassNotFoundException {
        this.typeLoader = new TypeLoader(JsonConfigWriter.class.getClassLoader());
        this.validator = new ApiConfigValidator(this.typeLoader, new SchemaRepository(this.typeLoader));
    }

    public JsonConfigWriter(TypeLoader typeLoader, ApiConfigValidator validator) throws ClassNotFoundException {
        this.typeLoader = typeLoader;
        this.validator = validator;
    }

    @Override
    public Map<ApiKey, String> writeConfig(Iterable<? extends ApiConfig> configs) throws ApiConfigException {
        ImmutableListMultimap apisByKey = Multimaps.index(configs, (Function)new Function<ApiConfig, ApiKey>(){

            public ApiKey apply(ApiConfig config) {
                return config.getApiKey();
            }
        });
        LinkedHashMap results = Maps.newLinkedHashMap();
        for (ApiKey apiKey : apisByKey.keySet()) {
            Collection apiConfigs = apisByKey.get((Object)apiKey);
            this.validator.validate(apiConfigs);
            results.put(apiKey, this.generateForApi(apiConfigs));
        }
        return results;
    }

    @Override
    public String getFileExtension() {
        return "api";
    }

    private String generateForApi(Iterable<? extends ApiConfig> apiConfigs) throws ApiConfigException {
        ObjectNode root = objectMapper.createObjectNode();
        ApiConfig apiConfig = (ApiConfig)Iterables.get(apiConfigs, (int)0);
        this.convertApi(root, apiConfig);
        this.convertApiAuth(root, apiConfig.getAuthConfig());
        this.convertApiFrontendLimits(root, apiConfig.getFrontendLimitsConfig());
        this.convertApiCacheControl(root, apiConfig.getCacheControlConfig());
        this.convertApiNamespace(root, apiConfig.getNamespaceConfig());
        this.convertApiMethods(apiConfigs, root);
        return this.toString(root);
    }

    private String toString(ObjectNode node) throws ApiConfigException {
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
        }
        catch (IOException e) {
            throw new ApiConfigException(e);
        }
    }

    private void setNodePropertyNoConflict(ObjectNode node, String key, JsonNode value, String errorMessage) {
        if (!node.path(key).isMissingNode()) {
            throw new IllegalArgumentException(errorMessage);
        }
        node.set(key, value);
    }

    private void setNodePropertyNoConflict(ObjectNode node, String key, JsonNode value) {
        this.setNodePropertyNoConflict(node, key, value, "Multiple values for same key '" + key + "'");
    }

    private void convertApi(ObjectNode root, ApiConfig config) {
        root.put("extends", this.getParentApiFile());
        root.put("abstract", config.getIsAbstract());
        root.put("root", config.getRoot());
        root.put("name", config.getName());
        if (config.getCanonicalName() != null) {
            root.put("canonicalName", config.getCanonicalName());
        }
        root.put("version", config.getVersion());
        if (config.getTitle() != null) {
            root.put("title", config.getTitle());
        }
        if (config.getDescription() != null) {
            root.put("description", config.getDescription());
        }
        if (config.getDocumentationLink() != null) {
            root.put("documentation", config.getDocumentationLink());
        }
        root.put("defaultVersion", config.getIsDefaultVersion());
        ArrayNode discovery = objectMapper.createArrayNode();
        discovery.add(config.getIsDiscoverable() ? "PUBLIC" : "OFF");
        root.set("discovery", (JsonNode)discovery);
        ObjectNode adapter = objectMapper.createObjectNode();
        adapter.put("bns", config.getBackendRoot());
        adapter.put("deadline", 65.0);
        adapter.put("type", "lily");
        root.set("adapter", (JsonNode)adapter);
    }

    protected String getParentApiFile() {
        return "thirdParty.api";
    }

    private void convertApiAuth(ObjectNode root, ApiAuthConfig config) {
        ObjectNode authConfig = objectMapper.createObjectNode();
        authConfig.put("allowCookieAuth", config.getAllowCookieAuth());
        List<String> blockedRegions = config.getBlockedRegions();
        if (!blockedRegions.isEmpty()) {
            ArrayNode blockedRegionsNode = objectMapper.createArrayNode();
            for (String region : blockedRegions) {
                blockedRegionsNode.add(region);
            }
            authConfig.set("blockedRegions", (JsonNode)blockedRegionsNode);
        }
        root.set("auth", (JsonNode)authConfig);
    }

    private void convertApiFrontendLimits(ObjectNode root, ApiFrontendLimitsConfig config) {
        ObjectNode frontendLimitsConfig = objectMapper.createObjectNode();
        frontendLimitsConfig.put("unregisteredUserQps", config.getUnregisteredUserQps());
        frontendLimitsConfig.put("unregisteredQps", config.getUnregisteredQps());
        frontendLimitsConfig.put("unregisteredDaily", config.getUnregisteredDaily());
        this.convertApiFrontendLimitRules(frontendLimitsConfig, config.getRules());
        root.set("frontendLimits", (JsonNode)frontendLimitsConfig);
    }

    private void convertApiCacheControl(ObjectNode root, ApiCacheControlConfig config) {
        ObjectNode cacheControlConfig = objectMapper.createObjectNode();
        cacheControlConfig.put("type", config.getType());
        cacheControlConfig.put("maxAge", config.getMaxAge());
        root.set("cacheControl", (JsonNode)cacheControlConfig);
    }

    private void convertApiNamespace(ObjectNode root, ApiNamespaceConfig config) {
        if (!config.getOwnerDomain().isEmpty()) {
            root.put("ownerDomain", config.getOwnerDomain());
        }
        if (!config.getOwnerName().isEmpty()) {
            root.put("ownerName", config.getOwnerName());
        }
        if (!config.getPackagePath().isEmpty()) {
            root.put("packagePath", config.getPackagePath());
        }
    }

    private void convertApiFrontendLimitRules(ObjectNode frontendLimitsConfig, List<ApiFrontendLimitsConfig.FrontendLimitsRule> rules) {
        ArrayNode rulesConfig = objectMapper.createArrayNode();
        for (ApiFrontendLimitsConfig.FrontendLimitsRule rule : rules) {
            ObjectNode ruleConfig = objectMapper.createObjectNode();
            ruleConfig.put("match", rule.getMatch());
            ruleConfig.put("qps", rule.getQps());
            ruleConfig.put("userQps", rule.getUserQps());
            ruleConfig.put("daily", rule.getDaily());
            ruleConfig.put("analyticsId", rule.getAnalyticsId());
            rulesConfig.add((JsonNode)ruleConfig);
        }
        frontendLimitsConfig.set("rules", (JsonNode)rulesConfig);
    }

    private void convertApiMethods(Iterable<? extends ApiConfig> configs, ObjectNode root) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ObjectNode methodsNode = objectMapper.createObjectNode();
        ObjectNode descriptorNode = objectMapper.createObjectNode();
        ObjectNode descriptorSchemasNode = objectMapper.createObjectNode();
        ObjectNode descriptorMethodsNode = objectMapper.createObjectNode();
        descriptorNode.set("schemas", (JsonNode)descriptorSchemasNode);
        descriptorNode.set("methods", (JsonNode)descriptorMethodsNode);
        for (ApiConfig apiConfig : configs) {
            this.convertApiMethods(methodsNode, descriptorSchemasNode, descriptorMethodsNode, apiConfig);
        }
        root.set("methods", (JsonNode)methodsNode);
        root.set("descriptor", (JsonNode)descriptorNode);
    }

    private void convertApiMethods(ObjectNode methodsNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodsNode, ApiConfig apiConfig) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ApiClassConfig.MethodConfigMap methodConfigs = apiConfig.getApiClassConfig().getMethods();
        for (Map.Entry methodConfig : methodConfigs.entrySet()) {
            if (((ApiMethodConfig)methodConfig.getValue()).isIgnored()) continue;
            EndpointMethod endpointMethod = (EndpointMethod)methodConfig.getKey();
            ApiMethodConfig config = (ApiMethodConfig)methodConfig.getValue();
            this.convertApiMethod(methodsNode, descriptorSchemasNode, descriptorMethodsNode, endpointMethod, config, apiConfig);
        }
    }

    private void convertApiMethod(ObjectNode methodsNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodsNode, EndpointMethod endpointMethod, ApiMethodConfig config, ApiConfig apiConfig) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ObjectNode methodNode = objectMapper.createObjectNode();
        this.setNodePropertyNoConflict(methodsNode, config.getFullMethodName(), (JsonNode)methodNode);
        methodNode.put("path", config.getPath());
        methodNode.put("description", config.getDescription());
        methodNode.put("httpMethod", config.getHttpMethod());
        methodNode.set("authLevel", (JsonNode)objectMapper.convertValue((Object)config.getAuthLevel(), JsonNode.class));
        methodNode.set("scopes", (JsonNode)objectMapper.convertValue(AuthScopeExpressions.encode(config.getScopeExpression()), JsonNode.class));
        methodNode.set("audiences", (JsonNode)objectMapper.convertValue(config.getAudiences(), JsonNode.class));
        methodNode.set("clientIds", (JsonNode)objectMapper.convertValue(config.getClientIds(), JsonNode.class));
        methodNode.put("rosyMethod", config.getFullJavaName());
        ObjectNode descriptorMethodNode = objectMapper.createObjectNode();
        this.setNodePropertyNoConflict(descriptorMethodsNode, config.getFullJavaName(), (JsonNode)descriptorMethodNode);
        this.convertMethodRequest(endpointMethod, methodNode, descriptorSchemasNode, descriptorMethodNode, config, apiConfig);
        this.convertMethodResponse(endpointMethod, methodNode, descriptorSchemasNode, descriptorMethodNode, config);
    }

    private void convertMethodRequest(EndpointMethod endpointMethod, ObjectNode apiMethodNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiMethodConfig config, ApiConfig apiConfig) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ObjectNode requestNode = objectMapper.createObjectNode();
        this.convertMethodRequestParameters(endpointMethod, requestNode, descriptorSchemasNode, descriptorMethodNode, config, apiConfig);
        apiMethodNode.set("request", (JsonNode)requestNode);
    }

    private void convertMethodRequestParameters(EndpointMethod endpointMethod, ObjectNode requestNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiMethodConfig config, ApiConfig apiConfig) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ObjectNode parametersNode = objectMapper.createObjectNode();
        Method method = endpointMethod.getMethod();
        List<ApiParameterConfig> parameterConfigs = config.getParameterConfigs();
        for (ApiParameterConfig parameterConfig : parameterConfigs) {
            switch (parameterConfig.getClassification()) {
                case INJECTED: {
                    break;
                }
                case API_PARAMETER: {
                    this.convertSimpleParameter(parameterConfig, parametersNode);
                    break;
                }
                case RESOURCE: {
                    this.convertComplexParameter(parameterConfig, method, descriptorSchemasNode, descriptorMethodNode, apiConfig, parameterConfigs);
                    break;
                }
                case UNKNOWN: {
                    throw new IllegalArgumentException("Unclassifiable parameter type found.");
                }
            }
        }
        if (parametersNode.size() != 0) {
            requestNode.set("parameters", (JsonNode)parametersNode);
        }
        if (descriptorMethodNode.get("request") != null) {
            requestNode.put("body", "autoTemplate(backendRequest)");
            requestNode.put("bodyName", "resource");
        } else {
            requestNode.put("body", "empty");
        }
    }

    private void convertSimpleParameter(ApiParameterConfig config, ObjectNode parametersNode) {
        TypeToken type;
        ObjectNode parameterNode = objectMapper.createObjectNode();
        if (config.isRepeated()) {
            parameterNode.put("repeated", true);
            type = config.getRepeatedItemSerializedType();
        } else {
            type = config.getSchemaBaseType();
        }
        if (config.isEnum()) {
            ObjectNode enumValuesNode = objectMapper.createObjectNode();
            for (Object enumConstant : type.getRawType().getEnumConstants()) {
                ObjectNode enumNode = objectMapper.createObjectNode();
                enumValuesNode.set(enumConstant.toString(), (JsonNode)enumNode);
            }
            parameterNode.set("enum", (JsonNode)enumValuesNode);
            type = TypeToken.of(String.class);
        }
        parameterNode.put("type", this.typeLoader.getParameterTypes().get(type.getRawType()));
        parameterNode.put("description", config.getDescription());
        parameterNode.put("required", !config.getNullable() && config.getDefaultValue() == null);
        String defaultValue = config.getDefaultValue();
        if (defaultValue != null) {
            Class parameterClass = type.getRawType();
            try {
                objectMapper.convertValue((Object)defaultValue, parameterClass);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid default value for type '%s'", defaultValue, type));
            }
            parameterNode.put("default", defaultValue);
        }
        parametersNode.set(config.getName(), (JsonNode)parameterNode);
    }

    private void convertComplexParameter(ApiParameterConfig config, Method method, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        TypeToken<?> type = config.getSchemaBaseType();
        ObjectNode requestTypeNode = objectMapper.createObjectNode();
        this.addTypeToNode(descriptorSchemasNode, type, null, requestTypeNode, apiConfig, parameterConfigs);
        this.setNodePropertyNoConflict(descriptorMethodNode, "request", (JsonNode)requestTypeNode, "Method " + method.getDeclaringClass().getName() + "." + method.getName() + " cannot have multiple resource parameters");
    }

    private void convertMethodResponse(EndpointMethod serviceMethod, ObjectNode methodNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiMethodConfig config) throws ApiConfigException {
        ObjectNode responseNode = objectMapper.createObjectNode();
        methodNode.set("response", (JsonNode)responseNode);
        if (config.hasResourceInResponse()) {
            responseNode.put("body", "autoTemplate(backendResponse)");
            TypeToken<?> returnType = ApiAnnotationIntrospector.getSchemaType(serviceMethod.getReturnType(), config.getApiClassConfig().getApiConfig());
            descriptorMethodNode.set("response", (JsonNode)this.convertMethodResponseType(descriptorSchemasNode, returnType, config));
        } else {
            responseNode.put("body", "empty");
        }
    }

    private ObjectNode convertMethodResponseType(ObjectNode descriptorSchemasNode, TypeToken<?> returnType, ApiMethodConfig config) throws ApiConfigException {
        ObjectNode returnTypeNode = objectMapper.createObjectNode();
        String responseTypeName = this.addTypeToNode(descriptorSchemasNode, returnType, null, returnTypeNode, config.getApiClassConfig().getApiConfig(), null);
        if (Types.isArrayType(returnType)) {
            ObjectNode propertiesNode = objectMapper.createObjectNode();
            propertiesNode.set("items", (JsonNode)returnTypeNode);
            ObjectNode arrayWrapperNode = objectMapper.createObjectNode();
            arrayWrapperNode.put("id", responseTypeName);
            arrayWrapperNode.put("type", "object");
            arrayWrapperNode.set("properties", (JsonNode)propertiesNode);
            descriptorSchemasNode.set(responseTypeName, (JsonNode)arrayWrapperNode);
            returnTypeNode = objectMapper.createObjectNode();
            returnTypeNode.put("$ref", responseTypeName);
        }
        return returnTypeNode;
    }

    @VisibleForTesting
    String addTypeToSchema(ObjectNode schemasNode, TypeToken<?> type, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        return this.addTypeToSchema(schemasNode, type, null, apiConfig, parameterConfigs);
    }

    @VisibleForTesting
    String addTypeToSchema(ObjectNode schemasNode, TypeToken<?> type, TypeToken<?> enclosingType, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        if (this.typeLoader.isSchemaType(type)) {
            return this.typeLoader.getSchemaType(type);
        }
        if (Types.isObject(type)) {
            if (!schemasNode.has(ANY_SCHEMA_NAME)) {
                ObjectNode anySchema = objectMapper.createObjectNode();
                anySchema.put("id", ANY_SCHEMA_NAME);
                anySchema.put("type", "any");
                schemasNode.set(ANY_SCHEMA_NAME, (JsonNode)anySchema);
            }
            return ANY_SCHEMA_NAME;
        }
        if (Types.isMapType(type)) {
            if (!schemasNode.has(MAP_SCHEMA_NAME)) {
                ObjectNode mapSchema = objectMapper.createObjectNode();
                mapSchema.put("id", MAP_SCHEMA_NAME);
                mapSchema.put("type", "object");
                schemasNode.set(MAP_SCHEMA_NAME, (JsonNode)mapSchema);
            }
            return MAP_SCHEMA_NAME;
        }
        String typeName = Types.getSimpleName(type, apiConfig.getSerializationConfig());
        JsonNode existing = schemasNode.get(typeName);
        if (existing != null && existing.isObject()) {
            return typeName;
        }
        ObjectNode schemaNode = objectMapper.createObjectNode();
        Class c = type.getRawType();
        if (c.isEnum()) {
            schemasNode.set(typeName, (JsonNode)schemaNode);
            schemaNode.put("id", typeName);
            schemaNode.put("type", "string");
            ArrayNode enumNode = objectMapper.createArrayNode();
            for (Object enumConstant : c.getEnumConstants()) {
                enumNode.add(enumConstant.toString());
            }
            schemaNode.set("enum", (JsonNode)enumNode);
        } else {
            TypeToken<?> serializedType = ApiAnnotationIntrospector.getSchemaType(type, apiConfig);
            if (!type.equals(serializedType)) {
                return this.addTypeToSchema(schemasNode, serializedType, enclosingType, apiConfig, parameterConfigs);
            }
            this.addBeanTypeToSchema(schemasNode, typeName, schemaNode, type, apiConfig, parameterConfigs);
        }
        return typeName;
    }

    private void addBeanTypeToSchema(ObjectNode schemasNode, String typeName, ObjectNode schemaNode, TypeToken<?> type, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        schemasNode.set(typeName, (JsonNode)schemaNode);
        schemaNode.put("id", typeName);
        schemaNode.put("type", "object");
        ObjectNode propertiesNode = objectMapper.createObjectNode();
        this.addBeanProperties(schemasNode, propertiesNode, type, apiConfig, parameterConfigs);
        schemaNode.set("properties", (JsonNode)propertiesNode);
    }

    private void addBeanProperties(ObjectNode schemasNode, ObjectNode node, TypeToken<?> beanType, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        ResourceSchema schema = this.resourceSchemaProvider.getResourceSchema(beanType, apiConfig);
        for (Map.Entry<String, ResourcePropertySchema> entry : schema.getProperties().entrySet()) {
            String propertyName = entry.getKey();
            ObjectNode propertyNode = objectMapper.createObjectNode();
            TypeToken<?> propertyType = entry.getValue().getType();
            if (propertyType == null) continue;
            this.addTypeToNode(schemasNode, propertyType, beanType, propertyNode, apiConfig, parameterConfigs);
            node.set(propertyName, (JsonNode)propertyNode);
        }
    }

    private String addTypeToNode(ObjectNode schemasNode, TypeToken<?> type, TypeToken<?> enclosingType, ObjectNode node, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        TypeToken<?> itemType = Types.getArrayItemType(type);
        if (this.typeLoader.isSchemaType(type)) {
            String basicTypeName = this.typeLoader.getSchemaType(type);
            this.addElementTypeToNode(schemasNode, type, basicTypeName, node, apiConfig);
            return basicTypeName;
        }
        if (itemType != null) {
            ObjectNode items = objectMapper.createObjectNode();
            node.put("type", "array");
            node.set("items", (JsonNode)items);
            String itemTypeName = this.addTypeToNode(schemasNode, itemType, enclosingType, items, apiConfig, parameterConfigs);
            String arraySuffix = "Collection";
            StringBuilder sb = new StringBuilder(itemTypeName.length() + arraySuffix.length());
            sb.append(itemTypeName).append(arraySuffix);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            return sb.toString();
        }
        if (type instanceof TypeVariable) {
            throw new IllegalArgumentException(String.format("Object type %s not supported.", type));
        }
        String typeName = this.addTypeToSchema(schemasNode, type, enclosingType, apiConfig, parameterConfigs);
        this.addElementTypeToNode(schemasNode, type, typeName, node, apiConfig);
        return typeName;
    }

    private void addElementTypeToNode(ObjectNode schemasNode, TypeToken<?> type, String typeName, ObjectNode node, ApiConfig apiConfig) {
        if (schemasNode.has(typeName)) {
            node.put("$ref", typeName);
        } else {
            node.put("type", typeName);
            String format = this.schemaFormatForType(type, apiConfig);
            if (format != null) {
                node.put("format", format);
            }
        }
    }

    @Nullable
    private String schemaFormatForType(TypeToken<?> type, ApiConfig apiConfig) {
        TypeToken<?> serializedType = ApiAnnotationIntrospector.getSchemaType(type, apiConfig);
        if (!type.equals(serializedType)) {
            return this.schemaFormatForType(serializedType, apiConfig);
        }
        return this.typeLoader.getSchemaFormat(type);
    }
}

