/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.jsonwriter;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.api.client.util.ClassInfo;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.jsonwriter.AbstractResourceSchemaProvider;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.Types;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class JacksonResourceSchemaProvider
extends AbstractResourceSchemaProvider {
    private static final Logger logger = Logger.getLogger(JacksonResourceSchemaProvider.class.getName());

    @Override
    public ResourceSchema getResourceSchema(TypeToken<?> type, ApiConfig config) {
        ResourceSchema schema = super.getResourceSchema(type, config);
        if (schema != null) {
            return schema;
        }
        ObjectMapper objectMapper = ObjectMapperUtil.createStandardObjectMapper(config.getSerializationConfig());
        JavaType javaType = objectMapper.getTypeFactory().constructType((Type)type.getRawType());
        BeanDescription beanDescription = objectMapper.getSerializationConfig().introspect(javaType);
        ResourceSchema.Builder schemaBuilder = ResourceSchema.builderForType(type.getRawType());
        Set<String> genericDataFieldNames = JacksonResourceSchemaProvider.getGenericDataFieldNames(type);
        for (BeanPropertyDefinition definition : beanDescription.findProperties()) {
            TypeToken<?> propertyType = this.getPropertyType(type, JacksonResourceSchemaProvider.toMethod(definition.getGetter()), JacksonResourceSchemaProvider.toMethod(definition.getSetter()), definition.getField(), config);
            String name = definition.getName();
            if (genericDataFieldNames == null || genericDataFieldNames.contains(name)) {
                if (JacksonResourceSchemaProvider.hasUnresolvedType(propertyType)) {
                    logger.warning("skipping field '" + name + "' of type '" + propertyType + "' because it is unresolved.");
                    continue;
                }
                if (propertyType != null) {
                    schemaBuilder.addProperty(name, ResourcePropertySchema.of(propertyType));
                    continue;
                }
                logger.warning("No type found for property '" + name + "' on class '" + type + "'.");
                continue;
            }
            logger.fine("skipping field '" + name + "' because it's not a Java client model field.");
        }
        return schemaBuilder.build();
    }

    private static Set<String> getGenericDataFieldNames(TypeToken<?> type) {
        if (!Types.isJavaClientEntity(type)) {
            return null;
        }
        return ImmutableSet.copyOf((Collection)ClassInfo.of((Class)type.getRawType(), (boolean)false).getNames());
    }

    private static boolean hasUnresolvedType(TypeToken<?> type) {
        Type javaType = type.getType();
        if (javaType instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)javaType;
            for (Type t : p.getActualTypeArguments()) {
                if (!Types.isWildcardType(type.resolveType(t))) continue;
                logger.warning("skipping field of type " + type + " because it is unresolved");
                return true;
            }
        }
        return false;
    }

    private static Method toMethod(AnnotatedMethod am) {
        if (am != null) {
            return am.getAnnotated();
        }
        return null;
    }

    @Nullable
    private TypeToken<?> getPropertyType(TypeToken<?> beanType, Method readMethod, Method writeMethod, AnnotatedField field, ApiConfig config) {
        if (readMethod != null) {
            return ApiAnnotationIntrospector.getSchemaType(beanType.resolveType(readMethod.getGenericReturnType()), config);
        }
        if (writeMethod != null) {
            Type[] paramTypes = writeMethod.getGenericParameterTypes();
            if (paramTypes.length == 1) {
                return ApiAnnotationIntrospector.getSchemaType(beanType.resolveType(paramTypes[0]), config);
            }
        } else if (field != null) {
            return ApiAnnotationIntrospector.getSchemaType(beanType.resolveType(field.getGenericType()), config);
        }
        return null;
    }
}

