/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.jsonwriter;

import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.ResourceTransformer;
import com.google.api.server.spi.config.Transformer;
import com.google.api.server.spi.config.jsonwriter.ResourceSchemaProvider;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.Serializers;
import com.google.common.reflect.TypeToken;
import java.util.List;
import javax.annotation.Nullable;

abstract class AbstractResourceSchemaProvider
implements ResourceSchemaProvider {
    AbstractResourceSchemaProvider() {
    }

    @Override
    @Nullable
    public ResourceSchema getResourceSchema(TypeToken<?> type, ApiConfig config) {
        return this.getResourceSchemaImpl(type, config);
    }

    @Nullable
    private <T> ResourceSchema getResourceSchemaImpl(TypeToken<T> type, ApiConfig config) {
        Class clazz = type.getRawType();
        List<Class<Transformer<?, ?>>> serializerClasses = Serializers.getSerializerClasses(type, config.getSerializationConfig());
        if (!serializerClasses.isEmpty() && ResourceTransformer.class.isAssignableFrom(serializerClasses.get(0))) {
            ResourceTransformer resourceSerializer = (ResourceTransformer)Serializers.instantiate(serializerClasses.get(0), type);
            return resourceSerializer.getResourceSchema();
        }
        return null;
    }
}

