/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.MethodHierarchyReader;
import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigSource;
import com.google.api.server.spi.config.ApiIssuer;
import com.google.api.server.spi.config.ApiIssuerAudience;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.Transformer;
import com.google.api.server.spi.config.annotationreader.AnnotationUtil;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationConfig;
import com.google.api.server.spi.config.annotationreader.ApiAuthAnnotationConfig;
import com.google.api.server.spi.config.annotationreader.ApiCacheControlAnnotationConfig;
import com.google.api.server.spi.config.annotationreader.ApiClassAnnotationConfig;
import com.google.api.server.spi.config.annotationreader.ApiFrontendLimitsAnnotationConfig;
import com.google.api.server.spi.config.annotationreader.ApiMethodAnnotationConfig;
import com.google.api.server.spi.config.annotationreader.ApiNamespaceAnnotationConfig;
import com.google.api.server.spi.config.annotationreader.CyclicApiInheritanceException;
import com.google.api.server.spi.config.annotationreader.IssuerUtil;
import com.google.api.server.spi.config.model.ApiClassConfig;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.model.ApiIssuerConfigs;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiParameterConfig;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ApiConfigAnnotationReader
implements ApiConfigSource {
    private final Map<String, Class<? extends Annotation>> annotationTypes;

    public ApiConfigAnnotationReader() throws ClassNotFoundException {
        this(new TypeLoader(ApiConfigAnnotationReader.class.getClassLoader()).getAnnotationTypes());
    }

    public ApiConfigAnnotationReader(Map<String, Class<? extends Annotation>> annotationTypes) {
        this.annotationTypes = annotationTypes;
    }

    @Override
    public void loadEndpointClass(ServiceContext serviceContext, Class<?> endpointClass, ApiConfig config) throws ApiConfigException {
        try {
            Annotation api = ApiConfigAnnotationReader.getDeclaredAnnotation(endpointClass, this.annotationTypes.get("Api"));
            Annotation apiClass = ApiConfigAnnotationReader.getDeclaredAnnotation(endpointClass, this.annotationTypes.get("ApiClass"));
            if (!this.readEndpointClass(config, endpointClass, api, apiClass, endpointClass)) {
                throw new ApiConfigException(endpointClass + " has no @Api annotation.");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ApiConfigException(e);
        }
    }

    @Override
    public void loadEndpointMethods(ServiceContext serviceContext, Class<?> endpointClass, ApiClassConfig.MethodConfigMap methodConfigMap) throws ApiConfigException {
        try {
            this.readEndpointMethods(endpointClass, methodConfigMap);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ApiConfigException(e);
        }
    }

    @Override
    public boolean isStaticConfig(ApiConfig config) {
        return true;
    }

    @Nullable
    private Class<?> determineInheritanceSource(Class<?> endpointClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class inheritanceSource = null;
        Annotation reference = ApiConfigAnnotationReader.getDeclaredAnnotation(endpointClass, this.annotationTypes.get("ApiReference"));
        if (reference != null) {
            inheritanceSource = (Class)this.getAnnotationProperty(reference, "value");
        }
        if (inheritanceSource == null) {
            inheritanceSource = endpointClass.getSuperclass();
        }
        return inheritanceSource;
    }

    @Nullable
    private Class<?> checkForInheritanceCycle(Class<?> endpointClass, @Nullable Class<?> cycleCheck) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, CyclicApiInheritanceException {
        for (int i = 0; cycleCheck != null && i < 2; ++i) {
            cycleCheck = this.determineInheritanceSource(cycleCheck);
        }
        if (endpointClass.equals(cycleCheck)) {
            throw new CyclicApiInheritanceException(endpointClass);
        }
        return cycleCheck;
    }

    private boolean readEndpointClass(ApiConfig config, Class<?> endpointClass, Annotation api, Annotation apiClass, @Nullable Class<?> cycleCheck) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, CyclicApiInheritanceException {
        cycleCheck = this.checkForInheritanceCycle(endpointClass, cycleCheck);
        boolean hasAnnotation = api != null;
        Class<?> inheritanceSource = this.determineInheritanceSource(endpointClass);
        if (inheritanceSource != null) {
            Annotation superApi = ApiConfigAnnotationReader.getDeclaredAnnotation(inheritanceSource, this.annotationTypes.get("Api"));
            Annotation superApiClass = ApiConfigAnnotationReader.getDeclaredAnnotation(inheritanceSource, this.annotationTypes.get("ApiClass"));
            hasAnnotation |= this.readEndpointClass(config, inheritanceSource, superApi, superApiClass, cycleCheck);
        }
        if (api != null) {
            this.readApi(new ApiAnnotationConfig(config), api);
            this.readApiAuth(new ApiAuthAnnotationConfig(config.getAuthConfig()), (Annotation)this.getAnnotationProperty(api, "auth"));
            this.readApiFrontendLimits(new ApiFrontendLimitsAnnotationConfig(config.getFrontendLimitsConfig()), (Annotation)this.getAnnotationProperty(api, "frontendLimits"));
            this.readApiCacheControl(new ApiCacheControlAnnotationConfig(config.getCacheControlConfig()), (Annotation)this.getAnnotationProperty(api, "cacheControl"));
            this.readApiNamespace(new ApiNamespaceAnnotationConfig(config.getNamespaceConfig()), (Annotation)this.getAnnotationProperty(api, "namespace"));
            this.readSerializers(config.getSerializationConfig(), (Class[])this.getAnnotationProperty(api, "transformers"));
        }
        if (apiClass != null) {
            this.readApiClass(new ApiClassAnnotationConfig(config.getApiClassConfig()), apiClass);
        }
        return hasAnnotation;
    }

    private void readApi(ApiAnnotationConfig config, Annotation api) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        config.setIsAbstractIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(api, "isAbstract")));
        config.setRootIfNotEmpty((String)this.getAnnotationProperty(api, "root"));
        config.setNameIfNotEmpty((String)this.getAnnotationProperty(api, "name"));
        config.setCanonicalNameIfNotEmpty((String)this.getAnnotationProperty(api, "canonicalName"));
        config.setVersionIfNotEmpty((String)this.getAnnotationProperty(api, "version"));
        config.setTitleIfNotEmpty((String)this.getAnnotationProperty(api, "title"));
        config.setDescriptionIfNotEmpty((String)this.getAnnotationProperty(api, "description"));
        config.setDocumentationLinkIfNotEmpty((String)this.getAnnotationProperty(api, "documentationLink"));
        config.setIsDefaultVersionIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(api, "defaultVersion")));
        config.setIsDiscoverableIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(api, "discoverable")));
        config.setUseDatastoreIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(api, "useDatastoreForAdditionalConfig")));
        config.setBackendRootIfNotEmpty((String)this.getAnnotationProperty(api, "backendRoot"));
        config.setResourceIfNotEmpty((String)this.getAnnotationProperty(api, "resource"));
        config.setAuthLevelIfSpecified((AuthLevel)((Object)this.getAnnotationProperty(api, "authLevel")));
        config.setScopesIfSpecified((String[])this.getAnnotationProperty(api, "scopes"));
        config.setAudiencesIfSpecified((String[])this.getAnnotationProperty(api, "audiences"));
        config.setIssuersIfSpecified(this.getIssuerConfigs(api));
        config.setIssuerAudiencesIfSpecified(this.getIssuerAudiences(api));
        config.setClientIdsIfSpecified((String[])this.getAnnotationProperty(api, "clientIds"));
        config.setAuthenticatorsIfSpecified((Class[])this.getAnnotationProperty(api, "authenticators"));
        config.setPeerAuthenticatorsIfSpecified((Class[])this.getAnnotationProperty(api, "peerAuthenticators"));
        config.setApiKeyRequiredIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(api, "apiKeyRequired")));
    }

    private ApiIssuerConfigs getIssuerConfigs(Annotation annotation) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return IssuerUtil.toConfig((ApiIssuer[])this.getAnnotationProperty(annotation, "issuers"));
    }

    private ApiIssuerAudienceConfig getIssuerAudiences(Annotation annotation) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return IssuerUtil.toConfig((ApiIssuerAudience[])this.getAnnotationProperty(annotation, "issuerAudiences"));
    }

    private <T> T getAnnotationProperty(Annotation annotation, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = annotation.annotationType().getMethod(name, new Class[0]).invoke((Object)annotation, new Object[0]);
        return (T)value;
    }

    protected void readApiAuth(ApiAuthAnnotationConfig config, Annotation auth) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        config.setAllowCookieAuthIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(auth, "allowCookieAuth")));
        config.setBlockedRegionsIfNotEmpty((String[])this.getAnnotationProperty(auth, "blockedRegions"));
    }

    private void readApiFrontendLimits(ApiFrontendLimitsAnnotationConfig config, Annotation frontendLimits) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        config.setUnregisteredUserQpsIfSpecified((Integer)this.getAnnotationProperty(frontendLimits, "unregisteredUserQps"));
        config.setUnregisteredQpsIfSpecified((Integer)this.getAnnotationProperty(frontendLimits, "unregisteredQps"));
        config.setUnregisteredDailyIfSpecified((Integer)this.getAnnotationProperty(frontendLimits, "unregisteredDaily"));
        this.readApiFrontendLimitRules(config, (Annotation[])this.getAnnotationProperty(frontendLimits, "rules"));
    }

    private void readSerializers(ApiSerializationConfig config, Class<? extends Transformer<?, ?>>[] serializers) {
        for (Class<? extends Transformer<?, ?>> serializer : serializers) {
            config.addSerializationConfig(serializer);
        }
    }

    private void readApiCacheControl(ApiCacheControlAnnotationConfig config, Annotation cacheControl) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        config.setTypeIfNotEmpty((String)this.getAnnotationProperty(cacheControl, "type"));
        config.setMaxAgeIfSpecified((Integer)this.getAnnotationProperty(cacheControl, "maxAge"));
    }

    protected void readApiNamespace(ApiNamespaceAnnotationConfig config, Annotation namespace) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        config.setOwnerDomainIfNotEmpty((String)this.getAnnotationProperty(namespace, "ownerDomain"));
        config.setOwnerNameIfNotEmpty((String)this.getAnnotationProperty(namespace, "ownerName"));
        config.setPackagePathIfNotEmpty((String)this.getAnnotationProperty(namespace, "packagePath"));
    }

    private void readApiFrontendLimitRules(ApiFrontendLimitsAnnotationConfig config, Annotation[] rules) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Annotation rule : rules) {
            String match = (String)this.getAnnotationProperty(rule, "match");
            int qps = (Integer)this.getAnnotationProperty(rule, "qps");
            int userQps = (Integer)this.getAnnotationProperty(rule, "userQps");
            int daily = (Integer)this.getAnnotationProperty(rule, "daily");
            String analyticsId = (String)this.getAnnotationProperty(rule, "analyticsId");
            config.getConfig().addRule(match, qps, userQps, daily, analyticsId);
        }
    }

    private void readApiClass(ApiClassAnnotationConfig config, Annotation apiClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        config.setResourceIfNotEmpty((String)this.getAnnotationProperty(apiClass, "resource"));
        config.setAuthLevelIfSpecified((AuthLevel)((Object)this.getAnnotationProperty(apiClass, "authLevel")));
        config.setScopesIfSpecified((String[])this.getAnnotationProperty(apiClass, "scopes"));
        config.setAudiencesIfSpecified((String[])this.getAnnotationProperty(apiClass, "audiences"));
        config.setIssuerAudiencesIfSpecified(this.getIssuerAudiences(apiClass));
        config.setClientIdsIfSpecified((String[])this.getAnnotationProperty(apiClass, "clientIds"));
        config.setAuthenticatorsIfSpecified((Class[])this.getAnnotationProperty(apiClass, "authenticators"));
        config.setPeerAuthenticatorsIfSpecified((Class[])this.getAnnotationProperty(apiClass, "peerAuthenticators"));
        config.setUseDatastoreIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(apiClass, "useDatastoreForAdditionalConfig")));
        config.setApiKeyRequiredIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(apiClass, "apiKeyRequired")));
    }

    private void readEndpointMethods(Class<?> endpointClass, ApiClassConfig.MethodConfigMap methodConfigMap) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        MethodHierarchyReader methodReader = new MethodHierarchyReader(endpointClass);
        Iterable<List<EndpointMethod>> methods = methodReader.getEndpointOverrides();
        for (List<EndpointMethod> overrides : methods) {
            this.readEndpointMethod(methodConfigMap, overrides);
        }
    }

    private void readEndpointMethod(ApiClassConfig.MethodConfigMap methodConfigMap, List<EndpointMethod> overrides) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<? extends Annotation> apiMethodClass = this.annotationTypes.get("ApiMethod");
        EndpointMethod finalMethod = overrides.get(0);
        ApiMethodConfig methodConfig = methodConfigMap.getOrCreate(finalMethod);
        this.readMethodRequestParameters(finalMethod, methodConfig);
        for (EndpointMethod method : Lists.reverse(overrides)) {
            Annotation apiMethod = method.getMethod().getAnnotation(apiMethodClass);
            if (apiMethod == null) continue;
            this.readApiMethodInstance(new ApiMethodAnnotationConfig(methodConfig), apiMethod);
        }
    }

    private void readApiMethodInstance(ApiMethodAnnotationConfig config, Annotation apiMethod) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        config.setNameIfNotEmpty((String)this.getAnnotationProperty(apiMethod, "name"));
        config.setDescriptionIfNotEmpty((String)this.getAnnotationProperty(apiMethod, "description"));
        config.setPathIfNotEmpty((String)this.getAnnotationProperty(apiMethod, "path"));
        config.setHttpMethodIfNotEmpty((String)this.getAnnotationProperty(apiMethod, "httpMethod"));
        config.setAuthLevelIfSpecified((AuthLevel)((Object)this.getAnnotationProperty(apiMethod, "authLevel")));
        config.setScopesIfSpecified((String[])this.getAnnotationProperty(apiMethod, "scopes"));
        config.setAudiencesIfSpecified((String[])this.getAnnotationProperty(apiMethod, "audiences"));
        config.setIssuerAudiencesIfSpecified(this.getIssuerAudiences(apiMethod));
        config.setClientIdsIfSpecified((String[])this.getAnnotationProperty(apiMethod, "clientIds"));
        config.setAuthenticatorsIfSpecified((Class[])this.getAnnotationProperty(apiMethod, "authenticators"));
        config.setPeerAuthenticatorsIfSpecified((Class[])this.getAnnotationProperty(apiMethod, "peerAuthenticators"));
        config.setIgnoredIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(apiMethod, "ignored")));
        config.setApiKeyRequiredIfSpecified((AnnotationBoolean)((Object)this.getAnnotationProperty(apiMethod, "apiKeyRequired")));
    }

    private void readMethodRequestParameters(EndpointMethod endpointMethod, ApiMethodConfig methodConfig) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        TypeToken<?>[] parameterTypes;
        Method method = endpointMethod.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length != (parameterTypes = endpointMethod.getParameterTypes()).length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation parameterName = AnnotationUtil.getNamedParameter(method, i, this.annotationTypes.get("Named"));
            Annotation description = AnnotationUtil.getParameterAnnotation(method, i, this.annotationTypes.get("Description"));
            Annotation nullable = AnnotationUtil.getNullableParameter(method, i, this.annotationTypes.get("Nullable"));
            Annotation defaultValue = AnnotationUtil.getParameterAnnotation(method, i, this.annotationTypes.get("DefaultValue"));
            this.readMethodRequestParameter(methodConfig, parameterName, description, nullable, defaultValue, parameterTypes[i]);
        }
    }

    private void readMethodRequestParameter(ApiMethodConfig methodConfig, Annotation parameterName, Annotation description, Annotation nullable, Annotation defaultValue, TypeToken<?> type) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        TypeToken<?> repeatedItemType;
        String parameterNameString = null;
        if (parameterName != null) {
            parameterNameString = (String)this.getAnnotationProperty(parameterName, "value");
        }
        String descriptionString = null;
        if (description != null) {
            descriptionString = (String)this.getAnnotationProperty(description, "value");
        }
        String defaultValueString = null;
        if (defaultValue != null) {
            defaultValueString = (String)this.getAnnotationProperty(defaultValue, "value");
        }
        ApiParameterConfig parameterConfig = methodConfig.addParameter(parameterNameString, descriptionString, nullable != null, defaultValueString, type);
        Annotation apiSerializer = type.getRawType().getAnnotation(this.annotationTypes.get("ApiTransformer"));
        if (apiSerializer != null) {
            Class serializer = (Class)this.getAnnotationProperty(apiSerializer, "value");
            parameterConfig.setSerializer(serializer);
        }
        if (parameterConfig.isRepeated() && (apiSerializer = (repeatedItemType = parameterConfig.getRepeatedItemType()).getRawType().getAnnotation(this.annotationTypes.get("ApiTransformer"))) != null) {
            Class repeatedItemSerializer = (Class)this.getAnnotationProperty(apiSerializer, "value");
            parameterConfig.setRepeatedItemSerializer(repeatedItemSerializer);
        }
    }

    private static <A extends Annotation> A getDeclaredAnnotation(Class<?> clazz, Class<A> annotationClass) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (A)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }
}

