/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.api.server.spi.config.annotationreader.AnnotationUtil;
import com.google.api.server.spi.config.model.ApiClassConfig;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import java.util.Arrays;

public class ApiClassAnnotationConfig {
    private final ApiClassConfig config;

    public ApiClassAnnotationConfig(ApiClassConfig config) {
        this.config = config;
    }

    public void setResourceIfNotEmpty(String resource) {
        if (!resource.isEmpty()) {
            this.config.setResource(resource);
        }
    }

    public void setAuthLevelIfSpecified(AuthLevel authLevel) {
        if (authLevel != AuthLevel.UNSPECIFIED) {
            this.config.setAuthLevel(authLevel);
        }
    }

    public void setScopesIfSpecified(String[] scopes) {
        if (!AnnotationUtil.isUnspecified(scopes)) {
            this.config.setScopeExpression(AuthScopeExpressions.interpret(scopes));
        }
    }

    public void setAudiencesIfSpecified(String[] audiences) {
        if (!AnnotationUtil.isUnspecified(audiences)) {
            this.config.setAudiences(Arrays.asList(audiences));
        }
    }

    public void setIssuerAudiencesIfSpecified(ApiIssuerAudienceConfig issuerAudiences) {
        if (issuerAudiences.isSpecified()) {
            this.config.setIssuerAudiences(issuerAudiences);
        }
    }

    public void setClientIdsIfSpecified(String[] clientIds) {
        if (!AnnotationUtil.isUnspecified(clientIds)) {
            this.config.setClientIds(Arrays.asList(clientIds));
        }
    }

    public void setAuthenticatorsIfSpecified(Class<? extends Authenticator>[] authenticators) {
        if (!AnnotationUtil.isUnspecified(authenticators)) {
            this.config.setAuthenticators(Arrays.asList(authenticators));
        }
    }

    public void setPeerAuthenticatorsIfSpecified(Class<? extends PeerAuthenticator>[] peerAuthenticators) {
        if (!AnnotationUtil.isUnspecifiedPeerAuthenticators(peerAuthenticators)) {
            this.config.setPeerAuthenticators(Arrays.asList(peerAuthenticators));
        }
    }

    public void setUseDatastoreIfSpecified(AnnotationBoolean useDatastore) {
        if (useDatastore == AnnotationBoolean.TRUE) {
            this.config.setUseDatastore(true);
        } else if (useDatastore == AnnotationBoolean.FALSE) {
            this.config.setUseDatastore(false);
        }
    }

    public void setApiKeyRequiredIfSpecified(AnnotationBoolean apiKeyRequired) {
        if (apiKeyRequired == AnnotationBoolean.TRUE) {
            this.config.setApiKeyRequired(true);
        } else if (apiKeyRequired == AnnotationBoolean.FALSE) {
            this.config.setApiKeyRequired(false);
        }
    }
}

