/*
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.api.server.spi.config;

/**
 * Annotation to specify a JWT issuer configuration.
 */
public @interface ApiIssuer {
  /**
   * A JWT provider id. This field is referenced by {@link ApiIssuerAudience}.
   */
  String name() default "";

  /**
   * The expected issuer (iss) value for JWT tokens generated by this issuer.
   */
  String issuer() default "";

  /**
   * The location of the JSON web key set used to verify tokens generated by this issuer.
   */
  String jwksUri() default "";
}
