/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.processing.impl;

import com.google.devtools.ksp.NoSourceFile;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010#\u001a\u00020\u000fH\u0002J.\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0016J.\u0010'\u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000b2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0016J\r\u0010*\u001a\u00020!H\u0000\u00a2\u0006\u0002\b+J(\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fH\u0016J\u001e\u00100\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001d0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00061"}, d2={"Lcom/google/devtools/ksp/processing/impl/CodeGeneratorImpl;", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "classDir", "Ljava/io/File;", "javaDir", "kotlinDir", "resourcesDir", "projectBase", "anyChangesWildcard", "Lcom/google/devtools/ksp/symbol/KSFile;", "allSources", "", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/google/devtools/ksp/symbol/KSFile;Ljava/util/List;)V", "fileMap", "", "", "fileOutputStreamMap", "Ljava/io/FileOutputStream;", "generatedFile", "", "getGeneratedFile", "()Ljava/util/Collection;", "outputs", "", "getOutputs", "()Ljava/util/Set;", "separator", "kotlin.jvm.PlatformType", "sourceToOutputs", "", "getSourceToOutputs", "()Ljava/util/Map;", "associate", "", "sources", "outputPath", "packageName", "fileName", "extensionName", "associateWithClasses", "classes", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "closeFiles", "closeFiles$compiler_plugin", "createNewFile", "Ljava/io/OutputStream;", "dependencies", "Lcom/google/devtools/ksp/processing/Dependencies;", "pathOf", "compiler-plugin"})
public final class CodeGeneratorImpl
implements CodeGenerator {
    @NotNull
    private final File classDir;
    @NotNull
    private final File javaDir;
    @NotNull
    private final File kotlinDir;
    @NotNull
    private final File resourcesDir;
    @NotNull
    private final File projectBase;
    @NotNull
    private final KSFile anyChangesWildcard;
    @NotNull
    private final List<KSFile> allSources;
    @NotNull
    private final Map<String, File> fileMap;
    @NotNull
    private final Map<String, FileOutputStream> fileOutputStreamMap;
    private final String separator;
    @NotNull
    private final Map<File, Set<File>> sourceToOutputs;

    public CodeGeneratorImpl(@NotNull File classDir, @NotNull File javaDir, @NotNull File kotlinDir, @NotNull File resourcesDir, @NotNull File projectBase, @NotNull KSFile anyChangesWildcard, @NotNull List<? extends KSFile> allSources) {
        Intrinsics.checkNotNullParameter((Object)classDir, (String)"classDir");
        Intrinsics.checkNotNullParameter((Object)javaDir, (String)"javaDir");
        Intrinsics.checkNotNullParameter((Object)kotlinDir, (String)"kotlinDir");
        Intrinsics.checkNotNullParameter((Object)resourcesDir, (String)"resourcesDir");
        Intrinsics.checkNotNullParameter((Object)projectBase, (String)"projectBase");
        Intrinsics.checkNotNullParameter((Object)anyChangesWildcard, (String)"anyChangesWildcard");
        Intrinsics.checkNotNullParameter(allSources, (String)"allSources");
        this.classDir = classDir;
        this.javaDir = javaDir;
        this.kotlinDir = kotlinDir;
        this.resourcesDir = resourcesDir;
        this.projectBase = projectBase;
        this.anyChangesWildcard = anyChangesWildcard;
        this.allSources = allSources;
        this.fileMap = new LinkedHashMap();
        this.fileOutputStreamMap = new LinkedHashMap();
        this.separator = File.separator;
        this.sourceToOutputs = new LinkedHashMap();
    }

    @NotNull
    public final Map<File, Set<File>> getSourceToOutputs() {
        return this.sourceToOutputs;
    }

    public final void closeFiles$compiler_plugin() {
        Iterable $this$forEach$iv = this.fileOutputStreamMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            FileOutputStream fileOutputStream = this.fileOutputStreamMap.get(it);
            Intrinsics.checkNotNull((Object)fileOutputStream);
            fileOutputStream.close();
        }
        this.fileOutputStreamMap.clear();
    }

    @NotNull
    public final String pathOf(@NotNull String packageName2, @NotNull String fileName2, @NotNull String extensionName) {
        File file;
        String string;
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        if (!Intrinsics.areEqual((Object)packageName2, (Object)"")) {
            Object object = new String[]{"."};
            Iterable iterable = StringsKt.split$default((CharSequence)packageName2, (String[])object, (boolean)false, (int)0, (int)6, null);
            object = this.separator;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"separator");
            string = Intrinsics.stringPlus((String)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)((CharSequence)object), null, null, (int)0, null, null, (int)62, null), (Object)this.separator);
        } else {
            string = "";
        }
        String packageDirs = string;
        String extension = !Intrinsics.areEqual((Object)extensionName, (Object)"") ? Intrinsics.stringPlus((String)".", (Object)extensionName) : "";
        switch (extensionName) {
            case "class": {
                file = this.classDir;
                break;
            }
            case "java": {
                file = this.javaDir;
                break;
            }
            case "kt": {
                file = this.kotlinDir;
                break;
            }
            default: {
                file = this.resourcesDir;
            }
        }
        String typeRoot = file.getPath();
        return typeRoot + this.separator + packageDirs + fileName2 + extension;
    }

    @NotNull
    public OutputStream createNewFile(@NotNull Dependencies dependencies, @NotNull String packageName2, @NotNull String fileName2, @NotNull String extensionName) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        String path = this.pathOf(packageName2, fileName2, extensionName);
        File file = new File(path);
        if (this.fileMap.containsKey(path)) {
            throw new FileAlreadyExistsException(file, null, null, 6, null);
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IllegalStateException("failed to make parent directories.");
        }
        FilesKt.writeText$default((File)file, (String)"", null, (int)2, null);
        this.fileMap.put(path, file);
        List sources = dependencies.isAllSources() ? CollectionsKt.plus((Collection)this.allSources, (Object)this.anyChangesWildcard) : (dependencies.getAggregating() ? CollectionsKt.plus((Collection)dependencies.getOriginatingFiles(), (Object)this.anyChangesWildcard) : dependencies.getOriginatingFiles());
        this.associate(sources, path);
        Map<String, FileOutputStream> map = this.fileOutputStreamMap;
        File file2 = this.fileMap.get(path);
        Intrinsics.checkNotNull((Object)file2);
        Object object = file2;
        object = new FileOutputStream((File)object);
        map.put(path, (FileOutputStream)object);
        FileOutputStream fileOutputStream = this.fileOutputStreamMap.get(path);
        Intrinsics.checkNotNull((Object)fileOutputStream);
        return fileOutputStream;
    }

    public void associate(@NotNull List<? extends KSFile> sources, @NotNull String packageName2, @NotNull String fileName2, @NotNull String extensionName) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        String path = this.pathOf(packageName2, fileName2, extensionName);
        this.associate(sources, path);
    }

    /*
     * WARNING - void declaration
     */
    public void associateWithClasses(@NotNull List<? extends KSClassDeclaration> classes, @NotNull String packageName2, @NotNull String fileName2, @NotNull String extensionName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        String path = this.pathOf(packageName2, fileName2, extensionName);
        Iterable $this$map$iv = classes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KSClassDeclaration kSClassDeclaration = (KSClassDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KSFile kSFile = it.getContainingFile();
            if (kSFile == null) {
                KSName kSName = it.getQualifiedName();
                kSFile = new NoSourceFile(this.projectBase, String.valueOf(kSName == null ? null : kSName.asString()));
            }
            collection.add(kSFile);
        }
        List files = (List)destination$iv$iv;
        this.associate(files, path);
    }

    /*
     * WARNING - void declaration
     */
    private final void associate(List<? extends KSFile> sources, String outputPath) {
        File output = FilesKt.relativeTo((File)new File(outputPath), (File)this.projectBase);
        Iterable $this$forEach$iv = sources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            KSFile source = (KSFile)element$iv;
            boolean bl = false;
            Map<File, Set<File>> map = this.getSourceToOutputs();
            File key$iv = FilesKt.relativeTo((File)new File(source.getFilePath()), (File)this.projectBase);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(output);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> getOutputs() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.fileMap.keySet();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(FilesKt.relativeTo((File)new File((String)it), (File)this.projectBase));
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<File> getGeneratedFile() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.fileOutputStreamMap.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = this.fileMap.get(it);
            Intrinsics.checkNotNull((Object)file);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }
}

