/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp;

import com.google.devtools.ksp.FileExternalizer;
import com.google.devtools.ksp.FileKeyDescriptor;
import com.google.devtools.ksp.PersistentMap;
import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.CollectionExternalizer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0014J\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0096\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/google/devtools/ksp/FileToFilesMap;", "Lcom/google/devtools/ksp/PersistentMap;", "Ljava/io/File;", "", "storageFile", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "keys", "getKeys", "()Ljava/util/Collection;", "dumpKey", "", "key", "dumpValue", "value", "get", "remove", "", "set", "compiler-plugin"})
public final class FileToFilesMap
extends PersistentMap<File, Collection<? extends File>> {
    public FileToFilesMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storageFile, FileKeyDescriptor.INSTANCE, (DataExternalizer)new CollectionExternalizer((DataExternalizer)FileExternalizer.INSTANCE, (Function0)1.INSTANCE), icContext);
    }

    @Override
    @Nullable
    public Collection<File> get(@NotNull File key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Collection)this.getStorage().get((Object)key);
    }

    @Override
    public void set(@NotNull File key, @NotNull Collection<? extends File> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getStorage().set((Object)key, value);
    }

    @NotNull
    protected String dumpKey(@NotNull File key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.path");
        return string;
    }

    @NotNull
    protected String dumpValue(@NotNull Collection<? extends File> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value);
    }

    @Override
    public void remove(@NotNull File key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.getStorage().remove((Object)key);
    }

    @NotNull
    public final Collection<File> getKeys() {
        return this.getStorage().getKeys();
    }
}

