/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstEvaluationContext;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstExpressionTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstExpressionTransformer$Data;", "context", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;)V", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "data", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "Data", "ir.interpreter"})
public abstract class IrConstExpressionTransformer
extends IrTransformer<Data> {
    @NotNull
    private final IrConstEvaluationContext context;

    public IrConstExpressionTransformer(@NotNull IrConstEvaluationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDEFAULT_PROPERTY_ACCESSOR())) {
            return declaration;
        }
        if (!(declaration instanceof IrConstructor)) ** GOTO lbl-1000
        v0 = IrUtilsKt.getParentClassOrNull(declaration);
        if ((v0 != null ? v0.getKind() : null) == ClassKind.ANNOTATION_CLASS) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isAnnotationConstructor = v1;
        return super.visitFunction(declaration, Data.copy$default(data, false, isAnnotationConstructor, 1, null));
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.context.canBeInterpreted(expression2)) {
            return this.context.interpret(expression2, data.mustEvaluate());
        }
        return super.visitCall(expression2, data);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrExpressionBody initializer = declaration2.getInitializer();
        IrElementBase irElementBase = initializer;
        if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) {
            return declaration2;
        }
        IrElementBase expression2 = irElementBase;
        IrGetField getField = IrTreeBuildUtilsKt.createGetField$default(declaration2, null, 1, null);
        if (this.context.canBeInterpreted(getField)) {
            initializer.setExpression(this.context.interpret((IrExpression)expression2, true));
        }
        return super.visitField(declaration2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.context.canBeInterpreted(expression2)) {
            return this.context.interpret(expression2, data.mustEvaluate());
        }
        return super.visitGetField(expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Data data) {
        IrConst foldedConst;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = super.visitStringConcatenation(expression2, data);
        IrStringConcatenation irStringConcatenation = object instanceof IrStringConcatenation ? (IrStringConcatenation)object : null;
        if (irStringConcatenation == null) {
            return expression2;
        }
        IrStringConcatenation transformed = irStringConcatenation;
        List folded = new ArrayList();
        List buildersList = new ArrayList();
        for (IrExpression next : transformed.getArguments()) {
            IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
            if (!this.context.canBeInterpreted(IrConstExpressionTransformer.visitStringConcatenation$wrapInStringConcat(next, expression2))) {
                ((Collection)folded).add(next);
                buildersList.add(new StringBuilder(IrConstExpressionTransformer.visitStringConcatenation$getConstStringOrEmpty(next)));
                continue;
            }
            if (last == null || !this.context.canBeInterpreted(IrConstExpressionTransformer.visitStringConcatenation$wrapInStringConcat(last, expression2))) {
                IrExpression result2 = IrConstExpressionTransformer.visitStringConcatenation$wrapInToStringConcatAndInterpret(next, this, data, expression2);
                ((Collection)folded).add(result2);
                buildersList.add(new StringBuilder(IrConstExpressionTransformer.visitStringConcatenation$getConstStringOrEmpty(result2)));
                continue;
            }
            IrExpression nextAsConst = IrConstExpressionTransformer.visitStringConcatenation$wrapInToStringConcatAndInterpret(next, this, data, expression2);
            if (!(nextAsConst instanceof IrConst)) {
                ((Collection)folded).add(next);
                buildersList.add(new StringBuilder(IrConstExpressionTransformer.visitStringConcatenation$getConstStringOrEmpty(next)));
                continue;
            }
            ((StringBuilder)CollectionsKt.last((List)buildersList)).append(String.valueOf(((IrConst)nextAsConst).getValue()));
            int n2 = folded.size() - 1;
            int n3 = Math.min(last.getStartOffset(), next.getStartOffset());
            int n4 = Math.max(last.getEndOffset(), next.getEndOffset());
            IrType irType = expression2.getType();
            String string = ((StringBuilder)CollectionsKt.last((List)buildersList)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            folded.set(n2, IrConstImpl.Companion.string(n3, n4, irType, string));
        }
        Object object2 = CollectionsKt.singleOrNull((List)folded);
        IrConst irConst = foldedConst = object2 instanceof IrConst ? (IrConst)object2 : null;
        if (foldedConst != null && foldedConst.getValue() instanceof String) {
            int n5 = expression2.getStartOffset();
            int n6 = expression2.getEndOffset();
            IrType irType = expression2.getType();
            String string = ((StringBuilder)CollectionsKt.single((List)buildersList)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return IrConstImpl.Companion.string(n5, n6, irType, string);
        }
        return BuildersKt.IrStringConcatenationImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), folded);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull Data data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object it = object = super.visitVararg(expression2, data);
        boolean bl2 = false;
        if (data.getInAnnotationConstructor() && this.context.canBeInterpreted(expression2)) {
            this.context.saveInConstTracker(expression2);
        }
        return object;
    }

    private static final IrExpression visitStringConcatenation$wrapInStringConcat(IrExpression $this$visitStringConcatenation_u24wrapInStringConcat, IrStringConcatenation $expression) {
        return BuildersKt.IrStringConcatenationImpl($this$visitStringConcatenation_u24wrapInStringConcat.getStartOffset(), $this$visitStringConcatenation_u24wrapInStringConcat.getEndOffset(), $expression.getType(), CollectionsKt.listOf((Object)$this$visitStringConcatenation_u24wrapInStringConcat));
    }

    private static final IrExpression visitStringConcatenation$wrapInToStringConcatAndInterpret(IrExpression $this$visitStringConcatenation_u24wrapInToStringConcatAndInterpret, IrConstExpressionTransformer this$0, Data $data, IrStringConcatenation $expression) {
        return this$0.context.interpret(IrConstExpressionTransformer.visitStringConcatenation$wrapInStringConcat($this$visitStringConcatenation_u24wrapInToStringConcatAndInterpret, $expression), $data.mustEvaluate());
    }

    private static final String visitStringConcatenation$getConstStringOrEmpty(IrExpression $this$visitStringConcatenation_u24getConstStringOrEmpty) {
        return $this$visitStringConcatenation_u24getConstStringOrEmpty instanceof IrConst ? String.valueOf(((IrConst)$this$visitStringConcatenation_u24getConstStringOrEmpty).getValue()) : "";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstExpressionTransformer$Data;", "", "inConstantExpression", "", "inAnnotationConstructor", "<init>", "(ZZ)V", "getInConstantExpression", "()Z", "getInAnnotationConstructor", "mustEvaluate", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "ir.interpreter"})
    public static final class Data {
        private final boolean inConstantExpression;
        private final boolean inAnnotationConstructor;

        public Data(boolean inConstantExpression, boolean inAnnotationConstructor) {
            this.inConstantExpression = inConstantExpression;
            this.inAnnotationConstructor = inAnnotationConstructor;
        }

        public /* synthetic */ Data(boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl2 = false;
            }
            if ((n2 & 2) != 0) {
                bl3 = false;
            }
            this(bl2, bl3);
        }

        public final boolean getInConstantExpression() {
            return this.inConstantExpression;
        }

        public final boolean getInAnnotationConstructor() {
            return this.inAnnotationConstructor;
        }

        public final boolean mustEvaluate() {
            return this.inConstantExpression || this.inAnnotationConstructor;
        }

        public final boolean component1() {
            return this.inConstantExpression;
        }

        public final boolean component2() {
            return this.inAnnotationConstructor;
        }

        @NotNull
        public final Data copy(boolean inConstantExpression, boolean inAnnotationConstructor) {
            return new Data(inConstantExpression, inAnnotationConstructor);
        }

        public static /* synthetic */ Data copy$default(Data data, boolean bl2, boolean bl3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl2 = data.inConstantExpression;
            }
            if ((n2 & 2) != 0) {
                bl3 = data.inAnnotationConstructor;
            }
            return data.copy(bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "Data(inConstantExpression=" + this.inConstantExpression + ", inAnnotationConstructor=" + this.inAnnotationConstructor + ')';
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.inConstantExpression);
            result2 = result2 * 31 + Boolean.hashCode(this.inAnnotationConstructor);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (this.inConstantExpression != data.inConstantExpression) {
                return false;
            }
            return this.inAnnotationConstructor == data.inAnnotationConstructor;
        }

        public Data() {
            this(false, false, 3, null);
        }
    }
}

