/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRedundantRepeatableChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmRedundantRepeatableChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmRedundantRepeatableChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRedundantRepeatableChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,40:1\n36#2:41\n33#2:42\n36#2:43\n33#2:44\n*S KotlinDebug\n*F\n+ 1 FirJvmRedundantRepeatableChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRedundantRepeatableChecker\n*L\n33#1:41\n33#1:42\n34#1:43\n34#1:44\n*E\n"})
public final class FirJvmRedundantRepeatableChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmRedundantRepeatableChecker INSTANCE = new FirJvmRedundantRepeatableChecker();

    private FirJvmRedundantRepeatableChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        FirAnnotation javaRepeatable;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirAnnotation kotlinRepeatable = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, StandardClassIds.Annotations.INSTANCE.getRepeatable(), context2.getSession());
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JvmStandardClassIds.Annotations.INSTANCE.getJvmRepeatable(), context2.getSession());
        if (firAnnotation == null) {
            firAnnotation = javaRepeatable = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JvmStandardClassIds.Annotations.Java.INSTANCE.getRepeatable(), context2.getSession());
        }
        if (kotlinRepeatable != null && javaRepeatable != null) {
            Object object;
            Object object2;
            DiagnosticContext diagnosticContext = context2;
            AbstractKtSourceElement abstractKtSourceElement = kotlinRepeatable.getSource();
            KtDiagnosticFactory2<FqName, FqName> ktDiagnosticFactory2 = FirJvmErrors.INSTANCE.getREDUNDANT_REPEATABLE_ANNOTATION();
            FirAnnotation $this$unexpandedClassId$iv = kotlinRepeatable;
            boolean $i$f$getUnexpandedClassId = false;
            FirAnnotation $this$unexpandedConeClassLikeType$iv$iv = $this$unexpandedClassId$iv;
            boolean $i$f$getUnexpandedConeClassLikeType = false;
            FirTypeRef firTypeRef = $this$unexpandedConeClassLikeType$iv$iv.getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
            Object object3 = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            if ((object3 != null && (object3 = ((ConeClassLikeType)object3).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object3).getClassId() : (object2 = null)) == null || (object2 = ((ClassId)object2).asSingleFqName()) == null) {
                object2 = FqName.ROOT;
            }
            $this$unexpandedClassId$iv = javaRepeatable;
            $i$f$getUnexpandedClassId = false;
            $this$unexpandedConeClassLikeType$iv$iv = $this$unexpandedClassId$iv;
            $i$f$getUnexpandedConeClassLikeType = false;
            firTypeRef = $this$unexpandedConeClassLikeType$iv$iv.getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef2 = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getConeType() : null;
            Object object4 = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            if ((object4 != null && (object4 = ((ConeClassLikeType)object4).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object4).getClassId() : (object = null)) == null || (object = ((ClassId)object).asSingleFqName()) == null) {
                object = FqName.ROOT;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, reporter, abstractKtSourceElement, ktDiagnosticFactory2, object2, object, null, 32, null);
        }
    }
}

