/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.IrWhenUtils;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmIrLowerUtilsKt;
import org.jetbrains.kotlin.codegen.intrinsics.TypeIntrinsics;
import org.jetbrains.kotlin.config.JvmWhenGenerationScheme;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.Handle;

@PhaseDescription(name="TypeSwitchTransformation")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002:\u0002,-B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J6\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0017\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00190\u001e\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u00020\"*\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\"\u0010'\u001a\u00020\u000e*\u00020\u001a2\u0006\u0010#\u001a\u00020$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020&0)H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeSwitchLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "getTypeSwitchDataOrNull", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeSwitchLowering$TypeSwitchData;", "whenExpression", "irBuiltins", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "transformToTypeSwitch", "typeSwitchData", "at", "R", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;Lorg/jetbrains/kotlin/ir/IrElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "createEqualToIndexCondition", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "tempVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "switchCondition", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeSwitchLowering$SwitchCondition;", "createTypeCondition", "switchConditions", "", "jdkTypeSwitchHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "SwitchCondition", "TypeSwitchData", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nTypeSwitchLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeSwitchLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeSwitchLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,275:1\n1#2:276\n827#3:277\n855#3,2:278\n1563#3:287\n1634#3,3:288\n1563#3:310\n1634#3,3:311\n2783#3,7:314\n382#4,7:280\n269#5,4:291\n389#6,13:295\n133#7,2:308\n*S KotlinDebug\n*F\n+ 1 TypeSwitchLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeSwitchLowering\n*L\n149#1:277\n149#1:278,2\n200#1:287\n200#1:288,3\n257#1:310\n257#1:311,3\n258#1:314,7\n170#1:280,7\n202#1:291,4\n234#1:295,13\n234#1:308,2\n*E\n"})
public final class TypeSwitchLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Handle jdkTypeSwitchHandle;

    public TypeSwitchLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.jdkTypeSwitchHandle = new Handle(6, "java/lang/runtime/SwitchBootstraps", "typeSwitch", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getWhenGenerationScheme() == JvmWhenGenerationScheme.INDY) {
            IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
        }
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2) {
        IrExpression newExpression;
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        TypeSwitchData typeSwitchDataOrNull = this.getTypeSwitchDataOrNull(expression2, this.context.getIrBuiltIns());
        IrExpression it = irExpression = (newExpression = typeSwitchDataOrNull == null ? (IrExpression)expression2 : this.transformToTypeSwitch(expression2, typeSwitchDataOrNull));
        boolean bl2 = false;
        IrElementTransformerVoidKt.transformChildrenVoid(it, this);
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSwitchData getTypeSwitchDataOrNull(IrWhen whenExpression, IrBuiltIns irBuiltins) {
        int typeChecksThreshold;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = whenExpression.getBranches();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IrBranch p0 = (IrBranch)element$iv$iv;
            boolean bl2 = false;
            if (IrUtilsKt.isElseBranch(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonElseBranches = (List)destination$iv$iv;
        IrValueAccessExpression whenSubject = null;
        ArrayList orderedCheckedTypes = new ArrayList();
        Map branchToSwitchConditions = new LinkedHashMap();
        int nextTypeIndex = 0;
        boolean hasNullChecks = false;
        for (IrBranch branch : nonElseBranches) {
            List<IrExpression> conditions;
            if (IrWhenUtils.INSTANCE.matchConditions(irBuiltins.getOrorSymbol(), branch.getCondition(), (Function1<? super IrExpression, Boolean>)((Function1)arg_0 -> TypeSwitchLowering.getTypeSwitchDataOrNull$lambda$2(irBuiltins, arg_0))) == null) {
                return null;
            }
            for (IrExpression condition : conditions) {
                Object object;
                void $this$getOrPut$iv;
                IrGetValue conditionSubject = TypeSwitchLowering.getTypeSwitchDataOrNull$getSubject(irBuiltins, condition);
                if (whenSubject != null && !Intrinsics.areEqual((Object)whenSubject.getSymbol(), (Object)conditionSubject.getSymbol())) {
                    return null;
                }
                whenSubject = conditionSubject;
                Map map = branchToSwitchConditions;
                IrBranch key$iv = branch;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List switchConditions = (List)object;
                if (TypeSwitchLowering.getTypeSwitchDataOrNull$isInstanceof(condition)) {
                    Intrinsics.checkNotNull((Object)condition, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall");
                    IrType type2 = ((IrTypeOperatorCall)condition).getTypeOperand();
                    if (TypeSwitchLowering.getTypeSwitchDataOrNull$isIneligibleTypeForTypeSwitch(type2)) {
                        return null;
                    }
                    switchConditions.add(new SwitchCondition(nextTypeIndex++, condition));
                    ((Collection)orderedCheckedTypes).add(type2);
                    continue;
                }
                boolean bl4 = TypeSwitchLowering.getTypeSwitchDataOrNull$isEqualsToNull(irBuiltins, condition);
                if (_Assertions.ENABLED && !bl4) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                switchConditions.add(new SwitchCondition(-1, condition));
                hasNullChecks = true;
            }
        }
        int n2 = typeChecksThreshold = hasNullChecks ? 1 : 2;
        if (whenSubject == null || orderedCheckedTypes.size() < typeChecksThreshold) {
            return null;
        }
        return new TypeSwitchData(whenSubject.getSymbol(), whenSubject.getType(), orderedCheckedTypes, branchToSwitchConditions);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression transformToTypeSwitch(IrWhen whenExpression, TypeSwitchData typeSwitchData) {
        void this_$iv$iv;
        IrBlockBuilder $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247;
        IrFunctionAccessExpression irFunctionAccessExpression2;
        void $this$mapTo$iv$iv;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        JvmIrBuilder $this$transformToTypeSwitch_u24lambda_u2411 = JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr, (IrElement)whenExpression);
        boolean bl2 = false;
        Handle bootstrapMethod = this.jdkTypeSwitchHandle;
        Iterable $this$map$iv = typeSwitchData.getOrderedCheckedTypes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IrType irType = (IrType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean irFunctionAccessExpression2 = false;
            collection.add(JvmIrUtilsKt.kClassReference($this$transformToTypeSwitch_u24lambda_u2411, (IrType)p0));
        }
        List bootstrapMethodArguments = (List)destination$iv$iv;
        Object $this$buildFun$iv = $this$transformToTypeSwitch_u24lambda_u2411.getContext().getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2423$iv = new IrFunctionBuilder();
        boolean bl3 = false;
        Object $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u245 = $this$buildFun_u24lambda_u2423$iv;
        boolean bl4 = false;
        Name name2 = Name.identifier("typeSwitch");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        ((IrDeclarationBuilder)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u245).setName(name2);
        ((IrFunctionBuilder)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u245).setReturnType($this$transformToTypeSwitch_u24lambda_u2411.getContext().getIrBuiltIns().getIntType());
        ((IrDeclarationBuilder)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u245).setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getINVOKEDYNAMIC_CALL_TARGET());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
        ((IrDeclarationBuilder)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u245).setVisibility(descriptorVisibility);
        Object $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u246 = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2423$iv);
        boolean bl5 = false;
        ((IrDeclarationBase)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u246).setParent($this$transformToTypeSwitch_u24lambda_u2411.getBackendContext().getSymbols().getKotlinJvmInternalInvokeDynamicPackage());
        DeclarationBuildersKt.addValueParameter((IrFunction)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u246, "obj", $this$transformToTypeSwitch_u24lambda_u2411.getContext().getIrBuiltIns().getAnyNType(), (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getSTUB_FOR_TYPE_SWITCH());
        DeclarationBuildersKt.addValueParameter((IrFunction)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u246, "restart", $this$transformToTypeSwitch_u24lambda_u2411.getContext().getIrBuiltIns().getIntType(), (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getSTUB_FOR_TYPE_SWITCH());
        Object dynamicTypeSwitchFunc = $this$buildFun$iv;
        JvmIrBuilder $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249 = (JvmIrBuilder)IrBuilderKt.at((IrBuilder)$this$transformToTypeSwitch_u24lambda_u2411, -1, -1);
        boolean bl6 = false;
        Object $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248 = $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u245 = ExpressionHelpersKt.irCall$default($this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249, $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249.getBackendContext().getSymbols().getJvmIndyIntrinsic(), $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249.getContext().getIrBuiltIns().getIntType(), 0, null, 12, null);
        boolean bl7 = false;
        IrFunctionAccessExpression irFunctionAccessExpression3 = irFunctionAccessExpression2 = ExpressionHelpersKt.irCall((IrBuilder)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249, (IrFunction)dynamicTypeSwitchFunc);
        int n2 = 0;
        IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = ((IrMemberAccessExpression)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248).getArguments();
        boolean bl8 = false;
        ((IrMemberAccessExpression)((Object)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247)).getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249, typeSwitchData.getSubjectType(), typeSwitchData.getSubjectVar()));
        ((IrMemberAccessExpression)((Object)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247)).getArguments().set(1, ExpressionHelpersKt.irInt$default($this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249, 0, null, 2, null));
        Unit unit = Unit.INSTANCE;
        valueArgumentsList.set(n2, irFunctionAccessExpression2);
        ((IrMemberAccessExpression)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248).getArguments().set(1, JvmIrLowerUtilsKt.jvmMethodHandle($this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249, bootstrapMethod));
        ((IrMemberAccessExpression)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248).getArguments().set(2, ExpressionHelpersKt.irVararg($this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249, $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249.getContext().getIrBuiltIns().getAnyType(), bootstrapMethodArguments));
        ((IrMemberAccessExpression)$this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248).setOrigin(JvmLoweredStatementOrigin.INSTANCE.getWHEN_AS_TYPE_SWITCH());
        Object indyIntrinsicCall = $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u245;
        IrVariable typeSwitchResultVar = Scope.createTemporaryVariable$default($this$transformToTypeSwitch_u24lambda_u2411.getScope(), (IrExpression)indyIntrinsicCall, "typeSwitchCallResult", false, null, null, 0, 0, 124, null);
        for (IrBranch branch : whenExpression.getBranches()) {
            List<SwitchCondition> switchConditions;
            if (IrUtilsKt.isElseBranch(branch)) continue;
            if (typeSwitchData.getBranchToSwitchConditions().get(branch) == null) {
                throw new IllegalStateException(("No switch conditions for branch:\n" + DumpIrTreeKt.dump$default(branch, null, 1, null)).toString());
            }
            branch.setCondition(this.createTypeCondition($this$transformToTypeSwitch_u24lambda_u2411, typeSwitchResultVar, switchConditions));
        }
        whenExpression.setOrigin(JvmLoweredStatementOrigin.INSTANCE.getWHEN_AS_TYPE_SWITCH());
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$transformToTypeSwitch_u24lambda_u2411;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u2410 = this_$iv$iv;
        boolean bl9 = false;
        $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u2410.unaryPlus(typeSwitchResultVar);
        $this$transformToTypeSwitch_u24lambda_u2411_u24lambda_u2410.unaryPlus(whenExpression);
        return (IrExpression)this_$iv$iv.doBuild();
    }

    public final <R> R at(@NotNull JvmIrBuilder $this$at, @NotNull IrElement element2, @NotNull Function1<? super JvmIrBuilder, ? extends R> action) {
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (R)action.invoke((Object)IrBuilderKt.at((IrBuilder)$this$at, element2.getStartOffset(), element2.getEndOffset()));
    }

    private final IrCall createEqualToIndexCondition(JvmIrBuilder $this$createEqualToIndexCondition, IrVariable tempVar, SwitchCondition switchCondition) {
        return (IrCall)this.at($this$createEqualToIndexCondition, switchCondition.getOriginalBranchCondition(), arg_0 -> TypeSwitchLowering.createEqualToIndexCondition$lambda$13(tempVar, switchCondition, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression createTypeCondition(JvmIrBuilder $this$createTypeCondition, IrVariable tempVar, List<SwitchCondition> switchConditions) {
        void $this$reduce$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        boolean bl2;
        boolean bl3 = bl2 = !((Collection)switchConditions).isEmpty();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-TypeSwitchLowering$createTypeCondition$22 = false;
            String $i$a$-assert-TypeSwitchLowering$createTypeCondition$22 = "switchConditions cannot be empty";
            throw new AssertionError((Object)$i$a$-assert-TypeSwitchLowering$createTypeCondition$22);
        }
        Iterable iterable = switchConditions;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (SwitchCondition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(this.createEqualToIndexCondition($this$createTypeCondition, tempVar, (SwitchCondition)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void condition;
            IrCall $i$f$mapTo2 = (IrCall)iterator$iv.next();
            IrCall acc = (IrCall)accumulator$iv;
            boolean bl5 = false;
            Object $this$createTypeCondition_u24lambda_u2417_u24lambda_u2416 = object = ExpressionHelpersKt.irCall((IrBuilder)$this$createTypeCondition, $this$createTypeCondition.getContext().getIrBuiltIns().getOrorSymbol());
            boolean bl6 = false;
            ((IrMemberAccessExpression)$this$createTypeCondition_u24lambda_u2417_u24lambda_u2416).getArguments().set(0, acc);
            ((IrMemberAccessExpression)$this$createTypeCondition_u24lambda_u2417_u24lambda_u2416).getArguments().set(1, condition);
            $this$createTypeCondition_u24lambda_u2417_u24lambda_u2416.setStartOffset(Math.min(acc.getStartOffset(), condition.getStartOffset()));
            $this$createTypeCondition_u24lambda_u2417_u24lambda_u2416.setEndOffset(Math.max(acc.getEndOffset(), condition.getEndOffset()));
            accumulator$iv = object;
        }
        return (IrExpression)accumulator$iv;
    }

    private static final IrGetValue getTypeSwitchDataOrNull$tryUnwrapSubject(IrExpression argument) {
        IrExpression irExpression = argument;
        return irExpression instanceof IrGetValue ? (IrGetValue)argument : (irExpression instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)argument).getOperator() == IrTypeOperator.IMPLICIT_CAST ? TypeSwitchLowering.getTypeSwitchDataOrNull$tryUnwrapSubject(((IrTypeOperatorCall)argument).getArgument()) : null);
    }

    private static final IrGetValue getTypeSwitchDataOrNull$unwrapSubject(IrExpression argument) {
        IrGetValue irGetValue = TypeSwitchLowering.getTypeSwitchDataOrNull$tryUnwrapSubject(argument);
        if (irGetValue == null) {
            throw new IllegalStateException("Failed to unwrap subject from argument " + argument);
        }
        return irGetValue;
    }

    private static final boolean getTypeSwitchDataOrNull$isSubjectCandidate(IrExpression argument) {
        return TypeSwitchLowering.getTypeSwitchDataOrNull$tryUnwrapSubject(argument) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getTypeSwitchDataOrNull$argumentsAreSubjectAndNullConst(IrExpression arg1, IrExpression arg2) {
        if (!TypeSwitchLowering.getTypeSwitchDataOrNull$isSubjectCandidate(arg1)) return false;
        IrExpression irExpression = arg2;
        if (irExpression == null) return false;
        boolean bl2 = IrUtilsKt.isNullConst(irExpression);
        if (!bl2) return false;
        return true;
    }

    private static final boolean getTypeSwitchDataOrNull$argumentsAreSubjectAndNullConst$1(List<? extends IrExpression> arguments2) {
        return arguments2.size() == 2 && (TypeSwitchLowering.getTypeSwitchDataOrNull$argumentsAreSubjectAndNullConst(arguments2.get(0), arguments2.get(1)) || TypeSwitchLowering.getTypeSwitchDataOrNull$argumentsAreSubjectAndNullConst(arguments2.get(1), arguments2.get(0)));
    }

    private static final boolean getTypeSwitchDataOrNull$isEqualsToNull(IrBuiltIns $irBuiltins, IrExpression condition) {
        return condition instanceof IrCall && Intrinsics.areEqual((Object)((IrCall)condition).getSymbol(), (Object)$irBuiltins.getEqeqSymbol()) && TypeSwitchLowering.getTypeSwitchDataOrNull$argumentsAreSubjectAndNullConst$1(((IrCall)condition).getArguments());
    }

    private static final boolean getTypeSwitchDataOrNull$isInstanceof(IrExpression condition) {
        return condition instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)condition).getOperator() == IrTypeOperator.INSTANCEOF && TypeSwitchLowering.getTypeSwitchDataOrNull$isSubjectCandidate(((IrTypeOperatorCall)condition).getArgument());
    }

    private static final boolean getTypeSwitchDataOrNull$isIneligibleTypeForTypeSwitch(IrType type2) {
        return IrTypeUtilsKt.isReifiedTypeParameter(type2) || TypeIntrinsics.isIntrinsicRequiredForInstanceOf(IrBasedDescriptorsKt.toIrBasedKotlinType$default(type2, null, 1, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final IrGetValue getTypeSwitchDataOrNull$getSubject(IrBuiltIns $irBuiltins, IrExpression condition) {
        IrGetValue irGetValue;
        if (TypeSwitchLowering.getTypeSwitchDataOrNull$isInstanceof(condition)) {
            Intrinsics.checkNotNull((Object)condition, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall");
            irGetValue = TypeSwitchLowering.getTypeSwitchDataOrNull$unwrapSubject(((IrTypeOperatorCall)condition).getArgument());
            return irGetValue;
        } else {
            if (!TypeSwitchLowering.getTypeSwitchDataOrNull$isEqualsToNull($irBuiltins, condition)) throw new IllegalStateException("Unexpected condition: " + condition);
            Intrinsics.checkNotNull((Object)condition, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
            IrMemberAccessExpression.ValueArgumentsList arguments2 = ((IrCall)condition).getArguments();
            IrExpression irExpression = (IrExpression)arguments2.get(0);
            if (irExpression != null ? IrUtilsKt.isNullConst(irExpression) : false) {
                irGetValue = TypeSwitchLowering.getTypeSwitchDataOrNull$unwrapSubject((IrExpression)arguments2.get(1));
                return irGetValue;
            } else {
                IrExpression irExpression2 = (IrExpression)arguments2.get(1);
                if (!(irExpression2 != null ? IrUtilsKt.isNullConst(irExpression2) : false)) throw new IllegalStateException("Unexpected arguments for EqualsToNull condition: " + arguments2);
                irGetValue = TypeSwitchLowering.getTypeSwitchDataOrNull$unwrapSubject((IrExpression)arguments2.get(0));
            }
        }
        return irGetValue;
    }

    private static final boolean getTypeSwitchDataOrNull$lambda$2(IrBuiltIns $irBuiltins, IrExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeSwitchLowering.getTypeSwitchDataOrNull$isInstanceof(it) || TypeSwitchLowering.getTypeSwitchDataOrNull$isEqualsToNull($irBuiltins, it);
    }

    private static final IrCall createEqualToIndexCondition$lambda$13(IrVariable $tempVar, SwitchCondition $switchCondition, JvmIrBuilder $this$at) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$this$at");
        IrCall $this$createEqualToIndexCondition_u24lambda_u2413_u24lambda_u2412 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$at, $this$at.getContext().getIrBuiltIns().getEqeqSymbol());
        boolean bl2 = false;
        $this$createEqualToIndexCondition_u24lambda_u2413_u24lambda_u2412.getArguments().set(0, ExpressionHelpersKt.irGet($this$at, $tempVar));
        $this$createEqualToIndexCondition_u24lambda_u2413_u24lambda_u2412.getArguments().set(1, ExpressionHelpersKt.irInt$default($this$at, $switchCondition.getCode(), null, 2, null));
        return irCall;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeSwitchLowering$SwitchCondition;", "", "code", "", "originalBranchCondition", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "<init>", "(ILorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getCode", "()I", "getOriginalBranchCondition", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.jvm.lower"})
    private static final class SwitchCondition {
        private final int code;
        @NotNull
        private final IrExpression originalBranchCondition;

        public SwitchCondition(int code, @NotNull IrExpression originalBranchCondition) {
            Intrinsics.checkNotNullParameter((Object)originalBranchCondition, (String)"originalBranchCondition");
            this.code = code;
            this.originalBranchCondition = originalBranchCondition;
        }

        public final int getCode() {
            return this.code;
        }

        @NotNull
        public final IrExpression getOriginalBranchCondition() {
            return this.originalBranchCondition;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\t\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeSwitchLowering$TypeSwitchData;", "", "subjectVar", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "subjectType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "orderedCheckedTypes", "", "branchToSwitchConditions", "", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeSwitchLowering$SwitchCondition;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;Lorg/jetbrains/kotlin/ir/types/IrType;Ljava/util/List;Ljava/util/Map;)V", "getSubjectVar", "()Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getSubjectType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getOrderedCheckedTypes", "()Ljava/util/List;", "getBranchToSwitchConditions", "()Ljava/util/Map;", "backend.jvm.lower"})
    private static final class TypeSwitchData {
        @NotNull
        private final IrValueSymbol subjectVar;
        @NotNull
        private final IrType subjectType;
        @NotNull
        private final List<IrType> orderedCheckedTypes;
        @NotNull
        private final Map<IrBranch, List<SwitchCondition>> branchToSwitchConditions;

        public TypeSwitchData(@NotNull IrValueSymbol subjectVar, @NotNull IrType subjectType, @NotNull List<? extends IrType> orderedCheckedTypes, @NotNull Map<IrBranch, ? extends List<SwitchCondition>> branchToSwitchConditions) {
            Intrinsics.checkNotNullParameter((Object)subjectVar, (String)"subjectVar");
            Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
            Intrinsics.checkNotNullParameter(orderedCheckedTypes, (String)"orderedCheckedTypes");
            Intrinsics.checkNotNullParameter(branchToSwitchConditions, (String)"branchToSwitchConditions");
            this.subjectVar = subjectVar;
            this.subjectType = subjectType;
            this.orderedCheckedTypes = orderedCheckedTypes;
            this.branchToSwitchConditions = branchToSwitchConditions;
        }

        @NotNull
        public final IrValueSymbol getSubjectVar() {
            return this.subjectVar;
        }

        @NotNull
        public final IrType getSubjectType() {
            return this.subjectType;
        }

        @NotNull
        public final List<IrType> getOrderedCheckedTypes() {
            return this.orderedCheckedTypes;
        }

        @NotNull
        public final Map<IrBranch, List<SwitchCondition>> getBranchToSwitchConditions() {
            return this.branchToSwitchConditions;
        }
    }
}

