/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtPrimaryConstructorElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ=\u0010\t\u001a\n \u000b*\u0004\u0018\u0001H\nH\n\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u0002H\fH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;)V", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getContainingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getOrCreateConstructorKeyword", "Lcom/intellij/psi/PsiElement;", "removeRedundantConstructorKeywordAndSpace", "", "addModifier", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "removeModifier", "addAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "psi"})
public final class KtPrimaryConstructor
extends KtConstructor<KtPrimaryConstructor> {
    public KtPrimaryConstructor(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public KtPrimaryConstructor(@NotNull KotlinConstructorStub<KtPrimaryConstructor> stub2) {
        Intrinsics.checkNotNullParameter(stub2, (String)"stub");
        KtPrimaryConstructorElementType ktPrimaryConstructorElementType = KtStubElementTypes.PRIMARY_CONSTRUCTOR;
        Intrinsics.checkNotNullExpressionValue((Object)ktPrimaryConstructorElementType, (String)"PRIMARY_CONSTRUCTOR");
        super(stub2, ktPrimaryConstructorElementType);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitPrimaryConstructor(this, data);
    }

    @Override
    @NotNull
    public KtClassOrObject getContainingClassOrObject() {
        PsiElement psiElement = this.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        return (KtClassOrObject)psiElement;
    }

    private final PsiElement getOrCreateConstructorKeyword() {
        PsiElement psiElement = this.getConstructorKeyword();
        if (psiElement == null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiElement psiElement2 = new KtPsiFactory(project, false, 2, null).createConstructorKeyword();
            KtParameterList ktParameterList = this.getValueParameterList();
            Intrinsics.checkNotNull((Object)ktParameterList);
            PsiElement psiElement3 = this.addBefore(psiElement2, ktParameterList);
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"addBefore(...)");
        }
        return psiElement;
    }

    public final void removeRedundantConstructorKeywordAndSpace() {
        PsiElement psiElement = this.getConstructorKeyword();
        if (psiElement != null) {
            psiElement.delete();
        }
        if (this.getPrevSibling() instanceof PsiWhiteSpace) {
            this.getPrevSibling().delete();
        }
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null) {
            AddRemoveModifierKt.addModifier(modifierList2, modifier);
            if (this.getModifierList() == null) {
                PsiElement psiElement = this.getConstructorKeyword();
                if (psiElement != null) {
                    psiElement.delete();
                }
            }
        } else {
            if (Intrinsics.areEqual((Object)modifier, (Object)KtTokens.PUBLIC_KEYWORD)) {
                return;
            }
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtModifierList newModifierList = new KtPsiFactory(project, false, 2, null).createModifierList(modifier);
            this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
        }
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        super.removeModifier(modifier);
        if (this.getModifierList() == null) {
            this.removeRedundantConstructorKeywordAndSpace();
        }
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null) {
            PsiElement psiElement = modifierList2.addBefore(annotationEntry2, modifierList2.getFirstChild());
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            ktAnnotationEntry = (KtAnnotationEntry)psiElement;
        } else {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
            String string = annotationEntry2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            KtModifierList newModifierList = ktPsiFactory.createModifierList(string);
            PsiElement psiElement = this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierList");
            List<KtAnnotationEntry> list = ((KtModifierList)psiElement).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationEntries(...)");
            Object object = CollectionsKt.first(list);
            Intrinsics.checkNotNull((Object)object);
            ktAnnotationEntry = (KtAnnotationEntry)object;
        }
        return ktAnnotationEntry;
    }
}

