/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJC\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J7\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0012H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002JC\u0010\u001d\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001fJ7\u0010 \u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010!\u001a\u00020\u0017*\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020\u0017*\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&*\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010'\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030(H\u0002J\u001c\u0010)\u001a\u00020\u0017*\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u001e\u0010.\u001a\u0004\u0018\u00010/*\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkAnnotated", "targetSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "outerProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkForInterface", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;)V", "hasExternalParts", "", "getMinimumVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "chooseMostSpecific", "a", "b", "checkOverrideCannotBeStatic", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkStaticOnConstOrJvmField", "containerIsInterface", "outerLevel", "", "containerIsNonCompanionObject", "getContainerAt", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isCompanion", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "hasAnnotationNamedAs", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "findAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmStaticChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1#2:217\n23#3:218\n54#3:219\n54#3:220\n54#3:221\n54#3:222\n23#3:223\n23#3:224\n23#3:225\n39#3:226\n56#3:227\n34#4:228\n65#5:229\n65#5:230\n295#6,2:231\n*S KotlinDebug\n*F\n+ 1 FirJvmStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker\n*L\n101#1:218\n107#1:219\n118#1:220\n121#1:221\n125#1:222\n132#1:223\n135#1:224\n139#1:225\n160#1:226\n175#1:227\n186#1:228\n192#1:229\n204#1:230\n211#1:231,2\n*E\n"})
public final class FirJvmStaticChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmStaticChecker INSTANCE = new FirJvmStaticChecker();

    private FirJvmStaticChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        block4: {
            FirPropertyAccessor it;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            if (declaration2 instanceof FirConstructor) {
                return;
            }
            if (declaration2 instanceof FirPropertyAccessor) {
                return;
            }
            FirJvmStaticChecker.check$checkIfAnnotated(context2, declaration2, reporter, declaration2);
            if (!(declaration2 instanceof FirProperty)) break block4;
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration2).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl2 = false;
                FirJvmStaticChecker.check$checkIfAnnotated(context2, declaration2, reporter, it);
            }
            FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration2).getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl3 = false;
                FirJvmStaticChecker.check$checkIfAnnotated(context2, declaration2, reporter, it);
            }
        }
    }

    private final void checkAnnotated(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration declaration2, KtSourceElement targetSource, FirProperty outerProperty) {
        boolean containerIsAnonymous;
        if (!(declaration2 instanceof FirMemberDeclaration)) {
            return;
        }
        FirBasedSymbol<?> firBasedSymbol = this.getContainerAt(context2, 0);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> container = firBasedSymbol;
        boolean bl2 = containerIsAnonymous = container instanceof FirClassSymbol && Intrinsics.areEqual((Object)((FirClassSymbol)container).getClassId().getShortClassName(), (Object)SpecialNames.ANONYMOUS);
        if (!(container instanceof FirClassSymbol) || ((FirClassSymbol)container).getClassKind() != ClassKind.OBJECT || !this.isCompanion((FirClassLikeSymbol)container) && containerIsAnonymous) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_NOT_IN_OBJECT_OR_COMPANION(), null, 8, null);
        } else if (this.isCompanion((FirClassLikeSymbol)container) && this.containerIsInterface(context2, 1)) {
            this.checkForInterface(context2, reporter, declaration2, targetSource);
        }
        this.checkOverrideCannotBeStatic(context2, reporter, (FirMemberDeclaration)declaration2, targetSource, outerProperty);
        this.checkStaticOnConstOrJvmField(context2, reporter, declaration2, targetSource);
    }

    static /* synthetic */ void checkAnnotated$default(FirJvmStaticChecker firJvmStaticChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, FirDeclaration firDeclaration, KtSourceElement ktSourceElement, FirProperty firProperty, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            firProperty = null;
        }
        firJvmStaticChecker.checkAnnotated(checkerContext, diagnosticReporter, firDeclaration, ktSourceElement, firProperty);
    }

    private final void checkForInterface(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration declaration2, KtSourceElement targetSource) {
        boolean isExternal;
        boolean bl2;
        Visibility visibility;
        Visibility visibility2;
        if (!(declaration2 instanceof FirCallableDeclaration)) {
            return;
        }
        if (declaration2 instanceof FirProperty) {
            visibility2 = this.getMinimumVisibility((FirProperty)declaration2);
        } else {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$getVisibility = false;
            visibility2 = visibility = $this$visibility$iv.getStatus().getVisibility();
        }
        if (declaration2 instanceof FirProperty) {
            bl2 = this.hasExternalParts((FirProperty)declaration2);
        } else {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isExternal = false;
            bl2 = isExternal = $this$isExternal$iv.getStatus().isExternal();
        }
        if (!Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Public.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_NON_PUBLIC_MEMBER(), null, 8, null);
        } else if (isExternal) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_EXTERNAL_IN_INTERFACE(), null, 8, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasExternalParts(FirProperty $this$hasExternalParts) {
        block5: {
            block4: {
                hasExternal = false;
                $this$isExternal$iv = $this$hasExternalParts;
                $i$f$isExternal = false;
                hasExternal = $this$isExternal$iv.getStatus().isExternal();
                v0 = $this$hasExternalParts.getGetter();
                if (v0 == null) break block4;
                it = v0;
                $i$a$-let-FirJvmStaticChecker$hasExternalParts$1 = false;
                if (hasExternal) ** GOTO lbl-1000
                $this$isExternal$iv = it;
                $i$f$isExternal = false;
                if ($this$isExternal$iv.getStatus().isExternal()) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                hasExternal = v1;
            }
            v2 = $this$hasExternalParts.getSetter();
            if (v2 == null) break block5;
            it = v2;
            $i$a$-let-FirJvmStaticChecker$hasExternalParts$2 = false;
            if (hasExternal) ** GOTO lbl-1000
            $this$isExternal$iv = it;
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            hasExternal = v3;
        }
        return hasExternal;
    }

    private final Visibility getMinimumVisibility(FirProperty $this$getMinimumVisibility) {
        Visibility minVisibility;
        block1: {
            boolean $i$f$getVisibility;
            FirMemberDeclaration $this$visibility$iv;
            FirPropertyAccessor it;
            minVisibility = null;
            FirMemberDeclaration $this$visibility$iv2 = $this$getMinimumVisibility;
            boolean $i$f$getVisibility2 = false;
            minVisibility = $this$visibility$iv2.getStatus().getVisibility();
            FirPropertyAccessor firPropertyAccessor = $this$getMinimumVisibility.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl2 = false;
                $this$visibility$iv = it;
                $i$f$getVisibility = false;
                minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
            }
            FirPropertyAccessor firPropertyAccessor2 = $this$getMinimumVisibility.getSetter();
            if (firPropertyAccessor2 == null) break block1;
            it = firPropertyAccessor2;
            boolean bl3 = false;
            $this$visibility$iv = it;
            $i$f$getVisibility = false;
            minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
        }
        return minVisibility;
    }

    private final Visibility chooseMostSpecific(Visibility a2, Visibility b2) {
        Integer n2 = a2.compareTo(b2);
        if (n2 == null) {
            return a2;
        }
        int difference2 = n2;
        return difference2 > 0 ? b2 : a2;
    }

    private final void checkOverrideCannotBeStatic(CheckerContext context2, DiagnosticReporter reporter, FirMemberDeclaration declaration2, KtSourceElement targetSource, FirProperty outerProperty) {
        boolean isOverride;
        boolean bl2;
        boolean $i$f$isOverride;
        FirMemberDeclaration $this$isOverride$iv;
        FirProperty firProperty = outerProperty;
        if (firProperty != null) {
            $this$isOverride$iv = firProperty;
            $i$f$isOverride = false;
            bl2 = $this$isOverride$iv.getStatus().isOverride();
        } else {
            $this$isOverride$iv = declaration2;
            $i$f$isOverride = false;
            bl2 = isOverride = $this$isOverride$iv.getStatus().isOverride();
        }
        if (!isOverride || !this.containerIsNonCompanionObject(context2, 0)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getOVERRIDE_CANNOT_BE_STATIC(), null, 8, null);
    }

    static /* synthetic */ void checkOverrideCannotBeStatic$default(FirJvmStaticChecker firJvmStaticChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, FirMemberDeclaration firMemberDeclaration, KtSourceElement ktSourceElement, FirProperty firProperty, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            firProperty = null;
        }
        firJvmStaticChecker.checkOverrideCannotBeStatic(checkerContext, diagnosticReporter, firMemberDeclaration, ktSourceElement, firProperty);
    }

    private final void checkStaticOnConstOrJvmField(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration declaration2, KtSourceElement targetSource) {
        block5: {
            block4: {
                if (!(declaration2 instanceof FirProperty)) {
                    return;
                }
                FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)declaration2;
                boolean $i$f$isConst = false;
                if ($this$isConst$iv.getStatus().isConst()) break block4;
                FirBackingField firBackingField = ((FirProperty)declaration2).getBackingField();
                boolean bl2 = firBackingField != null ? this.hasAnnotationNamedAs(firBackingField, JvmStandardClassIds.Annotations.INSTANCE.getJvmField(), context2.getSession()) : false;
                if (!bl2) break block5;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_CONST_OR_JVM_FIELD(), null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containerIsInterface(CheckerContext $this$containerIsInterface, int outerLevel) {
        FirBasedSymbol<?> container = this.getContainerAt($this$containerIsInterface, outerLevel);
        if (!(container instanceof FirClassSymbol)) return false;
        ClassKind $this$isInterface$iv = ((FirClassSymbol)container).getClassKind();
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containerIsNonCompanionObject(CheckerContext $this$containerIsNonCompanionObject, int outerLevel) {
        FirBasedSymbol<?> firBasedSymbol = this.getContainerAt($this$containerIsNonCompanionObject, outerLevel);
        if (firBasedSymbol == null) {
            return false;
        }
        FirBasedSymbol<?> containingClassSymbol = firBasedSymbol;
        if (!(containingClassSymbol instanceof FirRegularClassSymbol)) return false;
        FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)containingClassSymbol;
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol containingClass = firRegularClassSymbol;
        if (containingClass.getClassKind() != ClassKind.OBJECT) return false;
        FirClassLikeSymbol $this$isCompanion$iv = containingClass;
        boolean $i$f$isCompanion = false;
        if ($this$isCompanion$iv.getRawStatus().isCompanion()) return false;
        return true;
    }

    private final FirBasedSymbol<?> getContainerAt(CheckerContext $this$getContainerAt, int outerLevel) {
        int correction = CollectionsKt.lastOrNull($this$getContainerAt.getContainingDeclarations()) instanceof FirPropertySymbol ? 1 : 0;
        return (FirBasedSymbol)CollectionsKt.getOrNull((List)CollectionsKt.asReversed($this$getContainerAt.getContainingDeclarations()), (int)(outerLevel + correction));
    }

    private final boolean isCompanion(FirClassLikeSymbol<?> $this$isCompanion) {
        boolean bl2;
        FirRegularClassSymbol firRegularClassSymbol = $this$isCompanion instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$this$isCompanion : null;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
            boolean $i$f$isCompanion = false;
            bl2 = $this$isCompanion$iv.getRawStatus().isCompanion();
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private final boolean hasAnnotationNamedAs(FirDeclaration $this$hasAnnotationNamedAs, ClassId classId, FirSession session) {
        return this.findAnnotation($this$hasAnnotationNamedAs, classId, session) != null;
    }

    private final FirAnnotation findAnnotation(FirDeclaration $this$findAnnotation, ClassId classId, FirSession session) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()), session), (Object)classId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void check$checkIfAnnotated(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirDeclaration it) {
        FirAnnotation firAnnotation = INSTANCE.findAnnotation(it, JvmStandardClassIds.Annotations.INSTANCE.getJvmStatic(), $context.getSession());
        if (firAnnotation == null) {
            return;
        }
        FirAnnotation annotation = firAnnotation;
        KtSourceElement ktSourceElement = annotation.getSource();
        if (ktSourceElement == null && (ktSourceElement = it.getSource()) == null) {
            ktSourceElement = $declaration.getSource();
        }
        KtSourceElement targetSource = ktSourceElement;
        INSTANCE.checkAnnotated($context, $reporter, it, targetSource, $declaration instanceof FirProperty ? (FirProperty)$declaration : null);
    }
}

