/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.RedundantVisibilityModifierSyntaxCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J5\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0017JC\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001aJC\u0010\u001b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001aJ-\u0010!\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u001e*\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002J\u001c\u0010(\u001a\u00020\u001e*\u0004\u0018\u00010\u00162\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0002J%\u0010\u001c\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010*J,\u0010+\u001a\u00020\u00162\"\u0010,\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030.\u0012\u0004\u0012\u00020/0-\u0012\u0004\u0012\u00020\u00070-H\u0002J!\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u000202H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00103J!\u00104\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00105J!\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u000208H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00109R\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010 R\u0018\u0010%\u001a\u00020\u001e*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantVisibilityModifierSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "<init>", "()V", "checkPsiOrLightTree", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkPropertyAndReport", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkElementAndReport", "defaultVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/descriptors/Visibility;)V", "containingDeclarationSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/descriptors/Visibility;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "checkElementWithImplicitVisibilityAndReport", "implicitVisibility", "isPropertyFromParameter", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;)Z", "reportElement", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "canMakeSetterMoreAccessible", "setterImplicitVisibility", "hasSetterWithImplicitVisibility", "getHasSetterWithImplicitVisibility", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "isEffectivelyHiddenBy", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/descriptors/Visibility;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "findBiggestVisibility", "processSymbols", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "findPropertyAccessorVisibility", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "findPropertyVisibility", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "findFunctionVisibility", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "checkers"})
@SourceDebugExtension(value={"SMAP\nRedundantVisibilityModifierSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantVisibilityModifierSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantVisibilityModifierSyntaxChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,276:1\n95#2,3:277\n100#2:281\n95#3:280\n39#4:282\n23#4:283\n39#4:291\n39#4:292\n19#5:284\n45#5:285\n25#5:286\n18#5:287\n84#5:288\n67#5:290\n18#5:293\n18#5:294\n37#6:289\n*S KotlinDebug\n*F\n+ 1 RedundantVisibilityModifierSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantVisibilityModifierSyntaxChecker\n*L\n93#1:277,3\n93#1:281\n93#1:280\n148#1:282\n160#1:283\n218#1:291\n222#1:292\n180#1:284\n181#1:285\n200#1:286\n202#1:287\n208#1:288\n208#1:290\n234#1:293\n237#1:294\n208#1:289\n*E\n"})
public final class RedundantVisibilityModifierSyntaxChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final RedundantVisibilityModifierSyntaxChecker INSTANCE = new RedundantVisibilityModifierSyntaxChecker();

    private RedundantVisibilityModifierSyntaxChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (element2 instanceof FirPropertyAccessor || element2 instanceof FirValueParameter) {
            return;
        }
        if (element2 instanceof FirConstructor) {
            KtSourceElement ktSourceElement = ((FirConstructor)element2).getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return;
            }
        }
        if (element2 instanceof FirProperty) {
            this.checkPropertyAndReport(context2, reporter, (FirProperty)element2);
        } else {
            Object object = FirConflictsHelpersKt.getResolvedStatus(element2.getSymbol());
            if (object == null || (object = object.getDefaultVisibility()) == null) {
                object = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
            }
            Object defaultVisibility = object;
            this.checkElementAndReport(context2, reporter, element2, (Visibility)defaultVisibility);
        }
    }

    private final void checkPropertyAndReport(CheckerContext context2, DiagnosticReporter reporter, FirProperty property2) {
        Visibility setterImplicitVisibility = null;
        FirPropertyAccessor firPropertyAccessor = property2.getSetter();
        if (firPropertyAccessor != null) {
            Visibility visibility;
            FirPropertyAccessor setter2 = firPropertyAccessor;
            boolean bl2 = false;
            Visibility defaultVisibility = setter2.getSymbol().getResolvedStatus().getDefaultVisibility();
            setterImplicitVisibility = visibility = INSTANCE.implicitVisibility(context2, setter2, defaultVisibility);
            INSTANCE.checkElementAndReport(context2, reporter, setter2, visibility, property2.getSymbol());
        }
        FirPropertyAccessor firPropertyAccessor2 = property2.getGetter();
        if (firPropertyAccessor2 != null) {
            FirPropertyAccessor getter2 = firPropertyAccessor2;
            boolean bl3 = false;
            INSTANCE.checkElementAndReport(context2, reporter, getter2, getter2.getSymbol().getResolvedStatus().getDefaultVisibility(), property2.getSymbol());
        }
        FirBackingField firBackingField = property2.getBackingField();
        if (firBackingField != null) {
            FirBackingField field = firBackingField;
            boolean bl4 = false;
            INSTANCE.checkElementAndReport(context2, reporter, field, field.getSymbol().getResolvedStatus().getDefaultVisibility(), property2.getSymbol());
        }
        if (this.canMakeSetterMoreAccessible(property2, setterImplicitVisibility)) {
            return;
        }
        this.checkElementAndReport(context2, reporter, property2, property2.getSymbol().getResolvedStatus().getDefaultVisibility());
    }

    /*
     * WARNING - void declaration
     */
    private final void checkElementAndReport(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration element2, Visibility defaultVisibility) {
        FirBasedSymbol firBasedSymbol;
        RedundantVisibilityModifierSyntaxChecker redundantVisibilityModifierSyntaxChecker;
        CheckerContext checkerContext;
        DiagnosticReporter diagnosticReporter;
        FirDeclaration firDeclaration;
        Visibility visibility;
        block3: {
            void $this$findClosest_u24default$iv;
            CheckerContext checkerContext2 = context2;
            visibility = defaultVisibility;
            firDeclaration = element2;
            diagnosticReporter = reporter;
            checkerContext = context2;
            redundantVisibilityModifierSyntaxChecker = this;
            boolean $i$f$findClosest = false;
            for (FirBasedSymbol it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirBasedSymbol firBasedSymbol2;
                FirBasedSymbol firBasedSymbol3 = it$iv;
                if (!(firBasedSymbol3 instanceof FirBasedSymbol)) {
                    firBasedSymbol3 = firBasedSymbol = null;
                }
                if (firBasedSymbol3 == null) continue;
                FirBasedSymbol firBasedSymbol4 = firBasedSymbol2 = firBasedSymbol;
                boolean bl2 = false;
                FirBasedSymbol it = firBasedSymbol4;
                firBasedSymbol = true ? firBasedSymbol2 : null;
                if (firBasedSymbol == null) {
                    continue;
                }
                break block3;
            }
            firBasedSymbol = null;
        }
        FirBasedSymbol firBasedSymbol5 = firBasedSymbol;
        redundantVisibilityModifierSyntaxChecker.checkElementAndReport(checkerContext, diagnosticReporter, firDeclaration, visibility, firBasedSymbol5);
    }

    private final void checkElementAndReport(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration element2, Visibility defaultVisibility, FirBasedSymbol<?> containingDeclarationSymbol) {
        this.checkElementWithImplicitVisibilityAndReport(context2, reporter, element2, this.implicitVisibility(context2, element2, defaultVisibility), containingDeclarationSymbol);
    }

    private final void checkElementWithImplicitVisibilityAndReport(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration element2, Visibility implicitVisibility, FirBasedSymbol<?> containingDeclarationSymbol) {
        KtSourceElement ktSourceElement = element2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind && !this.isPropertyFromParameter(element2)) {
            return;
        }
        if (!(element2 instanceof FirMemberDeclaration)) {
            return;
        }
        KtSourceElement ktSourceElement2 = ((FirMemberDeclaration)element2).getSource();
        Visibility explicitVisibility = ktSourceElement2 != null ? RedundantVisibilityModifierSyntaxCheckerKt.getExplicitVisibility(ktSourceElement2) : null;
        boolean isHidden = this.isEffectivelyHiddenBy(explicitVisibility, containingDeclarationSymbol);
        if (isHidden) {
            this.reportElement(context2, reporter, element2);
            return;
        }
        ExplicitApiMode explicitApiMode = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExplicitApiMode());
        if (explicitApiMode != ExplicitApiMode.DISABLED && Intrinsics.areEqual((Object)explicitVisibility, (Object)Visibilities.Public.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)explicitVisibility, (Object)implicitVisibility)) {
            this.reportElement(context2, reporter, element2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPropertyFromParameter(FirElement $this$isPropertyFromParameter) {
        if (!($this$isPropertyFromParameter instanceof FirProperty)) return false;
        KtSourceElement ktSourceElement = ((FirProperty)$this$isPropertyFromParameter).getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) return false;
        return true;
    }

    private final void reportElement(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration element2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)element2.getSource(), FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER(), null, 8, null);
    }

    private final boolean canMakeSetterMoreAccessible(FirProperty $this$canMakeSetterMoreAccessible, Visibility setterImplicitVisibility) {
        FirMemberDeclaration $this$isOverride$iv = $this$canMakeSetterMoreAccessible;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return false;
        }
        if (!this.getHasSetterWithImplicitVisibility($this$canMakeSetterMoreAccessible)) {
            return false;
        }
        if (setterImplicitVisibility == null) {
            return false;
        }
        FirMemberDeclaration $this$visibility$iv = $this$canMakeSetterMoreAccessible;
        boolean $i$f$getVisibility = false;
        return !Intrinsics.areEqual((Object)setterImplicitVisibility, (Object)$this$visibility$iv.getStatus().getVisibility());
    }

    private final boolean getHasSetterWithImplicitVisibility(FirProperty $this$hasSetterWithImplicitVisibility) {
        FirPropertyAccessor firPropertyAccessor = $this$hasSetterWithImplicitVisibility.getSetter();
        if (firPropertyAccessor == null) {
            return false;
        }
        FirPropertyAccessor theSetter = firPropertyAccessor;
        KtSourceElement ktSourceElement = $this$hasSetterWithImplicitVisibility.getSource();
        KtSourceElement ktSourceElement2 = theSetter.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getLighterASTNode() : null), (Object)(ktSourceElement2 != null ? ktSourceElement2.getLighterASTNode() : null))) {
            return true;
        }
        KtSourceElement ktSourceElement3 = theSetter.getSource();
        if (ktSourceElement3 == null) {
            return true;
        }
        KtSourceElement theSource = ktSourceElement3;
        return RedundantVisibilityModifierSyntaxCheckerKt.getExplicitVisibility(theSource) == null;
    }

    private final boolean isEffectivelyHiddenBy(Visibility $this$isEffectivelyHiddenBy, FirBasedSymbol<?> declaration2) {
        EffectiveVisibility effectiveVisibility;
        boolean $i$f$getEffectiveVisibility;
        FirBasedSymbol $this$effectiveVisibility$iv;
        if ($this$isEffectivelyHiddenBy == null || Intrinsics.areEqual((Object)$this$isEffectivelyHiddenBy, (Object)Visibilities.Protected.INSTANCE)) {
            return false;
        }
        FirBasedSymbol<?> firBasedSymbol = declaration2;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            $this$effectiveVisibility$iv = (FirCallableSymbol)declaration2;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility = ((FirCallableSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            $this$effectiveVisibility$iv = (FirClassLikeSymbol)declaration2;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility = ((FirClassLikeSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else {
            return false;
        }
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility;
        Visibility containerVisibility = effectiveVisibility2.toVisibility();
        if (Intrinsics.areEqual((Object)containerVisibility, (Object)Visibilities.Local.INSTANCE) && Intrinsics.areEqual((Object)$this$isEffectivelyHiddenBy, (Object)Visibilities.Internal.INSTANCE)) {
            return true;
        }
        Integer n2 = $this$isEffectivelyHiddenBy.compareTo(containerVisibility);
        if (n2 == null) {
            return false;
        }
        int difference2 = n2;
        return difference2 > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Visibility implicitVisibility(CheckerContext context2, FirDeclaration $this$implicitVisibility, Visibility defaultVisibility) {
        Visibility visibility;
        boolean $i$f$isOverride;
        Object $this$isOverride$iv;
        block10: {
            block11: {
                block12: {
                    if ($this$implicitVisibility instanceof FirPropertyAccessor && ((FirPropertyAccessor)$this$implicitVisibility).isSetter() && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClassSymbol) {
                        $this$isOverride$iv = ((FirPropertyAccessor)$this$implicitVisibility).getPropertySymbol();
                        $i$f$isOverride = false;
                        if (((FirCallableSymbol)$this$isOverride$iv).getRawStatus().isOverride()) {
                            visibility = this.findPropertyAccessorVisibility(context2, (FirPropertyAccessor)$this$implicitVisibility);
                            return visibility;
                        }
                    }
                    if ($this$implicitVisibility instanceof FirPropertyAccessor) {
                        FirCallableSymbol $this$visibility$iv = ((FirPropertyAccessor)$this$implicitVisibility).getPropertySymbol();
                        boolean $i$f$getVisibility = false;
                        visibility = $this$visibility$iv.getResolvedStatus().getVisibility();
                        return visibility;
                    }
                    if (!($this$implicitVisibility instanceof FirConstructor)) break block10;
                    FirClassLikeSymbol<?> classSymbol = FirHelpersKt.getContainingClassSymbol($this$implicitVisibility);
                    if (!(classSymbol instanceof FirRegularClassSymbol)) break block11;
                    FirClassSymbol $this$isEnumClass$iv = (FirClassSymbol)classSymbol;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    if ($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) break block12;
                    FirClassLikeSymbol<?> $this$isSealed$iv = classSymbol;
                    boolean $i$f$isSealed = false;
                    if (!($this$isSealed$iv.getResolvedStatus().getModality() == Modality.SEALED)) break block11;
                }
                visibility = Visibilities.Private.INSTANCE;
                return visibility;
            }
            visibility = defaultVisibility;
            return visibility;
        }
        if ($this$implicitVisibility instanceof FirSimpleFunction && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClassSymbol) {
            $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
            $i$f$isOverride = false;
            if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) {
                visibility = this.findFunctionVisibility(context2, (FirSimpleFunction)$this$implicitVisibility);
                return visibility;
            }
        }
        if ($this$implicitVisibility instanceof FirProperty && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClassSymbol) {
            $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
            $i$f$isOverride = false;
            if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) {
                visibility = this.findPropertyVisibility(context2, (FirProperty)$this$implicitVisibility);
                return visibility;
            }
        }
        visibility = defaultVisibility;
        return visibility;
    }

    private final Visibility findBiggestVisibility(Function1<? super Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction>, Unit> processSymbols) {
        Ref.ObjectRef current = new Ref.ObjectRef();
        current.element = Visibilities.Private.INSTANCE;
        processSymbols.invoke(arg_0 -> RedundantVisibilityModifierSyntaxChecker.findBiggestVisibility$lambda$3(current, arg_0));
        return (Visibility)current.element;
    }

    private final Visibility findPropertyAccessorVisibility(CheckerContext context2, FirPropertyAccessor accessor) {
        FirPropertySymbol propertySymbol = accessor.getPropertySymbol();
        return this.findBiggestVisibility(arg_0 -> RedundantVisibilityModifierSyntaxChecker.findPropertyAccessorVisibility$lambda$5(context2, propertySymbol, arg_0));
    }

    private final Visibility findPropertyVisibility(CheckerContext context2, FirProperty property2) {
        return this.findBiggestVisibility(arg_0 -> RedundantVisibilityModifierSyntaxChecker.findPropertyVisibility$lambda$6(context2, property2, arg_0));
    }

    private final Visibility findFunctionVisibility(CheckerContext context2, FirSimpleFunction function2) {
        return this.findBiggestVisibility(arg_0 -> RedundantVisibilityModifierSyntaxChecker.findFunctionVisibility$lambda$7(context2, function2, arg_0));
    }

    private static final ProcessorAction findBiggestVisibility$lambda$3(Ref.ObjectRef $current, FirCallableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirCallableSymbol $this$visibility$iv = it;
        boolean $i$f$getVisibility = false;
        Integer difference2 = Visibilities.INSTANCE.compare((Visibility)$current.element, $this$visibility$iv.getResolvedStatus().getVisibility());
        if (difference2 != null && difference2 < 0) {
            $this$visibility$iv = it;
            $i$f$getVisibility = false;
            $current.element = $this$visibility$iv.getResolvedStatus().getVisibility();
        }
        return ProcessorAction.NEXT;
    }

    private static final ProcessorAction findPropertyAccessorVisibility$lambda$5$lambda$4(Function1 $checkVisibility, FirPropertySymbol property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        FirPropertyAccessorSymbol firPropertyAccessorSymbol = property2.getSetterSymbol();
        return (ProcessorAction)((Object)$checkVisibility.invoke((Object)(firPropertyAccessorSymbol != null ? (FirCallableSymbol)firPropertyAccessorSymbol : (FirCallableSymbol)property2)));
    }

    private static final Unit findPropertyAccessorVisibility$lambda$5(CheckerContext $context, FirPropertySymbol $propertySymbol, Function1 checkVisibility) {
        Intrinsics.checkNotNullParameter((Object)checkVisibility, (String)"checkVisibility");
        FirHelpersKt.processOverriddenPropertiesWithActionSafe($context, $propertySymbol, (Function1<? super FirPropertySymbol, ? extends ProcessorAction>)((Function1)arg_0 -> RedundantVisibilityModifierSyntaxChecker.findPropertyAccessorVisibility$lambda$5$lambda$4(checkVisibility, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit findPropertyVisibility$lambda$6(CheckerContext $context, FirProperty $property, Function1 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirHelpersKt.processOverriddenPropertiesWithActionSafe($context, $property.getSymbol(), (Function1<? super FirPropertySymbol, ? extends ProcessorAction>)it);
        return Unit.INSTANCE;
    }

    private static final Unit findFunctionVisibility$lambda$7(CheckerContext $context, FirSimpleFunction $function, Function1 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirHelpersKt.processOverriddenFunctionsWithActionSafe($context, $function.getSymbol(), (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)it);
        return Unit.INSTANCE;
    }
}

