/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CheckTreeConsistencyVisitor;
import org.jetbrains.kotlin.backend.common.IrValidationContext;
import org.jetbrains.kotlin.backend.common.IrValidationContextImpl;
import org.jetbrains.kotlin.backend.common.IrValidator;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.TreeConsistencyError;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.IrVerificationMode;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0007\u001a\u00020\u0006*\u00020\u000320\u0010\b\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001aR\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b20\u0010\b\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\tH\u0002\u001a/\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00060\u0017\u00a2\u0006\u0002\b\u0019*V\u0010\u0000\"(\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00012(\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0001\u00a8\u0006\u001a"}, d2={"ReportIrValidationError", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "", "", "checkTreeConsistency", "reportError", "Lorg/jetbrains/kotlin/backend/common/ReportIrValidationError;", "config", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "performBasicIrValidation", "element", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "validatorConfig", "validateIr", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "mode", "Lorg/jetbrains/kotlin/config/IrVerificationMode;", "runValidationRoutines", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/backend/common/IrValidationContext;", "Lkotlin/ExtensionFunctionType;", "ir.backend.common"})
public final class IrValidatorKt {
    private static final void checkTreeConsistency(IrElement $this$checkTreeConsistency, Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError, IrValidatorConfig config) {
        CheckTreeConsistencyVisitor checker = new CheckTreeConsistencyVisitor(reportError, config);
        $this$checkTreeConsistency.accept(checker, null);
        if (checker.getHasInconsistency()) {
            throw new TreeConsistencyError($this$checkTreeConsistency);
        }
    }

    private static final void performBasicIrValidation(IrElement element2, IrBuiltIns irBuiltIns, IrValidatorConfig validatorConfig, Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError) {
        if (validatorConfig.getCheckTreeConsistency()) {
            try {
                IrValidatorKt.checkTreeConsistency(element2, reportError, validatorConfig);
            }
            catch (TreeConsistencyError treeConsistencyError) {
                return;
            }
        }
        IrValidator validator2 = new IrValidator(validatorConfig, irBuiltIns, reportError);
        IrVisitorsKt.acceptVoid(element2, validator2);
    }

    public static final void validateIr(@NotNull MessageCollector messageCollector, @NotNull IrVerificationMode mode, @NotNull Function1<? super IrValidationContext, Unit> runValidationRoutines) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(runValidationRoutines, (String)"runValidationRoutines");
        if (mode == IrVerificationMode.NONE) {
            return;
        }
        IrValidationContextImpl validationContext = new IrValidationContextImpl(messageCollector, mode);
        runValidationRoutines.invoke((Object)validationContext);
        validationContext.throwValidationErrorIfNeeded();
    }

    public static final /* synthetic */ void access$performBasicIrValidation(IrElement element2, IrBuiltIns irBuiltIns, IrValidatorConfig validatorConfig, Function4 reportError) {
        IrValidatorKt.performBasicIrValidation(element2, irBuiltIns, validatorConfig, (Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit>)reportError);
    }
}

