/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.declarations;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.utils.TypeUtilsKt;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDirectInheritorsProvider;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0002J(\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 *\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneFirDirectInheritorsProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDirectInheritorsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "standaloneDeclarationProviderFactory", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;", "getStandaloneDeclarationProviderFactory", "()Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;", "standaloneDeclarationProviderFactory$delegate", "Lkotlin/Lazy;", "getDirectKotlinInheritors", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "includeLocalInheritors", "", "calculateAliases", "", "aliasedName", "Lorg/jetbrains/kotlin/name/Name;", "aliases", "", "isValidInheritor", "candidate", "baseFirClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "toFirSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/name/ClassId;", "module", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "analysis-api-fir-standalone-base"})
@SourceDebugExtension(value={"SMAP\nKotlinStandaloneFirDirectInheritorsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStandaloneFirDirectInheritorsProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneFirDirectInheritorsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1374#2:102\n1460#2,5:103\n774#2:108\n865#2,2:109\n1869#2,2:111\n*S KotlinDebug\n*F\n+ 1 KotlinStandaloneFirDirectInheritorsProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneFirDirectInheritorsProvider\n*L\n51#1:102\n51#1:103,5\n55#1:108\n55#1:109,2\n59#1:111,2\n*E\n"})
public final class KotlinStandaloneFirDirectInheritorsProvider
implements KotlinDirectInheritorsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy standaloneDeclarationProviderFactory$delegate;

    public KotlinStandaloneFirDirectInheritorsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.standaloneDeclarationProviderFactory$delegate = LazyKt.lazy(() -> KotlinStandaloneFirDirectInheritorsProvider.standaloneDeclarationProviderFactory_delegate$lambda$0(this));
    }

    private final KotlinStandaloneDeclarationProviderFactory getStandaloneDeclarationProviderFactory() {
        Lazy lazy = this.standaloneDeclarationProviderFactory$delegate;
        return (KotlinStandaloneDeclarationProviderFactory)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<KtClassOrObject> getDirectKotlinInheritors(@NotNull KtClass ktClass, @NotNull GlobalSearchScope scope, boolean includeLocalInheritors) {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ktClass, (String)"ktClass");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ClassId classId = ktClass.getClassId();
        if (classId == null) {
            return CollectionsKt.emptyList();
        }
        ClassId classId2 = classId;
        KaModule baseModule = KotlinProjectStructureProvider.Companion.getModule(this.project, ktClass, null);
        FirClassLikeSymbol<?> firClassLikeSymbol = this.toFirSymbol(classId2, baseModule);
        Object[] objectArray = firClassLikeSymbol != null ? (Object[])firClassLikeSymbol.getFir() : null;
        FirClass firClass = objectArray instanceof FirClass ? (FirClass)objectArray : null;
        if (firClass == null) {
            return CollectionsKt.emptyList();
        }
        FirClass baseFirClass = firClass;
        objectArray = new Name[]{classId2.getShortClassName()};
        Set baseClassNames = SetsKt.mutableSetOf((Object[])objectArray);
        this.calculateAliases(classId2.getShortClassName(), baseClassNames);
        Iterable $this$flatMap$iv = baseClassNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Name)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = this.getStandaloneDeclarationProviderFactory().getDirectInheritorCandidates((Name)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List possibleInheritors = (List)destination$iv$iv;
        if (possibleInheritors.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = possibleInheritors;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtClassOrObject)element$iv$iv;
            boolean bl3 = false;
            if (!this.isValidInheritor((KtClassOrObject)it, baseFirClass, scope, includeLocalInheritors)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void calculateAliases(Name aliasedName, Set<Name> aliases) {
        Iterable $this$forEach$iv = this.getStandaloneDeclarationProviderFactory().getInheritableTypeAliases(aliasedName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Name aliasName;
            KtTypeAlias alias = (KtTypeAlias)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)alias.getNameAsSafeName(), (String)"getNameAsSafeName(...)");
            boolean isNewAliasName = aliases.add(aliasName);
            if (!isNewAliasName) continue;
            this.calculateAliases(aliasName, aliases);
        }
    }

    private final boolean isValidInheritor(KtClassOrObject candidate, FirClass baseFirClass, GlobalSearchScope scope, boolean includeLocalInheritors) {
        if (!includeLocalInheritors && candidate.isLocal()) {
            return false;
        }
        if (!PsiUtilsKt.contains(scope, candidate)) {
            return false;
        }
        ClassId classId = candidate.getClassId();
        if (classId == null) {
            return false;
        }
        ClassId candidateClassId = classId;
        KaModule candidateModule = KotlinProjectStructureProvider.Companion.getModule(this.project, candidate, null);
        FirClassLikeSymbol<?> firClassLikeSymbol = this.toFirSymbol(candidateClassId, candidateModule);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> candidateFirSymbol = firClassLikeSymbol;
        Object e2 = candidateFirSymbol.getFir();
        FirClass firClass = e2 instanceof FirClass ? (FirClass)e2 : null;
        if (firClass == null) {
            return false;
        }
        FirClass candidateFirClass = firClass;
        return TypeUtilsKt.isSubclassOf(candidateFirClass, baseFirClass, candidateFirClass.getModuleData().getSession(), false);
    }

    private final FirClassLikeSymbol<?> toFirSymbol(ClassId $this$toFirSymbol, KaModule module2) {
        LLFirSession session = LLFirSessionCache.Companion.getInstance(this.project).getSession(module2, true);
        return FirSymbolProviderKt.getSymbolProvider(session).getClassLikeSymbolByClassId($this$toFirSymbol);
    }

    private static final KotlinStandaloneDeclarationProviderFactory standaloneDeclarationProviderFactory_delegate$lambda$0(KotlinStandaloneFirDirectInheritorsProvider this$0) {
        KotlinDeclarationProviderFactory kotlinDeclarationProviderFactory = KotlinDeclarationProviderFactory.Companion.getInstance(this$0.project);
        KotlinStandaloneDeclarationProviderFactory kotlinStandaloneDeclarationProviderFactory = kotlinDeclarationProviderFactory instanceof KotlinStandaloneDeclarationProviderFactory ? (KotlinStandaloneDeclarationProviderFactory)kotlinDeclarationProviderFactory : null;
        if (kotlinStandaloneDeclarationProviderFactory == null) {
            throw new IllegalStateException(('`' + Reflection.getOrCreateKotlinClass(KotlinStandaloneFirDirectInheritorsProvider.class).getSimpleName() + "` expects the following declaration provider factory to be registered: `" + Reflection.getOrCreateKotlinClass(KotlinStandaloneDeclarationProviderFactory.class).getSimpleName() + '`').toString());
        }
        return kotlinStandaloneDeclarationProviderFactory;
    }
}

