/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.FqNameEqualityChecker;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerStateKt;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u000f\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\u000f\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u000f\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u000f\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\u000f\u001a\u001c\u0010\u0010\u001a\u00020\u0007*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u0007*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a5\u0010\u0016\u001a\u00020\u0007*\u00020\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0018H\u0082\b\u001a\u0010\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b*\u00020\u000f\u001a\u0012\u0010\u001c\u001a\u00020\u0007*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010\u001f\u001a\u00020\u0007*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0010\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b*\u00020\b\u001a\n\u0010 \u001a\u00020\u0007*\u00020\b\u001a\n\u0010!\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\"\u001a\u00020\u0007*\u00020\b\u001a\n\u0010#\u001a\u00020\u0007*\u00020\b\u001a\n\u0010$\u001a\u00020\u0007*\u00020\b\u001a\n\u0010%\u001a\u00020\u0007*\u00020\b\u001a\n\u0010&\u001a\u00020\u0007*\u00020\b\u001a\n\u0010'\u001a\u00020\u0007*\u00020\b\u001a\n\u0010(\u001a\u00020\u0007*\u00020\b\u001a\n\u0010)\u001a\u00020\u0007*\u00020\b\u001a\n\u0010*\u001a\u00020\u0007*\u00020\b\u001a!\u0010+\u001a\u00020\u0007*\u00020\b2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00070\u0018H\u0082\b\u001a\n\u0010.\u001a\u00020\u0007*\u00020\b\u001a\f\u0010/\u001a\u0004\u0018\u000100*\u00020\b\u001a&\u00101\u001a\u00020\b*\u00020\b2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u001b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\b0\u001b\u001a\u001e\u00101\u001a\u00020\b*\u00020\b2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\b06\u001a\u0012\u0010\u001c\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010\u001f\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001a\u00108\u001a\u00020\u0007*\u00020\b2\u0006\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020;\u001a\n\u0010<\u001a\u00020\u0007*\u00020\b\u001a\u0012\u0010?\u001a\u00020\b*\u00020\b2\u0006\u0010@\u001a\u00020A\u001a\u0012\u0010B\u001a\u00020\b*\u00020\b2\u0006\u0010@\u001a\u00020A\u001a\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u001b2\u0006\u0010E\u001a\u00020DH\u0002\u001a\u001e\u0010F\u001a\u00020G2\u0006\u0010E\u001a\u00020D2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020D0IH\u0002\u001a\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020D0K2\u0006\u0010L\u001a\u00020M\u001a\u001e\u0010N\u001a\u00020G2\u0006\u0010L\u001a\u00020M2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020M0IH\u0002\u001a\u0010\u0010P\u001a\b\u0012\u0004\u0012\u00020M0K*\u00020M\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010=\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u0015\u0010Q\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010>\u00a8\u0006R"}, d2={"kotlinPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "getKotlinPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinReflectionPackageFqn", "kotlinCoroutinesPackageFqn", "isFunctionMarker", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isFunction", "isKFunction", "isSuspendFunction", "isKSuspendFunction", "isKProperty", "isKMutableProperty", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "isClassWithName", "name", "", "packageFqName", "isClassWithNamePrefix", "prefix", "checkNameAndPackage", "checkName", "Lkotlin/Function1;", "checkPackage", "superTypes", "", "isSubtypeOfClass", "superClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isStrictSubtypeOfClass", "isFunctionTypeOrSubtype", "isSuspendFunctionTypeOrSubtype", "isTypeParameter", "isInterface", "isExternalObject", "isAnnotation", "isFunctionOrKFunction", "isSuspendFunctionOrKFunction", "isThrowable", "isUnsigned", "isUnsignedArray", "isTypeFromKotlinPackage", "namePredicate", "Lorg/jetbrains/kotlin/name/Name;", "isPrimitiveArray", "getPrimitiveArrayElementType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "substitute", "params", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "arguments", "substitutionMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "isSubtypeOf", "superType", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "isNullable", "isBoxedArray", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "getArrayElementType", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "toArrayOrPrimitiveArrayType", "getImmediateSupertypes", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "irType", "collectAllSupertypes", "", "result", "", "getAllSubstitutedSupertypes", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "collectAllSuperclasses", "set", "getAllSuperclasses", "isReifiedTypeParameter", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/util/IrTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 5 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,252:1\n53#1,8:253\n53#1,8:261\n100#1,6:273\n100#1,6:279\n100#1,6:285\n100#1,6:291\n1761#2,3:269\n1563#2:297\n1634#2,3:298\n1634#2,2:302\n1636#2:322\n1634#2,3:324\n1761#2,3:327\n1563#2:330\n1634#2,3:331\n774#2:334\n865#2,2:335\n1634#2,3:338\n1#3:272\n16#4:301\n16#4:323\n16#4:337\n17#5,16:304\n33#5:321\n19#6:320\n*S KotlinDebug\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/util/IrTypeUtilsKt\n*L\n47#1:253,8\n50#1:261,8\n93#1:273,6\n95#1:279,6\n97#1:285,6\n108#1:291,6\n74#1:269,3\n115#1:297\n115#1:298,3\n120#1:302,2\n120#1:322\n129#1:324,3\n161#1:327,3\n203#1:330\n203#1:331,3\n208#1:334\n208#1:335,2\n209#1:338,3\n120#1:301\n129#1:323\n209#1:337\n120#1:304,16\n120#1:321\n120#1:320\n*E\n"})
public final class IrTypeUtilsKt {
    @NotNull
    private static final FqName kotlinPackageFqn = FqName.Companion.fromSegments(kotlin.collections.CollectionsKt.listOf((Object)"kotlin"));
    @NotNull
    private static final FqName kotlinReflectionPackageFqn;
    @NotNull
    private static final FqName kotlinCoroutinesPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    public static final boolean isFunctionMarker(@NotNull IrType $this$isFunctionMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionMarker, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isFunctionMarker);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isFunctionMarker(irClassifierSymbol) : false;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isFunction(irClassifierSymbol) : false;
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isKFunction(irClassifierSymbol) : false;
    }

    public static final boolean isSuspendFunction(@NotNull IrType $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isSuspendFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isSuspendFunction(irClassifierSymbol) : false;
    }

    public static final boolean isKSuspendFunction(@NotNull IrType $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKSuspendFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKSuspendFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isKSuspendFunction(irClassifierSymbol) : false;
    }

    public static final boolean isKProperty(@NotNull IrType $this$isKProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isKProperty, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKProperty);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KProperty", kotlinReflectionPackageFqn) : false;
    }

    public static final boolean isKMutableProperty(@NotNull IrType $this$isKMutableProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isKMutableProperty, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKMutableProperty);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KMutableProperty", kotlinReflectionPackageFqn) : false;
    }

    public static final boolean isFunctionMarker(@NotNull IrClassifierSymbol $this$isFunctionMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionMarker, (String)"<this>");
        return IrTypeUtilsKt.isClassWithName($this$isFunctionMarker, "Function", kotlinPackageFqn);
    }

    public static final boolean isFunction(@NotNull IrClassifierSymbol $this$isFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isFunction, "Function", kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrClassifierSymbol $this$isKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKFunction, "KFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isSuspendFunction(@NotNull IrClassifierSymbol $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isSuspendFunction, "SuspendFunction", kotlinCoroutinesPackageFqn);
    }

    public static final boolean isKSuspendFunction(@NotNull IrClassifierSymbol $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKSuspendFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKSuspendFunction, "KSuspendFunction", kotlinReflectionPackageFqn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClassWithName(IrClassifierSymbol $this$isClassWithName, String name2, FqName packageFqName) {
        Object packageFqName$iv;
        Object object;
        IrClassifierSymbol $this$checkNameAndPackage$iv = $this$isClassWithName;
        boolean $i$f$checkNameAndPackage = false;
        if ($this$checkNameAndPackage$iv.isBound()) {
            IrSymbolOwner irSymbolOwner = $this$checkNameAndPackage$iv.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            IrDeclarationWithName classifier$iv = (IrDeclarationWithName)irSymbolOwner;
            String string = classifier$iv.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String it = string;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it, (Object)name2)) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = classifier$iv.getParent();
            if (!(irDeclarationParent instanceof IrPackageFragment)) return false;
            IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
            object = irPackageFragment;
            if (irPackageFragment == null) return false;
            FqName fqName = ((IrPackageFragment)object).getPackageFqName();
            object = fqName;
            if (fqName == null) return false;
            if ((object = ((FqName)object).asString()) == null) {
                return false;
            }
        } else {
            IdSignature idSignature = $this$checkNameAndPackage$iv.getSignature();
            if (!(idSignature instanceof IdSignature.CommonSignature)) return false;
            IdSignature.CommonSignature commonSignature = (IdSignature.CommonSignature)idSignature;
            if (commonSignature == null) {
                return false;
            }
            IdSignature.CommonSignature commonSignature$iv = commonSignature;
            String it = commonSignature$iv.getDeclarationFqName();
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it, (Object)name2)) return false;
            it = commonSignature$iv.getPackageFqName();
            boolean bl4 = false;
            if (!Intrinsics.areEqual((Object)it, (Object)packageFqName.asString())) return false;
            return true;
        }
        Object it = packageFqName$iv = object;
        boolean bl5 = false;
        boolean bl6 = Intrinsics.areEqual((Object)it, (Object)packageFqName.asString());
        return bl6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClassWithNamePrefix(IrClassifierSymbol $this$isClassWithNamePrefix, String prefix, FqName packageFqName) {
        Object packageFqName$iv;
        Object object;
        IrClassifierSymbol $this$checkNameAndPackage$iv = $this$isClassWithNamePrefix;
        boolean $i$f$checkNameAndPackage = false;
        if ($this$checkNameAndPackage$iv.isBound()) {
            IrSymbolOwner irSymbolOwner = $this$checkNameAndPackage$iv.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            IrDeclarationWithName classifier$iv = (IrDeclarationWithName)irSymbolOwner;
            String string = classifier$iv.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String it = string;
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = classifier$iv.getParent();
            if (!(irDeclarationParent instanceof IrPackageFragment)) return false;
            IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
            object = irPackageFragment;
            if (irPackageFragment == null) return false;
            FqName fqName = ((IrPackageFragment)object).getPackageFqName();
            object = fqName;
            if (fqName == null) return false;
            if ((object = ((FqName)object).asString()) == null) {
                return false;
            }
        } else {
            IdSignature idSignature = $this$checkNameAndPackage$iv.getSignature();
            if (!(idSignature instanceof IdSignature.CommonSignature)) return false;
            IdSignature.CommonSignature commonSignature = (IdSignature.CommonSignature)idSignature;
            if (commonSignature == null) {
                return false;
            }
            IdSignature.CommonSignature commonSignature$iv = commonSignature;
            String it = commonSignature$iv.getDeclarationFqName();
            boolean bl3 = false;
            if (!StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) return false;
            it = commonSignature$iv.getPackageFqName();
            boolean bl4 = false;
            if (!Intrinsics.areEqual((Object)it, (Object)packageFqName.asString())) return false;
            return true;
        }
        Object it = packageFqName$iv = object;
        boolean bl5 = false;
        boolean bl6 = Intrinsics.areEqual((Object)it, (Object)packageFqName.asString());
        return bl6;
    }

    private static final boolean checkNameAndPackage(IrClassifierSymbol $this$checkNameAndPackage, Function1<? super String, Boolean> checkName, Function1<? super String, Boolean> checkPackage) {
        boolean bl2;
        boolean $i$f$checkNameAndPackage = false;
        if ($this$checkNameAndPackage.isBound()) {
            IrSymbolOwner irSymbolOwner = $this$checkNameAndPackage.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            IrDeclarationWithName classifier = (IrDeclarationWithName)irSymbolOwner;
            String string = classifier.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            if (!((Boolean)checkName.invoke((Object)string)).booleanValue()) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = classifier.getParent();
            Object object = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
            if (object == null || (object = ((IrPackageFragment)object).getPackageFqName()) == null || (object = ((FqName)object).asString()) == null) {
                return false;
            }
            Object packageFqName = object;
            bl2 = (Boolean)checkPackage.invoke(packageFqName);
        } else {
            IdSignature idSignature = $this$checkNameAndPackage.getSignature();
            IdSignature.CommonSignature commonSignature = idSignature instanceof IdSignature.CommonSignature ? (IdSignature.CommonSignature)idSignature : null;
            if (commonSignature == null) {
                return false;
            }
            IdSignature.CommonSignature commonSignature2 = commonSignature;
            bl2 = (Boolean)checkName.invoke((Object)commonSignature2.getDeclarationFqName()) != false && (Boolean)checkPackage.invoke((Object)commonSignature2.getPackageFqName()) != false;
        }
        return bl2;
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrClassifierSymbol $this$superTypes) {
        List<IrType> list;
        Intrinsics.checkNotNullParameter((Object)$this$superTypes, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = $this$superTypes;
        if (irClassifierSymbol instanceof IrClassSymbol) {
            list = ((IrClass)((IrClassSymbol)$this$superTypes).getOwner()).getSuperTypes();
        } else if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            list = ((IrTypeParameter)((IrTypeParameterSymbol)$this$superTypes).getOwner()).getSuperTypes();
        } else if (irClassifierSymbol instanceof IrScriptSymbol) {
            list = kotlin.collections.CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    public static final boolean isSubtypeOfClass(@NotNull IrClassifierSymbol $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return FqNameEqualityChecker.INSTANCE.areEqual($this$isSubtypeOfClass, superClass) || IrTypeUtilsKt.isStrictSubtypeOfClass($this$isSubtypeOfClass, superClass);
    }

    public static final boolean isStrictSubtypeOfClass(@NotNull IrClassifierSymbol $this$isStrictSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        boolean bl2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isStrictSubtypeOfClass, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
            Iterable $this$any$iv = IrTypeUtilsKt.superTypes($this$isStrictSubtypeOfClass);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl3 = false;
                    if (!IrTypeUtilsKt.isSubtypeOfClass(it, superClass)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $this$superTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$superTypes, (String)"<this>");
        Object object = IrTypesKt.getClassifierOrNull($this$superTypes);
        if (object == null || (object = IrTypeUtilsKt.superTypes((IrClassifierSymbol)object)) == null) {
            object = kotlin.collections.CollectionsKt.emptyList();
        }
        return object;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionTypeOrSubtype, (String)"<this>");
        Boolean bl2 = DFS.ifAny(kotlin.collections.CollectionsKt.listOf((Object)$this$isFunctionTypeOrSubtype), IrTypeUtilsKt::superTypes, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"ifAny(...)");
        return bl2;
    }

    public static final boolean isSuspendFunctionTypeOrSubtype(@NotNull IrType $this$isSuspendFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionTypeOrSubtype, (String)"<this>");
        Boolean bl2 = DFS.ifAny(kotlin.collections.CollectionsKt.listOf((Object)$this$isSuspendFunctionTypeOrSubtype), IrTypeUtilsKt::superTypes, isSuspendFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"ifAny(...)");
        return bl2;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeParameter, (String)"<this>");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterface, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isInterface);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isExternalObject(@NotNull IrType $this$isExternalObject) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalObject, (String)"<this>");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isExternalObject);
        IrClass it = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
        boolean bl2 = false;
        IrClass irClass = it;
        return (irClass != null ? irClass.getKind() : null) == ClassKind.OBJECT && it.isExternal();
    }

    public static final boolean isAnnotation(@NotNull IrType $this$isAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnnotation, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isAnnotation);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).getKind() : null) == ClassKind.ANNOTATION_CLASS;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $this$isFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionOrKFunction, (String)"<this>");
        return IrTypeUtilsKt.isFunction($this$isFunctionOrKFunction) || IrTypeUtilsKt.isKFunction($this$isFunctionOrKFunction);
    }

    public static final boolean isSuspendFunctionOrKFunction(@NotNull IrType $this$isSuspendFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionOrKFunction, (String)"<this>");
        return IrTypeUtilsKt.isSuspendFunction($this$isSuspendFunctionOrKFunction) || IrTypeUtilsKt.isKSuspendFunction($this$isSuspendFunctionOrKFunction);
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)$this$isThrowable, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isThrowable;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl2 = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)name2.asString(), (Object)"Throwable")) {
                    bl2 = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl2 = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl2 = Intrinsics.areEqual((Object)parent$iv.getPackageFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)$this$isUnsigned, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsigned;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl2 = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl3 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedType(name2)) {
                    bl2 = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl2 = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl2 = Intrinsics.areEqual((Object)parent$iv.getPackageFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public static final boolean isUnsignedArray(@NotNull IrType $this$isUnsignedArray) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)$this$isUnsignedArray, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsignedArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl2 = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl3 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedArray(name2)) {
                    bl2 = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl2 = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl2 = Intrinsics.areEqual((Object)parent$iv.getPackageFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private static final boolean isTypeFromKotlinPackage(IrType $this$isTypeFromKotlinPackage, Function1<? super Name, Boolean> namePredicate) {
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                return false;
            }
            IrClassSymbol classClassifier = irClassSymbol;
            if (!((Boolean)namePredicate.invoke((Object)((IrClass)classClassifier.getOwner()).getName())).booleanValue()) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier.getOwner()).getParent();
            IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
            if (irPackageFragment == null) {
                return false;
            }
            IrPackageFragment parent2 = irPackageFragment;
            return Intrinsics.areEqual((Object)parent2.getPackageFqName(), (Object)kotlinPackageFqn);
        }
        return false;
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isPrimitiveArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl2 = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name it = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl3 = false;
                if (!StandardNames.FqNames.primitiveArrayTypeShortNames.contains(it)) {
                    bl2 = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl2 = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl2 = Intrinsics.areEqual((Object)parent$iv.getPackageFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    @Nullable
    public static final PrimitiveType getPrimitiveArrayElementType(@NotNull IrType $this$getPrimitiveArrayElementType) {
        PrimitiveType primitiveType;
        Intrinsics.checkNotNullParameter((Object)$this$getPrimitiveArrayElementType, (String)"<this>");
        IrSimpleType irSimpleType = $this$getPrimitiveArrayElementType instanceof IrSimpleType ? (IrSimpleType)$this$getPrimitiveArrayElementType : null;
        if (irSimpleType != null) {
            IrSimpleType it = irSimpleType;
            boolean bl2 = false;
            IrSymbolOwner irSymbolOwner = it.getClassifier().getOwner();
            Object object = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
            if (object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
                Object fqn = object;
                boolean bl3 = false;
                primitiveType = StandardNames.FqNames.arrayClassFqNameToPrimitiveType.get(fqn);
            } else {
                primitiveType = null;
            }
        } else {
            primitiveType = null;
        }
        return primitiveType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull List<? extends IrTypeParameter> params, @NotNull List<? extends IrType> arguments2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$substitute, (String)"<this>");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Iterable iterable = params;
        IrType irType = $this$substitute;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getSymbol());
        }
        return IrTypeUtilsKt.substitute(irType, MapsKt.toMap((Iterable)kotlin.collections.CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Iterable)arguments2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull Map<IrTypeParameterSymbol, ? extends IrType> substitutionMap) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$substitute, (String)"<this>");
        Intrinsics.checkNotNullParameter(substitutionMap, (String)"substitutionMap");
        if (!($this$substitute instanceof IrSimpleType) || substitutionMap.isEmpty()) {
            return $this$substitute;
        }
        Object $this$memoryOptimizedMap$iv = $this$substitute.getAnnotations();
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)it;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
            boolean $i$f$deepCopyImpl = false;
            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
            boolean bl3 = false;
            ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
            TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
            IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
            if (irElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
            }
            collection.add((IrConstructorCall)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrConstructorCall)irElement), initialParent$iv));
        }
        List newAnnotations = CollectionsKt.compactIfPossible((List)destination$iv$iv);
        $this$memoryOptimizedMap$iv = substitutionMap.get(((IrSimpleType)$this$substitute).getClassifier());
        if ($this$memoryOptimizedMap$iv != null) {
            Object substitutedType = $this$memoryOptimizedMap$iv;
            boolean bl4 = false;
            return IrTypesKt.addAnnotations(IrTypesKt.mergeNullability((IrType)substitutedType, $this$substitute), newAnnotations);
        }
        Collection $this$memoryOptimizedMap$iv2 = ((IrSimpleType)$this$substitute).getArguments();
        boolean $i$f$memoryOptimizedMap2 = false;
        Iterable bl4 = $this$memoryOptimizedMap$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$memoryOptimizedMap$iv2.size());
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument;
            void it;
            IrTypeArgument bl2 = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            void var13_19 = it;
            if (var13_19 instanceof IrTypeProjection) {
                irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(IrTypeUtilsKt.substitute(((IrTypeProjection)it).getType(), substitutionMap), ((IrTypeProjection)it).getVariance());
            } else if (var13_19 instanceof IrStarProjection) {
                irTypeArgument = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(irTypeArgument);
        }
        List newArguments2 = CollectionsKt.compactIfPossible((List)destination$iv$iv2);
        return new IrSimpleTypeImpl(((IrSimpleType)$this$substitute).getClassifier(), ((IrSimpleType)$this$substitute).getNullability(), newArguments2, newAnnotations, null, 16, null);
    }

    public static final boolean isSubtypeOfClass(@NotNull IrType $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return $this$isSubtypeOfClass instanceof IrSimpleType && IrTypeUtilsKt.isSubtypeOfClass(((IrSimpleType)$this$isSubtypeOfClass).getClassifier(), superClass);
    }

    public static final boolean isStrictSubtypeOfClass(@NotNull IrType $this$isStrictSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isStrictSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return $this$isStrictSubtypeOfClass instanceof IrSimpleType && IrTypeUtilsKt.isStrictSubtypeOfClass(((IrSimpleType)$this$isStrictSubtypeOfClass).getClassifier(), superClass);
    }

    public static final boolean isSubtypeOf(@NotNull IrType $this$isSubtypeOf, @NotNull IrType superType, @NotNull IrTypeSystemContext typeSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, IrTypeCheckerStateKt.createIrTypeCheckerState(typeSystem), (KotlinTypeMarker)$this$isSubtypeOf, (KotlinTypeMarker)superType, false, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNullable(@NotNull IrType $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"<this>");
        IrType irType = $this$isNullable;
        if (irType instanceof IrSimpleType) {
            IrClassifierSymbol classifier = ((IrSimpleType)$this$isNullable).getClassifier();
            if (classifier instanceof IrClassSymbol) {
                if (((IrSimpleType)$this$isNullable).getNullability() != SimpleTypeNullability.MARKED_NULLABLE) return false;
                return true;
            }
            if (classifier instanceof IrTypeParameterSymbol) {
                switch (WhenMappings.$EnumSwitchMapping$0[((IrSimpleType)$this$isNullable).getNullability().ordinal()]) {
                    case 1: {
                        return true;
                    }
                    case 2: {
                        IrType p0;
                        Iterable $this$any$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            return false;
                        }
                        Iterator iterator2 = $this$any$iv.iterator();
                        do {
                            if (!iterator2.hasNext()) return false;
                            Object element$iv = iterator2.next();
                            p0 = (IrType)element$iv;
                            boolean bl2 = false;
                        } while (!IrTypeUtilsKt.isNullable(p0));
                        return true;
                    }
                    case 3: {
                        return false;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (!(classifier instanceof IrScriptSymbol)) throw new NoWhenBranchMatchedException();
            if (((IrSimpleType)$this$isNullable).getNullability() != SimpleTypeNullability.MARKED_NULLABLE) return false;
            return true;
        }
        if (irType instanceof IrDynamicType) {
            return true;
        }
        if (!(irType instanceof IrErrorType)) throw new NoWhenBranchMatchedException();
        boolean bl3 = ((IrErrorType)$this$isNullable).isMarkedNullable();
        return bl3;
    }

    public static final boolean isBoxedArray(@NotNull IrType $this$isBoxedArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoxedArray, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isBoxedArray);
        return Intrinsics.areEqual(object != null && (object = (IrClass)object.getOwner()) != null ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object) : null, (Object)StandardNames.FqNames.array.toSafe());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final IrType getArrayElementType(@NotNull IrType $this$getArrayElementType, @NotNull IrBuiltIns irBuiltIns) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$getArrayElementType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (!IrTypeUtilsKt.isBoxedArray($this$getArrayElementType)) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getArrayElementType);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClassSymbol classifier = irClassSymbol;
            IrType irType2 = irBuiltIns.getPrimitiveArrayElementTypes().get(classifier);
            irType = irType2;
            if (irType2 != null) return irType;
            IrType irType3 = irBuiltIns.getUnsignedArraysElementTypes().get(classifier);
            irType = irType3;
            if (irType3 != null) return irType;
            throw new AssertionError((Object)("Primitive array expected: " + classifier));
        }
        IrTypeArgument argument = (IrTypeArgument)kotlin.collections.CollectionsKt.singleOrNull(((IrSimpleType)$this$getArrayElementType).getArguments());
        if (argument instanceof IrTypeProjection) {
            irType = ((IrTypeProjection)argument).getType();
            return irType;
        }
        if (argument instanceof IrStarProjection) {
            irType = irBuiltIns.getAnyNType();
            return irType;
        }
        if (argument != null) throw new NoWhenBranchMatchedException();
        throw new IllegalStateException("Unexpected array argument type: null".toString());
    }

    @NotNull
    public static final IrType toArrayOrPrimitiveArrayType(@NotNull IrType $this$toArrayOrPrimitiveArrayType, @NotNull IrBuiltIns irBuiltIns) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toArrayOrPrimitiveArrayType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (IrTypePredicatesKt.isPrimitiveType$default($this$toArrayOrPrimitiveArrayType, false, 1, null)) {
            object = irBuiltIns.getPrimitiveArrayForType().get($this$toArrayOrPrimitiveArrayType);
            if (object == null || (object = IrTypesKt.getDefaultType((IrClassifierSymbol)object)) == null) {
                throw new AssertionError((Object)($this$toArrayOrPrimitiveArrayType + " not in primitiveArrayForType"));
            }
        } else {
            IrType[] irTypeArray = new IrType[]{$this$toArrayOrPrimitiveArrayType};
            object = IrTypesKt.typeWith((IrClassifierSymbol)irBuiltIns.getArrayClass(), irTypeArray);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IrSimpleType> getImmediateSupertypes(IrSimpleType irType) {
        void $this$memoryOptimizedMap$iv;
        Iterable $this$filterTo$iv$iv;
        Collection $this$filter$iv;
        IrType it;
        Collection collection;
        void $this$mapTo$iv$iv;
        IrClass irClass = IrTypesKt.getClass(irType);
        if (irClass == null) {
            throw new AssertionError((Object)("Not a class type: " + RenderIrElementKt.render$default(irType, null, 1, null)));
        }
        IrClass irClass2 = irClass;
        List<IrType> originalSupertypes = irClass2.getSuperTypes();
        Iterable $this$map$iv = irType.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            IrType irType2 = IrTypesKt.getTypeOrNull(it);
            if (irType2 == null) {
                throw new AssertionError((Object)("*-projection in supertype arguments: " + RenderIrElementKt.render$default(irType, null, 1, null)));
            }
            collection.add(irType2);
        }
        List arguments2 = (List)destination$iv$iv;
        $this$map$iv = originalSupertypes;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl3 = false;
            if (!(IrTypesKt.getClassOrNull(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$memoryOptimizedMap = false;
        $this$filterTo$iv$iv = (Iterable)$this$memoryOptimizedMap$iv;
        destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void superType;
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            IrType irType3 = IrTypeUtilsKt.substitute((IrType)superType, irClass2.getTypeParameters(), arguments2);
            Intrinsics.checkNotNull((Object)irType3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            collection.add((IrSimpleType)irType3);
        }
        return CollectionsKt.compactIfPossible((List)destination$iv$iv);
    }

    private static final void collectAllSupertypes(IrSimpleType irType, Set<IrSimpleType> result2) {
        List<IrSimpleType> immediateSupertypes = IrTypeUtilsKt.getImmediateSupertypes(irType);
        result2.addAll((Collection<IrSimpleType>)immediateSupertypes);
        for (IrSimpleType supertype : immediateSupertypes) {
            IrTypeUtilsKt.collectAllSupertypes(supertype, result2);
        }
    }

    @NotNull
    public static final Set<IrSimpleType> getAllSubstitutedSupertypes(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        HashSet result2 = new HashSet();
        IrTypeUtilsKt.collectAllSupertypes(IrUtilsKt.getDefaultType(irClass), result2);
        return result2;
    }

    private static final void collectAllSuperclasses(IrClass irClass, Set<IrClass> set) {
        for (IrType superType : irClass.getSuperTypes()) {
            IrClassSymbol classifier;
            IrClass superClass;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(superType);
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null || !set.add(superClass = (IrClass)(classifier = irClassSymbol).getOwner())) continue;
            IrTypeUtilsKt.collectAllSuperclasses(superClass, set);
        }
    }

    @NotNull
    public static final Set<IrClass> getAllSuperclasses(@NotNull IrClass $this$getAllSuperclasses) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllSuperclasses, (String)"<this>");
        HashSet result2 = new HashSet();
        IrTypeUtilsKt.collectAllSuperclasses($this$getAllSuperclasses, result2);
        return result2;
    }

    public static final boolean isReifiedTypeParameter(@NotNull IrType $this$isReifiedTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isReifiedTypeParameter, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isReifiedTypeParameter);
        Object object = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
        return object != null && (object = (IrTypeParameter)object.getOwner()) != null ? ((IrTypeParameter)object).isReified() : false;
    }

    static {
        Name name2 = Name.identifier("reflect");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        kotlinReflectionPackageFqn = kotlinPackageFqn.child(name2);
        Name name3 = Name.identifier("coroutines");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        kotlinCoroutinesPackageFqn = kotlinPackageFqn.child(name3);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SimpleTypeNullability.values().length];
            try {
                nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

