/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.JvmFieldApplicabilityProblem;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u000f*\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0002J\f\u0010\u0017\u001a\u00020\u000f*\u00020\u0002H\u0002J\u0014\u0010\u0018\u001a\u00020\u000f*\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u001a\u001a\u00020\u000f*\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "isInlineClassThatRequiresMangling", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isDontMangleClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "isOverridable", "containingClass", "hasCustomAccessor", "isInsideCompanionObjectOfInterface", "isInterfaceCompanionWithPublicJvmFieldProperties", "hasJvmFieldAnnotation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "isInsideJvmMultifileClassFile", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmFieldApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmFieldApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n21#2:152\n37#2:153\n55#2:154\n54#2:155\n21#2:161\n11#2:162\n59#3:156\n53#3,4:157\n42#3:163\n65#3:164\n18#3:168\n13#3:169\n1761#4,3:165\n*S KotlinDebug\n*F\n+ 1 FirJvmFieldApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker\n*L\n52#1:152\n54#1:153\n55#1:154\n56#1:155\n106#1:161\n106#1:162\n98#1:156\n98#1:157,4\n107#1:163\n116#1:164\n129#1:168\n131#1:169\n146#1:165,3\n*E\n"})
public final class FirJvmFieldApplicabilityChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirJvmFieldApplicabilityChecker INSTANCE = new FirJvmFieldApplicabilityChecker();

    private FirJvmFieldApplicabilityChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration2) {
        KtDiagnosticFactory1<String> ktDiagnosticFactory1;
        JvmFieldApplicabilityProblem jvmFieldApplicabilityProblem;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirSession session = context2.getSession();
        FirPureAbstractElement firPureAbstractElement = declaration2.getBackingField();
        if (firPureAbstractElement == null || (firPureAbstractElement = FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)((Object)firPureAbstractElement), JvmAbi.JVM_FIELD_ANNOTATION_CLASS_ID, session)) == null) {
            return;
        }
        FirPureAbstractElement annotation = firPureAbstractElement;
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(declaration2);
        FirRegularClassSymbol containingClassSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, session) : null;
        if (declaration2.getDelegate() != null) {
            jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.DELEGATE;
        } else {
            if (!DeclarationAttributesKt.getHasBackingField(declaration2)) {
                return;
            }
            if (this.isOverridable(declaration2, containingClassSymbol)) {
                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.NOT_FINAL;
            } else {
                FirMemberDeclaration $this$visibility$iv = declaration2;
                boolean $i$f$getVisibility = false;
                if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.PRIVATE;
                } else if (this.hasCustomAccessor(declaration2)) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.CUSTOM_ACCESSOR;
                } else {
                    FirMemberDeclaration $this$isOverride$iv = declaration2;
                    boolean $i$f$isOverride = false;
                    if ($this$isOverride$iv.getStatus().isOverride()) {
                        jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.OVERRIDES;
                    } else {
                        FirMemberDeclaration $this$isLateInit$iv = declaration2;
                        boolean $i$f$isLateInit = false;
                        if ($this$isLateInit$iv.getStatus().isLateInit()) {
                            jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.LATEINIT;
                        } else {
                            FirMemberDeclaration $this$isConst$iv = declaration2;
                            boolean $i$f$isConst = false;
                            if ($this$isConst$iv.getStatus().isConst()) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.CONST;
                            } else if (containingClassSymbol != null && this.isInsideCompanionObjectOfInterface(containingClassSymbol, session)) {
                                if (this.isInterfaceCompanionWithPublicJvmFieldProperties(containingClassSymbol, session)) return;
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.NOT_PUBLIC_VAL_WITH_JVMFIELD;
                            } else if (containingClassSymbol == null && this.isInsideJvmMultifileClassFile(context2)) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
                            } else if (this.isInlineClassThatRequiresMangling(declaration2.getReturnTypeRef(), session)) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.RETURN_TYPE_IS_VALUE_CLASS;
                            } else if (org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt.needsMultiFieldValueClassFlattening(declaration2.getReturnTypeRef(), session)) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.RETURN_TYPE_IS_VALUE_CLASS;
                            } else {
                                FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol;
                                if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) != ClassKind.ANNOTATION_CLASS) return;
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.ANNOTATION;
                            }
                        }
                    }
                }
            }
        }
        JvmFieldApplicabilityProblem problem = jvmFieldApplicabilityProblem;
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration2), (Object)true) && !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitJvmFieldOnOverrideFromInterfaceInPrimaryConstructor)) {
            ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD_WARNING();
        } else if (problem == JvmFieldApplicabilityProblem.ANNOTATION) {
            if (!languageVersionSettings.supportsFeature(LanguageFeature.ForbidJvmAnnotationsOnAnnotationParameters)) {
                ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD_WARNING();
            } else {
                if (languageVersionSettings.supportsFeature(LanguageFeature.ForbidFieldAnnotationsOnAnnotationParameters)) {
                    return;
                }
                ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD();
            }
        } else {
            ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD();
        }
        KtDiagnosticFactory1<String> factory2 = ktDiagnosticFactory1;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirAnnotation)annotation).getSource(), factory2, (Object)problem.getErrorMessage(), null, 16, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInlineClassThatRequiresMangling(FirTypeRef $this$isInlineClassThatRequiresMangling, FirSession session) {
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType($this$isInlineClassThatRequiresMangling), session);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$isInlineOrValue$iv = symbol;
        boolean $i$f$isInlineOrValue = false;
        FirClassLikeSymbol $this$isInline$iv$iv = $this$isInlineOrValue$iv;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv$iv.getRawStatus().isInline()) {
            FirClassLikeSymbol $this$isValue$iv$iv = $this$isInlineOrValue$iv;
            boolean $i$f$isValue = false;
            if (!$this$isValue$iv$iv.getRawStatus().isValue()) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        if (this.isDontMangleClass(symbol)) return false;
        return true;
    }

    private final boolean isDontMangleClass(FirRegularClassSymbol $this$isDontMangleClass) {
        return Intrinsics.areEqual((Object)$this$isDontMangleClass.getClassId(), (Object)StandardClassIds.INSTANCE.getResult());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOverridable(FirProperty $this$isOverridable, FirRegularClassSymbol containingClass) {
        FirMemberDeclaration $this$visibility$iv = $this$isOverridable;
        boolean $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) return false;
        FirMemberDeclaration $this$modality$iv = $this$isOverridable;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) return false;
        FirRegularClassSymbol firRegularClassSymbol = containingClass;
        if (firRegularClassSymbol == null) return true;
        FirClassLikeSymbol $this$isFinal$iv = firRegularClassSymbol;
        boolean $i$f$isFinal = false;
        if ($this$isFinal$iv.getResolvedStatus().getModality() != Modality.FINAL) return true;
        return false;
    }

    private final boolean hasCustomAccessor(FirProperty $this$hasCustomAccessor) {
        Object object;
        Object object2;
        return $this$hasCustomAccessor.getGetter() != null && !(((object2 = $this$hasCustomAccessor.getGetter()) != null && (object2 = ((FirPropertyAccessor)object2).getSource()) != null ? ((KtSourceElement)object2).getKind() : null) instanceof KtFakeSourceElementKind) || $this$hasCustomAccessor.getSetter() != null && !(((object = $this$hasCustomAccessor.getSetter()) != null && (object = ((FirPropertyAccessor)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtFakeSourceElementKind);
    }

    private final boolean isInsideCompanionObjectOfInterface(FirRegularClassSymbol $this$isInsideCompanionObjectOfInterface, FirSession session) {
        FirClassLikeSymbol $this$isCompanion$iv = $this$isInsideCompanionObjectOfInterface;
        boolean $i$f$isCompanion = false;
        if (!$this$isCompanion$iv.getRawStatus().isCompanion()) {
            return false;
        }
        FirClassLikeSymbol<FirClassLikeDeclaration> firClassLikeSymbol = org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt.getContainingDeclaration($this$isInsideCompanionObjectOfInterface, session);
        ClassKind outerClassKind = firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null;
        return outerClassKind == ClassKind.INTERFACE || outerClassKind == ClassKind.ANNOTATION_CLASS;
    }

    private final boolean isInterfaceCompanionWithPublicJvmFieldProperties(FirRegularClassSymbol containingClass, FirSession session) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        result2.element = true;
        DeclarationUtilsKt.processAllDeclaredCallables$default(containingClass, session, null, arg_0 -> FirJvmFieldApplicabilityChecker.isInterfaceCompanionWithPublicJvmFieldProperties$lambda$0(result2, session, arg_0), 2, null);
        return result2.element;
    }

    private final boolean hasJvmFieldAnnotation(FirPropertySymbol $this$hasJvmFieldAnnotation, FirSession session) {
        FirBackingFieldSymbol firBackingFieldSymbol = $this$hasJvmFieldAnnotation.getBackingFieldSymbol();
        return (firBackingFieldSymbol != null ? FirAnnotationUtilsKt.getAnnotationByClassId(firBackingFieldSymbol, JvmAbi.JVM_FIELD_ANNOTATION_CLASS_ID, session) : null) != null;
    }

    private final boolean isInsideJvmMultifileClassFile(CheckerContext context2) {
        boolean bl2;
        Object object = context2.getContainingFile();
        if (object != null && (object = ((FirFile)object).getAnnotations()) != null) {
            boolean bl3;
            block5: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef())), (Object)JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS_ID())) continue;
                        bl3 = true;
                        break block5;
                    }
                    bl3 = false;
                }
            }
            bl2 = bl3;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private static final Unit isInterfaceCompanionWithPublicJvmFieldProperties$lambda$0(Ref.BooleanRef $result, FirSession $session, FirCallableSymbol symbol) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                if (!$result.element || !(symbol instanceof FirPropertySymbol)) {
                    return Unit.INSTANCE;
                }
                FirCallableSymbol $this$visibility$iv = symbol;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Public.INSTANCE) || ((FirPropertySymbol)symbol).isVar()) break block4;
                FirCallableSymbol $this$modality$iv = symbol;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL && INSTANCE.hasJvmFieldAnnotation((FirPropertySymbol)symbol, $session)) break block5;
            }
            $result.element = false;
        }
        return Unit.INSTANCE;
    }
}

