/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ThreadLocalTypes;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCandidateInfo
extends CandidateInfo {
    public static final RecursionGuard<PsiElement> ourOverloadGuard = RecursionManager.createGuard("overload.guard");
    @ApplicabilityLevelConstant
    private volatile int myApplicabilityLevel;
    @ApplicabilityLevelConstant
    private volatile int myPertinentApplicabilityLevel;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor;
    private volatile @NlsContexts.DetailedDescription String myInferenceError;
    private volatile boolean myApplicabilityError;
    private final LanguageLevel myLanguageLevel;
    private volatile boolean myErased;

    public MethodCandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor2, boolean accessProblem, boolean staticsProblem, @NotNull PsiElement argumentList, PsiElement currFileContext, PsiType @Nullable [] argumentTypes, PsiType[] typeArguments2) {
        if (candidate == null) {
            MethodCandidateInfo.$$$reportNull$$$0(0);
        }
        if (substitutor2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(1);
        }
        if (argumentList == null) {
            MethodCandidateInfo.$$$reportNull$$$0(2);
        }
        this(candidate, substitutor2, accessProblem, staticsProblem, argumentList, currFileContext, argumentTypes, typeArguments2, PsiUtil.getLanguageLevel(argumentList));
    }

    public MethodCandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor2, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, PsiType @Nullable [] argumentTypes, PsiType[] typeArguments2, @NotNull LanguageLevel languageLevel) {
        if (candidate == null) {
            MethodCandidateInfo.$$$reportNull$$$0(3);
        }
        if (substitutor2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(4);
        }
        if (languageLevel == null) {
            MethodCandidateInfo.$$$reportNull$$$0(5);
        }
        super(candidate, substitutor2, accessProblem, staticsProblem, currFileContext);
        this.myArgumentList = argumentList;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments2;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isVarargs() {
        return false;
    }

    public boolean isApplicable() {
        return this.getPertinentApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        PsiType[] argumentTypes = this.getArgumentTypes();
        if (argumentTypes == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), argumentTypes, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        int result2 = this.myApplicabilityLevel;
        if (result2 == 0) {
            this.myApplicabilityLevel = result2 = this.getApplicabilityLevelInner();
        }
        return result2;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel() {
        return this.getPertinentApplicabilityLevel(null);
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel(@Nullable Map<MethodCandidateInfo, PsiSubstitutor> map) {
        int result2 = this.myPertinentApplicabilityLevel;
        if (result2 == 0) {
            this.myPertinentApplicabilityLevel = result2 = this.getPertinentApplicabilityLevelInner(() -> map != null ? (PsiSubstitutor)map.get(this) : this.getSubstitutor(false));
        }
        return result2;
    }

    @ApplicabilityLevelConstant
    private int getPertinentApplicabilityLevelInner(Supplier<? extends PsiSubstitutor> substitutorSupplier) {
        if (this.myArgumentList == null || !this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return this.getApplicabilityLevel();
        }
        PsiMethod method = this.getElement();
        if (this.isToInferApplicability()) {
            substitutorSupplier.get();
            if (this.myApplicabilityError || this.isPotentiallyCompatible() != ThreeState.YES) {
                return 1;
            }
            return this.isVarargs() ? 2 : 3;
        }
        PsiSubstitutor substitutor2 = substitutorSupplier.get();
        Computable<Integer> computable = () -> this.computeWithKnownTargetType(() -> {
            PsiType[] argumentTypes = this.getArgumentTypes();
            if (argumentTypes == null) {
                return 1;
            }
            int level1 = PsiUtil.getApplicabilityLevel(method, substitutor2, argumentTypes, this.myLanguageLevel, true, true, (left, right, allowUncheckedConversion, argId) -> MethodCandidateInfo.checkFunctionalInterfaceAcceptance(method, left, right, allowUncheckedConversion));
            if (!this.isVarargs() && level1 < 3) {
                return 1;
            }
            return level1;
        }, substitutor2);
        Integer applicabilityLevel = ourOverloadGuard.doPreventingRecursion(this.myArgumentList, false, computable);
        if (applicabilityLevel == null) {
            return 1;
        }
        int level = applicabilityLevel;
        if (level > 1 && !this.isTypeArgumentsApplicable(() -> substitutor2)) {
            level = 1;
        }
        return level;
    }

    private <T> T computeWithKnownTargetType(Computable<T> computable, PsiSubstitutor substitutor2) {
        if (this.myArgumentList instanceof PsiExpressionList) {
            PsiExpressionList argumentList = (PsiExpressionList)this.myArgumentList;
            PsiElement parent2 = argumentList.getParent();
            boolean prohibitCaching = (Boolean)CachedValuesManager.getCachedValue(parent2, () -> new CachedValueProvider.Result<Boolean>(!(parent2 instanceof PsiCallExpression) || JavaPsiFacade.getInstance(parent2.getProject()).getResolveHelper().hasOverloads((PsiCallExpression)parent2), PsiModificationTracker.MODIFICATION_COUNT));
            PsiExpression[] expressions = (PsiExpression[])Arrays.stream(argumentList.getExpressions()).map(expression2 -> PsiUtil.skipParenthesizedExprDown(expression2)).filter(expression2 -> expression2 != null && PsiPolyExpressionUtil.isPolyExpression(expression2)).toArray(PsiExpression[]::new);
            return (T)ThreadLocalTypes.performWithTypes(expressionTypes -> {
                PsiMethod method = this.getElement();
                boolean varargs = this.isVarargs();
                for (PsiExpression context2 : expressions) {
                    expressionTypes.forceType(context2, PsiTypesUtil.getTypeByMethod(context2, argumentList, method, varargs, substitutor2, false));
                }
                return computable.compute();
            }, prohibitCaching);
        }
        return computable.compute();
    }

    public boolean isOnArgumentList(PsiExpressionList argumentList) {
        return this.myArgumentList == argumentList;
    }

    public void setErased() {
        this.myErased = true;
    }

    public boolean isErased() {
        return this.myErased;
    }

    private static boolean checkFunctionalInterfaceAcceptance(PsiMethod method, PsiType left, PsiType right, boolean allowUncheckedConversion) {
        PsiFunctionalExpression fun = null;
        if (right instanceof PsiLambdaExpressionType) {
            fun = ((PsiLambdaExpressionType)right).getExpression();
        } else if (right instanceof PsiMethodReferenceType) {
            fun = ((PsiMethodReferenceType)right).getExpression();
        }
        return fun != null ? !(left instanceof PsiArrayType) && fun.isAcceptable(left, method) : TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);
    }

    public boolean isToInferApplicability() {
        return this.myTypeArguments == null && this.getElement().hasTypeParameters() && !this.isRawSubstitution();
    }

    public ThreeState isPotentiallyCompatible() {
        if (this.myArgumentList instanceof PsiExpressionList) {
            PsiMethod method = this.getElement();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiExpression[] expressions = ((PsiExpressionList)this.myArgumentList).getExpressions();
            if (!this.isVarargs() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                if (expressions.length != parameters2.length) {
                    return ThreeState.NO;
                }
            } else {
                if (expressions.length < parameters2.length - 1) {
                    return ThreeState.NO;
                }
                if (parameters2.length == 0 && expressions.length != parameters2.length) {
                    return ThreeState.NO;
                }
            }
            boolean unsure = false;
            for (int i2 = 0; i2 < expressions.length; ++i2) {
                ThreeState compatible;
                PsiType formalParameterType;
                PsiExpression expression2 = expressions[i2];
                PsiType psiType = formalParameterType = i2 < parameters2.length ? parameters2[i2].getType() : parameters2[parameters2.length - 1].getType();
                if (formalParameterType instanceof PsiEllipsisType && this.isVarargs()) {
                    formalParameterType = ((PsiEllipsisType)formalParameterType).getComponentType();
                }
                if ((compatible = MethodCandidateInfo.isPotentialCompatible(expression2, this.getSiteSubstitutor().substitute(formalParameterType), method)) == ThreeState.NO) {
                    return ThreeState.NO;
                }
                if (compatible != ThreeState.UNSURE) continue;
                unsure = true;
            }
            if (unsure) {
                return ThreeState.UNSURE;
            }
            if (method.hasTypeParameters() && this.myTypeArguments != null) {
                return ThreeState.fromBoolean(method.getTypeParameters().length == this.myTypeArguments.length);
            }
        }
        return ThreeState.YES;
    }

    private static ThreeState isPotentialCompatible(PsiExpression expression2, PsiType formalType, PsiMethod method) {
        if (expression2 instanceof PsiFunctionalExpression) {
            PsiClass targetTypeParameter = PsiUtil.resolveClassInClassTypeOnly(formalType);
            if (targetTypeParameter instanceof PsiTypeParameter && method.equals(((PsiTypeParameter)targetTypeParameter).getOwner())) {
                return ThreeState.YES;
            }
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(formalType);
            if (interfaceMethod == null) {
                return ThreeState.NO;
            }
            if (expression2 instanceof PsiLambdaExpression && ((PsiLambdaExpression)expression2).getParameterList().getParametersCount() != interfaceMethod.getParameterList().getParametersCount()) {
                return ThreeState.NO;
            }
            if (!((PsiFunctionalExpression)expression2).isPotentiallyCompatible(formalType)) {
                return ThreeState.UNSURE;
            }
        } else {
            if (expression2 instanceof PsiParenthesizedExpression) {
                return MethodCandidateInfo.isPotentialCompatible(((PsiParenthesizedExpression)expression2).getExpression(), formalType, method);
            }
            if (expression2 instanceof PsiConditionalExpression) {
                ThreeState thenCompatible = MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression2).getThenExpression(), formalType, method);
                ThreeState elseCompatible = MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression2).getElseExpression(), formalType, method);
                if (thenCompatible == ThreeState.NO || elseCompatible == ThreeState.NO) {
                    return ThreeState.NO;
                }
                if (thenCompatible == ThreeState.UNSURE || elseCompatible == ThreeState.UNSURE) {
                    return ThreeState.UNSURE;
                }
            } else if (expression2 instanceof PsiSwitchExpression) {
                Set states = PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)expression2).stream().map(expr -> MethodCandidateInfo.isPotentialCompatible(expr, formalType, method)).collect(Collectors.toSet());
                if (states.contains((Object)ThreeState.NO)) {
                    return ThreeState.NO;
                }
                if (states.contains((Object)ThreeState.UNSURE)) {
                    return ThreeState.UNSURE;
                }
            }
        }
        return ThreeState.YES;
    }

    @NotNull
    public PsiSubstitutor getSiteSubstitutor() {
        PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
        if (this.myTypeArguments != null) {
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParams = method.getTypeParameters();
            for (int i2 = 0; i2 < this.myTypeArguments.length && i2 < typeParams.length; ++i2) {
                incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i2], this.myTypeArguments[i2]);
            }
        }
        PsiSubstitutor psiSubstitutor = incompleteSubstitutor;
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(6);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getSubstitutorFromQualifier() {
        PsiSubstitutor psiSubstitutor = super.getSubstitutor();
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(7);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.getSubstitutor(true);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(8);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor(boolean includeReturnConstraint) {
        PsiSubstitutor substitutor2 = this.myCalcedSubstitutor;
        if (substitutor2 == null || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || MethodCandidateInfo.isOverloadCheck()) {
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method = this.getElement();
            if (this.myTypeArguments == null) {
                RecursionGuard.StackStamp stackStamp = RecursionManager.markStack();
                PsiSubstitutor inferredSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE, includeReturnConstraint);
                if (MethodCandidateInfo.isOverloadCheck() || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || this.myArgumentList != null && PsiResolveHelper.ourGraphGuard.currentStack().contains(this.myArgumentList.getParent()) || !stackStamp.mayCacheNow()) {
                    PsiSubstitutor psiSubstitutor = inferredSubstitutor;
                    if (psiSubstitutor == null) {
                        MethodCandidateInfo.$$$reportNull$$$0(9);
                    }
                    return psiSubstitutor;
                }
                this.myCalcedSubstitutor = substitutor2 = inferredSubstitutor;
            } else {
                PsiTypeParameter[] typeParams = method.getTypeParameters();
                if (this.isRawSubstitution()) {
                    PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(method.getProject()).createRawSubstitutor(this.mySubstitutor, typeParams);
                    if (psiSubstitutor == null) {
                        MethodCandidateInfo.$$$reportNull$$$0(10);
                    }
                    return psiSubstitutor;
                }
                for (int i2 = 0; i2 < this.myTypeArguments.length && i2 < typeParams.length; ++i2) {
                    incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i2], this.myTypeArguments[i2]);
                }
                this.myCalcedSubstitutor = substitutor2 = incompleteSubstitutor;
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(11);
        }
        return psiSubstitutor;
    }

    public static boolean isOverloadCheck() {
        return !ourOverloadGuard.currentStack().isEmpty();
    }

    public static boolean isOverloadCheck(PsiElement argumentList) {
        return ourOverloadGuard.currentStack().contains(argumentList);
    }

    public boolean isTypeArgumentsApplicable() {
        return this.isTypeArgumentsApplicable(() -> this.getSubstitutor(false));
    }

    private boolean isTypeArgumentsApplicable(Computable<? extends PsiSubstitutor> computable) {
        PsiMethod psiMethod = this.getElement();
        PsiTypeParameter[] typeParams = psiMethod.getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length && !PsiUtil.isLanguageLevel7OrHigher(psiMethod)) {
            return typeParams.length == 0 && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7);
        }
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, computable.compute(), this.getParent());
    }

    protected PsiElement getParent() {
        return this.myArgumentList != null ? this.myArgumentList.getParent() : null;
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    @NotNull
    public PsiMethod getElement() {
        PsiMethod psiMethod = (PsiMethod)super.getElement();
        if (psiMethod == null) {
            MethodCandidateInfo.$$$reportNull$$$0(12);
        }
        return psiMethod;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(13);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(policy, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY, includeReturnConstraint);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(14);
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor inferSubstitutorFromArgs(@NotNull ParameterTypeInferencePolicy policy, PsiExpression[] arguments2) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(15);
        }
        if (this.myTypeArguments == null) {
            return this.inferTypeArguments(policy, arguments2, true);
        }
        return this.getSiteSubstitutor();
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, PsiExpression @NotNull [] arguments2, boolean includeReturnConstraint) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(16);
        }
        if (arguments2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(17);
        }
        Computable<PsiSubstitutor> computable = () -> {
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParameters2 = method.getTypeParameters();
            if (this.isRawSubstitution()) {
                return JavaPsiFacade.getElementFactory(method.getProject()).createRawSubstitutor(this.mySubstitutor, typeParameters2);
            }
            PsiElement parent2 = this.getParent();
            if (parent2 == null) {
                return PsiSubstitutor.EMPTY;
            }
            Project project = method.getProject();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
            return javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters2, method.getParameterList().getParameters(), arguments2, this, parent2, policy, this.myLanguageLevel);
        };
        if (!includeReturnConstraint) {
            PsiSubstitutor psiSubstitutor = this.myArgumentList == null ? PsiSubstitutor.EMPTY : Objects.requireNonNull(ourOverloadGuard.doPreventingRecursion(this.myArgumentList, false, computable));
            if (psiSubstitutor == null) {
                MethodCandidateInfo.$$$reportNull$$$0(18);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = computable.compute();
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(19);
        }
        return psiSubstitutor;
    }

    public boolean isRawSubstitution() {
        PsiClass containingClass;
        PsiMethod method = this.getElement();
        return !method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor);
    }

    public boolean isInferencePossible() {
        return this.myArgumentList != null && this.myArgumentList.isValid();
    }

    public PsiType @Nullable [] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public boolean equals(Object o2) {
        return super.equals(o2) && this.isVarargs() == ((MethodCandidateInfo)o2).isVarargs();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.isVarargs() ? 1 : 0);
    }

    public void setApplicabilityError(@NotNull @NlsContexts.DetailedDescription String applicabilityError) {
        boolean overloadCheck;
        if (applicabilityError == null) {
            MethodCandidateInfo.$$$reportNull$$$0(20);
        }
        if (!(overloadCheck = MethodCandidateInfo.isOverloadCheck())) {
            this.myInferenceError = applicabilityError;
        }
        if (this.myArgumentList == null ? overloadCheck : MethodCandidateInfo.isOverloadCheck(this.myArgumentList)) {
            this.markNotApplicable();
        }
    }

    public void markNotApplicable() {
        this.myApplicabilityError = true;
    }

    @NlsContexts.DetailedDescription
    public String getInferenceErrorMessage() {
        this.getSubstitutor();
        return this.myInferenceError;
    }

    public String getInferenceErrorMessageAssumeAlreadyComputed() {
        return this.myInferenceError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/infos/MethodCandidateInfo";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicabilityError";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/infos/MethodCandidateInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiteSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorFromQualifier";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 14: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inferSubstitutorFromArgs";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setApplicabilityError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }

    public static @interface ApplicabilityLevelConstant {
    }
}

