/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.impl.MessageBusFactoryImpl;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager,
MessageBusOwner {
    private final MessageBus myMessageBus;
    private final DefaultPicoContainer picoContainer;
    private final ExtensionsAreaImpl myExtensionArea;
    private final Map<Class<?>, Object> myComponents;
    private final Set<Object> myDisposableComponents;
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(0);
        }
        this.myMessageBus = MessageBusFactoryImpl.createRootBus(this);
        this.myComponents = new HashMap();
        this.myDisposableComponents = ContainerUtil.newConcurrentSet();
        this.picoContainer = new DefaultPicoContainer((DefaultPicoContainer)parent2){

            @Override
            @Nullable
            public Object getComponentInstance(@NotNull Object componentKey) {
                if (componentKey == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + this);
                }
                Object o2 = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o2);
                return o2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/mock/MockComponentManager$1", "getComponentInstance"));
            }
        };
        this.picoContainer.registerComponentInstance(this.getClass(), this);
        this.myExtensionArea = new ExtensionsAreaImpl(this);
        Disposer.register(parentDisposable, this);
    }

    public DefaultPicoContainer getPicoContainer() {
        return this.picoContainer;
    }

    @Override
    public <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull PluginId pluginId) {
        if (aClass == null) {
            MockComponentManager.$$$reportNull$$$0(1);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(2);
        }
        return ReflectionUtil.newInstance(aClass, false);
    }

    @Override
    @NotNull
    public ExtensionsAreaImpl getExtensionArea() {
        ExtensionsAreaImpl extensionsAreaImpl = this.myExtensionArea;
        if (extensionsAreaImpl == null) {
            MockComponentManager.$$$reportNull$$$0(3);
        }
        return extensionsAreaImpl;
    }

    @Override
    public <T> T instantiateClassWithConstructorInjection(@NotNull Class<T> aClass, @NotNull Object key, @NotNull PluginId pluginId) {
        if (aClass == null) {
            MockComponentManager.$$$reportNull$$$0(4);
        }
        if (key == null) {
            MockComponentManager.$$$reportNull$$$0(5);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        if (error == null) {
            MockComponentManager.$$$reportNull$$$0(7);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(8);
        }
        ExceptionUtilRt.rethrowUnchecked(error);
        return new RuntimeException(error);
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull @NonNls String message, @NotNull PluginId pluginId) {
        if (message == null) {
            MockComponentManager.$$$reportNull$$$0(9);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(10);
        }
        return new RuntimeException(message);
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull @NonNls String message, @Nullable Throwable error, @NotNull PluginId pluginId, @Nullable Map<String, String> attachments) {
        if (message == null) {
            MockComponentManager.$$$reportNull$$$0(11);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(12);
        }
        return new RuntimeException(message);
    }

    protected void registerComponentInDisposer(@Nullable Object o2) {
        if (o2 instanceof Disposable && o2 != this && !(o2 instanceof MessageBus) && this.myDisposableComponents.add(o2)) {
            Disposer.register(this, (Disposable)o2);
        }
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(13);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(14);
        }
        this.picoContainer.unregisterComponent(serviceInterface.getName());
        this.picoContainer.registerComponentImplementation(serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceImplementation) {
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(15);
        }
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(16);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(17);
        }
        this.picoContainer.registerComponentInstance(serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation, @NotNull Disposable parentDisposable) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(18);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(19);
        }
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(20);
        }
        String key = serviceInterface.getName();
        this.registerService(serviceInterface, serviceImplementation);
        Disposer.register(parentDisposable, () -> this.picoContainer.unregisterComponent(key));
    }

    public <T> void addComponent(@NotNull Class<T> interfaceClass, @NotNull T instance2) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(21);
        }
        if (instance2 == null) {
            MockComponentManager.$$$reportNull$$$0(22);
        }
        this.myComponents.put(interfaceClass, instance2);
        this.registerComponentInDisposer(instance2);
    }

    @Override
    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        Object o2;
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(23);
        }
        return (T)((o2 = this.picoContainer.getComponentInstance(interfaceClass)) != null ? o2 : this.myComponents.get(interfaceClass));
    }

    @Override
    public <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            MockComponentManager.$$$reportNull$$$0(24);
        }
        T result2 = this.picoContainer.getService(serviceClass);
        this.registerComponentInDisposer(result2);
        return result2;
    }

    public final ComponentAdapter getComponentAdapter(@NotNull Object componentKey) {
        if (componentKey == null) {
            MockComponentManager.$$$reportNull$$$0(25);
        }
        return this.picoContainer.getComponentAdapter(componentKey);
    }

    @Override
    public final boolean hasComponent(@NotNull Class<?> interfaceClass) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(26);
        }
        return this.getComponentAdapter(interfaceClass) != null;
    }

    @Override
    public boolean isInjectionForExtensionSupported() {
        return false;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            MockComponentManager.$$$reportNull$$$0(27);
        }
        return messageBus;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void dispose() {
        Disposer.dispose(this.myMessageBus);
        this.myDisposed = true;
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            MockComponentManager.$$$reportNull$$$0(28);
        }
        return condition;
    }

    @Override
    @NotNull
    public Object createListener(@NotNull ListenerDescriptor descriptor2) {
        if (descriptor2 == null) {
            MockComponentManager.$$$reportNull$$$0(29);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> Class<T> loadClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) throws ClassNotFoundException {
        if (className == null) {
            MockComponentManager.$$$reportNull$$$0(30);
        }
        if (pluginDescriptor == null) {
            MockComponentManager.$$$reportNull$$$0(31);
        }
        Class<?> clazz = Class.forName(className);
        if (clazz == null) {
            MockComponentManager.$$$reportNull$$$0(32);
        }
        return clazz;
    }

    @Override
    @NotNull
    public ActivityCategory getActivityCategory(boolean isExtension) {
        ActivityCategory activityCategory = isExtension ? ActivityCategory.APP_EXTENSION : ActivityCategory.APP_SERVICE;
        if (activityCategory == null) {
            MockComponentManager.$$$reportNull$$$0(33);
        }
        return activityCategory;
    }

    @Override
    @NotNull
    public final <T> T instantiateClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) {
        T t2;
        if (className == null) {
            MockComponentManager.$$$reportNull$$$0(34);
        }
        if (pluginDescriptor == null) {
            MockComponentManager.$$$reportNull$$$0(35);
        }
        try {
            t2 = ReflectionUtil.newInstance(this.loadClass(className, pluginDescriptor));
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        if (t2 == null) {
            MockComponentManager.$$$reportNull$$$0(36);
        }
        return t2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 3: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceImplementation";
                break;
            }
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionArea";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClass";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityCategory";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClass";
                break;
            }
            case 3: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClassWithConstructorInjection";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createError";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerService";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasComponent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

