/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationCacheOwnerNormalizer;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestFrameworks {
    public static TestFrameworks getInstance() {
        return ApplicationManager.getApplication().getService(TestFrameworks.class);
    }

    public abstract boolean isTestClass(@NotNull PsiClass var1);

    public abstract boolean isPotentialTestClass(@NotNull PsiClass var1);

    @Nullable
    public abstract PsiMethod findOrCreateSetUpMethod(PsiClass var1);

    @Nullable
    public abstract PsiMethod findSetUpMethod(PsiClass var1);

    @Nullable
    public abstract PsiMethod findTearDownMethod(PsiClass var1);

    protected abstract boolean hasConfigMethods(PsiClass var1);

    public abstract boolean isTestMethod(PsiMethod var1);

    public boolean isTestMethod(PsiMethod method, boolean checkAbstract) {
        return this.isTestMethod(method);
    }

    public boolean isTestOrConfig(PsiClass psiClass) {
        return this.isTestClass(psiClass) || this.hasConfigMethods(psiClass);
    }

    @Nullable
    public static TestFramework detectFramework(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TestFrameworks.$$$reportNull$$$0(0);
        }
        return ContainerUtil.getFirstItem(TestFrameworks.detectApplicableFrameworks(psiClass));
    }

    @NotNull
    public static Set<TestFramework> detectApplicableFrameworks(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TestFrameworks.$$$reportNull$$$0(1);
        }
        PsiModifierListOwner normalized = AnnotationCacheOwnerNormalizer.normalize(psiClass);
        Set set = (Set)CachedValuesManager.getCachedValue(normalized, () -> CachedValueProvider.Result.create(TestFrameworks.computeFrameworks(normalized), PsiModificationTracker.MODIFICATION_COUNT));
        if (set == null) {
            TestFrameworks.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static Set<TestFramework> computeFrameworks(PsiElement psiClass) {
        LinkedHashSet<TestFramework> frameworks = new LinkedHashSet<TestFramework>();
        Language classLanguage = psiClass.getLanguage();
        HashMap<String, Language> checkedFrameworksByName = new HashMap<String, Language>();
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            String frameworkName = framework.getName();
            Language frameworkLanguage = framework.getLanguage();
            Language checkedFrameworkLanguage = (Language)checkedFrameworksByName.get(frameworkName);
            if (checkedFrameworkLanguage != null && TestFrameworks.isSubLanguage(checkedFrameworkLanguage, frameworkLanguage) || !TestFrameworks.isSubLanguage(classLanguage, frameworkLanguage)) continue;
            if (framework.isTestClass(psiClass) || framework.findSetUpMethod(psiClass) != null || framework.findTearDownMethod(psiClass) != null) {
                frameworks.add(framework);
            }
            checkedFrameworksByName.put(frameworkName, frameworkLanguage);
        }
        return frameworks;
    }

    public static boolean isSuitableByLanguage(PsiElement element2, TestFramework framework) {
        return element2.getContainingFile() != null && TestFrameworks.isSubLanguage(element2.getLanguage(), framework.getLanguage());
    }

    private static boolean isSubLanguage(@NotNull Language language, @NotNull Language parentLanguage) {
        if (language == null) {
            TestFrameworks.$$$reportNull$$$0(3);
        }
        if (parentLanguage == null) {
            TestFrameworks.$$$reportNull$$$0(4);
        }
        return parentLanguage == Language.ANY || language.isKindOf(parentLanguage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TestFrameworks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLanguage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TestFrameworks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detectApplicableFrameworks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectFramework";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "detectApplicableFrameworks";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSubLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

