/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassNonPublicConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDataClassNonPublicConstructorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDataClassNonPublicConstructorChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassNonPublicConstructorChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,44:1\n78#2:45\n18#3:46\n*S KotlinDebug\n*F\n+ 1 FirDataClassNonPublicConstructorChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassNonPublicConstructorChecker\n*L\n29#1:45\n33#1:46\n*E\n"})
public final class FirDataClassNonPublicConstructorChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirDataClassNonPublicConstructorChecker INSTANCE = new FirDataClassNonPublicConstructorChecker();

    private FirDataClassNonPublicConstructorChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration2) {
        boolean isAlreadyAnnotated;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.DataClassCopyRespectsConstructorVisibility)) {
                    return;
                }
                if (declaration2.getClassKind() != ClassKind.CLASS) break block7;
                FirRegularClass $this$isData$iv = declaration2;
                boolean $i$f$isData = false;
                if ($this$isData$iv.getStatus().isData()) break block8;
            }
            return;
        }
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol primaryConstructor2 = firConstructorSymbol;
        FirCallableSymbol $this$visibility$iv = primaryConstructor2;
        boolean $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Public.INSTANCE)) {
            return;
        }
        boolean bl2 = isAlreadyAnnotated = FirAnnotationUtilsKt.hasAnnotation(declaration2, StandardClassIds.Annotations.INSTANCE.getConsistentCopyVisibility(), context2.getSession()) || FirAnnotationUtilsKt.hasAnnotation(declaration2, StandardClassIds.Annotations.INSTANCE.getExposedCopyVisibility(), context2.getSession());
        if (isAlreadyAnnotated) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)primaryConstructor2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_COPY_VISIBILITY_WILL_BE_CHANGED(), null, 8, null);
    }
}

