/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.overrides;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.partial.ImplementAsErrorThrowingStubs;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageSupportForLinker;
import org.jetbrains.kotlin.backend.common.overrides.DefaultFakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideDeclarationTable;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.overrides.IrLinkerFakeOverrideBuilderStrategy;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilder;
import org.jetbrains.kotlin.ir.overrides.IrUnimplementedOverridesStrategy;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020$J\u0018\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020!2\u0006\u0010,\u001a\u00020$H\u0002J\u0016\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020!2\u0006\u0010,\u001a\u00020$J\u0006\u0010/\u001a\u00020(R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/backend/common/overrides/IrLinkerFakeOverrideProvider;", "", "linker", "Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "friendModules", "", "", "", "partialLinkageSupport", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;", "platformSpecificClassFilter", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "fakeOverrideDeclarationTable", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideDeclarationTable;", "externalOverridabilityConditions", "", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideDeclarationTable;Ljava/util/List;)V", "getMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "getPlatformSpecificClassFilter", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "irFakeOverrideBuilder", "Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "haveFakeOverrides", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fakeOverrideCandidates", "", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "getFakeOverrideCandidates", "()Ljava/util/Map;", "enqueueClass", "", "clazz", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "compatibilityMode", "buildFakeOverrideChainsForClass", "", "provideFakeOverrides", "klass", "ir.serialization.common"})
public final class IrLinkerFakeOverrideProvider {
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final PartialLinkageSupportForLinker partialLinkageSupport;
    @NotNull
    private final FakeOverrideClassFilter platformSpecificClassFilter;
    @NotNull
    private final FakeOverrideDeclarationTable fakeOverrideDeclarationTable;
    @NotNull
    private final IrFakeOverrideBuilder irFakeOverrideBuilder;
    @NotNull
    private final Set<IrClass> haveFakeOverrides;
    @NotNull
    private final Map<IrClass, CompatibilityMode> fakeOverrideCandidates;

    public IrLinkerFakeOverrideProvider(@NotNull FileLocalAwareLinker linker, @NotNull SymbolTable symbolTable, @NotNull KotlinMangler.IrMangler mangler, @NotNull IrTypeSystemContext typeSystem, @NotNull Map<String, ? extends Collection<String>> friendModules, @NotNull PartialLinkageSupportForLinker partialLinkageSupport, @NotNull FakeOverrideClassFilter platformSpecificClassFilter, @NotNull FakeOverrideDeclarationTable fakeOverrideDeclarationTable, @NotNull List<? extends IrExternalOverridabilityCondition> externalOverridabilityConditions) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        Intrinsics.checkNotNullParameter(friendModules, (String)"friendModules");
        Intrinsics.checkNotNullParameter((Object)partialLinkageSupport, (String)"partialLinkageSupport");
        Intrinsics.checkNotNullParameter((Object)platformSpecificClassFilter, (String)"platformSpecificClassFilter");
        Intrinsics.checkNotNullParameter((Object)fakeOverrideDeclarationTable, (String)"fakeOverrideDeclarationTable");
        Intrinsics.checkNotNullParameter(externalOverridabilityConditions, (String)"externalOverridabilityConditions");
        this.mangler = mangler;
        this.partialLinkageSupport = partialLinkageSupport;
        this.platformSpecificClassFilter = platformSpecificClassFilter;
        this.fakeOverrideDeclarationTable = fakeOverrideDeclarationTable;
        this.irFakeOverrideBuilder = new IrFakeOverrideBuilder(typeSystem, new IrLinkerFakeOverrideBuilderStrategy(linker, symbolTable, typeSystem.getIrBuiltIns(), this.partialLinkageSupport, this.fakeOverrideDeclarationTable, friendModules, this.partialLinkageSupport.isEnabled() ? (IrUnimplementedOverridesStrategy)new ImplementAsErrorThrowingStubs(this.partialLinkageSupport) : (IrUnimplementedOverridesStrategy)IrUnimplementedOverridesStrategy.ProcessAsFakeOverrides.INSTANCE), externalOverridabilityConditions);
        this.haveFakeOverrides = new LinkedHashSet();
        this.fakeOverrideCandidates = new LinkedHashMap();
    }

    public /* synthetic */ IrLinkerFakeOverrideProvider(FileLocalAwareLinker fileLocalAwareLinker, SymbolTable symbolTable, KotlinMangler.IrMangler irMangler, IrTypeSystemContext irTypeSystemContext, Map map, PartialLinkageSupportForLinker partialLinkageSupportForLinker, FakeOverrideClassFilter fakeOverrideClassFilter, FakeOverrideDeclarationTable fakeOverrideDeclarationTable, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            fakeOverrideClassFilter = DefaultFakeOverrideClassFilter.INSTANCE;
        }
        if ((n2 & 0x80) != 0) {
            fakeOverrideDeclarationTable = new FakeOverrideDeclarationTable(irMangler, null, 2, null);
        }
        if ((n2 & 0x100) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(fileLocalAwareLinker, symbolTable, irMangler, irTypeSystemContext, map, partialLinkageSupportForLinker, fakeOverrideClassFilter, fakeOverrideDeclarationTable, list);
    }

    @NotNull
    public final KotlinMangler.IrMangler getMangler() {
        return this.mangler;
    }

    @NotNull
    public final FakeOverrideClassFilter getPlatformSpecificClassFilter() {
        return this.platformSpecificClassFilter;
    }

    @NotNull
    public final Map<IrClass, CompatibilityMode> getFakeOverrideCandidates() {
        return this.fakeOverrideCandidates;
    }

    public final void enqueueClass(@NotNull IrClass clazz, @NotNull IdSignature signature, @NotNull CompatibilityMode compatibilityMode) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)compatibilityMode, (String)"compatibilityMode");
        this.fakeOverrideDeclarationTable.addDeserializedDeclarationAndSignature(clazz, signature);
        this.fakeOverrideCandidates.put(clazz, compatibilityMode);
    }

    private final boolean buildFakeOverrideChainsForClass(IrClass clazz, CompatibilityMode compatibilityMode) {
        if (this.haveFakeOverrides.contains(clazz)) {
            return true;
        }
        for (IrType supertype : clazz.getSuperTypes()) {
            CompatibilityMode mode;
            IrClass superClass;
            if (IrTypesKt.getClass(supertype) == null) {
                throw new IllegalStateException(("Unexpected super type: " + RenderIrElementKt.render$default(supertype, null, 1, null)).toString());
            }
            CompatibilityMode compatibilityMode2 = this.fakeOverrideCandidates.get(superClass);
            if (compatibilityMode2 == null) {
                compatibilityMode2 = compatibilityMode;
            }
            if (!this.buildFakeOverrideChainsForClass(superClass, mode = compatibilityMode2)) continue;
            this.haveFakeOverrides.add(superClass);
        }
        if (!this.platformSpecificClassFilter.needToConstructFakeOverrides(clazz)) {
            return false;
        }
        this.irFakeOverrideBuilder.buildFakeOverridesForClass(clazz, compatibilityMode.getLegacySignaturesForPrivateAndLocalDeclarations());
        return true;
    }

    public final void provideFakeOverrides(@NotNull IrClass klass, @NotNull CompatibilityMode compatibilityMode) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)compatibilityMode, (String)"compatibilityMode");
        this.buildFakeOverrideChainsForClass(klass, compatibilityMode);
        this.haveFakeOverrides.add(klass);
    }

    public final void provideFakeOverrides() {
        List entries = CollectionsKt.toMutableList((Collection)this.fakeOverrideCandidates.entrySet());
        while (!((Collection)entries).isEmpty()) {
            Map.Entry candidate = (Map.Entry)CollectionsKt.removeLast((List)entries);
            this.provideFakeOverrides((IrClass)candidate.getKey(), (CompatibilityMode)candidate.getValue());
        }
        this.fakeOverrideCandidates.clear();
    }
}

