/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class VFileMoveEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    @ApiStatus.Internal
    public VFileMoveEvent(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) {
        if (file == null) {
            VFileMoveEvent.$$$reportNull$$$0(0);
        }
        if (newParent == null) {
            VFileMoveEvent.$$$reportNull$$$0(1);
        }
        super(requestor);
        this.myFile = file;
        this.myNewParent = newParent;
        this.myOldParent = file.getParent();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            VFileMoveEvent.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile = this.myNewParent;
        if (virtualFile == null) {
            VFileMoveEvent.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.computePath();
        if (string == null) {
            VFileMoveEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected String computePath() {
        String string = this.myFile.getPath();
        if (string == null) {
            VFileMoveEvent.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            VFileMoveEvent.$$$reportNull$$$0(6);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && Comparing.equal(this.myFile.getParent(), this.myOldParent) && this.myOldParent.isValid();
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o2;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    @Override
    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myOldParent.hashCode();
        result2 = 31 * result2 + this.myNewParent.hashCode();
        return result2;
    }

    @NotNull
    public String getOldPath() {
        String string = this.myOldParent.getPath() + "/" + this.myFile.getName();
        if (string == null) {
            VFileMoveEvent.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getNewPath() {
        String string = this.myNewParent.getPath() + "/" + this.myFile.getName();
        if (string == null) {
            VFileMoveEvent.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

