/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u00015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001c2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J*\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020%0$H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0004J\u0010\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u001fH\u0004J\u001c\u0010+\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00132\b\b\u0002\u0010,\u001a\u00020-H\u0004J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001c2\u0006\u0010\u0018\u001a\u00020\u00132\b\b\u0002\u0010,\u001a\u00020-H\u0004J\u0010\u0010.\u001a\u00020-2\u0006\u0010(\u001a\u00020\u000eH\u0002J\f\u0010/\u001a\u00020\u000e*\u00020-H\u0002J\u0017\u00100\u001a\u00020\u0014*\u0004\u0018\u00010\u00142\u0006\u00101\u001a\u00020-H\u0082\u0002J\u001c\u00102\u001a\b\u0012\u0004\u0012\u0002H30\u001c\"\b\b\u0000\u00103*\u00020\u000e*\u00020\u0014H\u0002J\u0010\u00104\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "parent", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "redeclarationChecker", "Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;)V", "getRedeclarationChecker", "()Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "getParent", "()Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "addedDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getAddedDescriptors", "()Ljava/util/List;", "functionsByName", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;", "variablesAndClassifiersByName", "getContributedClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "name", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getContributedVariables", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getContributedFunctions", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getContributedDescriptors", "kindFilter", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "", "addVariableOrClassDescriptor", "", "descriptor", "addFunctionDescriptorInternal", "functionDescriptor", "variableOrClassDescriptorByName", "descriptorLimit", "", "addDescriptor", "descriptorByIndex", "plus", "value", "toDescriptors", "TDescriptor", "definitelyDoesNotContainName", "IntList", "resolution"})
public abstract class LexicalScopeStorage
implements LexicalScope {
    @NotNull
    private final LocalRedeclarationChecker redeclarationChecker;
    @NotNull
    private final HierarchicalScope parent;
    @NotNull
    private final List<DeclarationDescriptor> addedDescriptors;
    @Nullable
    private Map<Name, IntList> functionsByName;
    @Nullable
    private Map<Name, IntList> variablesAndClassifiersByName;

    public LexicalScopeStorage(@NotNull HierarchicalScope parent2, @NotNull LocalRedeclarationChecker redeclarationChecker) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)redeclarationChecker, (String)"redeclarationChecker");
        this.redeclarationChecker = redeclarationChecker;
        this.parent = ScopeUtilsKt.takeSnapshot(parent2);
        this.addedDescriptors = new SmartList();
    }

    @NotNull
    public final LocalRedeclarationChecker getRedeclarationChecker() {
        return this.redeclarationChecker;
    }

    @Override
    @NotNull
    public HierarchicalScope getParent() {
        return this.parent;
    }

    @NotNull
    protected final List<DeclarationDescriptor> getAddedDescriptors() {
        return this.addedDescriptors;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name2, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        DeclarationDescriptor declarationDescriptor = LexicalScopeStorage.variableOrClassDescriptorByName$default(this, name2, 0, 2, null);
        return declarationDescriptor instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor : null;
    }

    @NotNull
    public List<VariableDescriptor> getContributedVariables(@NotNull Name name2, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        DeclarationDescriptor declarationDescriptor = LexicalScopeStorage.variableOrClassDescriptorByName$default(this, name2, 0, 2, null);
        return CollectionsKt.listOfNotNull((Object)(declarationDescriptor instanceof VariableDescriptor ? (VariableDescriptor)declarationDescriptor : null));
    }

    @NotNull
    public List<FunctionDescriptor> getContributedFunctions(@NotNull Name name2, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return LexicalScopeStorage.functionsByName$default(this, name2, 0, 2, null);
    }

    @NotNull
    public List<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        return this.addedDescriptors;
    }

    protected final void addVariableOrClassDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Name name2 = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name name3 = name2;
        if (name3.isSpecial()) {
            return;
        }
        int descriptorIndex = this.addDescriptor(descriptor2);
        if (this.variablesAndClassifiersByName == null) {
            this.variablesAndClassifiersByName = new HashMap();
        }
        Map<Name, IntList> map = this.variablesAndClassifiersByName;
        Intrinsics.checkNotNull(map);
        Map<Name, IntList> map2 = this.variablesAndClassifiersByName;
        Intrinsics.checkNotNull(map2);
        map.put(name3, this.plus(map2.get(name3), descriptorIndex));
    }

    protected final void addFunctionDescriptorInternal(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        Name name2 = functionDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name name3 = name2;
        int descriptorIndex = this.addDescriptor(functionDescriptor);
        if (this.functionsByName == null) {
            this.functionsByName = new HashMap(1);
        }
        Map<Name, IntList> map = this.functionsByName;
        Intrinsics.checkNotNull(map);
        Map<Name, IntList> map2 = this.functionsByName;
        Intrinsics.checkNotNull(map2);
        map.put(name3, this.plus(map2.get(name3), descriptorIndex));
    }

    @Nullable
    protected final DeclarationDescriptor variableOrClassDescriptorByName(@NotNull Name name2, int descriptorLimit) {
        IntList list;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (descriptorLimit == 0) {
            return null;
        }
        Map<Name, IntList> map = this.variablesAndClassifiersByName;
        IntList intList = list = map != null ? map.get(name2) : null;
        while (list != null) {
            int descriptorIndex = list.getLast();
            if (descriptorIndex < descriptorLimit) {
                return this.descriptorByIndex(descriptorIndex);
            }
            list = list.getPrev();
        }
        return null;
    }

    public static /* synthetic */ DeclarationDescriptor variableOrClassDescriptorByName$default(LexicalScopeStorage lexicalScopeStorage, Name name2, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: variableOrClassDescriptorByName");
        }
        if ((n3 & 2) != 0) {
            n2 = lexicalScopeStorage.addedDescriptors.size();
        }
        return lexicalScopeStorage.variableOrClassDescriptorByName(name2, n2);
    }

    @NotNull
    protected final List<FunctionDescriptor> functionsByName(@NotNull Name name2, int descriptorLimit) {
        IntList list;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (descriptorLimit == 0) {
            return CollectionsKt.emptyList();
        }
        Map<Name, IntList> map = this.functionsByName;
        IntList intList = list = map != null ? map.get(name2) : null;
        while (list != null) {
            if (list.getLast() < descriptorLimit) {
                return this.toDescriptors(list);
            }
            list = list.getPrev();
        }
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List functionsByName$default(LexicalScopeStorage lexicalScopeStorage, Name name2, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: functionsByName");
        }
        if ((n3 & 2) != 0) {
            n2 = lexicalScopeStorage.addedDescriptors.size();
        }
        return lexicalScopeStorage.functionsByName(name2, n2);
    }

    private final int addDescriptor(DeclarationDescriptor descriptor2) {
        this.redeclarationChecker.checkBeforeAddingToScope(this, descriptor2);
        this.addedDescriptors.add(descriptor2);
        return this.addedDescriptors.size() - 1;
    }

    private final DeclarationDescriptor descriptorByIndex(int $this$descriptorByIndex) {
        return this.addedDescriptors.get($this$descriptorByIndex);
    }

    private final IntList plus(IntList $this$plus, int value2) {
        return new IntList(value2, $this$plus);
    }

    private final <TDescriptor extends DeclarationDescriptor> List<TDescriptor> toDescriptors(IntList $this$toDescriptors) {
        ArrayList<DeclarationDescriptor> result2 = new ArrayList<DeclarationDescriptor>(1);
        IntList rest = $this$toDescriptors;
        do {
            IntList intList = rest;
            Intrinsics.checkNotNull((Object)intList);
            DeclarationDescriptor declarationDescriptor = this.descriptorByIndex(intList.getLast());
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type TDescriptor of org.jetbrains.kotlin.resolve.scopes.LexicalScopeStorage.toDescriptors");
            result2.add(declarationDescriptor);
        } while ((rest = rest.getPrev()) != null);
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean definitelyDoesNotContainName(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Map<Name, IntList> map = this.functionsByName;
        if ((map != null ? map.get(name2) : null) != null) return false;
        Map<Name, IntList> map2 = this.variablesAndClassifiersByName;
        if (map2 == null) return true;
        IntList intList = map2.get(name2);
        if (intList != null) return false;
        return true;
    }

    @Override
    @Nullable
    public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name2, @NotNull LookupLocation location2) {
        return LexicalScope.DefaultImpls.getContributedClassifierIncludeDeprecated(this, name2, location2);
    }

    @Override
    public void recordLookup(@NotNull Name name2, @NotNull LookupLocation location2) {
        LexicalScope.DefaultImpls.recordLookup(this, name2, location2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;", "", "last", "", "prev", "<init>", "(ILorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;)V", "getLast", "()I", "getPrev", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;", "resolution"})
    private static final class IntList {
        private final int last;
        @Nullable
        private final IntList prev;

        public IntList(int last, @Nullable IntList prev) {
            this.last = last;
            this.prev = prev;
        }

        public final int getLast() {
            return this.last;
        }

        @Nullable
        public final IntList getPrev() {
            return this.prev;
        }
    }
}

