/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KotlinValueClassRepresentation;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.Utils;

public class KtClassElementType
extends KtStubElementType<KotlinClassStub, KtClass> {
    public KtClassElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtClassElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtClass.class, KotlinClassStub.class);
    }

    @Override
    @NotNull
    public KtClass createPsi(@NotNull KotlinClassStub stub2) {
        if (stub2 == null) {
            KtClassElementType.$$$reportNull$$$0(1);
        }
        return !stub2.isEnumEntry() ? new KtClass(stub2) : new KtEnumEntry(stub2);
    }

    @Override
    @NotNull
    public KtClass createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            KtClassElementType.$$$reportNull$$$0(2);
        }
        return node.getElementType() != KtStubElementTypes.ENUM_ENTRY ? new KtClass(node) : new KtEnumEntry(node);
    }

    @Override
    @NotNull
    public KotlinClassStub createStub(@NotNull KtClass psi, StubElement parentStub) {
        if (psi == null) {
            KtClassElementType.$$$reportNull$$$0(3);
        }
        FqName fqName = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        boolean isEnumEntry = psi instanceof KtEnumEntry;
        List<String> superNames = KtPsiUtilKt.getSuperNames(psi);
        ClassId classId = StubUtils.createNestedClassId(parentStub, psi);
        return new KotlinClassStubImpl(KtClassElementType.getStubType(isEnumEntry), parentStub, StringRef.fromString(fqName != null ? fqName.asString() : null), classId, StringRef.fromString(psi.getName()), Utils.INSTANCE.wrapStrings(superNames), psi.isInterface(), isEnumEntry, false, psi.isLocal(), psi.isTopLevel(), null);
    }

    @Override
    public void serialize(@NotNull KotlinClassStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub2 == null) {
            KtClassElementType.$$$reportNull$$$0(4);
        }
        if (dataStream == null) {
            KtClassElementType.$$$reportNull$$$0(5);
        }
        dataStream.writeName(stub2.getName());
        FqName fqName = stub2.getFqName();
        dataStream.writeName(fqName == null ? null : fqName.asString());
        StubUtils.serializeClassId(dataStream, stub2.getClassId());
        dataStream.writeBoolean(stub2.isInterface());
        dataStream.writeBoolean(stub2.isEnumEntry());
        dataStream.writeBoolean(stub2.isClsStubCompiledToJvmDefaultImplementation());
        dataStream.writeBoolean(stub2.isLocal());
        dataStream.writeBoolean(stub2.isTopLevel());
        List<String> superNames = stub2.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name2 : superNames) {
            dataStream.writeName(name2);
        }
        if (stub2 instanceof KotlinClassStubImpl) {
            KotlinClassStubImpl stubImpl = (KotlinClassStubImpl)stub2;
            KotlinValueClassRepresentation representation = stubImpl.getValueClassRepresentation();
            dataStream.writeVarInt(representation == null ? 0 : representation.ordinal() + 1);
        }
    }

    @Override
    @NotNull
    public KotlinClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtClassElementType.$$$reportNull$$$0(6);
        }
        StringRef name2 = dataStream.readName();
        StringRef qualifiedName2 = dataStream.readName();
        ClassId classId = StubUtils.deserializeClassId(dataStream);
        boolean isTrait = dataStream.readBoolean();
        boolean isEnumEntry = dataStream.readBoolean();
        boolean isNewPlaceForBodyGeneration = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] superNames = StringRef.createArray(superCount);
        for (int i2 = 0; i2 < superCount; ++i2) {
            superNames[i2] = dataStream.readName();
        }
        int representationOrdinal = dataStream.readVarInt();
        KotlinValueClassRepresentation representation = representationOrdinal == 0 ? null : (KotlinValueClassRepresentation)((Object)KotlinValueClassRepresentation.getEntries().get(representationOrdinal - 1));
        return new KotlinClassStubImpl(KtClassElementType.getStubType(isEnumEntry), parentStub, qualifiedName2, classId, name2, superNames, isTrait, isEnumEntry, isNewPlaceForBodyGeneration, isLocal, isTopLevel, representation);
    }

    @Override
    public void indexStub(@NotNull KotlinClassStub stub2, @NotNull IndexSink sink) {
        if (stub2 == null) {
            KtClassElementType.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            KtClassElementType.$$$reportNull$$$0(8);
        }
        StubIndexService.getInstance().indexClass(stub2, sink);
    }

    public static KtClassElementType getStubType(boolean isEnumEntry) {
        return isEnumEntry ? KtStubElementTypes.ENUM_ENTRY : KtStubElementTypes.CLASS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtClassElementType";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsiFromAst";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

