/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)V", "checkDuplicatedLabels", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirWhenConditionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenConditionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,71:1\n46#2:72\n*S KotlinDebug\n*F\n+ 1 FirWhenConditionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker\n*L\n43#1:72\n*E\n"})
public final class FirWhenConditionChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirWhenConditionChecker INSTANCE = new FirWhenConditionChecker();

    private FirWhenConditionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirWhenExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        for (FirWhenBranch branch : expression2.getBranches()) {
            FirExpression condition = branch.getCondition();
            if (condition instanceof FirElseIfTrueCondition) continue;
            FirHelpersKt.checkCondition(condition, context2, reporter);
        }
        if (expression2.getSubjectVariable() != null) {
            this.checkDuplicatedLabels(expression2, context2, reporter);
        }
    }

    private final void checkDuplicatedLabels(FirWhenExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        HashSet<Pair> checkedTypes = new HashSet<Pair>();
        HashSet<Object> checkedConstants = new HashSet<Object>();
        for (FirWhenBranch branch : expression2.getBranches()) {
            ConeKotlinType coneType;
            FirExpression condition = branch.getCondition();
            if (condition instanceof FirEqualityOperatorCall) {
                Object value2;
                Object object;
                FirCall $this$arguments$iv = (FirCall)((Object)condition);
                boolean $i$f$getArguments = false;
                List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments2.size() != 2 || !(FirExpressionUtilKt.unwrapSmartcastExpression(arguments2.get(0)) instanceof FirWhenSubjectExpression)) continue;
                FirExpression targetExpression = FirExpressionUtilKt.unwrapSmartcastExpression(arguments2.get(1));
                if (targetExpression instanceof FirLiteralExpression) {
                    object = ((FirLiteralExpression)targetExpression).getValue();
                } else if (targetExpression instanceof FirQualifiedAccessExpression) {
                    FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirQualifiedAccessExpression)targetExpression).getCalleeReference(), false, 1, null);
                    object = firCallableSymbol instanceof FirEnumEntrySymbol ? (FirEnumEntrySymbol)firCallableSymbol : null;
                    if (object == null) {
                        continue;
                    }
                } else {
                    FirClassLikeSymbol<?> classSymbol;
                    if (!(targetExpression instanceof FirResolvedQualifier) || ((FirResolvedQualifier)targetExpression).getSymbol() == null || FirHelpersKt.getClassKind(classSymbol) != ClassKind.OBJECT) continue;
                    object = classSymbol.getClassId();
                }
                if (checkedConstants.add(value2 = object)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirEqualityOperatorCall)condition).getSource(), FirErrors.INSTANCE.getDUPLICATE_BRANCH_CONDITION_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (!(condition instanceof FirTypeOperatorCall) || checkedTypes.add(TuplesKt.to((Object)(coneType = FirTypeUtilsKt.getConeType(((FirTypeOperatorCall)condition).getConversionTypeRef())), (Object)((Object)((FirTypeOperatorCall)condition).getOperation())))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirTypeOperatorCall)condition).getConversionTypeRef().getSource(), FirErrors.INSTANCE.getDUPLICATE_BRANCH_CONDITION_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

