/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInfixFunctionDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "hasExtensionOrDispatchReceiver", "", "function", "checkers"})
public final class FirInfixFunctionDeclarationChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirInfixFunctionDeclarationChecker INSTANCE = new FirInfixFunctionDeclarationChecker();

    private FirInfixFunctionDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!declaration2.getStatus().isInfix()) {
            return;
        }
        if (declaration2.getValueParameters().size() != 1 || !this.hasExtensionOrDispatchReceiver(declaration2, context2) || ((FirValueParameter)CollectionsKt.single(declaration2.getValueParameters())).isVararg()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_INFIX_MODIFIER(), null, 8, null);
        }
    }

    private final boolean hasExtensionOrDispatchReceiver(FirFunction function2, CheckerContext context2) {
        if (function2.getReceiverParameter() != null) {
            return true;
        }
        return CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirClassSymbol;
    }
}

