/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;

@PhaseDescription(name="RecordEnclosingMethods")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RecordEnclosingMethodsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
public final class RecordEnclosingMethodsLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public RecordEnclosingMethodsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept((IrVisitor)new IrVisitor<Unit, IrFunction>(this){
            final /* synthetic */ RecordEnclosingMethodsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element2, IrFunction data) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                IrVisitor irVisitor = this;
                IrFunction irFunction = element2 instanceof IrFunction ? (IrFunction)element2 : null;
                if (irFunction == null) {
                    irFunction = data;
                }
                element2.acceptChildren(irVisitor, irFunction);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2, IrFunction data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (!(data != null)) {
                    boolean $i$a$-require-RecordEnclosingMethodsLowering$lower$1$visitFunctionAccess$22 = false;
                    String $i$a$-require-RecordEnclosingMethodsLowering$lower$1$visitFunctionAccess$22 = "function call not in a method: " + RenderIrElementKt.render$default(expression2, null, 1, null);
                    throw new IllegalArgumentException($i$a$-require-RecordEnclosingMethodsLowering$lower$1$visitFunctionAccess$22.toString());
                }
                if (Intrinsics.areEqual(expression2.getSymbol(), (Object)this.this$0.getContext().getSymbols().getIndyLambdaMetafactoryIntrinsic())) {
                    IrExpression reference2 = (IrExpression)expression2.getArguments().get(1);
                    if (reference2 instanceof IrFunctionReference && IrUtilsKt.isLambda(((IrFunctionReference)reference2).getOrigin())) {
                        this.recordEnclosingMethodOverride(((IrFunctionSymbol)((IrFunctionReference)reference2).getSymbol()).getOwner(), data);
                    }
                } else if (JvmIrInlineUtilsKt.isInlineFunctionCall(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), this.this$0.getContext())) {
                    for (IrValueParameter parameter2 : ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getParameters()) {
                        IrExpression irExpression = expression2.getArguments().get(parameter2);
                        if (irExpression == null || (irExpression = JvmIrInlineUtilsKt.unwrapInlineLambda(irExpression)) == null) continue;
                        IrExpression lambda = irExpression;
                        this.recordEnclosingMethodOverride(((IrFunctionSymbol)((IrCallableReference)lambda).getSymbol()).getOwner(), data);
                    }
                }
                super.visitFunctionAccess(expression2, data);
            }

            private final void recordEnclosingMethodOverride(IrFunction from2, IrFunction to) {
                IrFunction old = JvmIrAttributesKt.getEnclosingMethodOverride(from2);
                if (old != null) {
                    boolean bl2;
                    boolean bl3 = bl2 = Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass(old), (Object)IrUtilsKt.getParentAsClass(to)) && old instanceof IrConstructor && to instanceof IrConstructor;
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(IrUtilsKt.getParentAsClass(old));
                    if (irConstructor != null) {
                        IrConstructor it = irConstructor;
                        boolean bl4 = false;
                        JvmIrAttributesKt.setEnclosingMethodOverride(from2, it);
                    }
                } else {
                    JvmIrAttributesKt.setEnclosingMethodOverride(from2, to);
                }
            }
        }, null);
    }
}

