/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.declaration;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFunctionParametersChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrFunctionParametersChecker
implements IrDeclarationChecker<IrFunction> {
    @NotNull
    public static final IrFunctionParametersChecker INSTANCE = new IrFunctionParametersChecker();

    private IrFunctionParametersChecker() {
    }

    @Override
    public void check(@NotNull IrFunction declaration2, @NotNull CheckerContext context2) {
        IrDeclarationBase param;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterator iterator2 = ((Iterable)declaration2.getValueParameters()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int i2 = n2++;
            IrValueParameter param2 = (IrValueParameter)iterator2.next();
            if (param2.getIndexInOldValueParameters() == i2) continue;
            context2.error(declaration2, "Inconsistent index (old API) of value parameter " + param2.getIndexInOldValueParameters() + " != " + i2);
        }
        IrParameterKind lastKind = null;
        Iterator iterator3 = ((Iterable)declaration2.getParameters()).iterator();
        int n3 = 0;
        while (iterator3.hasNext()) {
            int i3 = n3++;
            param = (IrValueParameter)iterator3.next();
            if (((IrValueParameter)param).getIndexInParameters() != i3) {
                context2.error(declaration2, "Inconsistent index (new API) of value parameter " + ((IrValueParameter)param).getIndexInParameters() + " != " + i3);
            }
            IrParameterKind kind = ((IrValueParameter)param).getKind();
            if (lastKind != null) {
                if (kind.compareTo((Enum)lastKind) < 0) {
                    context2.error(declaration2, "Invalid order of function parameters: " + (Object)((Object)kind) + " is placed after " + (Object)((Object)lastKind) + ".\nParameters must follow a strict order: [dispatch receiver, context parameters, extension receiver, regular parameters].");
                }
                if ((kind == IrParameterKind.DispatchReceiver || kind == IrParameterKind.ExtensionReceiver) && kind == lastKind) {
                    context2.error(declaration2, "Function may have only one " + (Object)((Object)kind) + " parameter");
                }
            }
            lastKind = kind;
        }
        iterator3 = ((Iterable)declaration2.getTypeParameters()).iterator();
        n3 = 0;
        while (iterator3.hasNext()) {
            int i4 = n3++;
            param = (IrTypeParameter)iterator3.next();
            if (((IrTypeParameter)param).getIndex() == i4) continue;
            context2.error(declaration2, "Inconsistent index of type parameter " + ((IrTypeParameter)param).getIndex() + " != " + i4);
        }
    }
}

