/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.lifetime;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.KaLifetimeTracker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fRJ\u0010\u0004\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0006 \b*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker;", "<init>", "()V", "lifetimeOwnersStack", "Ljava/lang/ThreadLocal;", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "kotlin.jvm.PlatformType", "currentToken", "getCurrentToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "beforeEnteringAnalysis", "", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "afterLeavingAnalysis", "Companion", "analysis-api-impl-base"})
public final class KaBaseLifetimeTracker
implements KaLifetimeTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ThreadLocal<PersistentList<KaLifetimeToken>> lifetimeOwnersStack = ThreadLocal.withInitial(KaBaseLifetimeTracker::lifetimeOwnersStack$lambda$0);

    @Override
    @Nullable
    public KaLifetimeToken getCurrentToken() {
        PersistentList<KaLifetimeToken> persistentList = this.lifetimeOwnersStack.get();
        Intrinsics.checkNotNullExpressionValue(persistentList, (String)"get(...)");
        return (KaLifetimeToken)CollectionsKt.lastOrNull((List)persistentList);
    }

    public final void beforeEnteringAnalysis(@NotNull KaSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.lifetimeOwnersStack.set(this.lifetimeOwnersStack.get().add(session.getToken()));
    }

    public final void afterLeavingAnalysis(@NotNull KaSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PersistentList<KaLifetimeToken> stack = this.lifetimeOwnersStack.get();
        Intrinsics.checkNotNull(stack);
        KaLifetimeToken last = (KaLifetimeToken)CollectionsKt.last((List)stack);
        if (!Intrinsics.areEqual((Object)last, (Object)session.getToken())) {
            throw new IllegalStateException("Check failed.");
        }
        this.lifetimeOwnersStack.set(stack.removeAt(CollectionsKt.getLastIndex((List)stack)));
    }

    private static final PersistentList lifetimeOwnersStack$lambda$0() {
        return ExtensionsKt.persistentListOf();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "project", "Lcom/intellij/openapi/project/Project;", "analysis-api-impl-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KaBaseLifetimeTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            KaLifetimeTracker kaLifetimeTracker = KaLifetimeTracker.Companion.getInstance(project);
            KaBaseLifetimeTracker kaBaseLifetimeTracker = kaLifetimeTracker instanceof KaBaseLifetimeTracker ? (KaBaseLifetimeTracker)kaLifetimeTracker : null;
            if (kaBaseLifetimeTracker == null) {
                throw new IllegalStateException(("Expected " + Reflection.getOrCreateKotlinClass(KaBaseLifetimeTracker.class).getSimpleName() + " to be registered for " + Reflection.getOrCreateKotlinClass(KaLifetimeTracker.class).getSimpleName() + '.').toString());
            }
            return kaBaseLifetimeTracker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

