/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWalkingState;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public class PsiTreeUtil {
    private static final Logger LOG = Logger.getInstance(PsiTreeUtil.class);
    private static final Key<Object> MARKER = Key.create("PsiTreeUtil.copyElements.MARKER");
    private static final Class<? extends PsiElement>[] WS = new Class[]{PsiWhiteSpace.class};
    private static final Class<? extends PsiElement>[] WS_COMMENTS = new Class[]{PsiWhiteSpace.class, PsiComment.class};

    @Contract(value="null, _, _ -> false", pure=true)
    public static boolean isAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element2, boolean strict) {
        PsiElement parent2;
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (ancestor == null) {
            return false;
        }
        if ((ancestor instanceof StubBasedPsiElement && ((StubBasedPsiElement)ancestor).getStub() != null || element2 instanceof StubBasedPsiElement && ((StubBasedPsiElement)element2).getStub() != null) && ancestor.getContainingFile() != element2.getContainingFile()) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent2 = strict ? element2.getParent() : element2;
        while (parent2 != null) {
            if (parent2.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent2 instanceof PsiFile) {
                return false;
            }
            parent2 = parent2.getParent();
        }
        return false;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isContextAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element2, boolean strict) {
        PsiElement parent2;
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(1);
        }
        if (ancestor == null) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent2 = strict ? element2.getContext() : element2;
        while (parent2 != null) {
            PsiElement context2;
            if (parent2.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent2 instanceof PsiFile && (context2 = parent2.getContext()) == null) {
                return false;
            }
            parent2 = parent2.getContext();
        }
        return false;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull List<? extends @Nullable PsiElement> elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonParent(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement ... elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(3);
        }
        return elements.length == 0 ? null : PsiTreeUtil.findCommonParent(Arrays.asList(elements));
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        int depth1;
        PsiFile file2;
        if (element1 == null) {
            PsiTreeUtil.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(5);
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile file1 = element1.getContainingFile();
        PsiFile topLevel = file1 == (file2 = element2.getContainingFile()) ? file1 : null;
        int depth2 = PsiTreeUtil.getDepth(element2, topLevel);
        PsiElement parent1 = element1;
        PsiElement parent2 = element2;
        for (depth1 = PsiTreeUtil.getDepth(element1, topLevel); depth1 > depth2; --depth1) {
            parent1 = parent1.getParent();
        }
        while (depth2 > depth1) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    @Contract(pure=true)
    public static int getDepth(@NotNull PsiElement element2, @Nullable PsiElement topLevel) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(6);
        }
        int depth = 0;
        for (PsiElement parent2 = element2; parent2 != topLevel && parent2 != null; parent2 = parent2.getParent()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull Collection<? extends @Nullable PsiElement> elements) {
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(7);
        }
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonContext(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent1;
        if (element1 == null) {
            PsiTreeUtil.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(9);
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile2 = element1.getContainingFile();
        PsiFile topLevel = containingFile2 == element2.getContainingFile() ? containingFile2 : null;
        int depth1 = PsiTreeUtil.getContextDepth(element1, topLevel);
        int depth2 = PsiTreeUtil.getContextDepth(element2, topLevel);
        PsiElement parent2 = element2;
        for (parent1 = element1; depth1 > depth2 && parent1 != null; parent1 = parent1.getContext(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getContext();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getContext();
            parent2 = parent2.getContext();
        }
        return parent1;
    }

    private static int getContextDepth(@NotNull PsiElement element2, @Nullable PsiElement topLevel) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(10);
        }
        int depth = 0;
        for (PsiElement parent2 = element2; parent2 != topLevel && parent2 != null; parent2 = parent2.getContext()) {
            ++depth;
        }
        return depth;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(11);
        }
        return PsiTreeUtil.findChildOfType(element2, aClass, true, null);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass, boolean strict) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(12);
        }
        return PsiTreeUtil.findChildOfType(element2, aClass, strict, null);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfType(final @Nullable PsiElement element2, final @NotNull Class<T> aClass, final boolean strict, final @Nullable Class<? extends PsiElement> stopAt) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(13);
        }
        if (element2 == null) {
            return null;
        }
        PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

            @Override
            public boolean execute(@NotNull PsiElement each) {
                if (each == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (strict && each == element2) {
                    return true;
                }
                if (aClass.isInstance(each)) {
                    return this.setFound(each);
                }
                return stopAt == null || !stopAt.isInstance(each);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$1", "execute"));
            }
        };
        PsiTreeUtil.processElements(element2, (PsiElementProcessor<? super PsiElement>)processor);
        return (T)((PsiElement)aClass.cast(processor.getFoundElement()));
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfAnyType(@Nullable PsiElement element2, Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(14);
        }
        return PsiTreeUtil.findChildOfAnyType(element2, true, classes);
    }

    @SafeVarargs
    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfAnyType(final @Nullable PsiElement element2, final boolean strict, final Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(15);
        }
        if (element2 == null) {
            return null;
        }
        PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

            @Override
            public boolean execute(@NotNull PsiElement each) {
                if (each == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (strict && each == element2) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes)) {
                    return this.setFound(each);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$2", "execute"));
            }
        };
        PsiTreeUtil.processElements(element2, (PsiElementProcessor<? super PsiElement>)processor);
        return processor.getFoundElement();
    }

    public static <T extends PsiElement> @Unmodifiable @NotNull Collection<T> findChildrenOfType(@Nullable PsiElement element2, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(16);
        }
        return PsiTreeUtil.findChildrenOfAnyType(element2, true, aClass);
    }

    @SafeVarargs
    public static <T extends PsiElement> @Unmodifiable @NotNull Collection<T> findChildrenOfAnyType(@Nullable PsiElement element2, Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(17);
        }
        return PsiTreeUtil.findChildrenOfAnyType(element2, true, classes);
    }

    @SafeVarargs
    public static <T extends PsiElement> @Unmodifiable @NotNull Collection<T> findChildrenOfAnyType(final @Nullable PsiElement element2, final boolean strict, final Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(18);
        }
        if (element2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PsiTreeUtil.$$$reportNull$$$0(19);
            }
            return list;
        }
        PsiElementProcessor.CollectElements<PsiElement> processor = new PsiElementProcessor.CollectElements<PsiElement>(){

            @Override
            public boolean execute(@NotNull PsiElement each) {
                if (each == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (strict && each == element2) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes)) {
                    return super.execute(each);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$3", "execute"));
            }
        };
        PsiTreeUtil.processElements(element2, (PsiElementProcessor<? super PsiElement>)processor);
        Collection collection = processor.getCollection();
        if (collection == null) {
            PsiTreeUtil.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getChildOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(21);
        }
        if (element2 != null) {
            for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!aClass.isInstance(child)) continue;
                return (T)((PsiElement)aClass.cast(child));
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element2, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            PsiTreeUtil.$$$reportNull$$$0(22);
        }
        return PsiTreeUtil.findFirstParent(element2, false, condition);
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element2, boolean strict, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            PsiTreeUtil.$$$reportNull$$$0(23);
        }
        if (strict && element2 != null) {
            element2 = element2.getParent();
        }
        while (element2 != null) {
            if (condition.value(element2)) {
                return element2;
            }
            element2 = element2.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstContext(@Nullable PsiElement element2, boolean strict, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            PsiTreeUtil.$$$reportNull$$$0(24);
        }
        if (strict && element2 != null) {
            element2 = element2.getContext();
        }
        while (element2 != null) {
            if (condition.value(element2)) {
                return element2;
            }
            element2 = element2.getContext();
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> T getRequiredChildOfType(@NotNull PsiElement element2, @NotNull Class<T> aClass) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(25);
        }
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(26);
        }
        T child = PsiTreeUtil.getChildOfType(element2, aClass);
        assert (child != null) : "Missing required child of type " + aClass.getName();
        T t2 = child;
        if (t2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(27);
        }
        return t2;
    }

    public static int countChildrenOfType(@NotNull PsiElement element2, @NotNull Class<? extends PsiElement> clazz) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(28);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(29);
        }
        int result2 = 0;
        for (PsiElement cur = element2.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!clazz.isInstance(cur)) continue;
            ++result2;
        }
        return result2;
    }

    public static <T extends PsiElement> T @Nullable [] getChildrenOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(30);
        }
        if (element2 == null) {
            return null;
        }
        List<T> result2 = PsiTreeUtil.getChildrenOfTypeAsList(element2, aClass);
        return result2.isEmpty() ? null : (PsiElement[])ArrayUtil.toObjectArray(result2, aClass);
    }

    @SafeVarargs
    public static <T extends PsiElement> @Unmodifiable @NotNull List<T> getChildrenOfAnyType(@Nullable PsiElement element2, Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(31);
        }
        List result2 = null;
        if (element2 != null) {
            for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!PsiTreeUtil.instanceOf(child, classes)) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(child);
            }
        }
        List list = result2 != null ? result2 : ContainerUtil.emptyList();
        if (list == null) {
            PsiTreeUtil.$$$reportNull$$$0(32);
        }
        return list;
    }

    public static <T extends PsiElement> @Unmodifiable @NotNull List<T> getChildrenOfTypeAsList(@Nullable PsiElement element2, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(33);
        }
        List result2 = null;
        if (element2 != null) {
            for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!aClass.isInstance(child)) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add((PsiElement)aClass.cast(child));
            }
        }
        List list = result2 != null ? result2 : Collections.emptyList();
        if (list == null) {
            PsiTreeUtil.$$$reportNull$$$0(34);
        }
        return list;
    }

    public static @Unmodifiable @NotNull List<PsiElement> getElementsOfRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            PsiTreeUtil.$$$reportNull$$$0(35);
        }
        if (end == null) {
            PsiTreeUtil.$$$reportNull$$$0(36);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement e2 = start; e2 != end; e2 = e2.getNextSibling()) {
            if (e2 == null) {
                throw new IllegalArgumentException("Invalid range: " + start + ".." + end);
            }
            result2.add(e2);
        }
        result2.add(end);
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            PsiTreeUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getStubChildOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass) {
        StubElement stub2;
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(38);
        }
        if (element2 == null) {
            return null;
        }
        StubElement stubElement = stub2 = element2 instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element2).getStub() : null;
        if (stub2 == null) {
            return PsiTreeUtil.getChildOfType(element2, aClass);
        }
        for (StubElement childStub : stub2.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass.isInstance(child)) continue;
            return (T)((PsiElement)aClass.cast(child));
        }
        return null;
    }

    public static <T extends PsiElement> @Unmodifiable @NotNull List<T> getStubChildrenOfTypeAsList(@Nullable PsiElement element2, @NotNull Class<? extends T> aClass) {
        StubElement stub2;
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(39);
        }
        if (element2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PsiTreeUtil.$$$reportNull$$$0(40);
            }
            return list;
        }
        StubElement stubElement = stub2 = element2 instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element2).getStub() : null;
        if (stub2 == null) {
            return PsiTreeUtil.getChildrenOfTypeAsList(element2, aClass);
        }
        SmartList<PsiElement> result2 = new SmartList<PsiElement>();
        for (StubElement childStub : stub2.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass.isInstance(child)) continue;
            result2.add((PsiElement)aClass.cast(child));
        }
        SmartList<PsiElement> smartList = result2;
        if (smartList == null) {
            PsiTreeUtil.$$$reportNull$$$0(41);
        }
        return smartList;
    }

    public static boolean instanceOf(Object object, Class<?> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(42);
        }
        if (object != null) {
            for (Class<?> c2 : classes) {
                if (!c2.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getChildOfAnyType(@Nullable PsiElement element2, Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(43);
        }
        if (element2 != null) {
            for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
                for (Class<T> clazz : classes) {
                    if (!clazz.isInstance(child)) continue;
                    return (T)((PsiElement)clazz.cast(child));
                }
            }
        }
        return null;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getNextSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(44);
        }
        if (sibling != null) {
            for (PsiElement nextSibling = sibling.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                if (!aClass.isInstance(nextSibling)) continue;
                return (T)((PsiElement)aClass.cast(nextSibling));
            }
        }
        return null;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(45);
        }
        if (sibling != null) {
            for (PsiElement prevSibling = sibling.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
                if (!aClass.isInstance(prevSibling)) continue;
                return (T)((PsiElement)aClass.cast(prevSibling));
            }
        }
        return null;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass) {
        T next;
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(46);
        }
        T answer = PsiTreeUtil.getParentOfType(element2, aClass);
        while ((next = PsiTreeUtil.getParentOfType(answer, aClass)) != null) {
            answer = next;
        }
        return answer;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(47);
        }
        return PsiTreeUtil.getParentOfType(element2, aClass, true);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement getStubOrPsiParent(@Nullable PsiElement element2) {
        Object stub2;
        if (element2 instanceof StubBasedPsiElement && (stub2 = ((StubBasedPsiElement)element2).getStub()) != null) {
            StubElement parentStub = stub2.getParentStub();
            return parentStub != null ? (PsiElement)parentStub.getPsi() : null;
        }
        return element2 != null ? element2.getParent() : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <E extends PsiElement> E getStubOrPsiParentOfType(@Nullable PsiElement element2, @NotNull Class<E> parentClass) {
        Object stub2;
        if (parentClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(48);
        }
        if (element2 instanceof StubBasedPsiElement && (stub2 = ((StubBasedPsiElement)element2).getStub()) != null) {
            return stub2.getParentStubOfType(parentClass);
        }
        return PsiTreeUtil.getParentOfType(element2, parentClass);
    }

    @SafeVarargs
    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(49);
        }
        if (stopAt == null) {
            PsiTreeUtil.$$$reportNull$$$0(50);
        }
        if (element2 == null) {
            return null;
        }
        if (strict) {
            element2 = element2.getContext();
        }
        while (element2 != null && !aClass.isInstance(element2)) {
            if (PsiTreeUtil.instanceOf(element2, stopAt)) {
                return null;
            }
            element2 = element2.getContext();
        }
        return (T)((PsiElement)aClass.cast(element2));
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element2, @NotNull Class<? extends T> aClass, boolean strict) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(51);
        }
        return PsiTreeUtil.getContextOfType(element2, strict, aClass);
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element2, Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(52);
        }
        return PsiTreeUtil.getContextOfType(element2, true, classes);
    }

    @SafeVarargs
    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element2, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(53);
        }
        if (element2 == null) {
            return null;
        }
        if (strict) {
            element2 = element2.getContext();
        }
        while (element2 != null && !PsiTreeUtil.instanceOf(element2, classes)) {
            element2 = element2.getContext();
        }
        return (T)element2;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass, boolean strict) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(54);
        }
        return PsiTreeUtil.getParentOfType(element2, aClass, strict, -1);
    }

    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass, boolean strict, int minStartOffset) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(55);
        }
        if (element2 == null) {
            return null;
        }
        if (strict) {
            if (element2 instanceof PsiFile) {
                return null;
            }
            element2 = element2.getParent();
        }
        while (element2 != null && (minStartOffset == -1 || element2.getNode().getStartOffset() >= minStartOffset)) {
            if (aClass.isInstance(element2)) {
                return (T)((PsiElement)aClass.cast(element2));
            }
            if (element2 instanceof PsiFile) {
                return null;
            }
            element2 = element2.getParent();
        }
        return null;
    }

    @SafeVarargs
    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element2, @NotNull Class<T> aClass, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(56);
        }
        if (stopAt == null) {
            PsiTreeUtil.$$$reportNull$$$0(57);
        }
        if (element2 == null) {
            return null;
        }
        if (strict) {
            if (element2 instanceof PsiFile) {
                return null;
            }
            element2 = element2.getParent();
        }
        while (element2 != null && !aClass.isInstance(element2)) {
            if (PsiTreeUtil.instanceOf(element2, stopAt)) {
                return null;
            }
            if (element2 instanceof PsiFile) {
                return null;
            }
            element2 = element2.getParent();
        }
        return (T)((PsiElement)aClass.cast(element2));
    }

    public static <T extends PsiElement> @Unmodifiable @NotNull List<T> collectParents(@NotNull PsiElement element2, @NotNull Class<? extends T> parent2, boolean includeMyself, @NotNull Predicate<? super PsiElement> stopCondition) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(58);
        }
        if (parent2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(59);
        }
        if (stopCondition == null) {
            PsiTreeUtil.$$$reportNull$$$0(60);
        }
        if (!includeMyself) {
            element2 = element2.getParent();
        }
        SmartList<PsiElement> parents2 = new SmartList<PsiElement>();
        while (element2 != null && !stopCondition.test(element2)) {
            if (parent2.isInstance(element2)) {
                parents2.add((PsiElement)parent2.cast(element2));
            }
            element2 = element2.getParent();
        }
        SmartList<PsiElement> smartList = parents2;
        if (smartList == null) {
            PsiTreeUtil.$$$reportNull$$$0(61);
        }
        return smartList;
    }

    @Nullable
    public static PsiElement findSiblingForward(@NotNull PsiElement element2, @NotNull IElementType elementType, @Nullable Consumer<? super PsiElement> consumer2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(62);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(63);
        }
        return PsiTreeUtil.findSiblingForward(element2, elementType, true, consumer2);
    }

    @Nullable
    public static PsiElement findSiblingForward(@NotNull PsiElement element2, @NotNull IElementType elementType, boolean strict, @Nullable Consumer<? super PsiElement> consumer2) {
        PsiElement e2;
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(64);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(65);
        }
        PsiElement psiElement = e2 = strict ? element2.getNextSibling() : element2;
        while (e2 != null) {
            if (elementType.equals(e2.getNode().getElementType())) {
                return e2;
            }
            if (consumer2 != null) {
                consumer2.consume(e2);
            }
            e2 = e2.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static PsiElement findSiblingBackward(@NotNull PsiElement element2, @NotNull IElementType elementType, @Nullable Consumer<? super PsiElement> consumer2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(66);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(67);
        }
        return PsiTreeUtil.findSiblingBackward(element2, elementType, true, consumer2);
    }

    @Nullable
    public static PsiElement findSiblingBackward(@NotNull PsiElement element2, @NotNull IElementType elementType, boolean strict, @Nullable Consumer<? super PsiElement> consumer2) {
        PsiElement e2;
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(68);
        }
        if (elementType == null) {
            PsiTreeUtil.$$$reportNull$$$0(69);
        }
        PsiElement psiElement = e2 = strict ? element2.getPrevSibling() : element2;
        while (e2 != null) {
            if (elementType.equals(e2.getNode().getElementType())) {
                return e2;
            }
            if (consumer2 != null) {
                consumer2.consume(e2);
            }
            e2 = e2.getPrevSibling();
        }
        return null;
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiElement skipSiblingsForward(@Nullable PsiElement element2, Class<? extends PsiElement> ... elementClasses) {
        if (elementClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(70);
        }
        if (element2 != null) {
            for (PsiElement e2 = element2.getNextSibling(); e2 != null; e2 = e2.getNextSibling()) {
                if (PsiTreeUtil.instanceOf(e2, elementClasses)) continue;
                return e2;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement skipWhitespacesForward(@Nullable PsiElement element2) {
        return PsiTreeUtil.skipSiblingsForward(element2, WS);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement skipWhitespacesAndCommentsForward(@Nullable PsiElement element2) {
        return PsiTreeUtil.skipSiblingsForward(element2, WS_COMMENTS);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiElement skipSiblingsBackward(@Nullable PsiElement element2, Class<? extends PsiElement> ... elementClasses) {
        if (elementClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(71);
        }
        if (element2 != null) {
            for (PsiElement e2 = element2.getPrevSibling(); e2 != null; e2 = e2.getPrevSibling()) {
                if (PsiTreeUtil.instanceOf(e2, elementClasses)) continue;
                return e2;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement skipWhitespacesBackward(@Nullable PsiElement element2) {
        return PsiTreeUtil.skipSiblingsBackward(element2, WS);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement skipWhitespacesAndCommentsBackward(@Nullable PsiElement element2) {
        return PsiTreeUtil.skipSiblingsBackward(element2, WS_COMMENTS);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiElement skipParentsOfType(@Nullable PsiElement element2, Class<? extends PsiElement> ... parentClasses) {
        if (parentClasses == null) {
            PsiTreeUtil.$$$reportNull$$$0(72);
        }
        if (element2 != null) {
            for (PsiElement e2 = element2.getParent(); e2 != null; e2 = e2.getParent()) {
                if (PsiTreeUtil.instanceOf(e2, parentClasses)) continue;
                return e2;
            }
        }
        return null;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static PsiElement skipMatching(@Nullable PsiElement element2, @NotNull @NotNull Function<? super @NotNull PsiElement, ? extends @Nullable PsiElement> next, @NotNull @NotNull Predicate<? super @NotNull PsiElement> condition) {
        if (next == null) {
            PsiTreeUtil.$$$reportNull$$$0(73);
        }
        if (condition == null) {
            PsiTreeUtil.$$$reportNull$$$0(74);
        }
        if (element2 != null) {
            PsiElement e2 = next.apply(element2);
            while (e2 != null) {
                if (!condition.test(e2)) {
                    return e2;
                }
                e2 = next.apply(e2);
            }
        }
        return null;
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element2, Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(75);
        }
        return PsiTreeUtil.getParentOfType(element2, true, classes);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getNonStrictParentOfType(@Nullable PsiElement element2, Class<? extends T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(76);
        }
        return PsiTreeUtil.getParentOfType(element2, false, classes);
    }

    @SafeVarargs
    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element2, boolean strict, Class<? extends T> ... classes) {
        PsiElement run2;
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(77);
        }
        if (strict) {
            if (element2 == null || element2 instanceof PsiFile) {
                return null;
            }
            run2 = element2.getParent();
        } else {
            run2 = element2;
        }
        while (run2 != null) {
            if (PsiTreeUtil.instanceOf(run2, classes)) {
                return (T)run2;
            }
            if (run2 instanceof PsiFile) break;
            run2 = run2.getParent();
        }
        return null;
    }

    @Contract(pure=true)
    public static PsiElement @NotNull [] collectElements(@Nullable PsiElement element2, @NotNull PsiElementFilter filter) {
        if (filter == null) {
            PsiTreeUtil.$$$reportNull$$$0(78);
        }
        ArrayList result2 = new ArrayList();
        PsiTreeUtil.processElements(element2, (? super PsiElement e2) -> {
            if (filter.isAccepted(e2)) {
                result2.add(e2);
            }
            return true;
        });
        PsiElement[] psiElementArray = result2.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            PsiTreeUtil.$$$reportNull$$$0(79);
        }
        return psiElementArray;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T extends PsiElement> Collection<T> collectElementsOfType(@Nullable PsiElement element2, Class<T> ... classes) {
        if (classes == null) {
            PsiTreeUtil.$$$reportNull$$$0(80);
        }
        return PsiTreeUtil.findChildrenOfAnyType(element2, false, classes);
    }

    @Contract(value="null, _, _ -> true")
    public static <T extends PsiElement> boolean processElements(@Nullable PsiElement element2, @NotNull Class<T> elementClass, @NotNull PsiElementProcessor<? super T> processor) {
        if (elementClass == null) {
            PsiTreeUtil.$$$reportNull$$$0(81);
        }
        if (processor == null) {
            PsiTreeUtil.$$$reportNull$$$0(82);
        }
        return element2 == null || PsiTreeUtil.processElements(element2, (? super PsiElement e2) -> {
            PsiElement t2 = (PsiElement)ObjectUtils.tryCast(e2, elementClass);
            return t2 == null || processor.execute(t2);
        });
    }

    @Contract(value="null, _ -> true")
    public static boolean processElements(@Nullable PsiElement element2, final @NotNull PsiElementProcessor<? super PsiElement> processor) {
        if (processor == null) {
            PsiTreeUtil.$$$reportNull$$$0(83);
        }
        if (element2 == null) {
            return true;
        }
        if (element2 instanceof PsiCompiledElement || !element2.isPhysical()) {
            if (!processor.execute(element2)) {
                return false;
            }
            for (PsiElement child : element2.getChildren()) {
                if (PsiTreeUtil.processElements(child, processor)) continue;
                return false;
            }
            return true;
        }
        final boolean[] result2 = new boolean[]{true};
        element2.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (processor.execute(element2)) {
                    super.visitElement(element2);
                } else {
                    this.stopWalking();
                    result2[0] = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil$4", "visitElement"));
            }
        });
        return result2[0];
    }

    public static boolean processElements(@NotNull PsiElementProcessor<? super PsiElement> processor, PsiElement ... elements) {
        if (processor == null) {
            PsiTreeUtil.$$$reportNull$$$0(84);
        }
        if (elements != null) {
            for (PsiElement element2 : elements) {
                if (PsiTreeUtil.processElements(element2, processor)) continue;
                return false;
            }
        }
        return true;
    }

    public static void mark(@NotNull PsiElement element2, @NotNull Object marker) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(85);
        }
        if (marker == null) {
            PsiTreeUtil.$$$reportNull$$$0(86);
        }
        element2.getNode().putCopyableUserData(MARKER, marker);
    }

    public static Object mark(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(87);
        }
        Object mark = new Object();
        PsiTreeUtil.mark(element2, mark);
        return mark;
    }

    @Nullable
    public static PsiElement releaseMark(@NotNull PsiElement root, @NotNull Object marker) {
        ASTNode node;
        if (root == null) {
            PsiTreeUtil.$$$reportNull$$$0(88);
        }
        if (marker == null) {
            PsiTreeUtil.$$$reportNull$$$0(89);
        }
        if (marker.equals((node = root.getNode()).getCopyableUserData(MARKER))) {
            node.putCopyableUserData(MARKER, null);
            return root;
        }
        for (PsiElement child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement result2 = PsiTreeUtil.releaseMark(child, marker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffset(@NotNull PsiFile file, int offset, @NotNull Class<T> clazz, boolean strictStart) {
        if (file == null) {
            PsiTreeUtil.$$$reportNull$$$0(90);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(91);
        }
        PsiElement result2 = null;
        for (PsiElement psiElement : file.getViewProvider().getAllFiles()) {
            T parent2;
            PsiElement elementAt = psiElement.findElementAt(offset);
            if (elementAt == null || (parent2 = PsiTreeUtil.getParentOfType(elementAt, clazz, strictStart)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return (T)result2;
    }

    @SafeVarargs
    @Contract(pure=true)
    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffsetWithStopSet(@NotNull PsiFile file, int offset, @NotNull Class<T> clazz, boolean strictStart, Class<? extends PsiElement> ... stopAt) {
        if (file == null) {
            PsiTreeUtil.$$$reportNull$$$0(92);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(93);
        }
        if (stopAt == null) {
            PsiTreeUtil.$$$reportNull$$$0(94);
        }
        PsiElement result2 = null;
        for (PsiElement psiElement : file.getViewProvider().getAllFiles()) {
            T parent2;
            PsiElement elementAt = psiElement.findElementAt(offset);
            if (elementAt == null || (parent2 = PsiTreeUtil.getParentOfType(elementAt, clazz, strictStart, stopAt)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return (T)result2;
    }

    @Contract(pure=true)
    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull Class<T> clazz) {
        if (file == null) {
            PsiTreeUtil.$$$reportNull$$$0(95);
        }
        if (clazz == null) {
            PsiTreeUtil.$$$reportNull$$$0(96);
        }
        PsiElement result2 = null;
        FileViewProvider viewProvider = file.getViewProvider();
        for (Language lang : viewProvider.getLanguages()) {
            T run2;
            PsiElement elementAt = viewProvider.findElementAt(startOffset, lang);
            T prev = run2 = PsiTreeUtil.getParentOfType(elementAt, clazz, false);
            while (run2 != null && run2.getTextRange().getStartOffset() == startOffset && run2.getTextRange().getEndOffset() <= endOffset) {
                prev = run2;
                run2 = PsiTreeUtil.getParentOfType(run2, clazz);
            }
            if (prev == null) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            if (elementStartOffset != startOffset || elementEndOffset > endOffset || result2 != null && result2.getTextRange().getEndOffset() >= elementEndOffset) continue;
            result2 = prev;
        }
        return (T)result2;
    }

    @NotNull
    public static PsiElement getDeepestFirst(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(97);
        }
        PsiElement result2 = element2;
        while (true) {
            PsiElement firstChild;
            if ((firstChild = result2.getFirstChild()) == null) {
                PsiElement psiElement = result2;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(98);
                }
                return psiElement;
            }
            result2 = firstChild;
        }
    }

    @NotNull
    public static PsiElement getDeepestLast(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(99);
        }
        PsiElement result2 = element2;
        while (true) {
            PsiElement lastChild;
            if ((lastChild = result2.getLastChild()) == null) {
                PsiElement psiElement = result2;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(100);
                }
                return psiElement;
            }
            result2 = lastChild;
        }
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement current) {
        if (current == null) {
            PsiTreeUtil.$$$reportNull$$$0(101);
        }
        while (!(current instanceof PsiFileSystemItem)) {
            PsiElement prevSibling = current.getPrevSibling();
            if (prevSibling != null) {
                return PsiTreeUtil.lastChild(prevSibling);
            }
            PsiElement parent2 = current.getParent();
            if (parent2 == null || parent2 instanceof PsiFile) {
                return null;
            }
            current = parent2;
        }
        return null;
    }

    @Nullable
    public static PsiElement nextLeaf(@NotNull PsiElement current) {
        if (current == null) {
            PsiTreeUtil.$$$reportNull$$$0(102);
        }
        while (!(current instanceof PsiFileSystemItem)) {
            PsiElement nextSibling = current.getNextSibling();
            if (nextSibling != null) {
                return PsiTreeUtil.firstChild(nextSibling);
            }
            PsiElement parent2 = current.getParent();
            if (parent2 == null || parent2 instanceof PsiFile) {
                return null;
            }
            current = parent2;
        }
        return null;
    }

    @NotNull
    public static PsiElement lastChild(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(103);
        }
        return PsiTreeUtil.getDeepestLast(element2);
    }

    @NotNull
    public static PsiElement firstChild(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(104);
        }
        return PsiTreeUtil.getDeepestFirst(element2);
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement element2, boolean skipEmptyElements) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(105);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element2);
        while (skipEmptyElements && prevLeaf != null && prevLeaf.getTextLength() == 0) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement prevVisibleLeaf(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(106);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element2, true);
        while (prevLeaf != null && StringUtil.isEmptyOrSpaces(prevLeaf.getText())) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf, true);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement nextVisibleLeaf(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(107);
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element2, true);
        while (nextLeaf != null && StringUtil.isEmptyOrSpaces(nextLeaf.getText())) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf, true);
        }
        return nextLeaf;
    }

    @Nullable
    public static PsiElement prevCodeLeaf(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(108);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element2, true);
        while (prevLeaf != null && PsiTreeUtil.isNonCodeLeaf(prevLeaf)) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf, true);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement nextCodeLeaf(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(109);
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element2, true);
        while (nextLeaf != null && PsiTreeUtil.isNonCodeLeaf(nextLeaf)) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf, true);
        }
        return nextLeaf;
    }

    private static boolean isNonCodeLeaf(PsiElement leaf) {
        return StringUtil.isEmptyOrSpaces(leaf.getText()) || PsiTreeUtil.getNonStrictParentOfType(leaf, PsiComment.class) != null;
    }

    @Nullable
    public static PsiElement nextLeaf(@NotNull PsiElement element2, boolean skipEmptyElements) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(110);
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element2);
        while (skipEmptyElements && nextLeaf != null && nextLeaf.getTextLength() == 0) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf);
        }
        return nextLeaf;
    }

    public static boolean hasErrorElements(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTreeUtil.$$$reportNull$$$0(111);
        }
        Ref<Boolean> result2 = new Ref<Boolean>(false);
        PsiWalkingState.processAll(element2, el -> {
            if (el instanceof PsiErrorElement) {
                result2.set(true);
                return false;
            }
            return true;
        });
        return result2.get();
    }

    @NotNull
    public static @NotNull PsiElement @NotNull [] filterAncestors(@NotNull @NotNull PsiElement @NotNull [] elements) {
        int previousSize;
        if (elements == null) {
            PsiTreeUtil.$$$reportNull$$$0(112);
        }
        ArrayList filteredElements = new ArrayList();
        ContainerUtil.addAll(filteredElements, elements);
        block0: do {
            previousSize = filteredElements.size();
            for (int i2 = 0; i2 < filteredElements.size(); ++i2) {
                PsiElement element2 = (PsiElement)filteredElements.get(i2);
                for (int j2 = 0; j2 < filteredElements.size(); ++j2) {
                    PsiElement element22 = (PsiElement)filteredElements.get(j2);
                    if (i2 == j2 || !PsiTreeUtil.isAncestor(element2, element22, false)) continue;
                    filteredElements.remove(element22);
                    continue block0;
                }
            }
        } while (filteredElements.size() != previousSize);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(filteredElements);
        if (psiElementArray == null) {
            PsiTreeUtil.$$$reportNull$$$0(113);
        }
        return psiElementArray;
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state) {
        if (processor == null) {
            PsiTreeUtil.$$$reportNull$$$0(114);
        }
        if (entrance == null) {
            PsiTreeUtil.$$$reportNull$$$0(115);
        }
        if (state == null) {
            PsiTreeUtil.$$$reportNull$$$0(116);
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!scope.processDeclarations(processor, state, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    public static boolean treeWalkUp(@NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull PairProcessor<? super PsiElement, ? super PsiElement> eachScopeAndLastParent) {
        if (entrance == null) {
            PsiTreeUtil.$$$reportNull$$$0(117);
        }
        if (eachScopeAndLastParent == null) {
            PsiTreeUtil.$$$reportNull$$$0(118);
        }
        PsiElement prevParent = null;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!eachScopeAndLastParent.process(scope, prevParent)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    @NotNull
    public static PsiElement findPrevParent(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            PsiTreeUtil.$$$reportNull$$$0(119);
        }
        if (descendant == null) {
            PsiTreeUtil.$$$reportNull$$$0(120);
        }
        PsiElement cur = descendant;
        while (cur != null) {
            PsiElement parent2 = cur.getParent();
            if (parent2 == ancestor) {
                PsiElement psiElement = cur;
                if (psiElement == null) {
                    PsiTreeUtil.$$$reportNull$$$0(121);
                }
                return psiElement;
            }
            cur = parent2;
        }
        throw new AssertionError((Object)(descendant + " is not a descendant of " + ancestor));
    }

    public static @Unmodifiable @NotNull List<PsiElement> getInjectedElements(@NotNull OuterLanguageElement outerLanguageElement) {
        if (outerLanguageElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(122);
        }
        PsiFile psi = outerLanguageElement.getContainingFile().getViewProvider().getPsi(outerLanguageElement.getLanguage());
        TextRange injectionRange = outerLanguageElement.getTextRange();
        ArrayList<PsiElement> res2 = new ArrayList<PsiElement>();
        assert (psi != null) : outerLanguageElement;
        for (PsiElement element2 = psi.findElementAt(injectionRange.getStartOffset()); element2 != null && injectionRange.intersectsStrict(element2.getTextRange()); element2 = element2.getNextSibling()) {
            res2.add(element2);
        }
        ArrayList<PsiElement> arrayList = res2;
        if (arrayList == null) {
            PsiTreeUtil.$$$reportNull$$$0(123);
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement getDeepestVisibleFirst(@NotNull PsiElement psiElement) {
        PsiElement first;
        if (psiElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(124);
        }
        if (StringUtil.isEmptyOrSpaces((first = PsiTreeUtil.getDeepestFirst(psiElement)).getText())) {
            first = PsiTreeUtil.nextVisibleLeaf(first);
        }
        return first;
    }

    @Nullable
    public static PsiElement getDeepestVisibleLast(@NotNull PsiElement psiElement) {
        PsiElement last;
        if (psiElement == null) {
            PsiTreeUtil.$$$reportNull$$$0(125);
        }
        if (StringUtil.isEmptyOrSpaces((last = PsiTreeUtil.getDeepestLast(psiElement)).getText())) {
            last = PsiTreeUtil.prevVisibleLeaf(last);
        }
        return last;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T extends PsiElement> T findSameElementInCopy(@Nullable T element2, @NotNull PsiFile copy) throws IllegalStateException {
        if (copy == null) {
            PsiTreeUtil.$$$reportNull$$$0(126);
        }
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof SyntheticElement) {
            return (T)((SyntheticElement)((Object)element2)).findSameElementInCopy(copy);
        }
        IntArrayList offsets = new IntArrayList();
        Object cur = element2;
        while (!cur.getClass().equals(copy.getClass())) {
            int pos = 0;
            for (PsiElement sibling = cur.getPrevSibling(); sibling != null; sibling = sibling.getPrevSibling()) {
                ++pos;
            }
            offsets.add(pos);
            if ((cur = cur.getParent()) != null) continue;
            throw new IllegalStateException("Cannot find parent file; element class: " + element2.getClass());
        }
        cur = copy;
        for (int level = offsets.size() - 1; level >= 0; --level) {
            int pos = offsets.get(level);
            if ((cur = cur.getFirstChild()) == null) {
                throw new IllegalStateException("File structure differs: no child");
            }
            for (int i2 = 0; i2 < pos; ++i2) {
                if ((cur = cur.getNextSibling()) != null) continue;
                throw new IllegalStateException("File structure differs: number of siblings is less than " + pos);
            }
        }
        if (!cur.getClass().equals(element2.getClass())) {
            throw new IllegalStateException("File structure differs: " + cur.getClass() + " != " + element2.getClass());
        }
        return (T)cur;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 61: 
            case 79: 
            case 98: 
            case 100: 
            case 113: 
            case 121: 
            case 123: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 61: 
            case 79: 
            case 98: 
            case 100: 
            case 113: 
            case 121: 
            case 123: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 31: 
            case 42: 
            case 43: 
            case 52: 
            case 53: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 61: 
            case 79: 
            case 98: 
            case 100: 
            case 113: 
            case 121: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiTreeUtil";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 29: 
            case 91: 
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 50: 
            case 57: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopCondition";
                break;
            }
            case 63: 
            case 65: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClasses";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 90: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 115: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachScopeAndLastParent";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerLanguageElement";
                break;
            }
            case 124: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiTreeUtil";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenOfAnyType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredChildOfType";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfAnyType";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfTypeAsList";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsOfRange";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubChildrenOfTypeAsList";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElements";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepestFirst";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepestLast";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAncestors";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrevParent";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedElements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isContextAncestor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommonParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDepth";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCommonContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContextDepth";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findChildOfType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findChildOfAnyType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfAnyType";
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 61: 
            case 79: 
            case 98: 
            case 100: 
            case 113: 
            case 121: 
            case 123: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFirstParent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findFirstContext";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredChildOfType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "countChildrenOfType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfAnyType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfTypeAsList";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOfRange";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getStubChildOfType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getStubChildrenOfTypeAsList";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfAnyType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingOfType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingOfType";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfType";
                break;
            }
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 75: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiParentOfType";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getContextOfType";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingForward";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingBackward";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsForward";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsBackward";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "skipParentsOfType";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "skipMatching";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParentOfType";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "collectElements";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "collectElementsOfType";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "mark";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "releaseMark";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtOffset";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtOffsetWithStopSet";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtRange";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestFirst";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestLast";
                break;
            }
            case 101: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "prevLeaf";
                break;
            }
            case 102: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "nextLeaf";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "lastChild";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "firstChild";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "prevVisibleLeaf";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "nextVisibleLeaf";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "prevCodeLeaf";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "nextCodeLeaf";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorElements";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "filterAncestors";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "treeWalkUp";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "findPrevParent";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedElements";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestVisibleFirst";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestVisibleLast";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "findSameElementInCopy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 61: 
            case 79: 
            case 98: 
            case 100: 
            case 113: 
            case 121: 
            case 123: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

