/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharTableImpl
implements CharTable {
    private static final int INTERN_THRESHOLD = 40;
    private static final StringHashToCharSequencesMap STATIC_ENTRIES = CharTableImpl.newStaticSet();
    private final StringHashToCharSequencesMap entries = new StringHashToCharSequencesMap(10, 0.9f);

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence text) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(0);
        }
        CharSequence charSequence = text.length() > 40 ? text : this.doIntern(text);
        if (charSequence == null) {
            CharTableImpl.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CharSequence doIntern(@NotNull CharSequence text, int startOffset, int endOffset) {
        int hashCode;
        CharSequence interned;
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(2);
        }
        if ((interned = CharTableImpl.STATIC_ENTRIES.getSubSequenceWithHashCode(hashCode = startOffset == 0 && endOffset == text.length() ? StringUtil.stringHashCode(text) : StringUtil.stringHashCode(text, startOffset, endOffset), text, startOffset, endOffset)) != null) {
            CharSequence charSequence = interned;
            if (charSequence != null) return charSequence;
            CharTableImpl.$$$reportNull$$$0(3);
            return charSequence;
        }
        StringHashToCharSequencesMap stringHashToCharSequencesMap = this.entries;
        // MONITORENTER : stringHashToCharSequencesMap
        CharSequence charSequence = this.entries.getOrAddSubSequenceWithHashCode(hashCode, text, startOffset, endOffset);
        // MONITOREXIT : stringHashToCharSequencesMap
        if (charSequence != null) return charSequence;
        CharTableImpl.$$$reportNull$$$0(4);
        return charSequence;
    }

    @NotNull
    public CharSequence doIntern(@NotNull CharSequence text) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(5);
        }
        return this.doIntern(text, 0, text.length());
    }

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
        if (baseText == null) {
            CharTableImpl.$$$reportNull$$$0(6);
        }
        return endOffset - startOffset > 40 ? CharTableImpl.substring(baseText, startOffset, endOffset) : this.doIntern(baseText, startOffset, endOffset);
    }

    @NotNull
    private static String substring(@NotNull CharSequence text, int startOffset, int endOffset) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(7);
        }
        if (text instanceof String) {
            String string = ((String)text).substring(startOffset, endOffset);
            if (string == null) {
                CharTableImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = text.subSequence(startOffset, endOffset).toString();
        if (string == null) {
            CharTableImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static CharSequence getStaticInterned(@NotNull CharSequence text) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(10);
        }
        return CharTableImpl.STATIC_ENTRIES.get(text);
    }

    @NotNull
    private static StringHashToCharSequencesMap newStaticSet() {
        StringHashToCharSequencesMap r2 = new StringHashToCharSequencesMap(10, 0.9f);
        r2.add("==");
        r2.add("!=");
        r2.add("||");
        r2.add("++");
        r2.add("--");
        r2.add("<");
        r2.add("<=");
        r2.add("<<=");
        r2.add("<<");
        r2.add(">");
        r2.add("&");
        r2.add("&&");
        r2.add("+=");
        r2.add("-=");
        r2.add("*=");
        r2.add("/=");
        r2.add("&=");
        r2.add("|=");
        r2.add("^=");
        r2.add("%=");
        r2.add("(");
        r2.add(")");
        r2.add("{");
        r2.add("}");
        r2.add("[");
        r2.add("]");
        r2.add(";");
        r2.add(",");
        r2.add("...");
        r2.add(".");
        r2.add("=");
        r2.add("!");
        r2.add("~");
        r2.add("?");
        r2.add(":");
        r2.add("+");
        r2.add("-");
        r2.add("*");
        r2.add("/");
        r2.add("|");
        r2.add("^");
        r2.add("%");
        r2.add("@");
        r2.add(" ");
        r2.add("  ");
        r2.add("   ");
        r2.add("    ");
        r2.add("     ");
        r2.add("      ");
        r2.add("       ");
        r2.add("        ");
        r2.add("         ");
        r2.add("          ");
        r2.add("           ");
        r2.add("            ");
        r2.add("             ");
        r2.add("              ");
        r2.add("               ");
        r2.add("\n");
        r2.add("\n  ");
        r2.add("\n    ");
        r2.add("\n      ");
        r2.add("\n        ");
        r2.add("\n          ");
        r2.add("\n            ");
        r2.add("\n              ");
        r2.add("\n                ");
        r2.add("<");
        r2.add(">");
        r2.add("</");
        r2.add("/>");
        r2.add("\"");
        r2.add("'");
        r2.add("");
        StringHashToCharSequencesMap stringHashToCharSequencesMap = r2;
        if (stringHashToCharSequencesMap == null) {
            CharTableImpl.$$$reportNull$$$0(11);
        }
        return stringHashToCharSequencesMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/CharTableImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/CharTableImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doIntern";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "substring";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newStaticSet";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doIntern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substring";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStaticInterned";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StringHashToCharSequencesMap
    extends Int2ObjectOpenHashMap<Object> {
        private StringHashToCharSequencesMap(int capacity, float loadFactor) {
            super(capacity, loadFactor);
        }

        private CharSequence getSubSequenceWithHashCode(int hashCode, @NotNull CharSequence sequence2, int startOffset, int endOffset) {
            Object o2;
            if (sequence2 == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(0);
            }
            if ((o2 = this.get(hashCode)) == null) {
                return null;
            }
            if (o2 instanceof CharSequence) {
                if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals((CharSequence)o2, sequence2, startOffset, endOffset)) {
                    return (CharSequence)o2;
                }
                return null;
            }
            if (o2 instanceof CharSequence[]) {
                for (CharSequence cs : (CharSequence[])o2) {
                    if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence2, startOffset, endOffset)) continue;
                    return cs;
                }
                return null;
            }
            assert (false) : o2.getClass();
            return null;
        }

        private static boolean charSequenceSubSequenceEquals(@NotNull CharSequence cs, @NotNull CharSequence baseSequence, int startOffset, int endOffset) {
            if (cs == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(1);
            }
            if (baseSequence == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(2);
            }
            if (cs.length() != endOffset - startOffset) {
                return false;
            }
            if (cs == baseSequence && startOffset == 0) {
                return true;
            }
            int len = cs.length();
            for (int i2 = 0; i2 < len; ++i2) {
                if (cs.charAt(i2) == baseSequence.charAt(startOffset + i2)) continue;
                return false;
            }
            return true;
        }

        private CharSequence get(@NotNull CharSequence sequence2) {
            if (sequence2 == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(3);
            }
            int endOffset = sequence2.length();
            int hashCode = StringUtil.stringHashCode(sequence2);
            return this.getSubSequenceWithHashCode(hashCode, sequence2, 0, endOffset);
        }

        private void add(@NotNull CharSequence sequence2) {
            if (sequence2 == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(4);
            }
            int endOffset = sequence2.length();
            int hashCode = StringUtil.stringHashCode(sequence2);
            this.getOrAddSubSequenceWithHashCode(hashCode, sequence2, 0, endOffset);
        }

        @NotNull
        private CharSequence getOrAddSubSequenceWithHashCode(int hashCode, @NotNull CharSequence sequence2, int startOffset, int endOffset) {
            String addedSequence;
            Object value2;
            if (sequence2 == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(5);
            }
            if ((value2 = this.get(hashCode)) == null) {
                addedSequence = CharTableImpl.substring(sequence2, startOffset, endOffset);
                this.put(hashCode, addedSequence);
            } else if (value2 instanceof CharSequence) {
                CharSequence existingSequence = (CharSequence)value2;
                if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals(existingSequence, sequence2, startOffset, endOffset)) {
                    CharSequence charSequence = existingSequence;
                    if (charSequence == null) {
                        StringHashToCharSequencesMap.$$$reportNull$$$0(6);
                    }
                    return charSequence;
                }
                addedSequence = CharTableImpl.substring(sequence2, startOffset, endOffset);
                this.put(hashCode, new CharSequence[]{existingSequence, addedSequence});
            } else if (value2 instanceof CharSequence[]) {
                CharSequence[] existingSequenceArray;
                for (CharSequence cs : existingSequenceArray = (CharSequence[])value2) {
                    if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence2, startOffset, endOffset)) continue;
                    CharSequence charSequence = cs;
                    if (charSequence == null) {
                        StringHashToCharSequencesMap.$$$reportNull$$$0(7);
                    }
                    return charSequence;
                }
                addedSequence = CharTableImpl.substring(sequence2, startOffset, endOffset);
                CharSequence[] newSequenceArray = ArrayUtil.append(existingSequenceArray, addedSequence, CharSequence[]::new);
                this.put(hashCode, newSequenceArray);
            } else {
                assert (false) : value2.getClass();
                if (null == null) {
                    StringHashToCharSequencesMap.$$$reportNull$$$0(8);
                }
                return null;
            }
            String string = addedSequence;
            if (string == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseSequence";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrAddSubSequenceWithHashCode";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubSequenceWithHashCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "charSequenceSubSequenceEquals";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrAddSubSequenceWithHashCode";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

