/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueClassRepresentationKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirDesignatedStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolver;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.util.PrivateForInline;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\f\u0010(\u001a\u00020\u0017*\u00020)H$J\f\u0010*\u001a\u00020\u0017*\u00020)H$J\u001a\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\"\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020\u001b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020)05H\u0086\b\u00f8\u0001\u0000J\u001a\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020A2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020\u001b2\b\u0010.\u001a\u0004\u0018\u00010\u0002H&J\u001a\u0010D\u001a\u00020<2\u0006\u0010E\u001a\u00020F2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010G\u001a\u00020)2\u0006\u00107\u001a\u00020)2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010H\u001a\u00020<2\u0006\u00103\u001a\u00020\u001b2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010I\u001a\u00020J2\u0006\u0010C\u001a\u00020\u001bJ\u000e\u0010K\u001a\u00020J2\u0006\u0010C\u001a\u00020\u001bJ\u001a\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010O\u001a\u00020J2\u0006\u0010@\u001a\u00020\u001bH\u0016J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020R0Q2\u0006\u0010@\u001a\u00020\u001bH\u0016J\u001a\u0010S\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030U0T2\u0006\u0010V\u001a\u00020RH\u0014J\u0014\u0010W\u001a\u00020J2\n\u0010X\u001a\u0006\u0012\u0002\b\u00030UH\u0002J\u0010\u0010Y\u001a\u00020J2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010Z\u001a\u00020\u00172\u0006\u0010@\u001a\u00020AH\u0014J(\u0010[\u001a\u00020J2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00020QH\u0002J\u001a\u0010a\u001a\u00020<2\u0006\u0010b\u001a\u00020c2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010d\u001a\u00020<2\u0006\u0010e\u001a\u00020f2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010g\u001a\u00020<2\u0006\u0010h\u001a\u00020i2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J(\u0010g\u001a\u00020J2\u0006\u0010h\u001a\u00020i2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020i0Q2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0002J\u001a\u0010k\u001a\u00020<2\u0006\u0010l\u001a\u00020_2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010k\u001a\u00020J2\u0006\u0010l\u001a\u00020_2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020_0QJ\u001a\u0010n\u001a\u00020<2\u0006\u0010o\u001a\u00020p2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010[\u001a\u00020<2\u0006\u0010\\\u001a\u00020]2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010q\u001a\u00020<2\u0006\u0010r\u001a\u00020s2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010t\u001a\u00020<2\u0006\u0010u\u001a\u00020v2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020z2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010{\u001a\u00020<2\u0006\u0010|\u001a\u00020}2\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0019\u0010$\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\f\u0012\u0004\b%\u0010\u001d\u001a\u0004\b&\u0010'\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006~"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "designationMapForLocalClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "scopeForLocalClass", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getStatusComputationSession", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "isTransformerForLocalDeclarations", "", "()Z", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getClasses$annotations", "()V", "getClasses", "()Ljava/util/List;", "statusResolver", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "getStatusResolver", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "containingClass", "getContainingClass$annotations", "getContainingClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "needResolveMembers", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "needResolveNestedClassifiers", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "data", "transformDeclarationStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "declarationStatus", "storeClass", "klass", "computeResult", "Lkotlin/Function0;", "transformDeclaration", "declaration", "transformDanglingModifierList", "Lorg/jetbrains/kotlin/fir/declarations/FirDanglingModifierList;", "danglingModifierList", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformClassContent", "firClass", "transformAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "transformDeclarationContent", "transformClass", "transformValueClassRepresentation", "", "transformClassStatus", "transformReplSnippet", "Lorg/jetbrains/kotlin/fir/declarations/FirReplSnippet;", "replSnippet", "forceResolveStatusesOfSupertypes", "additionalSuperTypes", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "superTypeToSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "typeRef", "forceResolveStatusOfCorrespondingClass", "superClassSymbol", "forceResolveStatusesOfClass", "resolveClassForSuperType", "transformPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "containingProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "overriddenStatuses", "transformConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "transformErrorPrimaryConstructor", "errorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "transformSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "overriddenFunctions", "transformProperty", "property", "overriddenProperties", "transformField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "transformEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "transformTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirStatusResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,556:1\n228#1,2:596\n230#1,2:600\n238#2,4:557\n230#2,4:561\n230#2,2:565\n232#2,2:569\n230#2,4:571\n230#2,4:575\n230#2,2:594\n232#2,2:602\n230#2,4:605\n230#2,4:609\n230#2,4:613\n230#2,4:621\n230#2,4:644\n230#2,4:648\n1869#3,2:567\n1869#3,2:590\n1869#3,2:592\n1869#3,2:598\n1563#3:617\n1634#3,3:618\n1563#3:625\n1634#3,3:626\n1617#3,9:629\n1869#3:638\n1870#3:640\n1626#3:641\n81#4,7:579\n76#4,2:586\n57#4:588\n78#4:589\n49#5:604\n21#5:643\n1#6:639\n1#6:642\n*S KotlinDebug\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer\n*L\n321#1:596,2\n321#1:600,2\n210#1:557,4\n237#1:561,4\n261#1:565,2\n261#1:569,2\n270#1:571,4\n282#1:575,4\n320#1:594,2\n320#1:602,2\n427#1:605,4\n445#1:609,4\n458#1:613,4\n483#1:621,4\n521#1:644,4\n533#1:648,4\n262#1:567,2\n301#1:590,2\n308#1:592,2\n322#1:598,2\n473#1:617\n473#1:618,3\n490#1:625\n490#1:626,3\n491#1:629,9\n491#1:638\n491#1:640\n491#1:641\n295#1:579,7\n295#1:586,2\n295#1:588\n295#1:589\n328#1:604\n513#1:643\n491#1:639\n*E\n"})
public abstract class AbstractFirStatusResolveTransformer
extends FirAbstractTreeTransformer<FirResolvedDeclarationStatus> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final StatusComputationSession statusComputationSession;
    @NotNull
    private final Map<FirClassLikeDeclaration, FirClassLikeDeclaration> designationMapForLocalClasses;
    @Nullable
    private final FirScope scopeForLocalClass;
    @NotNull
    private final List<FirClass> classes;
    @NotNull
    private final FirStatusResolver statusResolver;

    public AbstractFirStatusResolveTransformer(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)statusComputationSession, (String)"statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, (String)"designationMapForLocalClasses");
        super(FirResolvePhase.STATUS);
        this.session = session;
        this.scopeSession = scopeSession;
        this.statusComputationSession = statusComputationSession;
        this.designationMapForLocalClasses = designationMapForLocalClasses;
        this.scopeForLocalClass = scopeForLocalClass;
        this.classes = new ArrayList();
        this.statusResolver = new FirStatusResolver(this.session, this.scopeSession);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    public final StatusComputationSession getStatusComputationSession() {
        return this.statusComputationSession;
    }

    private final boolean isTransformerForLocalDeclarations() {
        return this.scopeForLocalClass != null;
    }

    @NotNull
    public final List<FirClass> getClasses() {
        return this.classes;
    }

    @PrivateForInline
    public static /* synthetic */ void getClasses$annotations() {
    }

    @NotNull
    public final FirStatusResolver getStatusResolver() {
        return this.statusResolver;
    }

    @Nullable
    public final FirClass getContainingClass() {
        return (FirClass)CollectionsKt.lastOrNull(this.classes);
    }

    public static /* synthetic */ void getContainingClass$annotations() {
    }

    protected abstract boolean needResolveMembers(@NotNull FirDeclaration var1);

    protected abstract boolean needResolveNestedClassifiers(@NotNull FirDeclaration var1);

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl2 = false;
            FirDeclaration firDeclaration = this.transformDeclarationContent(file, data);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file.getModuleData().getSession()).handleExceptionOnFileAnalysis(file, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return file;
    }

    @Override
    @NotNull
    public FirDeclarationStatus transformDeclarationStatus(@NotNull FirDeclarationStatus declarationStatus, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)declarationStatus, (String)"declarationStatus");
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = data;
        return firResolvedDeclarationStatus != null ? (FirDeclarationStatus)firResolvedDeclarationStatus : declarationStatus;
    }

    @NotNull
    public final FirDeclaration storeClass(@NotNull FirClass klass, @NotNull Function0<? extends FirDeclaration> computeResult) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(computeResult, (String)"computeResult");
        boolean $i$f$storeClass = false;
        ((Collection)this.getClasses()).add(klass);
        FirDeclaration result2 = (FirDeclaration)computeResult.invoke();
        this.getClasses().remove(CollectionsKt.getLastIndex(this.getClasses()));
        return result2;
    }

    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration2, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirDeclaration firDeclaration;
            boolean bl2 = false;
            if (declaration2 instanceof FirCallableDeclaration) {
                if (declaration2 instanceof FirFunction) {
                    for (FirValueParameter valueParameter2 : ((FirFunction)declaration2).getValueParameters()) {
                        this.transformValueParameter(valueParameter2, data);
                    }
                }
                firDeclaration = declaration2;
            } else {
                firDeclaration = (FirDeclaration)this.transformElement((FirElement)declaration2, data);
            }
            return firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(declaration2, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirDanglingModifierList transformDanglingModifierList(@NotNull FirDanglingModifierList danglingModifierList, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)danglingModifierList, (String)"danglingModifierList");
        return danglingModifierList;
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            Iterable $this$forEach$iv = typeAlias.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl3 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data);
            }
            typeAlias.transformStatus(this, this.statusResolver.resolveStatus(typeAlias, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeAlias, data);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
            return (FirTypeAlias)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(typeAlias, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirResolvedDeclarationStatus data) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            firStatement = this.transformClassContent(regularClass, data);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(regularClass, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firStatement;
    }

    @NotNull
    public abstract FirStatement transformClassContent(@NotNull FirClass var1, @Nullable FirResolvedDeclarationStatus var2);

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable FirResolvedDeclarationStatus data) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            firStatement = this.transformClassContent(anonymousObject, data);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(anonymousObject, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration2, @Nullable FirResolvedDeclarationStatus data) {
        FirDeclaration it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<FirDeclaration> list;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            list = ((FirRegularClass)declaration2).getDeclarations();
        } else if (firDeclaration instanceof FirAnonymousObject) {
            list = ((FirAnonymousObject)declaration2).getDeclarations();
        } else if (firDeclaration instanceof FirFile) {
            list = ((FirFile)declaration2).getDeclarations();
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Unsupported declaration: " + declaration2.getClass();
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl2 = false;
            void $this$transformDeclarationContent_u24lambda_u246 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl3 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$transformDeclarationContent_u24lambda_u246, "declaration", declaration2);
            kotlinExceptionWithAttachments.withAttachment(string, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        List<FirDeclaration> declarations2 = list;
        if (this.needResolveMembers(declaration2)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl4 = false;
                if (it instanceof FirClassLikeDeclaration) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data);
            }
        }
        if (this.needResolveNestedClassifiers(declaration2)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl5 = false;
                if (!(it instanceof FirClassLikeDeclaration)) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data);
            }
        }
        return declaration2;
    }

    @Override
    @NotNull
    public FirStatement transformClass(@NotNull FirClass klass, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            AbstractFirStatusResolveTransformer this_$iv = this;
            boolean $i$f$storeClass = false;
            ((Collection)this_$iv.getClasses()).add(klass);
            boolean bl3 = false;
            Iterable $this$forEach$iv = klass.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl4 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data);
            }
            FirDeclaration result$iv = this.transformDeclarationContent(klass, data);
            this_$iv.getClasses().remove(CollectionsKt.getLastIndex(this_$iv.getClasses()));
            FirDeclaration firDeclaration = result$iv;
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(klass, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    public final void transformValueClassRepresentation(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        if (firClass instanceof FirRegularClass) {
            FirClass $this$isInlineOrValue$iv = firClass;
            boolean $i$f$isInlineOrValue = false;
            if ($this$isInlineOrValue$iv.getStatus().isInline() || $this$isInlineOrValue$iv.getStatus().isValue()) {
                FirValueClassRepresentationKt.setValueClassRepresentation((FirRegularClass)firClass, ValueClassesUtilsKt.computeValueClassRepresentation((FirRegularClass)firClass, this.session));
            }
        }
    }

    public final void transformClassStatus(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        firClass.transformStatus(this, this.statusResolver.resolveStatus(firClass, this.getContainingClass(), false));
    }

    @Override
    @NotNull
    public FirReplSnippet transformReplSnippet(@NotNull FirReplSnippet replSnippet, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)replSnippet, (String)"replSnippet");
        return replSnippet;
    }

    public void forceResolveStatusesOfSupertypes(@NotNull FirClass regularClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        for (FirTypeRef superTypeRef : CollectionsKt.plus((Collection)regularClass.getSuperTypeRefs(), (Iterable)this.additionalSuperTypes(regularClass))) {
            for (FirClassifierSymbol<?> classifierSymbol : this.superTypeToSymbols(superTypeRef)) {
                this.forceResolveStatusOfCorrespondingClass(classifierSymbol);
            }
        }
    }

    @NotNull
    public List<FirTypeRef> additionalSuperTypes(@NotNull FirClass regularClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected Collection<FirClassifierSymbol<?>> superTypeToSymbols(@NotNull FirTypeRef typeRef) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        return CollectionsKt.listOfNotNull(ToSymbolUtilsKt.toSymbol(FirTypeUtilsKt.getConeType(typeRef), this.session));
    }

    private final void forceResolveStatusOfCorrespondingClass(FirClassifierSymbol<?> superClassSymbol) {
        if (this.isTransformerForLocalDeclarations()) {
            if (superClassSymbol instanceof FirClassSymbol) {
                FirLazyDeclarationResolverKt.lazyResolveToPhaseWithCallableMembers((FirClassSymbol)superClassSymbol, FirResolvePhase.STATUS);
            } else {
                FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)superClassSymbol, FirResolvePhase.STATUS);
            }
        } else {
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)superClassSymbol, FirResolvePhase.STATUS.getPrevious());
        }
        FirClassifierSymbol<?> firClassifierSymbol = superClassSymbol;
        if (firClassifierSymbol instanceof FirRegularClassSymbol) {
            this.forceResolveStatusesOfClass((FirRegularClass)((FirRegularClassSymbol)superClassSymbol).getFir());
        } else if (firClassifierSymbol instanceof FirTypeAliasSymbol) {
            for (FirClassifierSymbol<?> classifierSymbol : this.superTypeToSymbols(((FirTypeAlias)((FirTypeAliasSymbol)superClassSymbol).getFir()).getExpandedTypeRef())) {
                this.forceResolveStatusOfCorrespondingClass(classifierSymbol);
            }
        } else if (!(firClassifierSymbol instanceof FirTypeParameterSymbol) && !(firClassifierSymbol instanceof FirAnonymousObjectSymbol)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void forceResolveStatusesOfClass(FirRegularClass regularClass) {
        if (!Intrinsics.areEqual((Object)regularClass.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
            if (!statusComputationStatus.getRequiresComputation()) {
                return;
            }
            this.statusComputationSession.startComputing(regularClass);
            this.forceResolveStatusesOfSupertypes(regularClass);
            this.statusComputationSession.endComputing(regularClass);
            return;
        }
        StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
        if (!statusComputationStatus.getRequiresComputation()) {
            return;
        }
        if (!this.resolveClassForSuperType(regularClass)) {
            return;
        }
        this.statusComputationSession.endComputing(regularClass);
    }

    protected boolean resolveClassForSuperType(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        DesignationState designationState = DesignationState.Companion.create(regularClass.getSymbol(), this.designationMapForLocalClasses, false);
        if (designationState == null) {
            return false;
        }
        DesignationState designation = designationState;
        FirDesignatedStatusResolveTransformer transformer2 = new FirDesignatedStatusResolveTransformer(this.session, this.scopeSession, designation, this.statusComputationSession, this.designationMapForLocalClasses, this.scopeForLocalClass);
        FirTransformerUtilKt.transformSingle((FirElement)designation.getFirstDeclaration(), transformer2, null);
        return true;
    }

    private final void transformPropertyAccessor(FirPropertyAccessor propertyAccessor, FirProperty containingProperty, List<? extends FirResolvedDeclarationStatus> overriddenStatuses) {
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            propertyAccessor.transformStatus(this, this.statusResolver.resolveStatus(propertyAccessor, this.getContainingClass(), containingProperty, false, overriddenStatuses));
            propertyAccessor.transformValueParameters(this, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(propertyAccessor, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    static /* synthetic */ void transformPropertyAccessor$default(AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer, FirPropertyAccessor firPropertyAccessor, FirProperty firProperty, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformPropertyAccessor");
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        abstractFirStatusResolveTransformer.transformPropertyAccessor(firPropertyAccessor, firProperty, list);
    }

    @Override
    @NotNull
    public FirStatement transformConstructor(@NotNull FirConstructor constructor, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            constructor.transformStatus(this, this.statusResolver.resolveStatus(constructor, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)constructor, data);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(constructor, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)errorPrimaryConstructor, (String)"errorPrimaryConstructor");
        return this.transformConstructor((FirConstructor)errorPrimaryConstructor, data);
    }

    @Override
    @NotNull
    public FirStatement transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            List<FirSimpleFunction> overriddenFunctions = this.statusResolver.getOverriddenFunctions(simpleFunction, this.getContainingClass());
            this.transformSimpleFunction(simpleFunction, overriddenFunctions, data);
            return simpleFunction;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(simpleFunction, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull List<? extends FirSimpleFunction> overriddenFunctions, @Nullable FirResolvedDeclarationStatus data) {
        Collection<FirResolvedDeclarationStatus> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        Intrinsics.checkNotNullParameter(overriddenFunctions, (String)"overriddenFunctions");
        Iterable iterable = overriddenFunctions;
        boolean bl2 = false;
        FirClass firClass = this.getContainingClass();
        FirSimpleFunction firSimpleFunction = simpleFunction;
        FirStatusResolver firStatusResolver = this.statusResolver;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirSimpleFunction firSimpleFunction2 = (FirSimpleFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            FirDeclarationStatus firDeclarationStatus = it.getStatus();
            Intrinsics.checkNotNull((Object)firDeclarationStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
            collection.add((FirResolvedDeclarationStatus)firDeclarationStatus);
        }
        collection = (List)destination$iv$iv;
        FirResolvedDeclarationStatus resolvedStatus = firStatusResolver.resolveStatus(firSimpleFunction, firClass, bl2, (List<? extends FirResolvedDeclarationStatus>)collection);
        simpleFunction.transformStatus(this, resolvedStatus);
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)simpleFunction, data);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        FirStatement cfr_ignored_0 = (FirStatement)((Object)firDeclaration);
    }

    public static /* synthetic */ void transformSimpleFunction$default(AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer, FirSimpleFunction firSimpleFunction, List list, FirResolvedDeclarationStatus firResolvedDeclarationStatus, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformSimpleFunction");
        }
        if ((n2 & 4) != 0) {
            firResolvedDeclarationStatus = null;
        }
        abstractFirStatusResolveTransformer.transformSimpleFunction(firSimpleFunction, list, firResolvedDeclarationStatus);
    }

    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property2, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            List<FirProperty> overridden = this.statusResolver.getOverriddenProperties(property2, this.getContainingClass());
            this.transformProperty(property2, overridden);
            return property2;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(property2, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void transformProperty(@NotNull FirProperty property2, @NotNull List<? extends FirProperty> overriddenProperties) {
        block8: {
            FirCallableDeclaration it;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter(overriddenProperties, (String)"overriddenProperties");
            Iterable $this$map$iv = overriddenProperties;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirProperty firProperty = (FirProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirDeclarationStatus firDeclarationStatus = it2.getStatus();
                Intrinsics.checkNotNull((Object)firDeclarationStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                collection.add((FirResolvedDeclarationStatus)firDeclarationStatus);
            }
            List overriddenStatuses = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = overriddenProperties;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirResolvedDeclarationStatus firResolvedDeclarationStatus;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                FirProperty it3 = (FirProperty)element$iv$iv;
                boolean bl4 = false;
                if (it3.getSetter() == null) {
                    firResolvedDeclarationStatus = null;
                } else {
                    FirPropertyAccessor setter2;
                    FirDeclarationStatus firDeclarationStatus = setter2.getStatus();
                    Intrinsics.checkNotNull((Object)firDeclarationStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                    firResolvedDeclarationStatus = (FirResolvedDeclarationStatus)firDeclarationStatus;
                }
                if (firResolvedDeclarationStatus == null) continue;
                FirResolvedDeclarationStatus it$iv$iv = firResolvedDeclarationStatus;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List overriddenSetters = (List)destination$iv$iv2;
            property2.transformStatus(this, this.statusResolver.resolveStatus(property2, this.getContainingClass(), false, (List<? extends FirResolvedDeclarationStatus>)overriddenStatuses));
            FirPropertyAccessor firPropertyAccessor = property2.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl6 = false;
                AbstractFirStatusResolveTransformer.transformPropertyAccessor$default(this, (FirPropertyAccessor)it, property2, null, 4, null);
            }
            FirPropertyAccessor firPropertyAccessor2 = property2.getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl7 = false;
                this.transformPropertyAccessor((FirPropertyAccessor)it, property2, overriddenSetters);
            }
            FirBackingField firBackingField = property2.getBackingField();
            if (firBackingField != null) {
                it = firBackingField;
                boolean bl8 = false;
                ((FirBackingField)it).transformStatus(this, this.statusResolver.resolveStatus(it, this.getContainingClass(), property2, false));
            }
            FirNamedFunctionSymbol firNamedFunctionSymbol = DeclarationAttributesKt.getComponentFunctionSymbol(property2);
            if (firNamedFunctionSymbol == null) break block8;
            FirNamedFunctionSymbol componentFunction = firNamedFunctionSymbol;
            boolean bl9 = false;
            if (Intrinsics.areEqual((Object)((FirSimpleFunction)componentFunction.getFir()).getStatus().getVisibility(), (Object)Visibilities.Unknown.INSTANCE)) {
                FirMemberDeclaration $this$visibility$iv = property2;
                boolean $i$f$getVisibility = false;
                ((FirSimpleFunction)componentFunction.getFir()).replaceStatus(UtilsKt.copy$default(((FirSimpleFunction)componentFunction.getFir()).getStatus(), $this$visibility$iv.getStatus().getVisibility(), null, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0x3FFFFE, null));
            }
        }
    }

    @Override
    @NotNull
    public FirStatement transformField(@NotNull FirField field, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            field.transformStatus(this, this.statusResolver.resolveStatus(field, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)field, data);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirField");
            return (FirField)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(field, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable FirResolvedDeclarationStatus data) {
        FirPropertyAccessor firPropertyAccessor;
        Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
        FirPropertyAccessor it = firPropertyAccessor = propertyAccessor;
        boolean bl2 = false;
        this.transformProperty((FirProperty)it.getPropertySymbol().getFir(), data);
        return firPropertyAccessor;
    }

    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl2 = false;
            enumEntry.transformStatus(this, this.statusResolver.resolveStatus(enumEntry, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)enumEntry, data);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
            return (FirEnumEntry)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(enumEntry, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)valueParameter2, data);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration);
    }

    @Override
    @NotNull
    public FirTypeParameterRef transformTypeParameter(@NotNull FirTypeParameter typeParameter, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeParameter, data);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameter");
        return (FirTypeParameter)firDeclaration;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return block;
    }
}

