/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeResolutionResultOverridesOtherToPreserveCompatibility;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCustomEnumEntriesMigrationQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCustomEnumEntriesMigrationQualifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCustomEnumEntriesMigrationQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCustomEnumEntriesMigrationQualifierChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,27:1\n2746#2,3:28\n*S KotlinDebug\n*F\n+ 1 FirCustomEnumEntriesMigrationQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCustomEnumEntriesMigrationQualifierChecker\n*L\n22#1:28,3\n*E\n"})
public final class FirCustomEnumEntriesMigrationQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirCustomEnumEntriesMigrationQualifierChecker INSTANCE = new FirCustomEnumEntriesMigrationQualifierChecker();

    private FirCustomEnumEntriesMigrationQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedQualifier expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.PrioritizedEnumEntries)) {
                return;
            }
            FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
            if (!Intrinsics.areEqual((Object)(firClassLikeSymbol != null ? firClassLikeSymbol.getName() : null), (Object)StandardNames.ENUM_ENTRIES)) {
                return;
            }
            Iterable $this$none$iv = expression2.getNonFatalDiagnostics();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ConeDiagnostic it = (ConeDiagnostic)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof ConeResolutionResultOverridesOtherToPreserveCompatibility)) continue;
                    bl2 = false;
                    break block6;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getDEPRECATED_ACCESS_TO_ENTRIES_AS_QUALIFIER(), (DiagnosticContext)context2, null, 8, null);
    }
}

