/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "shouldReportOpenFromSource", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "getShouldReportOpenFromSource", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOpenMemberChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOpenMemberChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,52:1\n15#2,11:53\n*S KotlinDebug\n*F\n+ 1 FirOpenMemberChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker\n*L\n33#1:53,11\n*E\n"})
public final class FirOpenMemberChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirOpenMemberChecker INSTANCE = new FirOpenMemberChecker();

    private FirOpenMemberChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (DeclarationUtilsKt.getCanHaveOpenMembers(declaration2)) {
            return;
        }
        org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.processAllDeclaredCallables$default(declaration2.getSymbol(), context2.getSession(), null, arg_0 -> FirOpenMemberChecker.check$lambda$0(declaration2, reporter, context2, arg_0), 2, null);
    }

    private final boolean getShouldReportOpenFromSource(KtSourceElement $this$shouldReportOpenFromSource) {
        KtSourceElementKind ktSourceElementKind = $this$shouldReportOpenFromSource.getKind();
        return Intrinsics.areEqual((Object)ktSourceElementKind, (Object)KtRealSourceElementKind.INSTANCE) || Intrinsics.areEqual((Object)ktSourceElementKind, (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }

    private static final Unit check$lambda$0(FirClass $declaration, DiagnosticReporter $reporter, CheckerContext $context, FirCallableSymbol memberDeclaration) {
        block9: {
            KtSourceElement source;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)memberDeclaration, (String)"memberDeclaration");
                    if (memberDeclaration instanceof FirConstructorSymbol) {
                        return Unit.INSTANCE;
                    }
                    KtSourceElement ktSourceElement = memberDeclaration.getSource();
                    if (ktSourceElement == null) {
                        return Unit.INSTANCE;
                    }
                    source = ktSourceElement;
                    FirCallableSymbol $this$isOpen$iv = memberDeclaration;
                    boolean $i$f$isOpen = false;
                    if (!($this$isOpen$iv.getResolvedStatus().getModality() == Modality.OPEN)) break block7;
                    FirCallableSymbol $this$isOverride$iv = memberDeclaration;
                    boolean $i$f$isOverride = false;
                    if (!$this$isOverride$iv.getRawStatus().isOverride() && $declaration.getClassKind() == ClassKind.ANNOTATION_CLASS) break block8;
                }
                FirBasedSymbol firBasedSymbol = memberDeclaration;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OPEN_KEYWORD");
                if (!FirKeywordUtilsKt.hasModifier(firBasedSymbol, ktModifierKeywordToken) || !INSTANCE.getShouldReportOpenFromSource(source)) break block9;
            }
            if ($declaration.getClassKind() == ClassKind.OBJECT) {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_OBJECT(), (DiagnosticContext)$context, null, 8, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_FINAL_CLASS(), (DiagnosticContext)$context, null, 8, null);
            }
        }
        return Unit.INSTANCE;
    }
}

