/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.types.EnrichedProjectionKind;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u0010\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002JP\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassVarianceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkCallableDeclaration", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkTypeParameters", "typeParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "checkVarianceConflict", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "containingType", "isInAbbreviation", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirClassVarianceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirClassVarianceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassVarianceChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n808#2,11:195\n1563#2:206\n1634#2,3:207\n*S KotlinDebug\n*F\n+ 1 FirClassVarianceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassVarianceChecker\n*L\n33#1:195,11\n33#1:206\n33#1:207,3\n*E\n"})
public final class FirClassVarianceChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirClassVarianceChecker INSTANCE = new FirClassVarianceChecker();

    private FirClassVarianceChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable iterable = declaration2.getTypeParameters();
        FirClassVarianceChecker firClassVarianceChecker = this;
        boolean $i$f$filterIsInstance = false;
        void var6_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirTypeParameter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getSymbol());
        }
        firClassVarianceChecker.checkTypeParameters((List)destination$iv$iv, Variance.OUT_VARIANCE, context2, reporter);
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            FirClassVarianceChecker.checkVarianceConflict$default(this, superTypeRef, Variance.OUT_VARIANCE, context2, reporter, null, 16, null);
        }
        DeclarationUtilsKt.processAllDeclarations$default(declaration2, context2.getSession(), null, arg_0 -> FirClassVarianceChecker.check$lambda$1(context2, reporter, arg_0), 2, null);
    }

    private final void checkCallableDeclaration(FirCallableSymbol<?> member, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement memberSource = member.getSource();
        if (member instanceof FirNamedFunctionSymbol && memberSource != null && !(memberSource.getKind() instanceof KtFakeSourceElementKind)) {
            for (FirValueParameterSymbol param : ((FirNamedFunctionSymbol)member).getValueParameterSymbols()) {
                FirClassVarianceChecker.checkVarianceConflict$default(this, param.getResolvedReturnTypeRef(), Variance.IN_VARIANCE, context2, reporter, null, 16, null);
            }
        }
        Variance returnTypeVariance = member instanceof FirPropertySymbol && ((FirPropertySymbol)member).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        KtSourceElement returnSource = member.getResolvedReturnTypeRef().getSource();
        if (returnSource != null) {
            if (memberSource != null && returnSource.getKind() instanceof KtFakeSourceElementKind && !(memberSource.getKind() instanceof KtFakeSourceElementKind)) {
                returnSource = memberSource;
            }
        } else {
            returnSource = memberSource;
        }
        this.checkVarianceConflict(member.getResolvedReturnTypeRef(), returnTypeVariance, context2, reporter, returnSource);
        FirResolvedTypeRef receiverTypeRef = member.getResolvedReceiverTypeRef();
        if (receiverTypeRef != null) {
            FirClassVarianceChecker.checkVarianceConflict$default(this, receiverTypeRef, Variance.IN_VARIANCE, context2, reporter, null, 16, null);
        }
    }

    private final void checkTypeParameters(List<FirTypeParameterSymbol> typeParameters2, Variance variance2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeParameterSymbol typeParameter : typeParameters2) {
            for (FirResolvedTypeRef bound : typeParameter.getResolvedBounds()) {
                FirClassVarianceChecker.checkVarianceConflict$default(this, bound, variance2, context2, reporter, null, 16, null);
            }
        }
    }

    private final void checkVarianceConflict(FirTypeRef typeRef, Variance variance2, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source) {
        ConeKotlinType expandedType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(typeRef), context2.getSession(), null, 2, null);
        KtSourceElement ktSourceElement = source;
        if (ktSourceElement == null) {
            ktSourceElement = typeRef.getSource();
        }
        FirClassVarianceChecker.checkVarianceConflict$default(this, expandedType, variance2, typeRef, expandedType, context2, reporter, ktSourceElement, false, 128, null);
    }

    static /* synthetic */ void checkVarianceConflict$default(FirClassVarianceChecker firClassVarianceChecker, FirTypeRef firTypeRef, Variance variance2, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            ktSourceElement = null;
        }
        firClassVarianceChecker.checkVarianceConflict(firTypeRef, variance2, checkerContext, diagnosticReporter, ktSourceElement);
    }

    private final void checkVarianceConflict(ConeKotlinType type2, Variance variance2, FirTypeRef typeRef, ConeKotlinType containingType, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source, boolean isInAbbreviation) {
        ConeClassLikeType fullyExpandedType2;
        FirClassLikeSymbol<?> classSymbol;
        if (type2 instanceof ConeTypeParameterType) {
            KtSourceElement resultSource;
            ConeSimpleKotlinType fullyExpandedType3 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeSimpleKotlinType)type2, context2.getSession(), null, 2, null);
            FirTypeParameterSymbol typeParameterSymbol = ((ConeTypeParameterType)type2).getLookupTag().getTypeParameterSymbol();
            KtSourceElement ktSourceElement = source;
            if (ktSourceElement == null) {
                FirTypeRef firTypeRef = typeRef;
                ktSourceElement = firTypeRef != null ? firTypeRef.getSource() : null;
            }
            if ((resultSource = ktSourceElement) != null && !typeParameterSymbol.getVariance().allowsPosition(variance2) && !fullyExpandedType3.getAttributes().contains(CompilerConeAttributes.UnsafeVariance.INSTANCE)) {
                KtDiagnosticFactory4<FirTypeParameterSymbol, Variance, Variance, ConeKotlinType> factory2 = isInAbbreviation ? FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_IN_EXPANDED_TYPE() : FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_ERROR();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultSource, factory2, (Object)typeParameterSymbol, (Object)typeParameterSymbol.getVariance(), (Object)variance2, (Object)containingType, (DiagnosticContext)context2, null, 128, null);
            }
            return;
        }
        if (type2 instanceof ConeClassLikeType && (classSymbol = ToSymbolUtilsKt.toSymbol((fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, context2.getSession(), null, 2, null)).getLookupTag(), context2.getSession())) instanceof FirClassSymbol) {
            List<FirTypeRefSource> typeRefAndSourcesForArguments = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
            ConeTypeProjection[] coneTypeProjectionArray = fullyExpandedType2.getTypeArguments();
            int n2 = coneTypeProjectionArray.length;
            block11: for (int i2 = 0; i2 < n2; ++i2) {
                ConeKotlinType typeArgumentType;
                FirTypeRefSource subTypeRefAndSource;
                Variance variance3;
                Variance variance4;
                int index2 = i2;
                ConeTypeProjection typeArgument = coneTypeProjectionArray[i2];
                Object object = (FirTypeParameterSymbol)CollectionsKt.getOrNull(((FirClassSymbol)classSymbol).getTypeParameterSymbols(), (int)index2);
                if (object == null || (object = object.getVariance()) == null) continue;
                Object paramVariance = object;
                switch (WhenMappings.$EnumSwitchMapping$0[typeArgument.getKind().ordinal()]) {
                    case 1: {
                        variance4 = Variance.IN_VARIANCE;
                        break;
                    }
                    case 2: {
                        variance4 = Variance.OUT_VARIANCE;
                        break;
                    }
                    case 3: {
                        variance4 = Variance.INVARIANT;
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                Variance argVariance = variance4;
                if (ConeTypeProjectionKt.getType(typeArgument) == null) continue;
                switch (WhenMappings.$EnumSwitchMapping$1[EnrichedProjectionKind.Companion.getEffectiveProjectionKind((Variance)((Object)paramVariance), argVariance).ordinal()]) {
                    case 1: {
                        variance3 = variance2;
                        break;
                    }
                    case 2: {
                        variance3 = variance2.opposite();
                        break;
                    }
                    case 3: {
                        variance3 = Variance.INVARIANT;
                        break;
                    }
                    case 4: {
                        variance3 = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Variance newVariance = variance3;
                if (newVariance == null) continue;
                List<FirTypeRefSource> list = typeRefAndSourcesForArguments;
                FirTypeRefSource firTypeRefSource = subTypeRefAndSource = list != null ? (FirTypeRefSource)CollectionsKt.getOrNull(list, (int)index2) : null;
                FirTypeRef firTypeRef = firTypeRefSource != null ? firTypeRefSource.getTypeRef() : null;
                Object object2 = subTypeRefAndSource;
                if (object2 == null || (object2 = ((FirTypeRefSource)object2).getTypeRef()) == null || (object2 = ((FirTypeRef)object2).getSource()) == null) {
                    object2 = source;
                }
                this.checkVarianceConflict(typeArgumentType, newVariance, firTypeRef, containingType, context2, reporter, (KtSourceElement)object2, AbbreviatedTypeAttributeKt.isTypealiasExpansion(type2));
            }
        }
    }

    static /* synthetic */ void checkVarianceConflict$default(FirClassVarianceChecker firClassVarianceChecker, ConeKotlinType coneKotlinType, Variance variance2, FirTypeRef firTypeRef, ConeKotlinType coneKotlinType2, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, boolean bl2, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            ktSourceElement = null;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = false;
        }
        firClassVarianceChecker.checkVarianceConflict(coneKotlinType, variance2, firTypeRef, coneKotlinType2, checkerContext, diagnosticReporter, ktSourceElement, bl2);
    }

    private static final Unit check$lambda$1(CheckerContext $context, DiagnosticReporter $reporter, FirBasedSymbol member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        if (member instanceof FirCallableSymbol) {
            if (Visibilities.INSTANCE.isPrivate(((FirCallableSymbol)member).getResolvedStatus().getVisibility())) {
                return Unit.INSTANCE;
            }
            INSTANCE.checkTypeParameters(((FirCallableSymbol)member).getOwnTypeParameterSymbols(), Variance.IN_VARIANCE, $context, $reporter);
            INSTANCE.checkCallableDeclaration((FirCallableSymbol)member, $context, $reporter);
        }
        if (member instanceof FirClassLikeSymbol) {
            if (Visibilities.INSTANCE.isPrivate(((FirClassLikeSymbol)member).getResolvedStatus().getVisibility())) {
                return Unit.INSTANCE;
            }
            if (!(member instanceof FirClassSymbol)) {
                INSTANCE.checkTypeParameters(((FirClassLikeSymbol)member).getOwnTypeParameterSymbols(), Variance.IN_VARIANCE, $context, $reporter);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EnrichedProjectionKind.values().length];
            try {
                nArray[EnrichedProjectionKind.OUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

