/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LoggingContext;
import org.jetbrains.kotlin.config.phaser.ActionState;
import org.jetbrains.kotlin.config.phaser.BeforeOrAfter;
import org.jetbrains.kotlin.config.phaser.CompilerPhase;
import org.jetbrains.kotlin.config.phaser.PhaseConfig;
import org.jetbrains.kotlin.config.phaser.PhaserState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005B\u0089\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00000\t\u0012$\b\u0002\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00028\u0001`\r0\t\u0012$\b\u0002\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00028\u0002`\r0\t\u00126\b\u0002\u0010\u000f\u001a0\u0012,\u0012*\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0010j\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000`\u00120\t\u0012N\b\u0002\u0010\u0013\u001aH\u0012D\u0012B\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0010j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0014\u0012\u0004\u0012\u00028\u0000`\u00120\t\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010!\u001a\u00028\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010(J\u001d\u0010)\u001a\u00028\u00022\u0006\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010*J-\u0010+\u001a\u00028\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010(J-\u0010,\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010-J5\u0010.\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u00012\u0006\u0010/\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u00100J-\u00101\u001a\u00028\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u00002\u0006\u00102\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010(J0\u00103\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00000\u0014042\u0006\u00105\u001a\u00020\u0016H\u0016J\b\u00106\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR-\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00028\u0001`\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR-\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00028\u0002`\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR<\u0010\u000f\u001a0\u0012,\u0012*\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0010j\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000`\u00120\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\u0013\u001aH\u0012D\u0012B\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0010j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0014\u0012\u0004\u0012\u00028\u0000`\u00120\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/config/phaser/NamedCompilerPhase;", "Context", "Lorg/jetbrains/kotlin/config/LoggingContext;", "Input", "Output", "Lorg/jetbrains/kotlin/config/phaser/CompilerPhase;", "name", "", "prerequisite", "", "preconditions", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/config/phaser/Checker;", "postconditions", "preactions", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/config/phaser/ActionState;", "Lorg/jetbrains/kotlin/config/phaser/Action;", "postactions", "Lkotlin/Pair;", "nlevels", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;I)V", "getName", "()Ljava/lang/String;", "getPrerequisite", "()Ljava/util/Set;", "getPreconditions", "getPostconditions", "getNlevels", "()I", "invoke", "phaseConfig", "Lorg/jetbrains/kotlin/config/phaser/PhaseConfig;", "phaserState", "Lorg/jetbrains/kotlin/config/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/config/phaser/PhaseConfig;Lorg/jetbrains/kotlin/config/phaser/PhaserState;Lorg/jetbrains/kotlin/config/LoggingContext;Ljava/lang/Object;)Ljava/lang/Object;", "phaseBody", "(Lorg/jetbrains/kotlin/config/LoggingContext;Ljava/lang/Object;)Ljava/lang/Object;", "outputIfNotEnabled", "runBefore", "(Lorg/jetbrains/kotlin/config/phaser/PhaseConfig;Lorg/jetbrains/kotlin/config/phaser/PhaserState;Lorg/jetbrains/kotlin/config/LoggingContext;Ljava/lang/Object;)V", "runAfter", "output", "(Lorg/jetbrains/kotlin/config/phaser/PhaseConfig;Lorg/jetbrains/kotlin/config/phaser/PhaserState;Lorg/jetbrains/kotlin/config/LoggingContext;Ljava/lang/Object;Ljava/lang/Object;)V", "runAndProfile", "source", "getNamedSubphases", "", "startDepth", "toString", "config"})
@SourceDebugExtension(value={"SMAP\nCompilerPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerPhase.kt\norg/jetbrains/kotlin/config/phaser/NamedCompilerPhase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CompilerPhase.kt\norg/jetbrains/kotlin/config/phaser/CompilerPhaseKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,153:1\n1563#2:154\n1634#2,3:155\n27#3,4:158\n27#3,4:164\n29#4,2:162\n31#4:168\n*S KotlinDebug\n*F\n+ 1 CompilerPhase.kt\norg/jetbrains/kotlin/config/phaser/NamedCompilerPhase\n*L\n92#1:154\n92#1:155,3\n101#1:158,4\n139#1:164,4\n138#1:162,2\n138#1:168\n*E\n"})
public abstract class NamedCompilerPhase<Context extends LoggingContext, Input, Output>
implements CompilerPhase<Context, Input, Output> {
    @NotNull
    private final String name;
    @NotNull
    private final Set<NamedCompilerPhase<?, ?, ?>> prerequisite;
    @NotNull
    private final Set<Function1<Input, Unit>> preconditions;
    @NotNull
    private final Set<Function1<Output, Unit>> postconditions;
    @NotNull
    private final Set<Function3<ActionState, Input, Context, Unit>> preactions;
    @NotNull
    private final Set<Function3<ActionState, Pair<? extends Input, ? extends Output>, Context, Unit>> postactions;
    private final int nlevels;

    public NamedCompilerPhase(@NotNull String name2, @NotNull Set<? extends NamedCompilerPhase<?, ?, ?>> prerequisite, @NotNull Set<? extends Function1<? super Input, Unit>> preconditions, @NotNull Set<? extends Function1<? super Output, Unit>> postconditions, @NotNull Set<? extends Function3<? super ActionState, ? super Input, ? super Context, Unit>> preactions, @NotNull Set<? extends Function3<? super ActionState, ? super Pair<? extends Input, ? extends Output>, ? super Context, Unit>> postactions, int nlevels) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(prerequisite, (String)"prerequisite");
        Intrinsics.checkNotNullParameter(preconditions, (String)"preconditions");
        Intrinsics.checkNotNullParameter(postconditions, (String)"postconditions");
        Intrinsics.checkNotNullParameter(preactions, (String)"preactions");
        Intrinsics.checkNotNullParameter(postactions, (String)"postactions");
        this.name = name2;
        this.prerequisite = prerequisite;
        this.preconditions = preconditions;
        this.postconditions = postconditions;
        this.preactions = preactions;
        this.postactions = postactions;
        this.nlevels = nlevels;
    }

    public /* synthetic */ NamedCompilerPhase(String string, Set set, Set set2, Set set3, Set set4, Set set5, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n3 & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n3 & 8) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n3 & 0x10) != 0) {
            set4 = SetsKt.emptySet();
        }
        if ((n3 & 0x20) != 0) {
            set5 = SetsKt.emptySet();
        }
        if ((n3 & 0x40) != 0) {
            n2 = 0;
        }
        this(string, set, set2, set3, set4, set5, n2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Set<NamedCompilerPhase<?, ?, ?>> getPrerequisite() {
        return this.prerequisite;
    }

    @NotNull
    public final Set<Function1<Input, Unit>> getPreconditions() {
        return this.preconditions;
    }

    @NotNull
    public final Set<Function1<Output, Unit>> getPostconditions() {
        return this.postconditions;
    }

    protected final int getNlevels() {
        return this.nlevels;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Output invoke(@NotNull PhaseConfig phaseConfig, @NotNull PhaserState phaserState, @NotNull Context context2, Input input) {
        Output Output2;
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter((Object)phaserState, (String)"phaserState");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        if (!phaseConfig.isEnabled(this)) {
            return this.outputIfNotEnabled(phaseConfig, phaserState, context2, input);
        }
        boolean bl2 = phaserState.getAlreadyDone().containsAll((Collection)this.prerequisite);
        if (_Assertions.ENABLED && !bl2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean $i$a$-assert-NamedCompilerPhase$invoke$22 = false;
            Iterable iterable = SetsKt.minus(this.prerequisite, (Iterable)phaserState.getAlreadyDone());
            StringBuilder stringBuilder = new StringBuilder().append("Lowering ").append(this.name).append(": phases ");
            boolean $i$f$map = false;
            void var10_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NamedCompilerPhase namedCompilerPhase = (NamedCompilerPhase)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.name);
            }
            String $i$a$-assert-NamedCompilerPhase$invoke$22 = stringBuilder.append((List)destination$iv$iv).append(" are required, but not satisfied").toString();
            throw new AssertionError((Object)$i$a$-assert-NamedCompilerPhase$invoke$22);
        }
        context2.setInVerbosePhase(phaseConfig.isVerbose(this));
        this.runBefore(phaseConfig, phaserState, context2, input);
        if (phaseConfig.getNeedProfiling()) {
            Output2 = this.runAndProfile(phaseConfig, phaserState, context2, input);
        } else {
            void $this$downlevel$iv;
            PhaserState $i$a$-assert-NamedCompilerPhase$invoke$22 = phaserState;
            int nlevels$iv = this.nlevels;
            boolean $i$f$downlevel = false;
            $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() + nlevels$iv);
            boolean bl4 = false;
            Output result$iv = this.phaseBody(context2, input);
            $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() - nlevels$iv);
            Output2 = result$iv;
        }
        Output output = Output2;
        this.runAfter(phaseConfig, phaserState, context2, input, output);
        context2.setInVerbosePhase(false);
        phaserState.getAlreadyDone().add(this);
        int n2 = phaserState.getPhaseCount();
        phaserState.setPhaseCount(n2 + 1);
        return output;
    }

    public abstract Output phaseBody(@NotNull Context var1, Input var2);

    public abstract Output outputIfNotEnabled(@NotNull PhaseConfig var1, @NotNull PhaserState var2, @NotNull Context var3, Input var4);

    private final void runBefore(PhaseConfig phaseConfig, PhaserState phaserState, Context context2, Input input) {
        ActionState state = new ActionState(phaseConfig, this, phaserState.getPhaseCount(), BeforeOrAfter.BEFORE);
        for (Function3<ActionState, Input, Context, Unit> function3 : this.preactions) {
            function3.invoke((Object)state, input, context2);
        }
        if (phaseConfig.getCheckConditions()) {
            for (Function1 function1 : this.preconditions) {
                function1.invoke(input);
            }
        }
    }

    private final void runAfter(PhaseConfig phaseConfig, PhaserState phaserState, Context context2, Input input, Output output) {
        ActionState state = new ActionState(phaseConfig, this, phaserState.getPhaseCount(), BeforeOrAfter.AFTER);
        for (Function3<ActionState, Pair<? extends Input, ? extends Output>, Context, Unit> function3 : this.postactions) {
            function3.invoke((Object)state, (Object)TuplesKt.to(input, output), context2);
        }
        if (phaseConfig.getCheckConditions()) {
            for (Function1 function1 : this.postconditions) {
                function1.invoke(output);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Output runAndProfile(PhaseConfig phaseConfig, PhaserState phaserState, Context context2, Input source) {
        void $this$downlevel$iv;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        PhaserState phaserState2 = phaserState;
        int nlevels$iv = this.nlevels;
        boolean $i$f$downlevel = false;
        $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() + nlevels$iv);
        Ref.ObjectRef objectRef = result2;
        boolean bl3 = false;
        Output result$iv = this.phaseBody(context2, source);
        $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() - nlevels$iv);
        objectRef.element = result$iv;
        long msec = System.currentTimeMillis() - start$iv;
        System.out.println((Object)(StringsKt.repeat((CharSequence)"\t", (int)phaserState.getDepth()) + this.name + ": " + msec + " msec"));
        return (Output)result2.element;
    }

    @Override
    @NotNull
    public List<Pair<Integer, NamedCompilerPhase<Context, ?, ?>>> getNamedSubphases(int startDepth) {
        return CollectionsKt.listOf((Object)TuplesKt.to((Object)startDepth, (Object)this));
    }

    @NotNull
    public String toString() {
        return "Compiler Phase @" + this.name;
    }
}

