/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAttributesEffectsBuilder {
    private static final Logger LOG = Logger.getInstance(TextAttributesEffectsBuilder.class);
    private static final Map<EffectType, EffectSlot> EFFECT_SLOTS_MAP;
    private final Map<EffectSlot, EffectDescriptor> myEffectsMap = new HashMap<EffectSlot, EffectDescriptor>(EffectSlot.values().length);

    private TextAttributesEffectsBuilder() {
    }

    @NotNull
    public static TextAttributesEffectsBuilder create() {
        return new TextAttributesEffectsBuilder();
    }

    @NotNull
    public static TextAttributesEffectsBuilder create(@NotNull TextAttributes deepestAttributes) {
        if (deepestAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(0);
        }
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = TextAttributesEffectsBuilder.create().coverWith(deepestAttributes);
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(1);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public TextAttributesEffectsBuilder coverWith(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(2);
        }
        attributes.forEachAdditionalEffect(this::coverWith);
        this.coverWith(attributes.getEffectType(), attributes.getEffectColor());
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(3);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public TextAttributesEffectsBuilder slipUnder(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(4);
        }
        this.slipUnder(attributes.getEffectType(), attributes.getEffectColor());
        attributes.forEachAdditionalEffect(this::slipUnder);
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(5);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public TextAttributesEffectsBuilder coverWith(@Nullable EffectType effectType, @Nullable Color effectColor) {
        return this.mutateBuilder(effectType, effectColor, this.myEffectsMap::put);
    }

    @NotNull
    public TextAttributesEffectsBuilder slipUnder(@Nullable EffectType effectType, @Nullable Color effectColor) {
        return this.mutateBuilder(effectType, effectColor, this.myEffectsMap::putIfAbsent);
    }

    @NotNull
    private TextAttributesEffectsBuilder mutateBuilder(@Nullable EffectType effectType, @Nullable Color effectColor, @NotNull BiConsumer<? super EffectSlot, ? super EffectDescriptor> slotMutator) {
        if (slotMutator == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(6);
        }
        if (effectColor != null && effectType != null) {
            EffectSlot slot = EFFECT_SLOTS_MAP.get((Object)effectType);
            if (slot != null) {
                slotMutator.accept(slot, EffectDescriptor.create(effectType, effectColor));
            } else {
                LOG.debug("Effect " + (Object)((Object)effectType) + " is not supported by builder");
            }
        }
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(7);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    Map<EffectType, Color> getEffectsMap() {
        if (this.myEffectsMap.isEmpty()) {
            Map<EffectType, Color> map = Collections.emptyMap();
            if (map == null) {
                TextAttributesEffectsBuilder.$$$reportNull$$$0(8);
            }
            return map;
        }
        HashMap<EffectType, Color> result2 = new HashMap<EffectType, Color>();
        this.myEffectsMap.forEach((key, val) -> {
            if (val != null) {
                result2.put(val.effectType, val.effectColor);
            }
        });
        HashMap<EffectType, Color> hashMap = result2;
        if (hashMap == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    public TextAttributes applyTo(@NotNull TextAttributes targetAttributes) {
        Iterator<EffectDescriptor> effectsIterator;
        if (targetAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(10);
        }
        if (!(effectsIterator = this.myEffectsMap.values().iterator()).hasNext()) {
            targetAttributes.setEffectColor(null);
            targetAttributes.setEffectType(EffectType.BOXED);
            targetAttributes.setAdditionalEffects(Collections.emptyMap());
        } else {
            EffectDescriptor mainEffectDescriptor = effectsIterator.next();
            targetAttributes.setEffectType(mainEffectDescriptor.effectType);
            targetAttributes.setEffectColor(mainEffectDescriptor.effectColor);
            int effectsLeft = this.myEffectsMap.size() - 1;
            if (effectsLeft == 0) {
                targetAttributes.setAdditionalEffects(Collections.emptyMap());
            } else if (effectsLeft == 1) {
                EffectDescriptor additionalEffect = effectsIterator.next();
                targetAttributes.setAdditionalEffects(Collections.singletonMap(additionalEffect.effectType, additionalEffect.effectColor));
            } else {
                EnumMap effectsMap = new EnumMap(EffectType.class);
                effectsIterator.forEachRemaining(descriptor2 -> effectsMap.put(descriptor2.effectType, descriptor2.effectColor));
                targetAttributes.setAdditionalEffects(effectsMap);
            }
        }
        TextAttributes textAttributes = targetAttributes;
        if (textAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(11);
        }
        return textAttributes;
    }

    @Contract(value="null -> null")
    @Nullable
    public EffectDescriptor getEffectDescriptor(@Nullable EffectSlot effectSlot) {
        return this.myEffectsMap.get((Object)effectSlot);
    }

    static {
        HashMap<EffectType, EffectSlot> map = new HashMap<EffectType, EffectSlot>();
        map.put(EffectType.STRIKEOUT, EffectSlot.STRIKE_SLOT);
        map.put(EffectType.BOXED, EffectSlot.FRAME_SLOT);
        map.put(EffectType.ROUNDED_BOX, EffectSlot.FRAME_SLOT);
        map.put(EffectType.SLIGHTLY_WIDER_BOX, EffectSlot.FRAME_SLOT);
        map.put(EffectType.BOLD_LINE_UNDERSCORE, EffectSlot.UNDERLINE_SLOT);
        map.put(EffectType.LINE_UNDERSCORE, EffectSlot.UNDERLINE_SLOT);
        map.put(EffectType.WAVE_UNDERSCORE, EffectSlot.UNDERLINE_SLOT);
        map.put(EffectType.BOLD_DOTTED_LINE, EffectSlot.UNDERLINE_SLOT);
        EFFECT_SLOTS_MAP = Collections.unmodifiableMap(map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepestAttributes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slotMutator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetAttributes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "coverWith";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "slipUnder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mutateBuilder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectsMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "coverWith";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "slipUnder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mutateBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum EffectSlot {
        FRAME_SLOT,
        UNDERLINE_SLOT,
        STRIKE_SLOT;

    }

    public static final class EffectDescriptor {
        @NotNull
        public final EffectType effectType;
        @NotNull
        public final Color effectColor;

        private EffectDescriptor(@NotNull EffectType effectType, @NotNull Color effectColor) {
            if (effectType == null) {
                EffectDescriptor.$$$reportNull$$$0(0);
            }
            if (effectColor == null) {
                EffectDescriptor.$$$reportNull$$$0(1);
            }
            this.effectType = effectType;
            this.effectColor = effectColor;
        }

        @NotNull
        static EffectDescriptor create(@NotNull EffectType effectType, @NotNull Color effectColor) {
            if (effectType == null) {
                EffectDescriptor.$$$reportNull$$$0(2);
            }
            if (effectColor == null) {
                EffectDescriptor.$$$reportNull$$$0(3);
            }
            return new EffectDescriptor(effectType, effectColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectColor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder$EffectDescriptor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

