/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    private static boolean ourMirrorToStderr = true;
    private final String myCategory;
    private LogLevel myLevel = LogLevel.WARNING;

    public DefaultLogger(String category) {
        this.myCategory = category;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.myLevel.compareTo(LogLevel.DEBUG) >= 0;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.myLevel.compareTo(LogLevel.TRACE) >= 0;
    }

    @Override
    public void trace(String message) {
        if (this.isTraceEnabled()) {
            System.out.println("TRACE[" + this.myCategory + "]: " + message);
        }
    }

    @Override
    public void trace(@Nullable Throwable t2) {
        if (t2 != null && this.isTraceEnabled()) {
            System.out.print("TRACE[" + this.myCategory + "]: ");
            t2.printStackTrace(System.out);
        }
    }

    @Override
    public void debug(String message, @Nullable Throwable t2) {
        if (this.isDebugEnabled()) {
            System.out.println("DEBUG[" + this.myCategory + "]: " + message);
            if (t2 != null) {
                t2.printStackTrace(System.out);
            }
        }
    }

    @Override
    public void info(String message, Throwable t2) {
        if (this.myLevel.compareTo(LogLevel.INFO) >= 0) {
            System.out.println("INFO[" + this.myCategory + "]: " + message);
            if (t2 != null) {
                t2.printStackTrace(System.out);
            }
        }
    }

    @Override
    public void warn(String message, @Nullable Throwable t2) {
        t2 = DefaultLogger.ensureNotControlFlow(t2);
        System.err.println("WARN: " + message);
        if (t2 != null) {
            t2.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message, @Nullable Throwable t2, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(0);
        }
        t2 = DefaultLogger.ensureNotControlFlow(t2);
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message + DefaultLogger.detailsToString(details) + DefaultLogger.attachmentsToString(t2));
            if (t2 != null) {
                t2.printStackTrace(System.err);
            }
        }
        throw new AssertionError(message, t2);
    }

    @Override
    public void setLevel(@NotNull Level level) {
        if (level == null) {
            DefaultLogger.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void setLevel(@NotNull LogLevel level) {
        if (level == null) {
            DefaultLogger.$$$reportNull$$$0(2);
        }
        this.myLevel = level;
    }

    @NotNull
    public static String detailsToString(String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(3);
        }
        return details.length > 0 ? "\nDetails:\n" + String.join((CharSequence)"\n", details) : "";
    }

    @NotNull
    public static String attachmentsToString(@Nullable Throwable t2) {
        if (t2 != null) {
            String prefix = "\n\nAttachments:\n";
            String attachments = ExceptionUtil.findCauseAndSuppressed(t2, ExceptionWithAttachments.class).stream().flatMap(e2 -> Stream.of(e2.getAttachments())).map(ATTACHMENT_TO_STRING).collect(Collectors.joining("\n----\n", prefix, ""));
            if (!attachments.equals(prefix)) {
                String string = attachments;
                if (string == null) {
                    DefaultLogger.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        return "";
    }

    public static boolean shouldDumpExceptionToStderr() {
        return ourMirrorToStderr;
    }

    public static void disableStderrDumping(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DefaultLogger.$$$reportNull$$$0(5);
        }
        boolean prev = ourMirrorToStderr;
        ourMirrorToStderr = false;
        Disposer.register(parentDisposable, () -> {
            ourMirrorToStderr = prev;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "attachmentsToString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detailsToString";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disableStderrDumping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

