/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\u000f\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J\"\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0011J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "<init>", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "resolveAnnotationsOnFiles", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "scopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "checkRedeclarations", "reportRedeclarationsWithClassifiers", "descriptorMap", "Lcom/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkRedeclarationsInPackages", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "topLevelFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getTopLevelDescriptorsByFqName", "", "fqName", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "frontend"})
@SourceDebugExtension(value={"SMAP\nDeclarationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationResolver.kt\norg/jetbrains/kotlin/resolve/DeclarationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 diagnosticUtils.kt\norg/jetbrains/kotlin/diagnostics/DiagnosticUtilsKt\n*L\n1#1,112:1\n1761#2,3:113\n3307#2,10:120\n163#3,4:116\n*S KotlinDebug\n*F\n+ 1 DeclarationResolver.kt\norg/jetbrains/kotlin/resolve/DeclarationResolver\n*L\n69#1:113,3\n87#1:120,10\n71#1:116,4\n*E\n"})
public final class DeclarationResolver {
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final BindingTrace trace;

    public DeclarationResolver(@NotNull AnnotationResolver annotationResolver, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.annotationResolver = annotationResolver;
        this.trace = trace;
    }

    public final void resolveAnnotationsOnFiles(@NotNull TopDownAnalysisContext c2, @NotNull FileScopeProvider scopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        Intrinsics.checkNotNullParameter((Object)scopeProvider2, (String)"scopeProvider");
        Collection<KtFile> collection = c2.getFiles();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getFiles(...)");
        Map filesToScope = CollectionsKt.keysToMap((Iterable)collection, arg_0 -> DeclarationResolver.resolveAnnotationsOnFiles$lambda$0(scopeProvider2, arg_0));
        for (Map.Entry entry : filesToScope.entrySet()) {
            KtFile file2 = (KtFile)entry.getKey();
            LexicalScope fileScope = (LexicalScope)entry.getValue();
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file2.getAnnotationEntries(), this.trace);
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file2.getDanglingAnnotations(), this.trace);
        }
    }

    public final void checkRedeclarations(@NotNull TopDownAnalysisContext c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        for (ClassDescriptorWithResolutionScopes classDescriptor : c2.getDeclaredClasses().values()) {
            HashMultimap descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor.getUnsubstitutedMemberScope(), null, null, 3, null)) {
                if (!(desc instanceof ClassifierDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(((DeclarationDescriptorNonRoot)desc).getName(), desc);
            }
            Intrinsics.checkNotNull(descriptorMap);
            this.reportRedeclarationsWithClassifiers(descriptorMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRedeclarationsWithClassifiers(Multimap<Name, DeclarationDescriptor> descriptorMap) {
        for (Name name2 : descriptorMap.keySet()) {
            boolean bl2;
            Collection<DeclarationDescriptor> descriptors;
            block5: {
                descriptors = descriptorMap.get(name2);
                if (descriptors.size() <= 1) continue;
                Intrinsics.checkNotNull(descriptors);
                Iterable $this$any$iv = descriptors;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof ClassifierDescriptor)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            for (DeclarationDescriptor descriptor2 : descriptors) {
                void it;
                void trace$iv;
                PsiElement psiElement$iv;
                BindingTrace bindingTrace = this.trace;
                Intrinsics.checkNotNull((Object)descriptor2);
                DeclarationDescriptor descriptor$iv = descriptor2;
                boolean $i$f$reportOnDeclaration = false;
                if (DescriptorToSourceUtils.descriptorToDeclaration(descriptor$iv) == null) continue;
                boolean bl4 = false;
                PsiElement psiElement = psiElement$iv;
                void var14_17 = trace$iv;
                boolean bl5 = false;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on((PsiElement)it, descriptors);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                var14_17.report(parametrizedDiagnostic);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkRedeclarationsInPackages(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull Multimap<FqName, KtElement> topLevelFqNames) {
        Intrinsics.checkNotNullParameter((Object)topLevelDescriptorProvider, (String)"topLevelDescriptorProvider");
        Intrinsics.checkNotNullParameter(topLevelFqNames, (String)"topLevelFqNames");
        Map<FqName, Collection<KtElement>> map = topLevelFqNames.asMap();
        Intrinsics.checkNotNullExpressionValue(map, (String)"asMap(...)");
        for (Map.Entry<FqName, Collection<KtElement>> entry : map.entrySet()) {
            void $this$partition$iv;
            FqName fqName = entry.getKey();
            Collection<KtElement> declarationsOrPackageDirectives = entry.getValue();
            if (fqName.isRoot()) continue;
            Intrinsics.checkNotNull((Object)fqName);
            Iterable iterable = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Object[] second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl2 = false;
                boolean bl3 = it instanceof MemberDescriptor && ((MemberDescriptor)it).isExpect() ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List expected = (List)pair.component1();
            List actual = (List)pair.component2();
            second$iv = new List[]{expected, actual};
            for (List descriptors : kotlin.collections.CollectionsKt.listOf((Object[])second$iv)) {
                if (descriptors.size() <= 1) continue;
                for (KtElement directive : declarationsOrPackageDirectives) {
                    PsiElement psiElement = directive instanceof KtPackageDirective ? (KtPackageDirective)directive : null;
                    if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                        psiElement = directive;
                    }
                    PsiElement reportAt = psiElement;
                    this.trace.report(Errors.PACKAGE_OR_CLASSIFIER_REDECLARATION.on(reportAt, fqName.shortName().asString()));
                }
            }
        }
    }

    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(TopLevelDescriptorProvider topLevelDescriptorProvider, FqName fqName, LookupLocation location2) {
        HashSet<ClassifierDescriptor> descriptors = new HashSet<ClassifierDescriptor>();
        CollectionsKt.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassifierDescriptors(fqName, location2));
        return descriptors;
    }

    private static final LexicalScope resolveAnnotationsOnFiles$lambda$0(FileScopeProvider $scopeProvider, KtFile it) {
        Intrinsics.checkNotNull((Object)it);
        return $scopeProvider.getFileResolutionScope(it);
    }
}

