/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeChecker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/type/IrTypeParameterScopeChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/type/IrTypeChecker;", "<init>", "()V", "check", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "container", "Lorg/jetbrains/kotlin/ir/IrElement;", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "checkTypeParameterReference", "element", "typeParameterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "ir.backend.common"})
public final class IrTypeParameterScopeChecker
implements IrTypeChecker {
    @NotNull
    public static final IrTypeParameterScopeChecker INSTANCE = new IrTypeParameterScopeChecker();

    private IrTypeParameterScopeChecker() {
    }

    @Override
    public void check(@NotNull IrType type2, @NotNull IrElement container, @NotNull CheckerContext context2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            IrSimpleType irSimpleType = type2 instanceof IrSimpleType ? (IrSimpleType)type2 : null;
            IrClassifierSymbol irClassifierSymbol = irSimpleType != null ? irSimpleType.getClassifier() : null;
            IrTypeParameterSymbol irTypeParameterSymbol = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
            if (irTypeParameterSymbol == null) break block0;
            IrTypeParameterSymbol it = irTypeParameterSymbol;
            boolean bl2 = false;
            INSTANCE.checkTypeParameterReference(context2, container, it);
        }
    }

    private final void checkTypeParameterReference(CheckerContext context2, IrElement element2, IrTypeParameterSymbol typeParameterSymbol) {
        if (!context2.getTypeParameterScopeStack().isVisibleInCurrentScope(typeParameterSymbol)) {
            context2.error(element2, "The following element references a type parameter '" + RenderIrElementKt.render$default(typeParameterSymbol.getOwner(), null, 1, null) + "' that is not available in the current scope.");
        }
    }
}

