/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.pagecache.PagedStorage;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class InputStreamOverPagedStorage
extends InputStream {
    @NotNull
    private final PagedStorage pagedStorage;
    private final long limit;
    private long position;

    /*
     * WARNING - void declaration
     */
    public InputStreamOverPagedStorage(@NotNull PagedStorage pagedStorage, long position, long l2) {
        void limit;
        if (pagedStorage == null) {
            InputStreamOverPagedStorage.$$$reportNull$$$0(0);
        }
        void totalBytes = limit - position;
        if (totalBytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("limit(=" + (long)limit + ")-position(=" + position + ") = " + (long)totalBytes + " > MAX_INT");
        }
        long storageLength = pagedStorage.length();
        if (limit > storageLength) {
            throw new IllegalArgumentException("limit(=" + (long)limit + ") > storage.length(=" + storageLength + ")");
        }
        this.pagedStorage = pagedStorage;
        this.position = position;
        this.limit = limit;
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return (int)(this.limit - this.position);
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.limit) {
            byte b2 = this.pagedStorage.get(this.position);
            ++this.position;
            return b2 & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte @NotNull [] buffer, int offset, int length) throws IOException {
        if (buffer == null) {
            InputStreamOverPagedStorage.$$$reportNull$$$0(1);
        }
        if (length == 0) {
            return 0;
        }
        int bytesRemains = this.available();
        assert (bytesRemains >= 0) : "position(=" + this.position + ") > limit(=" + this.limit + ")";
        if (bytesRemains == 0) {
            return -1;
        }
        if (length > bytesRemains) {
            length = bytesRemains;
        }
        this.pagedStorage.get(this.position, buffer, offset, length);
        this.position += (long)length;
        return length;
    }

    @Override
    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.position += amountSkipped;
        return amountSkipped;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pagedStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/InputStreamOverPagedStorage";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

