/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.AbstractKotlinParsing;
import org.jetbrains.kotlin.parsing.AbstractTokenStreamPattern;
import org.jetbrains.kotlin.parsing.AbstractTokenStreamPredicate;
import org.jetbrains.kotlin.parsing.BindFirstShebangWithWhitespaceOnly;
import org.jetbrains.kotlin.parsing.Consumer;
import org.jetbrains.kotlin.parsing.DoNotBindAnything;
import org.jetbrains.kotlin.parsing.FirstBefore;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.parsing.KotlinWhitespaceAndCommentsBindersKt;
import org.jetbrains.kotlin.parsing.LastBefore;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilderForByClause;
import org.jetbrains.kotlin.parsing.TrailingCommentsBinder;

public class KotlinParsing
extends AbstractKotlinParsing {
    private static final TokenSet GT_COMMA_COLON_SET = TokenSet.create(KtTokens.GT, KtTokens.COMMA, KtTokens.COLON);
    private static final Logger LOG = Logger.getInstance(KotlinParsing.class);
    private static final TokenSet TOP_LEVEL_DECLARATION_FIRST = TokenSet.create(KtTokens.TYPE_ALIAS_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.PACKAGE_KEYWORD);
    private static final TokenSet TOP_LEVEL_DECLARATION_FIRST_SEMICOLON_SET = TokenSet.orSet(TOP_LEVEL_DECLARATION_FIRST, TokenSet.create(KtTokens.SEMICOLON));
    private static final TokenSet LT_EQ_SEMICOLON_TOP_LEVEL_DECLARATION_FIRST_SET = TokenSet.orSet(TokenSet.create(KtTokens.LT, KtTokens.EQ, KtTokens.SEMICOLON), TOP_LEVEL_DECLARATION_FIRST);
    private static final TokenSet DECLARATION_FIRST = TokenSet.orSet(TOP_LEVEL_DECLARATION_FIRST, TokenSet.create(KtTokens.INIT_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD, KtTokens.CONSTRUCTOR_KEYWORD));
    private static final TokenSet CLASS_NAME_RECOVERY_SET = TokenSet.orSet(TokenSet.create(KtTokens.LT, KtTokens.LPAR, KtTokens.COLON, KtTokens.LBRACE), TOP_LEVEL_DECLARATION_FIRST);
    private static final TokenSet TYPE_PARAMETER_GT_RECOVERY_SET = TokenSet.create(KtTokens.WHERE_KEYWORD, KtTokens.LPAR, KtTokens.COLON, KtTokens.LBRACE, KtTokens.GT);
    public static final TokenSet PARAMETER_NAME_RECOVERY_SET = TokenSet.create(KtTokens.COLON, KtTokens.EQ, KtTokens.COMMA, KtTokens.RPAR, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD);
    private static final TokenSet PACKAGE_NAME_RECOVERY_SET = TokenSet.create(KtTokens.DOT, KtTokens.EOL_OR_SEMICOLON);
    private static final TokenSet IMPORT_RECOVERY_SET = TokenSet.create(KtTokens.AS_KEYWORD, KtTokens.DOT, KtTokens.EOL_OR_SEMICOLON);
    private static final TokenSet TYPE_REF_FIRST = TokenSet.create(KtTokens.LBRACKET, KtTokens.IDENTIFIER, KtTokens.LPAR, KtTokens.HASH, KtTokens.DYNAMIC_KEYWORD);
    private static final TokenSet LBRACE_RBRACE_TYPE_REF_FIRST_SET = TokenSet.orSet(TokenSet.create(KtTokens.LBRACE, KtTokens.RBRACE), TYPE_REF_FIRST);
    private static final TokenSet COLON_COMMA_LBRACE_RBRACE_TYPE_REF_FIRST_SET = TokenSet.orSet(TokenSet.create(KtTokens.COLON, KtTokens.COMMA, KtTokens.LBRACE, KtTokens.RBRACE), TYPE_REF_FIRST);
    private static final TokenSet RECEIVER_TYPE_TERMINATORS = TokenSet.create(KtTokens.DOT, KtTokens.SAFE_ACCESS);
    private static final TokenSet VALUE_PARAMETER_FIRST = TokenSet.orSet(TokenSet.create(KtTokens.IDENTIFIER, KtTokens.LBRACKET, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD), TokenSet.andNot(KtTokens.MODIFIER_KEYWORDS, TokenSet.create(KtTokens.FUN_KEYWORD)));
    private static final TokenSet LAMBDA_VALUE_PARAMETER_FIRST = TokenSet.orSet(TokenSet.create(KtTokens.IDENTIFIER, KtTokens.LBRACKET), TokenSet.andNot(KtTokens.MODIFIER_KEYWORDS, TokenSet.create(KtTokens.FUN_KEYWORD)));
    private static final TokenSet SOFT_KEYWORDS_AT_MEMBER_START = TokenSet.create(KtTokens.CONSTRUCTOR_KEYWORD, KtTokens.INIT_KEYWORD);
    private static final TokenSet ANNOTATION_TARGETS = TokenSet.create(KtTokens.ALL_KEYWORD, KtTokens.FILE_KEYWORD, KtTokens.FIELD_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD, KtTokens.PROPERTY_KEYWORD, KtTokens.RECEIVER_KEYWORD, KtTokens.PARAM_KEYWORD, KtTokens.SETPARAM_KEYWORD, KtTokens.DELEGATE_KEYWORD);
    private static final TokenSet BLOCK_DOC_COMMENT_SET = TokenSet.create(KtTokens.BLOCK_COMMENT, KtTokens.DOC_COMMENT);
    private static final TokenSet SEMICOLON_SET = TokenSet.create(KtTokens.SEMICOLON);
    private static final TokenSet COMMA_COLON_GT_SET = TokenSet.create(KtTokens.COMMA, KtTokens.COLON, KtTokens.GT);
    private static final TokenSet IDENTIFIER_RBRACKET_LBRACKET_SET = TokenSet.create(KtTokens.IDENTIFIER, KtTokens.RBRACKET, KtTokens.LBRACKET);
    private static final TokenSet LBRACE_RBRACE_SET = TokenSet.create(KtTokens.LBRACE, KtTokens.RBRACE);
    private static final TokenSet COMMA_SEMICOLON_RBRACE_SET = TokenSet.create(KtTokens.COMMA, KtTokens.SEMICOLON, KtTokens.RBRACE);
    private static final TokenSet VALUE_ARGS_RECOVERY_SET = TokenSet.create(KtTokens.LBRACE, KtTokens.SEMICOLON, KtTokens.RPAR, KtTokens.EOL_OR_SEMICOLON, KtTokens.RBRACE);
    private static final TokenSet PROPERTY_NAME_FOLLOW_SET = TokenSet.create(KtTokens.COLON, KtTokens.EQ, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.SEMICOLON, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.CLASS_KEYWORD);
    private static final TokenSet PROPERTY_NAME_FOLLOW_MULTI_DECLARATION_RECOVERY_SET = TokenSet.orSet(PROPERTY_NAME_FOLLOW_SET, PARAMETER_NAME_RECOVERY_SET);
    private static final TokenSet PROPERTY_NAME_FOLLOW_FUNCTION_OR_PROPERTY_RECOVERY_SET = TokenSet.orSet(PROPERTY_NAME_FOLLOW_SET, LBRACE_RBRACE_SET, TOP_LEVEL_DECLARATION_FIRST);
    private static final TokenSet IDENTIFIER_EQ_COLON_SEMICOLON_SET = TokenSet.create(KtTokens.IDENTIFIER, KtTokens.EQ, KtTokens.COLON, KtTokens.SEMICOLON);
    private static final TokenSet COMMA_RPAR_COLON_EQ_SET = TokenSet.create(KtTokens.COMMA, KtTokens.RPAR, KtTokens.COLON, KtTokens.EQ);
    private static final TokenSet ACCESSOR_FIRST_OR_PROPERTY_END = TokenSet.orSet(KtTokens.MODIFIER_KEYWORDS, TokenSet.create(KtTokens.AT, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD, KtTokens.FIELD_KEYWORD, KtTokens.EOL_OR_SEMICOLON, KtTokens.RBRACE));
    private static final TokenSet RPAR_IDENTIFIER_COLON_LBRACE_EQ_SET = TokenSet.create(KtTokens.RPAR, KtTokens.IDENTIFIER, KtTokens.COLON, KtTokens.LBRACE, KtTokens.EQ);
    private static final TokenSet COMMA_COLON_RPAR_SET = TokenSet.create(KtTokens.COMMA, KtTokens.COLON, KtTokens.RPAR);
    private static final TokenSet RPAR_COLON_LBRACE_EQ_SET = TokenSet.create(KtTokens.RPAR, KtTokens.COLON, KtTokens.LBRACE, KtTokens.EQ);
    private static final TokenSet LBRACKET_LBRACE_RBRACE_LPAR_SET = TokenSet.create(KtTokens.LBRACKET, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.LPAR);
    private static final TokenSet FUNCTION_NAME_FOLLOW_SET = TokenSet.create(KtTokens.LT, KtTokens.LPAR, KtTokens.RPAR, KtTokens.COLON, KtTokens.EQ);
    private static final TokenSet FUNCTION_NAME_RECOVERY_SET = TokenSet.orSet(TokenSet.create(KtTokens.LT, KtTokens.LPAR, KtTokens.RPAR, KtTokens.COLON, KtTokens.EQ), LBRACE_RBRACE_SET, TOP_LEVEL_DECLARATION_FIRST);
    private static final TokenSet VALUE_PARAMETERS_FOLLOW_SET = TokenSet.create(KtTokens.EQ, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.SEMICOLON, KtTokens.RPAR);
    private static final TokenSet LPAR_VALUE_PARAMETERS_FOLLOW_SET = TokenSet.orSet(TokenSet.create(KtTokens.LPAR), VALUE_PARAMETERS_FOLLOW_SET);
    private static final TokenSet LPAR_LBRACE_COLON_CONSTRUCTOR_KEYWORD_SET = TokenSet.create(KtTokens.LPAR, KtTokens.LBRACE, KtTokens.COLON, KtTokens.CONSTRUCTOR_KEYWORD);
    private static final TokenSet definitelyOutOfReceiverSet = TokenSet.orSet(TokenSet.create(KtTokens.EQ, KtTokens.COLON, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.BY_KEYWORD), TOP_LEVEL_DECLARATION_FIRST);
    private static final TokenSet EOL_OR_SEMICOLON_RBRACE_SET = TokenSet.create(KtTokens.EOL_OR_SEMICOLON, KtTokens.RBRACE);
    private static final TokenSet CLASS_INTERFACE_SET = TokenSet.create(KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD);
    private final KotlinExpressionParsing myExpressionParsing;
    private final FirstBefore lastDotAfterReceiverLParPattern = new FirstBefore(new AbstractKotlinParsing.AtSet(RECEIVER_TYPE_TERMINATORS), new AbstractTokenStreamPredicate(){

        @Override
        public boolean matching(boolean topLevel) {
            if (topLevel && KotlinParsing.this.atSet(definitelyOutOfReceiverSet)) {
                return true;
            }
            return topLevel && !KotlinParsing.this.at(KtTokens.QUEST) && !KotlinParsing.this.at(KtTokens.LPAR) && !KotlinParsing.this.at(KtTokens.RPAR);
        }
    });
    private final LastBefore lastDotAfterReceiverNotLParPattern = new LastBefore(new AbstractKotlinParsing.AtSet(RECEIVER_TYPE_TERMINATORS), new AbstractTokenStreamPredicate(){

        @Override
        public boolean matching(boolean topLevel) {
            if (topLevel && (KotlinParsing.this.atSet(definitelyOutOfReceiverSet) || KotlinParsing.this.at(KtTokens.LPAR))) {
                return true;
            }
            if (topLevel && KotlinParsing.this.at(KtTokens.IDENTIFIER)) {
                IElementType lookahead = KotlinParsing.this.lookahead(1);
                return lookahead != KtTokens.LT && lookahead != KtTokens.DOT && lookahead != KtTokens.SAFE_ACCESS && lookahead != KtTokens.QUEST;
            }
            return false;
        }
    });
    private static final TokenSet NO_MODIFIER_BEFORE_FOR_VALUE_PARAMETER = TokenSet.create(KtTokens.COMMA, KtTokens.COLON, KtTokens.EQ, KtTokens.RPAR);

    static KotlinParsing createForTopLevel(SemanticWhitespaceAwarePsiBuilder builder2) {
        return new KotlinParsing(builder2, true, true);
    }

    static KotlinParsing createForTopLevelNonLazy(SemanticWhitespaceAwarePsiBuilder builder2) {
        return new KotlinParsing(builder2, true, false);
    }

    private static KotlinParsing createForByClause(SemanticWhitespaceAwarePsiBuilder builder2, boolean isLazy) {
        return new KotlinParsing(new SemanticWhitespaceAwarePsiBuilderForByClause(builder2), false, isLazy);
    }

    private KotlinParsing(final SemanticWhitespaceAwarePsiBuilder builder2, boolean isTopLevel, boolean isLazy) {
        super(builder2, isLazy);
        this.myExpressionParsing = isTopLevel ? new KotlinExpressionParsing(builder2, this, isLazy) : new KotlinExpressionParsing(builder2, this, isLazy){

            @Override
            protected boolean parseCallWithClosure() {
                if (((SemanticWhitespaceAwarePsiBuilderForByClause)builder2).getStackSize() > 0) {
                    return super.parseCallWithClosure();
                }
                return false;
            }

            @Override
            protected KotlinParsing create(SemanticWhitespaceAwarePsiBuilder builder22) {
                return KotlinParsing.createForByClause(builder22, this.isLazy);
            }
        };
    }

    void parseFile() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        while (!this.eof()) {
            this.parseTopLevelDeclaration();
        }
        this.checkUnclosedBlockComment();
        fileMarker.done(KtNodeTypes.KT_FILE);
    }

    private void checkUnclosedBlockComment() {
        if (BLOCK_DOC_COMMENT_SET.contains(this.myBuilder.rawLookup(-1))) {
            int startOffset = this.myBuilder.rawTokenTypeStart(-1);
            int endOffset = this.myBuilder.rawTokenTypeStart(0);
            CharSequence tokenChars = this.myBuilder.getOriginalText().subSequence(startOffset, endOffset);
            if (tokenChars.length() <= 2 || !tokenChars.subSequence(tokenChars.length() - 2, tokenChars.length()).toString().equals("*/")) {
                PsiBuilder.Marker marker = this.myBuilder.mark();
                marker.error("Unclosed comment");
                marker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_RIGHT_BINDER, null);
            }
        }
    }

    void parseTypeCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        this.parseTypeRef();
        this.checkForUnexpectedSymbols();
        marker.done(KtNodeTypes.TYPE_CODE_FRAGMENT);
    }

    void parseExpressionCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        this.myExpressionParsing.parseExpression();
        this.checkForUnexpectedSymbols();
        marker.done(KtNodeTypes.EXPRESSION_CODE_FRAGMENT);
    }

    void parseBlockCodeFragment() {
        PsiBuilder.Marker marker = this.mark();
        PsiBuilder.Marker blockMarker = this.mark();
        if (this.at(KtTokens.PACKAGE_KEYWORD) || this.at(KtTokens.IMPORT_KEYWORD)) {
            PsiBuilder.Marker err = this.mark();
            this.parsePreamble();
            err.error("Package directive and imports are forbidden in code fragments");
        }
        this.myExpressionParsing.parseStatements();
        this.checkForUnexpectedSymbols();
        blockMarker.done(KtNodeTypes.BLOCK);
        marker.done(KtNodeTypes.BLOCK_CODE_FRAGMENT);
    }

    void parseLambdaExpression() {
        this.myExpressionParsing.parseFunctionLiteral(false, false);
    }

    void parseBlockExpression() {
        this.parseBlock(false);
    }

    void parseScript() {
        PsiBuilder.Marker fileMarker = this.mark();
        this.parsePreamble();
        PsiBuilder.Marker scriptMarker = this.mark();
        PsiBuilder.Marker blockMarker = this.mark();
        this.myExpressionParsing.parseStatements(true);
        this.checkForUnexpectedSymbols();
        blockMarker.done(KtNodeTypes.BLOCK);
        blockMarker.setCustomEdgeTokenBinders(KotlinWhitespaceAndCommentsBindersKt.PRECEDING_ALL_BINDER, KotlinWhitespaceAndCommentsBindersKt.TRAILING_ALL_BINDER);
        scriptMarker.done(KtNodeTypes.SCRIPT);
        scriptMarker.setCustomEdgeTokenBinders(KotlinWhitespaceAndCommentsBindersKt.PRECEDING_ALL_BINDER, KotlinWhitespaceAndCommentsBindersKt.TRAILING_ALL_BINDER);
        fileMarker.done(KtNodeTypes.KT_FILE);
    }

    private void checkForUnexpectedSymbols() {
        while (!this.eof()) {
            this.errorAndAdvance("Unexpected symbol");
        }
    }

    private void parsePreamble() {
        PsiBuilder.Marker firstEntry = this.mark();
        this.parseFileAnnotationList(AnnotationParsingMode.FILE_ANNOTATIONS_BEFORE_PACKAGE);
        PsiBuilder.Marker packageDirective = this.mark();
        this.parseModifierList(TokenSet.EMPTY);
        if (this.at(KtTokens.PACKAGE_KEYWORD)) {
            this.advance();
            this.parsePackageName();
            firstEntry.drop();
            this.consumeIf(KtTokens.SEMICOLON);
            packageDirective.done(KtNodeTypes.PACKAGE_DIRECTIVE);
        } else {
            firstEntry.rollbackTo();
            this.parseFileAnnotationList(AnnotationParsingMode.FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED);
            packageDirective = this.mark();
            packageDirective.done(KtNodeTypes.PACKAGE_DIRECTIVE);
            packageDirective.setCustomEdgeTokenBinders(BindFirstShebangWithWhitespaceOnly.INSTANCE, null);
        }
        this.parseImportDirectives();
    }

    private void parsePackageName() {
        PsiBuilder.Marker qualifiedExpression = this.mark();
        boolean simpleName2 = true;
        while (true) {
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                this.errorWithRecovery("Package name must be a '.'-separated identifier list placed on a single line", PACKAGE_NAME_RECOVERY_SET);
                break;
            }
            if (this.at(KtTokens.DOT)) {
                this.advance();
                qualifiedExpression.error("Package name must be a '.'-separated identifier list");
                qualifiedExpression = this.mark();
                continue;
            }
            PsiBuilder.Marker nsName = this.mark();
            boolean simpleNameFound = this.expect(KtTokens.IDENTIFIER, "Package name must be a '.'-separated identifier list", PACKAGE_NAME_RECOVERY_SET);
            if (simpleNameFound) {
                nsName.done(KtNodeTypes.REFERENCE_EXPRESSION);
            } else {
                nsName.drop();
            }
            if (!simpleName2) {
                PsiBuilder.Marker precedingMarker = qualifiedExpression.precede();
                qualifiedExpression.done(KtNodeTypes.DOT_QUALIFIED_EXPRESSION);
                qualifiedExpression = precedingMarker;
            }
            if (!this.at(KtTokens.DOT)) break;
            this.advance();
            if (simpleName2 && !simpleNameFound) {
                qualifiedExpression.drop();
                qualifiedExpression = this.mark();
                continue;
            }
            simpleName2 = false;
        }
        qualifiedExpression.drop();
    }

    private void parseImportDirective() {
        assert (this._at(KtTokens.IMPORT_KEYWORD));
        PsiBuilder.Marker importDirective = this.mark();
        this.advance();
        if (this.closeImportWithErrorIfNewline(importDirective, null, "Expecting qualified name")) {
            return;
        }
        if (!this.at(KtTokens.IDENTIFIER)) {
            PsiBuilder.Marker error = this.mark();
            this.skipUntil(TokenSet.create(KtTokens.EOL_OR_SEMICOLON));
            error.error("Expecting qualified name");
            importDirective.done(KtNodeTypes.IMPORT_DIRECTIVE);
            this.consumeIf(KtTokens.SEMICOLON);
            return;
        }
        PsiBuilder.Marker qualifiedName2 = this.mark();
        PsiBuilder.Marker reference2 = this.mark();
        this.advance();
        reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
        while (this.at(KtTokens.DOT) && this.lookahead(1) != KtTokens.MUL) {
            this.advance();
            if (this.closeImportWithErrorIfNewline(importDirective, null, "Import must be placed on a single line")) {
                qualifiedName2.drop();
                return;
            }
            reference2 = this.mark();
            if (this.expect(KtTokens.IDENTIFIER, "Qualified name must be a '.'-separated identifier list", IMPORT_RECOVERY_SET)) {
                reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
            } else {
                reference2.drop();
            }
            PsiBuilder.Marker precede = qualifiedName2.precede();
            qualifiedName2.done(KtNodeTypes.DOT_QUALIFIED_EXPRESSION);
            qualifiedName2 = precede;
        }
        qualifiedName2.drop();
        if (this.at(KtTokens.DOT)) {
            this.advance();
            assert (this._at(KtTokens.MUL));
            this.advance();
            if (this.at(KtTokens.AS_KEYWORD)) {
                PsiBuilder.Marker as = this.mark();
                this.advance();
                if (this.closeImportWithErrorIfNewline(importDirective, null, "Expecting identifier")) {
                    as.drop();
                    return;
                }
                this.consumeIf(KtTokens.IDENTIFIER);
                as.done(KtNodeTypes.IMPORT_ALIAS);
                as.precede().error("Cannot rename all imported items to one identifier");
            }
        }
        if (this.at(KtTokens.AS_KEYWORD)) {
            PsiBuilder.Marker alias = this.mark();
            this.advance();
            if (this.closeImportWithErrorIfNewline(importDirective, alias, "Expecting identifier")) {
                return;
            }
            this.expect(KtTokens.IDENTIFIER, "Expecting identifier", SEMICOLON_SET);
            alias.done(KtNodeTypes.IMPORT_ALIAS);
        }
        this.consumeIf(KtTokens.SEMICOLON);
        importDirective.done(KtNodeTypes.IMPORT_DIRECTIVE);
        importDirective.setCustomEdgeTokenBinders(null, TrailingCommentsBinder.INSTANCE);
    }

    private boolean closeImportWithErrorIfNewline(PsiBuilder.Marker importDirective, @Nullable PsiBuilder.Marker importAlias, String errorMessage) {
        if (this.myBuilder.newlineBeforeCurrentToken()) {
            if (importAlias != null) {
                importAlias.done(KtNodeTypes.IMPORT_ALIAS);
            }
            this.error(errorMessage);
            importDirective.done(KtNodeTypes.IMPORT_DIRECTIVE);
            return true;
        }
        return false;
    }

    private void parseImportDirectives() {
        PsiBuilder.Marker importList = this.mark();
        if (!this.at(KtTokens.IMPORT_KEYWORD)) {
            importList.setCustomEdgeTokenBinders(DoNotBindAnything.INSTANCE, null);
        }
        while (this.at(KtTokens.IMPORT_KEYWORD)) {
            this.parseImportDirective();
        }
        importList.done(KtNodeTypes.IMPORT_LIST);
    }

    private void parseTopLevelDeclaration() {
        if (this.at(KtTokens.SEMICOLON)) {
            this.advance();
            return;
        }
        PsiBuilder.Marker decl = this.mark();
        if (this.at(KtTokens.CONTEXT_KEYWORD)) {
            this.parseContextReceiverList();
        }
        ModifierDetector detector = new ModifierDetector();
        this.parseModifierList(detector, TokenSet.EMPTY);
        IElementType declType = this.parseCommonDeclaration(detector, NameParsingMode.REQUIRED, DeclarationParsingMode.MEMBER_OR_TOPLEVEL);
        if (declType == null && this.at(KtTokens.LBRACE)) {
            this.error("Expecting a top level declaration");
            this.parseBlock();
            declType = KtNodeTypes.FUN;
        }
        if (declType == null && this.at(KtTokens.IMPORT_KEYWORD)) {
            this.error("imports are only allowed in the beginning of file");
            this.parseImportDirectives();
            decl.drop();
        } else if (declType == null) {
            this.errorAndAdvance("Expecting a top level declaration");
            decl.drop();
        } else {
            KotlinParsing.closeDeclarationWithCommentBinders(decl, declType, true);
        }
    }

    public IElementType parseCommonDeclaration(@NotNull ModifierDetector detector, @NotNull NameParsingMode nameParsingModeForObject, @NotNull DeclarationParsingMode declarationParsingMode) {
        if (detector == null) {
            KotlinParsing.$$$reportNull$$$0(0);
        }
        if (nameParsingModeForObject == null) {
            KotlinParsing.$$$reportNull$$$0(1);
        }
        if (declarationParsingMode == null) {
            KotlinParsing.$$$reportNull$$$0(2);
        }
        switch (this.getTokenId()) {
            case 20: 
            case 43: {
                return this.parseClass(detector.isEnumDetected(), true);
            }
            case 25: {
                return this.parseFunction();
            }
            case 23: 
            case 24: {
                return this.parseProperty(declarationParsingMode);
            }
            case 19: {
                return this.parseTypeAlias();
            }
            case 36: {
                this.parseObject(nameParsingModeForObject, true);
                return KtNodeTypes.OBJECT_DECLARATION;
            }
            case 46: {
                if (!detector.isEnumDetected() || !declarationParsingMode.canBeEnumUsedAsSoftKeyword) break;
                return this.parseClass(true, false);
            }
        }
        return null;
    }

    boolean parseModifierList(@NotNull TokenSet noModifiersBefore) {
        if (noModifiersBefore == null) {
            KotlinParsing.$$$reportNull$$$0(3);
        }
        return this.parseModifierList(null, noModifiersBefore);
    }

    void parseAnnotationsList(@NotNull TokenSet noModifiersBefore) {
        if (noModifiersBefore == null) {
            KotlinParsing.$$$reportNull$$$0(4);
        }
        this.doParseModifierList(null, TokenSet.EMPTY, AnnotationParsingMode.DEFAULT, noModifiersBefore);
    }

    boolean parseModifierList(@Nullable Consumer<IElementType> tokenConsumer, @NotNull TokenSet noModifiersBefore) {
        if (noModifiersBefore == null) {
            KotlinParsing.$$$reportNull$$$0(5);
        }
        return this.doParseModifierList(tokenConsumer, KtTokens.MODIFIER_KEYWORDS, AnnotationParsingMode.DEFAULT, noModifiersBefore);
    }

    private void parseFunctionTypeValueParameterModifierList() {
        this.doParseModifierList(null, KtTokens.RESERVED_VALUE_PARAMETER_MODIFIER_KEYWORDS, AnnotationParsingMode.NO_ANNOTATIONS, NO_MODIFIER_BEFORE_FOR_VALUE_PARAMETER);
    }

    private void parseTypeModifierList() {
        this.doParseModifierList(null, KtTokens.TYPE_MODIFIER_KEYWORDS, AnnotationParsingMode.TYPE_CONTEXT, TokenSet.EMPTY);
    }

    private void parseTypeArgumentModifierList() {
        this.doParseModifierList(null, KtTokens.TYPE_ARGUMENT_MODIFIER_KEYWORDS, AnnotationParsingMode.NO_ANNOTATIONS, COMMA_COLON_GT_SET);
    }

    private boolean doParseModifierListBody(@Nullable Consumer<IElementType> tokenConsumer, @NotNull TokenSet modifierKeywords, @NotNull AnnotationParsingMode annotationParsingMode, @NotNull TokenSet noModifiersBefore) {
        if (modifierKeywords == null) {
            KotlinParsing.$$$reportNull$$$0(6);
        }
        if (annotationParsingMode == null) {
            KotlinParsing.$$$reportNull$$$0(7);
        }
        if (noModifiersBefore == null) {
            KotlinParsing.$$$reportNull$$$0(8);
        }
        boolean empty = true;
        while (!this.eof()) {
            if (this.at(KtTokens.AT) && annotationParsingMode.allowAnnotations) {
                PsiBuilder.Marker beforeAnnotationMarker = this.mark();
                boolean isAnnotationParsed = this.parseAnnotationOrList(annotationParsingMode);
                if (!isAnnotationParsed && !annotationParsingMode.withSignificantWhitespaceBeforeArguments) {
                    beforeAnnotationMarker.rollbackTo();
                    this.doParseModifierListBody(tokenConsumer, modifierKeywords, AnnotationParsingMode.WITH_SIGNIFICANT_WHITESPACE_BEFORE_ARGUMENTS, noModifiersBefore);
                    empty = false;
                    break;
                }
                beforeAnnotationMarker.drop();
            } else if (!this.tryParseModifier(tokenConsumer, noModifiersBefore, modifierKeywords)) break;
            empty = false;
        }
        return empty;
    }

    private boolean doParseModifierList(@Nullable Consumer<IElementType> tokenConsumer, @NotNull TokenSet modifierKeywords, @NotNull AnnotationParsingMode annotationParsingMode, @NotNull TokenSet noModifiersBefore) {
        if (modifierKeywords == null) {
            KotlinParsing.$$$reportNull$$$0(9);
        }
        if (annotationParsingMode == null) {
            KotlinParsing.$$$reportNull$$$0(10);
        }
        if (noModifiersBefore == null) {
            KotlinParsing.$$$reportNull$$$0(11);
        }
        PsiBuilder.Marker list = this.mark();
        boolean empty = this.doParseModifierListBody(tokenConsumer, modifierKeywords, annotationParsingMode, noModifiersBefore);
        if (empty) {
            list.drop();
        } else {
            list.done(KtNodeTypes.MODIFIER_LIST);
        }
        return !empty;
    }

    private boolean tryParseModifier(@Nullable Consumer<IElementType> tokenConsumer, @NotNull TokenSet noModifiersBefore, @NotNull TokenSet modifierKeywords) {
        if (noModifiersBefore == null) {
            KotlinParsing.$$$reportNull$$$0(12);
        }
        if (modifierKeywords == null) {
            KotlinParsing.$$$reportNull$$$0(13);
        }
        PsiBuilder.Marker marker = this.mark();
        if (this.atSet(modifierKeywords)) {
            IElementType lookahead = this.lookahead(1);
            if (this.at(KtTokens.FUN_KEYWORD) && lookahead != KtTokens.INTERFACE_KEYWORD) {
                marker.rollbackTo();
                return false;
            }
            if (lookahead != null && !noModifiersBefore.contains(lookahead)) {
                IElementType tt = this.tt();
                if (tokenConsumer != null) {
                    tokenConsumer.consume(tt);
                }
                this.advance();
                marker.collapse(tt);
                return true;
            }
        }
        marker.rollbackTo();
        return false;
    }

    private void parseContextReceiverList() {
        this.parseContextReceiverList(true);
    }

    private void parseContextReceiverList(boolean allowNamed) {
        assert (this._at(KtTokens.CONTEXT_KEYWORD));
        PsiBuilder.Marker contextReceiverList = this.mark();
        this.advance();
        if (this.at(KtTokens.LPAR)) {
            block7: {
                this.advance();
                while (true) {
                    if (this.at(KtTokens.COMMA)) {
                        this.errorAndAdvance("Expecting a type reference");
                    }
                    this.parseContextReceiver(allowNamed);
                    if (this.at(KtTokens.RPAR)) {
                        this.advance();
                        break block7;
                    }
                    if (this.at(KtTokens.COMMA)) {
                        this.advance();
                        continue;
                    }
                    if (!this.at(KtTokens.RPAR)) break;
                }
                this.error("Expecting comma or ')'");
            }
            contextReceiverList.done(KtNodeTypes.CONTEXT_RECEIVER_LIST);
        } else {
            this.errorWithRecovery("Expecting context receivers", TokenSet.EMPTY);
            contextReceiverList.drop();
        }
    }

    private void parseContextReceiver(boolean allowNamed) {
        if (allowNamed && this.tryParseValueParameter(true)) {
            return;
        }
        PsiBuilder.Marker contextReceiver = this.mark();
        if (this.myExpressionParsing.isAtLabelDefinitionOrMissingIdentifier()) {
            this.myExpressionParsing.parseLabelDefinition();
        }
        this.parseTypeRef();
        contextReceiver.done(KtNodeTypes.CONTEXT_RECEIVER);
    }

    private void parseFileAnnotationList(AnnotationParsingMode mode) {
        if (!mode.isFileAnnotationParsingMode) {
            LOG.error("expected file annotation parsing mode, but:" + (Object)((Object)mode));
        }
        PsiBuilder.Marker fileAnnotationsList = this.mark();
        if (this.parseAnnotations(mode)) {
            fileAnnotationsList.done(KtNodeTypes.FILE_ANNOTATION_LIST);
        } else {
            fileAnnotationsList.drop();
        }
    }

    boolean parseAnnotations(AnnotationParsingMode mode) {
        if (!this.parseAnnotationOrList(mode)) {
            return false;
        }
        while (this.parseAnnotationOrList(mode)) {
        }
        return true;
    }

    private boolean parseAnnotationOrList(AnnotationParsingMode mode) {
        if (this.at(KtTokens.AT)) {
            IElementType nextRawToken;
            IElementType tokenToMatch = nextRawToken = this.myBuilder.rawLookup(1);
            boolean isTargetedAnnotation = false;
            if ((nextRawToken == KtTokens.IDENTIFIER || ANNOTATION_TARGETS.contains(nextRawToken)) && this.lookahead(2) == KtTokens.COLON) {
                tokenToMatch = this.lookahead(3);
                isTargetedAnnotation = true;
            } else if (this.lookahead(1) == KtTokens.COLON) {
                isTargetedAnnotation = true;
                tokenToMatch = this.lookahead(2);
            }
            if (tokenToMatch == KtTokens.IDENTIFIER) {
                return this.parseAnnotation(mode);
            }
            if (tokenToMatch == KtTokens.LBRACKET) {
                return this.parseAnnotationList(mode);
            }
            if (isTargetedAnnotation) {
                if (this.lookahead(1) == KtTokens.COLON) {
                    this.errorAndAdvance("Expected annotation identifier after ':'", 2);
                } else {
                    this.errorAndAdvance("Expected annotation identifier after ':'", 3);
                }
            } else {
                this.errorAndAdvance("Expected annotation identifier after '@'", 1);
            }
            return true;
        }
        return false;
    }

    private boolean parseAnnotationList(AnnotationParsingMode mode) {
        assert (this._at(KtTokens.AT));
        PsiBuilder.Marker annotation = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (!this.parseAnnotationTargetIfNeeded(mode)) {
            annotation.rollbackTo();
            this.myBuilder.restoreNewlinesState();
            return false;
        }
        assert (this._at(KtTokens.LBRACKET));
        this.advance();
        if (!this.at(KtTokens.IDENTIFIER) && !this.at(KtTokens.AT)) {
            this.error("Expecting a list of annotations");
        } else {
            while (this.at(KtTokens.IDENTIFIER) || this.at(KtTokens.AT)) {
                if (this.at(KtTokens.AT)) {
                    this.errorAndAdvance("No '@' needed in annotation list");
                    continue;
                }
                this.parseAnnotation(AnnotationParsingMode.DEFAULT);
                while (this.at(KtTokens.COMMA)) {
                    this.errorAndAdvance("No commas needed to separate annotations");
                }
            }
        }
        this.expect(KtTokens.RBRACKET, "Expecting ']' to close the annotation list");
        this.myBuilder.restoreNewlinesState();
        annotation.done(KtNodeTypes.ANNOTATION);
        return true;
    }

    private boolean parseAnnotationTargetIfNeeded(AnnotationParsingMode mode) {
        String expectedAnnotationTargetBeforeColon = "Expected annotation target before ':'";
        if (this.at(KtTokens.COLON)) {
            this.errorAndAdvance(expectedAnnotationTargetBeforeColon);
            return true;
        }
        KtKeywordToken targetKeyword = this.atTargetKeyword();
        if (mode == AnnotationParsingMode.FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED && (targetKeyword != KtTokens.FILE_KEYWORD || this.lookahead(1) != KtTokens.COLON)) {
            return false;
        }
        if (this.lookahead(1) == KtTokens.COLON && targetKeyword == null && this.at(KtTokens.IDENTIFIER)) {
            this.errorAndAdvance(expectedAnnotationTargetBeforeColon);
            this.advance();
            return true;
        }
        if (targetKeyword == null && mode.isFileAnnotationParsingMode) {
            this.parseAnnotationTarget(KtTokens.FILE_KEYWORD);
        } else if (targetKeyword != null) {
            this.parseAnnotationTarget(targetKeyword);
        }
        return true;
    }

    private void parseAnnotationTarget(KtKeywordToken keyword) {
        String message = "Expecting \"" + keyword.getValue() + KtTokens.COLON.getValue() + "\" prefix for " + keyword.getValue() + " annotations";
        PsiBuilder.Marker marker = this.mark();
        if (!this.expect(keyword, message)) {
            marker.drop();
        } else {
            marker.done(KtNodeTypes.ANNOTATION_TARGET);
        }
        this.expect(KtTokens.COLON, message, IDENTIFIER_RBRACKET_LBRACKET_SET);
    }

    @Nullable
    private KtKeywordToken atTargetKeyword() {
        for (IElementType target : ANNOTATION_TARGETS.getTypes()) {
            if (!this.at(target)) continue;
            return (KtKeywordToken)target;
        }
        return null;
    }

    private boolean parseAnnotation(AnnotationParsingMode mode) {
        boolean shouldBeParsedNextAsFunctionalType;
        assert (this._at(KtTokens.IDENTIFIER) || this._at(KtTokens.AT) && (!this.isNextRawTokenCommentOrWhitespace() || this.lookahead(1) == KtTokens.COLON)) : "Invalid annotation prefix";
        PsiBuilder.Marker annotation = this.mark();
        boolean atAt = this.at(KtTokens.AT);
        if (atAt) {
            this.advance();
        }
        if (atAt && !this.parseAnnotationTargetIfNeeded(mode)) {
            annotation.rollbackTo();
            return false;
        }
        PsiBuilder.Marker reference2 = this.mark();
        PsiBuilder.Marker typeReference = this.mark();
        this.parseUserType();
        typeReference.done(KtNodeTypes.TYPE_REFERENCE);
        reference2.done(KtNodeTypes.CONSTRUCTOR_CALLEE);
        this.parseTypeArgumentList();
        boolean whitespaceAfterAnnotation = KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(-1));
        boolean bl2 = shouldBeParsedNextAsFunctionalType = this.at(KtTokens.LPAR) && whitespaceAfterAnnotation && mode.withSignificantWhitespaceBeforeArguments;
        if (this.at(KtTokens.LPAR) && !shouldBeParsedNextAsFunctionalType) {
            this.myExpressionParsing.parseValueArgumentList();
            if (mode.typeContext && (this.getLastToken() != KtTokens.RPAR || this.at(KtTokens.ARROW))) {
                annotation.done(KtNodeTypes.ANNOTATION_ENTRY);
                return false;
            }
        }
        annotation.done(KtNodeTypes.ANNOTATION_ENTRY);
        return true;
    }

    private boolean isNextRawTokenCommentOrWhitespace() {
        return KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(1));
    }

    private IElementType parseClassOrObject(boolean object, NameParsingMode nameParsingMode, boolean optionalBody, boolean enumClass, boolean expectKindKeyword) {
        if (expectKindKeyword) {
            if (object ? !$assertionsDisabled && !this._at(KtTokens.OBJECT_KEYWORD) : !$assertionsDisabled && !this._atSet(CLASS_INTERFACE_SET)) {
                throw new AssertionError();
            }
            this.advance();
        } else {
            assert (enumClass) : "Currently classifiers without class/interface/object are only allowed for enums";
            this.error("'class' keyword is expected after 'enum'");
        }
        if (nameParsingMode == NameParsingMode.REQUIRED) {
            this.expect(KtTokens.IDENTIFIER, "Name expected", CLASS_NAME_RECOVERY_SET);
        } else {
            assert (object) : "Must be an object to be nameless";
            if (this.at(KtTokens.IDENTIFIER)) {
                if (nameParsingMode == NameParsingMode.PROHIBITED) {
                    this.errorAndAdvance("An object expression cannot bind a name");
                } else {
                    assert (nameParsingMode == NameParsingMode.ALLOWED);
                    this.advance();
                }
            }
        }
        boolean typeParametersDeclared = this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET);
        PsiBuilder.Marker beforeConstructorModifiers = this.mark();
        PsiBuilder.Marker primaryConstructorMarker = this.mark();
        boolean hasConstructorModifiers = this.parseModifierList(TokenSet.EMPTY);
        if (hasConstructorModifiers && !this.atSet(LPAR_LBRACE_COLON_CONSTRUCTOR_KEYWORD_SET)) {
            beforeConstructorModifiers.rollbackTo();
            return object ? KtNodeTypes.OBJECT_DECLARATION : KtNodeTypes.CLASS;
        }
        beforeConstructorModifiers.drop();
        boolean hasConstructorKeyword = this.at(KtTokens.CONSTRUCTOR_KEYWORD);
        if (hasConstructorKeyword) {
            this.advance();
        }
        if (this.at(KtTokens.LPAR)) {
            this.parseValueParameterList(false, true, LBRACE_RBRACE_SET);
            primaryConstructorMarker.done(KtNodeTypes.PRIMARY_CONSTRUCTOR);
        } else if (hasConstructorModifiers || hasConstructorKeyword) {
            primaryConstructorMarker.done(KtNodeTypes.PRIMARY_CONSTRUCTOR);
            if (hasConstructorKeyword) {
                this.error("Expecting primary constructor parameter list");
            } else {
                this.error("Expecting 'constructor' keyword");
            }
        } else {
            primaryConstructorMarker.drop();
        }
        if (this.at(KtTokens.COLON)) {
            this.advance();
            this.parseDelegationSpecifierList();
        }
        AbstractKotlinParsing.OptionalMarker whereMarker = new AbstractKotlinParsing.OptionalMarker(object);
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        whereMarker.error("Where clause is not allowed for objects");
        if (this.at(KtTokens.LBRACE)) {
            if (enumClass) {
                this.parseEnumClassBody();
            } else {
                this.parseClassBody();
            }
        } else if (!optionalBody) {
            PsiBuilder.Marker fakeBody = this.mark();
            this.error("Expecting a class body");
            fakeBody.done(KtNodeTypes.CLASS_BODY);
        }
        return object ? KtNodeTypes.OBJECT_DECLARATION : KtNodeTypes.CLASS;
    }

    private IElementType parseClass(boolean enumClass, boolean expectKindKeyword) {
        return this.parseClassOrObject(false, NameParsingMode.REQUIRED, true, enumClass, expectKindKeyword);
    }

    void parseObject(NameParsingMode nameParsingMode, boolean optionalBody) {
        this.parseClassOrObject(true, nameParsingMode, optionalBody, false, true);
    }

    private void parseEnumClassBody() {
        if (!this.at(KtTokens.LBRACE)) {
            return;
        }
        PsiBuilder.Marker body2 = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        if (!this.parseEnumEntries() && !this.at(KtTokens.RBRACE)) {
            this.error("Expecting ';' after the last enum entry or '}' to close enum class body");
        }
        this.parseMembers();
        this.expect(KtTokens.RBRACE, "Expecting '}' to close enum class body");
        this.myBuilder.restoreNewlinesState();
        body2.done(KtNodeTypes.CLASS_BODY);
    }

    private boolean parseEnumEntries() {
        while (!this.eof() && !this.at(KtTokens.RBRACE)) {
            switch (this.parseEnumEntry()) {
                case FAILED: {
                    if (this.at(KtTokens.SEMICOLON)) {
                        this.advance();
                        return true;
                    }
                    return false;
                }
                case NO_DELIMITER: {
                    return false;
                }
                case COMMA_DELIMITER: {
                    break;
                }
                case SEMICOLON_DELIMITER: {
                    return true;
                }
            }
        }
        return false;
    }

    private ParseEnumEntryResult parseEnumEntry() {
        PsiBuilder.Marker entry = this.mark();
        this.parseModifierList(COMMA_SEMICOLON_RBRACE_SET);
        if (!this.atSet(SOFT_KEYWORDS_AT_MEMBER_START) && this.at(KtTokens.IDENTIFIER)) {
            boolean semicolonFound;
            boolean commaFound;
            this.advance();
            if (this.at(KtTokens.LPAR)) {
                PsiBuilder.Marker initializerList = this.mark();
                PsiBuilder.Marker delegatorSuperCall = this.mark();
                PsiBuilder.Marker callee = this.mark();
                PsiBuilder.Marker typeReference = this.mark();
                PsiBuilder.Marker type2 = this.mark();
                PsiBuilder.Marker referenceExpr = this.mark();
                referenceExpr.done(KtNodeTypes.ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION);
                type2.done(KtNodeTypes.USER_TYPE);
                typeReference.done(KtNodeTypes.TYPE_REFERENCE);
                callee.done(KtNodeTypes.CONSTRUCTOR_CALLEE);
                this.myExpressionParsing.parseValueArgumentList();
                delegatorSuperCall.done(KtNodeTypes.SUPER_TYPE_CALL_ENTRY);
                initializerList.done(KtNodeTypes.INITIALIZER_LIST);
            }
            if (this.at(KtTokens.LBRACE)) {
                this.parseClassBody();
            }
            if (commaFound = this.at(KtTokens.COMMA)) {
                this.advance();
            }
            if (semicolonFound = this.at(KtTokens.SEMICOLON)) {
                this.advance();
            }
            KotlinParsing.closeDeclarationWithCommentBinders(entry, KtNodeTypes.ENUM_ENTRY, true);
            return semicolonFound ? ParseEnumEntryResult.SEMICOLON_DELIMITER : (commaFound ? ParseEnumEntryResult.COMMA_DELIMITER : ParseEnumEntryResult.NO_DELIMITER);
        }
        entry.rollbackTo();
        return ParseEnumEntryResult.FAILED;
    }

    private void parseClassBody() {
        PsiBuilder.Marker body2 = this.mark();
        this.myBuilder.enableNewlines();
        if (this.expect(KtTokens.LBRACE, "Expecting a class body")) {
            this.parseMembers();
            this.expect(KtTokens.RBRACE, "Missing '}");
        }
        this.myBuilder.restoreNewlinesState();
        body2.done(KtNodeTypes.CLASS_BODY);
    }

    private void parseMembers() {
        while (!this.eof() && !this.at(KtTokens.RBRACE)) {
            this.parseMemberDeclaration();
        }
    }

    private void parseMemberDeclaration() {
        if (this.at(KtTokens.SEMICOLON)) {
            this.advance();
            return;
        }
        PsiBuilder.Marker decl = this.mark();
        if (this.at(KtTokens.CONTEXT_KEYWORD)) {
            this.parseContextReceiverList();
        }
        ModifierDetector detector = new ModifierDetector();
        this.parseModifierList(detector, TokenSet.EMPTY);
        IElementType declType = this.parseMemberDeclarationRest(detector);
        if (declType == null) {
            this.errorWithRecovery("Expecting member declaration", TokenSet.EMPTY);
            decl.drop();
        } else {
            KotlinParsing.closeDeclarationWithCommentBinders(decl, declType, true);
        }
    }

    private IElementType parseMemberDeclarationRest(@NotNull ModifierDetector modifierDetector) {
        IElementType declType;
        if (modifierDetector == null) {
            KotlinParsing.$$$reportNull$$$0(14);
        }
        if ((declType = this.parseCommonDeclaration(modifierDetector, modifierDetector.isCompanionDetected() ? NameParsingMode.ALLOWED : NameParsingMode.REQUIRED, DeclarationParsingMode.MEMBER_OR_TOPLEVEL)) != null) {
            return declType;
        }
        if (this.at(KtTokens.INIT_KEYWORD)) {
            this.advance();
            if (this.at(KtTokens.LBRACE)) {
                this.parseBlock();
            } else {
                this.mark().error("Expecting '{' after 'init'");
            }
            declType = KtNodeTypes.CLASS_INITIALIZER;
        } else if (this.at(KtTokens.CONSTRUCTOR_KEYWORD)) {
            this.parseSecondaryConstructor();
            declType = KtNodeTypes.SECONDARY_CONSTRUCTOR;
        } else if (this.at(KtTokens.LBRACE)) {
            this.error("Expecting member declaration");
            this.parseBlock();
            declType = KtNodeTypes.FUN;
        }
        return declType;
    }

    private void parseSecondaryConstructor() {
        assert (this._at(KtTokens.CONSTRUCTOR_KEYWORD));
        this.advance();
        if (this.at(KtTokens.LPAR)) {
            this.parseValueParameterList(false, true, VALUE_ARGS_RECOVERY_SET);
        } else {
            this.errorWithRecovery("Expecting '('", TokenSet.orSet(VALUE_ARGS_RECOVERY_SET, TokenSet.create(KtTokens.COLON)));
        }
        if (this.at(KtTokens.COLON)) {
            this.advance();
            PsiBuilder.Marker delegationCall = this.mark();
            if (this.at(KtTokens.THIS_KEYWORD) || this.at(KtTokens.SUPER_KEYWORD)) {
                this.parseThisOrSuper();
                this.myExpressionParsing.parseValueArgumentList();
            } else {
                this.error("Expecting a 'this' or 'super' constructor call");
                PsiBuilder.Marker beforeWrongDelegationCallee = null;
                if (!this.at(KtTokens.LPAR)) {
                    beforeWrongDelegationCallee = this.mark();
                    this.advance();
                }
                this.myExpressionParsing.parseValueArgumentList();
                if (beforeWrongDelegationCallee != null) {
                    if (this.at(KtTokens.LBRACE)) {
                        beforeWrongDelegationCallee.drop();
                    } else {
                        beforeWrongDelegationCallee.rollbackTo();
                    }
                }
            }
            delegationCall.done(KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL);
        } else {
            PsiBuilder.Marker emptyDelegationCall = this.mark();
            this.mark().done(KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE);
            emptyDelegationCall.done(KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL);
        }
        if (this.at(KtTokens.LBRACE)) {
            this.parseBlock();
        }
    }

    private void parseThisOrSuper() {
        assert (this._at(KtTokens.THIS_KEYWORD) || this._at(KtTokens.SUPER_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        mark.done(KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE);
    }

    private IElementType parseTypeAlias() {
        assert (this._at(KtTokens.TYPE_ALIAS_KEYWORD));
        this.advance();
        this.expect(KtTokens.IDENTIFIER, "Type name expected", LT_EQ_SEMICOLON_TOP_LEVEL_DECLARATION_FIRST_SET);
        this.parseTypeParameterList(TYPE_PARAMETER_GT_RECOVERY_SET);
        if (this.at(KtTokens.WHERE_KEYWORD)) {
            PsiBuilder.Marker error = this.mark();
            this.parseTypeConstraints();
            error.error("Type alias parameters can't have bounds");
        }
        this.expect(KtTokens.EQ, "Expecting '='", TOP_LEVEL_DECLARATION_FIRST_SEMICOLON_SET);
        this.parseTypeRef();
        this.consumeIf(KtTokens.SEMICOLON);
        return KtNodeTypes.TYPEALIAS;
    }

    public IElementType parseProperty(DeclarationParsingMode mode) {
        assert (this.at(KtTokens.VAL_KEYWORD) || this.at(KtTokens.VAR_KEYWORD));
        this.advance();
        boolean typeParametersDeclared = this.at(KtTokens.LT) && this.parseTypeParameterList(IDENTIFIER_EQ_COLON_SEMICOLON_SET);
        this.myBuilder.disableJoiningComplexTokens();
        PsiBuilder.Marker receiver = this.mark();
        boolean receiverTypeDeclared = this.parseReceiverType("property", PROPERTY_NAME_FOLLOW_SET);
        boolean multiDeclaration = this.at(KtTokens.LPAR);
        KotlinParsing.errorIf(receiver, multiDeclaration && receiverTypeDeclared, "Receiver type is not allowed on a destructuring declaration");
        boolean isNameOnTheNextLine = this.eol();
        PsiBuilder.Marker beforeName = this.mark();
        if (multiDeclaration) {
            PsiBuilder.Marker multiDecl = this.mark();
            this.parseMultiDeclarationName(PROPERTY_NAME_FOLLOW_SET, PROPERTY_NAME_FOLLOW_MULTI_DECLARATION_RECOVERY_SET);
            KotlinParsing.errorIf(multiDecl, !mode.destructuringAllowed, "Destructuring declarations are only allowed for local variables/values");
        } else {
            this.parseFunctionOrPropertyName(receiverTypeDeclared, "property", PROPERTY_NAME_FOLLOW_SET, PROPERTY_NAME_FOLLOW_FUNCTION_OR_PROPERTY_RECOVERY_SET, true);
        }
        this.myBuilder.restoreJoiningComplexTokensState();
        boolean noTypeReference = true;
        if (this.at(KtTokens.COLON)) {
            noTypeReference = false;
            PsiBuilder.Marker type2 = this.mark();
            this.advance();
            this.parseTypeRef();
            KotlinParsing.errorIf(type2, multiDeclaration, "Type annotations are not allowed on destructuring declarations");
        }
        this.parseTypeConstraintsGuarded(typeParametersDeclared);
        if (!this.parsePropertyDelegateOrAssignment() && isNameOnTheNextLine && noTypeReference && !receiverTypeDeclared) {
            beforeName.rollbackTo();
            this.error("Expecting property name or receiver type");
            return KtNodeTypes.PROPERTY;
        }
        beforeName.drop();
        if (mode.accessorsAllowed) {
            this.myBuilder.enableNewlines();
            boolean hasNewLineWithSemicolon = this.consumeIf(KtTokens.SEMICOLON) && this.myBuilder.newlineBeforeCurrentToken();
            this.myBuilder.restoreNewlinesState();
            if (!hasNewLineWithSemicolon) {
                PropertyComponentKind.Collector alreadyRead = new PropertyComponentKind.Collector();
                PropertyComponentKind propertyComponentKind = this.parsePropertyComponent(alreadyRead);
                while (propertyComponentKind != null) {
                    alreadyRead.collect(propertyComponentKind);
                    propertyComponentKind = this.parsePropertyComponent(alreadyRead);
                }
                if (!this.atSet(EOL_OR_SEMICOLON_RBRACE_SET)) {
                    if (this.getLastToken() != KtTokens.SEMICOLON) {
                        this.errorUntil("Property getter or setter expected", TokenSet.orSet(DECLARATION_FIRST, TokenSet.create(KtTokens.EOL_OR_SEMICOLON, KtTokens.LBRACE, KtTokens.RBRACE)));
                    }
                } else {
                    this.consumeIf(KtTokens.SEMICOLON);
                }
            }
        }
        return multiDeclaration ? KtNodeTypes.DESTRUCTURING_DECLARATION : KtNodeTypes.PROPERTY;
    }

    private boolean parsePropertyDelegateOrAssignment() {
        if (this.at(KtTokens.BY_KEYWORD)) {
            this.parsePropertyDelegate();
            return true;
        }
        if (this.at(KtTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
            return true;
        }
        return false;
    }

    private void parsePropertyDelegate() {
        assert (this._at(KtTokens.BY_KEYWORD));
        PsiBuilder.Marker delegate = this.mark();
        this.advance();
        this.myExpressionParsing.parseExpression();
        delegate.done(KtNodeTypes.PROPERTY_DELEGATE);
    }

    public void parseMultiDeclarationName(TokenSet follow, TokenSet recoverySet) {
        this.myBuilder.disableNewlines();
        this.advance();
        if (!this.atSet(follow)) {
            do {
                if (this.at(KtTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a name");
                } else if (this.at(KtTokens.RPAR)) {
                    this.error("Expecting a name");
                    break;
                }
                PsiBuilder.Marker property2 = this.mark();
                this.parseModifierList(COMMA_RPAR_COLON_EQ_SET);
                this.expect(KtTokens.IDENTIFIER, "Expecting a name", recoverySet);
                if (this.at(KtTokens.COLON)) {
                    this.advance();
                    this.parseTypeRef(follow);
                }
                property2.done(KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY);
                if (!this.at(KtTokens.COMMA)) break;
                this.advance();
            } while (!this.at(KtTokens.RPAR));
        }
        this.expect(KtTokens.RPAR, "Expecting ')'", follow);
        this.myBuilder.restoreNewlinesState();
    }

    @Nullable
    private PropertyComponentKind parsePropertyComponent(PropertyComponentKind.Collector notAllowedKind) {
        PropertyComponentKind propertyComponentKind;
        PsiBuilder.Marker propertyComponent = this.mark();
        this.parseModifierList(TokenSet.EMPTY);
        if (this.at(KtTokens.GET_KEYWORD)) {
            propertyComponentKind = PropertyComponentKind.GET;
        } else if (this.at(KtTokens.SET_KEYWORD)) {
            propertyComponentKind = PropertyComponentKind.SET;
        } else if (this.at(KtTokens.FIELD_KEYWORD)) {
            propertyComponentKind = PropertyComponentKind.FIELD;
        } else {
            propertyComponent.rollbackTo();
            return null;
        }
        if (notAllowedKind.contains(propertyComponentKind)) {
            propertyComponent.rollbackTo();
            return null;
        }
        this.advance();
        if (!this.at(KtTokens.LPAR) && propertyComponentKind != PropertyComponentKind.FIELD) {
            if (!this.atSet(ACCESSOR_FIRST_OR_PROPERTY_END)) {
                this.errorUntil("Accessor body expected", TokenSet.orSet(ACCESSOR_FIRST_OR_PROPERTY_END, TokenSet.create(KtTokens.LBRACE, KtTokens.LPAR, KtTokens.EQ)));
            } else {
                KotlinParsing.closeDeclarationWithCommentBinders(propertyComponent, KtNodeTypes.PROPERTY_ACCESSOR, true);
                return propertyComponentKind;
            }
        }
        this.myBuilder.disableNewlines();
        if (propertyComponentKind != PropertyComponentKind.FIELD) {
            PsiBuilder.Marker parameterList2 = this.mark();
            this.expect(KtTokens.LPAR, "Expecting '('", RPAR_IDENTIFIER_COLON_LBRACE_EQ_SET);
            if (propertyComponentKind == PropertyComponentKind.SET) {
                PsiBuilder.Marker setterParameter = this.mark();
                this.parseModifierList(COMMA_COLON_RPAR_SET);
                this.expect(KtTokens.IDENTIFIER, "Expecting parameter name", RPAR_COLON_LBRACE_EQ_SET);
                if (this.at(KtTokens.COLON)) {
                    this.advance();
                    this.parseTypeRef();
                }
                setterParameter.done(KtNodeTypes.VALUE_PARAMETER);
                if (this.at(KtTokens.COMMA)) {
                    this.advance();
                }
            }
            if (!this.at(KtTokens.RPAR)) {
                this.errorUntil("Expecting ')'", TokenSet.create(KtTokens.RPAR, KtTokens.COLON, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.EQ, KtTokens.EOL_OR_SEMICOLON));
            }
            if (this.at(KtTokens.RPAR)) {
                this.advance();
            }
            parameterList2.done(KtNodeTypes.VALUE_PARAMETER_LIST);
        }
        this.myBuilder.restoreNewlinesState();
        if (this.at(KtTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        if (propertyComponentKind != PropertyComponentKind.FIELD) {
            this.parseFunctionContract();
            this.parseFunctionBody();
        } else if (this.at(KtTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
            this.consumeIf(KtTokens.SEMICOLON);
        }
        if (propertyComponentKind == PropertyComponentKind.FIELD) {
            KotlinParsing.closeDeclarationWithCommentBinders(propertyComponent, KtNodeTypes.BACKING_FIELD, true);
        } else {
            KotlinParsing.closeDeclarationWithCommentBinders(propertyComponent, KtNodeTypes.PROPERTY_ACCESSOR, true);
        }
        return propertyComponentKind;
    }

    @NotNull
    private IElementType parseFunction() {
        IElementType iElementType = this.parseFunction(false);
        if (iElementType == null) {
            KotlinParsing.$$$reportNull$$$0(15);
        }
        return iElementType;
    }

    @Contract(value="false -> !null")
    IElementType parseFunction(boolean failIfIdentifierExists) {
        assert (this._at(KtTokens.FUN_KEYWORD));
        this.advance();
        if (this.at(KtTokens.RBRACE)) {
            this.error("Function body expected");
            return KtNodeTypes.FUN;
        }
        boolean typeParameterListOccurred = false;
        if (this.at(KtTokens.LT)) {
            this.parseTypeParameterList(LBRACKET_LBRACE_RBRACE_LPAR_SET);
            typeParameterListOccurred = true;
        }
        this.myBuilder.disableJoiningComplexTokens();
        boolean receiverFound = this.parseReceiverType("function", FUNCTION_NAME_FOLLOW_SET);
        if (this.at(KtTokens.IDENTIFIER) && failIfIdentifierExists) {
            this.myBuilder.restoreJoiningComplexTokensState();
            return null;
        }
        this.parseFunctionOrPropertyName(receiverFound, "function", FUNCTION_NAME_FOLLOW_SET, FUNCTION_NAME_RECOVERY_SET, false);
        this.myBuilder.restoreJoiningComplexTokensState();
        if (this.at(KtTokens.LT)) {
            PsiBuilder.Marker error = this.mark();
            this.parseTypeParameterList(LPAR_VALUE_PARAMETERS_FOLLOW_SET);
            if (typeParameterListOccurred) {
                int finishIndex = this.myBuilder.rawTokenIndex();
                error.rollbackTo();
                error = this.mark();
                this.advance(finishIndex - this.myBuilder.rawTokenIndex());
                error.error("Only one type parameter list is allowed for a function");
            } else {
                error.drop();
            }
            typeParameterListOccurred = true;
        }
        if (this.at(KtTokens.LPAR)) {
            this.parseValueParameterList(false, false, VALUE_PARAMETERS_FOLLOW_SET);
        } else {
            this.error("Expecting '('");
        }
        if (this.at(KtTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        boolean functionContractOccurred = this.parseFunctionContract();
        this.parseTypeConstraintsGuarded(typeParameterListOccurred);
        if (!functionContractOccurred) {
            this.parseFunctionContract();
        }
        if (this.at(KtTokens.SEMICOLON)) {
            this.advance();
        } else if (this.at(KtTokens.EQ) || this.at(KtTokens.LBRACE)) {
            this.parseFunctionBody();
        }
        return KtNodeTypes.FUN;
    }

    private boolean parseReceiverType(String title, TokenSet nameFollow) {
        boolean receiverPresent;
        PsiBuilder.Marker annotations2 = this.mark();
        boolean annotationsPresent = this.parseAnnotations(AnnotationParsingMode.DEFAULT);
        int lastDot = this.lastDotAfterReceiver();
        boolean bl2 = receiverPresent = lastDot != -1;
        if (annotationsPresent) {
            if (receiverPresent) {
                annotations2.rollbackTo();
            } else {
                annotations2.error("Annotations are not allowed in this position");
            }
        } else {
            annotations2.drop();
        }
        if (!receiverPresent) {
            return false;
        }
        this.createTruncatedBuilder(lastDot).parseTypeRefWithoutIntersections();
        if (this.atSet(RECEIVER_TYPE_TERMINATORS)) {
            this.advance();
        } else {
            this.errorWithRecovery("Expecting '.' before a " + title + " name", nameFollow);
        }
        return true;
    }

    private int lastDotAfterReceiver() {
        AbstractTokenStreamPattern pattern = this.at(KtTokens.LPAR) ? this.lastDotAfterReceiverLParPattern : this.lastDotAfterReceiverNotLParPattern;
        pattern.reset();
        return this.matchTokenStreamPredicate(pattern);
    }

    private void parseFunctionOrPropertyName(boolean receiverFound, String title, TokenSet nameFollow, TokenSet recoverySet, boolean nameRequired) {
        if (!nameRequired && this.atSet(nameFollow)) {
            return;
        }
        if (this.expect(KtTokens.IDENTIFIER)) {
            return;
        }
        this.errorWithRecovery("Expecting " + title + " name" + (!receiverFound ? " or receiver type" : ""), recoverySet);
    }

    private void parseFunctionBody() {
        if (this.at(KtTokens.LBRACE)) {
            this.parseBlock();
        } else if (this.at(KtTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
            this.consumeIf(KtTokens.SEMICOLON);
        } else {
            this.error("Expecting function body");
        }
    }

    void parseBlock() {
        this.parseBlock(true);
    }

    private void parseBlock(boolean collapse) {
        boolean canCollapse;
        PsiBuilder.Marker lazyBlock = this.mark();
        this.myBuilder.enableNewlines();
        boolean hasOpeningBrace = this.expect(KtTokens.LBRACE, "Expecting '{' to open a block");
        boolean bl2 = canCollapse = collapse && hasOpeningBrace && this.isLazy;
        if (canCollapse) {
            this.advanceBalancedBlock();
        } else {
            this.myExpressionParsing.parseStatements();
            this.expect(KtTokens.RBRACE, "Expecting '}'");
        }
        this.myBuilder.restoreNewlinesState();
        if (canCollapse) {
            lazyBlock.collapse(KtNodeTypes.BLOCK);
        } else {
            lazyBlock.done(KtNodeTypes.BLOCK);
        }
    }

    public void advanceBalancedBlock() {
        int braceCount = 1;
        while (!this.eof()) {
            if (this._at(KtTokens.LBRACE)) {
                ++braceCount;
            } else if (this._at(KtTokens.RBRACE)) {
                --braceCount;
            }
            this.advance();
            if (braceCount != 0) continue;
            break;
        }
    }

    private void parseDelegationSpecifierList() {
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance("Expecting a delegation specifier");
                continue;
            }
            this.parseDelegationSpecifier();
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
        list.done(KtNodeTypes.SUPER_TYPE_LIST);
    }

    private void parseDelegationSpecifier() {
        PsiBuilder.Marker delegator = this.mark();
        PsiBuilder.Marker reference2 = this.mark();
        this.parseTypeRef();
        if (this.at(KtTokens.BY_KEYWORD)) {
            reference2.drop();
            this.advance();
            KotlinParsing.createForByClause((SemanticWhitespaceAwarePsiBuilder)this.myBuilder, (boolean)this.isLazy).myExpressionParsing.parseExpression();
            delegator.done(KtNodeTypes.DELEGATED_SUPER_TYPE_ENTRY);
        } else if (this.at(KtTokens.LPAR)) {
            reference2.done(KtNodeTypes.CONSTRUCTOR_CALLEE);
            this.myExpressionParsing.parseValueArgumentList();
            delegator.done(KtNodeTypes.SUPER_TYPE_CALL_ENTRY);
        } else {
            reference2.drop();
            delegator.done(KtNodeTypes.SUPER_TYPE_ENTRY);
        }
    }

    private boolean parseTypeParameterList(TokenSet recoverySet) {
        boolean result2 = false;
        if (this.at(KtTokens.LT)) {
            PsiBuilder.Marker list = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            do {
                if (this.at(KtTokens.COMMA)) {
                    this.errorAndAdvance("Expecting type parameter declaration");
                }
                this.parseTypeParameter();
                if (!this.at(KtTokens.COMMA)) break;
                this.advance();
            } while (!this.at(KtTokens.GT));
            this.expect(KtTokens.GT, "Missing '>'", recoverySet);
            this.myBuilder.restoreNewlinesState();
            result2 = true;
            list.done(KtNodeTypes.TYPE_PARAMETER_LIST);
        }
        return result2;
    }

    private void parseTypeConstraintsGuarded(boolean typeParameterListOccurred) {
        PsiBuilder.Marker error = this.mark();
        boolean constraints = this.parseTypeConstraints();
        KotlinParsing.errorIf(error, constraints && !typeParameterListOccurred, "Type constraints are not allowed when no type parameters declared");
    }

    private boolean parseTypeConstraints() {
        if (this.at(KtTokens.WHERE_KEYWORD)) {
            this.parseTypeConstraintList();
            return true;
        }
        return false;
    }

    private void parseTypeConstraintList() {
        assert (this._at(KtTokens.WHERE_KEYWORD));
        this.advance();
        PsiBuilder.Marker list = this.mark();
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance("Type constraint expected");
            }
            this.parseTypeConstraint();
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
        list.done(KtNodeTypes.TYPE_CONSTRAINT_LIST);
    }

    private void parseTypeConstraint() {
        PsiBuilder.Marker constraint = this.mark();
        this.parseAnnotations(AnnotationParsingMode.DEFAULT);
        PsiBuilder.Marker reference2 = this.mark();
        if (this.expect(KtTokens.IDENTIFIER, "Expecting type parameter name", COLON_COMMA_LBRACE_RBRACE_TYPE_REF_FIRST_SET)) {
            reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
        } else {
            reference2.drop();
        }
        this.expect(KtTokens.COLON, "Expecting ':' before the upper bound", LBRACE_RBRACE_TYPE_REF_FIRST_SET);
        this.parseTypeRef();
        constraint.done(KtNodeTypes.TYPE_CONSTRAINT);
    }

    private boolean parseFunctionContract() {
        if (this.at(KtTokens.CONTRACT_KEYWORD)) {
            this.myExpressionParsing.parseContractDescriptionBlock();
            return true;
        }
        return false;
    }

    private void parseTypeParameter() {
        if (this.atSet(TYPE_PARAMETER_GT_RECOVERY_SET)) {
            this.error("Type parameter declaration expected");
            return;
        }
        PsiBuilder.Marker mark = this.mark();
        this.parseModifierList(GT_COMMA_COLON_SET);
        this.expect(KtTokens.IDENTIFIER, "Type parameter name expected", TokenSet.EMPTY);
        if (this.at(KtTokens.COLON)) {
            this.advance();
            this.parseTypeRef();
        }
        mark.done(KtNodeTypes.TYPE_PARAMETER);
    }

    void parseTypeRef() {
        this.parseTypeRef(TokenSet.EMPTY);
    }

    void parseTypeRefWithoutIntersections() {
        this.parseTypeRef(TokenSet.EMPTY, false);
    }

    void parseTypeRef(TokenSet extraRecoverySet) {
        this.parseTypeRef(extraRecoverySet, true);
    }

    private void parseTypeRef(TokenSet extraRecoverySet, boolean allowSimpleIntersectionTypes) {
        PsiBuilder.Marker typeRefMarker = this.parseTypeRefContents(extraRecoverySet, allowSimpleIntersectionTypes);
        typeRefMarker.done(KtNodeTypes.TYPE_REFERENCE);
    }

    private PsiBuilder.Marker parseTypeRefContents(TokenSet extraRecoverySet, boolean allowSimpleIntersectionTypes) {
        PsiBuilder.Marker typeRefMarker = this.mark();
        this.parseTypeModifierList();
        IElementType lookahead = this.lookahead(1);
        IElementType lookahead2 = this.lookahead(2);
        boolean typeBeforeDot = true;
        boolean withContextReceiver = this.at(KtTokens.CONTEXT_KEYWORD) && lookahead == KtTokens.LPAR;
        boolean wasFunctionTypeParsed = false;
        PsiBuilder.Marker contextReceiversStart = this.mark();
        if (withContextReceiver) {
            this.parseContextReceiverList(false);
        }
        PsiBuilder.Marker typeElementMarker = this.mark();
        if (this.at(KtTokens.IDENTIFIER) && (lookahead != KtTokens.DOT || lookahead2 != KtTokens.IDENTIFIER) && lookahead != KtTokens.LT && this.at(KtTokens.DYNAMIC_KEYWORD)) {
            PsiBuilder.Marker dynamicType = this.mark();
            this.advance();
            dynamicType.done(KtNodeTypes.DYNAMIC_TYPE);
        } else if (this.at(KtTokens.IDENTIFIER) || this.at(KtTokens.PACKAGE_KEYWORD) || this.atParenthesizedMutableForPlatformTypes(0)) {
            this.parseUserType();
        } else if (this.at(KtTokens.LPAR)) {
            PsiBuilder.Marker functionOrParenthesizedType = this.mark();
            this.advance();
            this.parseTypeRefContents(TokenSet.EMPTY, true).drop();
            if (this.at(KtTokens.RPAR) && this.lookahead(1) != KtTokens.ARROW) {
                this.advance();
                functionOrParenthesizedType.drop();
            } else {
                functionOrParenthesizedType.rollbackTo();
                this.parseFunctionType(contextReceiversStart.precede());
                wasFunctionTypeParsed = true;
            }
        } else {
            this.errorWithRecovery("Type expected", TokenSet.orSet(TOP_LEVEL_DECLARATION_FIRST, TokenSet.create(KtTokens.EQ, KtTokens.COMMA, KtTokens.GT, KtTokens.RBRACKET, KtTokens.DOT, KtTokens.RPAR, KtTokens.RBRACE, KtTokens.LBRACE, KtTokens.SEMICOLON), extraRecoverySet));
            typeBeforeDot = false;
        }
        this.myBuilder.disableJoiningComplexTokens();
        typeElementMarker = this.parseNullableTypeSuffix(typeElementMarker);
        this.myBuilder.restoreJoiningComplexTokensState();
        boolean wasIntersection = false;
        if (allowSimpleIntersectionTypes && this.at(KtTokens.AND)) {
            PsiBuilder.Marker leftTypeRef = typeElementMarker;
            typeElementMarker = typeElementMarker.precede();
            PsiBuilder.Marker intersectionType = leftTypeRef.precede();
            leftTypeRef.done(KtNodeTypes.TYPE_REFERENCE);
            this.advance();
            this.parseTypeRef(extraRecoverySet, true);
            intersectionType.done(KtNodeTypes.INTERSECTION_TYPE);
            wasIntersection = true;
        }
        if (typeBeforeDot && this.at(KtTokens.DOT) && !wasIntersection && !wasFunctionTypeParsed) {
            PsiBuilder.Marker functionType = contextReceiversStart.precede();
            PsiBuilder.Marker receiverTypeRef = typeElementMarker.precede();
            PsiBuilder.Marker receiverType = receiverTypeRef.precede();
            receiverTypeRef.done(KtNodeTypes.TYPE_REFERENCE);
            receiverType.done(KtNodeTypes.FUNCTION_TYPE_RECEIVER);
            this.advance();
            if (this.at(KtTokens.LPAR)) {
                this.parseFunctionType(functionType);
            } else {
                functionType.drop();
                this.error("Expecting function type");
            }
            wasFunctionTypeParsed = true;
        }
        if (withContextReceiver && !wasFunctionTypeParsed) {
            this.errorWithRecovery("Function type expected expected", TokenSet.orSet(TOP_LEVEL_DECLARATION_FIRST, TokenSet.create(KtTokens.EQ, KtTokens.COMMA, KtTokens.GT, KtTokens.RBRACKET, KtTokens.DOT, KtTokens.RPAR, KtTokens.RBRACE, KtTokens.LBRACE, KtTokens.SEMICOLON), extraRecoverySet));
        }
        typeElementMarker.drop();
        contextReceiversStart.drop();
        return typeRefMarker;
    }

    @NotNull
    private PsiBuilder.Marker parseNullableTypeSuffix(@NotNull PsiBuilder.Marker typeElementMarker) {
        if (typeElementMarker == null) {
            KotlinParsing.$$$reportNull$$$0(16);
        }
        while (this.at(KtTokens.QUEST) && this.myBuilder.rawLookup(1) != KtTokens.COLON) {
            PsiBuilder.Marker precede = typeElementMarker.precede();
            this.advance();
            typeElementMarker.done(KtNodeTypes.NULLABLE_TYPE);
            typeElementMarker = precede;
        }
        PsiBuilder.Marker marker = typeElementMarker;
        if (marker == null) {
            KotlinParsing.$$$reportNull$$$0(17);
        }
        return marker;
    }

    private void parseUserType() {
        PsiBuilder.Marker userType = this.mark();
        if (this.at(KtTokens.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker keyword = this.mark();
            this.advance();
            keyword.error("Expecting an element");
            this.expect(KtTokens.DOT, "Expecting '.'", TokenSet.create(KtTokens.IDENTIFIER, KtTokens.LBRACE, KtTokens.RBRACE));
        }
        PsiBuilder.Marker reference2 = this.mark();
        while (true) {
            this.recoverOnParenthesizedWordForPlatformTypes(0, "Mutable", true);
            if (!this.expect(KtTokens.IDENTIFIER, "Expecting type name", TokenSet.orSet(KotlinExpressionParsing.EXPRESSION_FIRST, KotlinExpressionParsing.EXPRESSION_FOLLOW, DECLARATION_FIRST))) {
                reference2.drop();
                break;
            }
            reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
            this.parseTypeArgumentList();
            this.recoverOnPlatformTypeSuffix();
            if (!this.at(KtTokens.DOT) || this.lookahead(1) == KtTokens.LPAR && !this.atParenthesizedMutableForPlatformTypes(1)) break;
            PsiBuilder.Marker precede = userType.precede();
            userType.done(KtNodeTypes.USER_TYPE);
            userType = precede;
            this.advance();
            reference2 = this.mark();
        }
        userType.done(KtNodeTypes.USER_TYPE);
    }

    private boolean atParenthesizedMutableForPlatformTypes(int offset) {
        return this.recoverOnParenthesizedWordForPlatformTypes(offset, "Mutable", false);
    }

    private boolean recoverOnParenthesizedWordForPlatformTypes(int offset, String word, boolean consume) {
        if (this.lookahead(offset) == KtTokens.LPAR && this.lookahead(offset + 1) == KtTokens.IDENTIFIER && this.lookahead(offset + 2) == KtTokens.RPAR && this.lookahead(offset + 3) == KtTokens.IDENTIFIER) {
            PsiBuilder.Marker error = this.mark();
            this.advance(offset);
            this.advance();
            if (!word.equals(this.myBuilder.getTokenText())) {
                error.rollbackTo();
                return false;
            }
            this.advance();
            this.advance();
            if (consume) {
                error.error("Unexpected tokens");
            } else {
                error.rollbackTo();
            }
            return true;
        }
        return false;
    }

    private void recoverOnPlatformTypeSuffix() {
        if (this.at(KtTokens.EXCL)) {
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error("Unexpected token");
        }
    }

    private void parseTypeArgumentList() {
        if (!this.at(KtTokens.LT)) {
            return;
        }
        PsiBuilder.Marker list = this.mark();
        this.tryParseTypeArgumentList(TokenSet.EMPTY);
        list.done(KtNodeTypes.TYPE_ARGUMENT_LIST);
    }

    boolean tryParseTypeArgumentList(TokenSet extraRecoverySet) {
        this.myBuilder.disableNewlines();
        this.advance();
        do {
            PsiBuilder.Marker projection = this.mark();
            this.recoverOnParenthesizedWordForPlatformTypes(0, "out", true);
            this.parseTypeArgumentModifierList();
            if (this.at(KtTokens.MUL)) {
                this.advance();
            } else {
                this.parseTypeRef(extraRecoverySet);
            }
            projection.done(KtNodeTypes.TYPE_PROJECTION);
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        } while (!this.at(KtTokens.GT));
        boolean atGT = this.at(KtTokens.GT);
        if (!atGT) {
            this.error("Expecting a '>'");
        } else {
            this.advance();
        }
        this.myBuilder.restoreNewlinesState();
        return atGT;
    }

    private void parseFunctionType(PsiBuilder.Marker functionType) {
        this.parseFunctionTypeContents(functionType).done(KtNodeTypes.FUNCTION_TYPE);
    }

    private PsiBuilder.Marker parseFunctionTypeContents(PsiBuilder.Marker functionType) {
        assert (this._at(KtTokens.LPAR)) : this.tt();
        this.parseValueParameterList(true, true, TokenSet.EMPTY);
        this.expect(KtTokens.ARROW, "Expecting '->' to specify return type of a function type", TYPE_REF_FIRST);
        this.parseTypeRef();
        return functionType;
    }

    private void parseValueParameterList(boolean isFunctionTypeContents, boolean typeRequired, TokenSet recoverySet) {
        assert (this._at(KtTokens.LPAR));
        PsiBuilder.Marker parameters2 = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (!this.at(KtTokens.RPAR) && !this.atSet(recoverySet)) {
            while (true) {
                if (this.at(KtTokens.COMMA)) {
                    this.errorAndAdvance("Expecting a parameter declaration");
                } else if (this.at(KtTokens.RPAR)) break;
                if (isFunctionTypeContents) {
                    if (!this.tryParseValueParameter(typeRequired)) {
                        PsiBuilder.Marker valueParameter2 = this.mark();
                        this.parseFunctionTypeValueParameterModifierList();
                        this.parseTypeRef();
                        KotlinParsing.closeDeclarationWithCommentBinders(valueParameter2, KtNodeTypes.VALUE_PARAMETER, false);
                    }
                } else {
                    this.parseValueParameter(typeRequired);
                }
                if (this.at(KtTokens.COMMA)) {
                    this.advance();
                    continue;
                }
                if (this.at(KtTokens.COLON)) continue;
                if (!this.at(KtTokens.RPAR)) {
                    this.error("Expecting comma or ')'");
                }
                if (!this.atSet(isFunctionTypeContents ? LAMBDA_VALUE_PARAMETER_FIRST : VALUE_PARAMETER_FIRST)) break;
            }
        }
        this.expect(KtTokens.RPAR, "Expecting ')'", recoverySet);
        this.myBuilder.restoreNewlinesState();
        parameters2.done(KtNodeTypes.VALUE_PARAMETER_LIST);
    }

    private boolean tryParseValueParameter(boolean typeRequired) {
        return this.parseValueParameter(true, typeRequired);
    }

    public void parseValueParameter(boolean typeRequired) {
        this.parseValueParameter(false, typeRequired);
    }

    private boolean parseValueParameter(boolean rollbackOnFailure, boolean typeRequired) {
        PsiBuilder.Marker parameter2 = this.mark();
        this.parseModifierList(NO_MODIFIER_BEFORE_FOR_VALUE_PARAMETER);
        if (this.at(KtTokens.VAR_KEYWORD) || this.at(KtTokens.VAL_KEYWORD)) {
            this.advance();
        }
        if (!this.parseFunctionParameterRest(typeRequired) && rollbackOnFailure) {
            parameter2.rollbackTo();
            return false;
        }
        KotlinParsing.closeDeclarationWithCommentBinders(parameter2, KtNodeTypes.VALUE_PARAMETER, false);
        return true;
    }

    private boolean parseFunctionParameterRest(boolean typeRequired) {
        boolean noErrors = true;
        if (this.at(KtTokens.IDENTIFIER) && this.lookahead(1) == KtTokens.LT || this.at(KtTokens.COLON)) {
            this.error("Parameter name expected");
            if (this.at(KtTokens.COLON)) {
                this.advance();
            } else {
                noErrors = false;
            }
            this.parseTypeRef();
        } else {
            this.expect(KtTokens.IDENTIFIER, "Parameter name expected", PARAMETER_NAME_RECOVERY_SET);
            if (this.at(KtTokens.COLON)) {
                this.advance();
                if (this.at(KtTokens.IDENTIFIER) && this.lookahead(1) == KtTokens.COLON) {
                    this.error("Type reference expected");
                    return false;
                }
                this.parseTypeRef();
            } else if (typeRequired) {
                this.errorWithRecovery("Parameters must have type annotation", PARAMETER_NAME_RECOVERY_SET);
                noErrors = false;
            }
        }
        if (this.at(KtTokens.EQ)) {
            this.advance();
            this.myExpressionParsing.parseExpression();
        }
        return noErrors;
    }

    @Override
    protected KotlinParsing create(SemanticWhitespaceAwarePsiBuilder builder2) {
        return KotlinParsing.createForTopLevel(builder2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 15: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParsingModeForObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationParsingMode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noModifiersBefore";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierKeywords";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationParsingMode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierDetector";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/parsing/KotlinParsing";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElementMarker";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/parsing/KotlinParsing";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFunction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNullableTypeSuffix";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseCommonDeclaration";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseAnnotationsList";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doParseModifierListBody";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doParseModifierList";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryParseModifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseMemberDeclarationRest";
                break;
            }
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseNullableTypeSuffix";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static enum AnnotationParsingMode {
        DEFAULT(false, true, false, false),
        FILE_ANNOTATIONS_BEFORE_PACKAGE(true, true, false, false),
        FILE_ANNOTATIONS_WHEN_PACKAGE_OMITTED(true, true, false, false),
        TYPE_CONTEXT(false, true, true, false),
        WITH_SIGNIFICANT_WHITESPACE_BEFORE_ARGUMENTS(false, true, true, true),
        NO_ANNOTATIONS(false, false, false, false);

        final boolean isFileAnnotationParsingMode;
        final boolean allowAnnotations;
        final boolean withSignificantWhitespaceBeforeArguments;
        final boolean typeContext;

        private AnnotationParsingMode(boolean isFileAnnotationParsingMode, boolean allowAnnotations, boolean typeContext2, boolean withSignificantWhitespaceBeforeArguments) {
            this.isFileAnnotationParsingMode = isFileAnnotationParsingMode;
            this.allowAnnotations = allowAnnotations;
            this.typeContext = typeContext2;
            this.withSignificantWhitespaceBeforeArguments = withSignificantWhitespaceBeforeArguments;
        }
    }

    static class ModifierDetector
    implements Consumer<IElementType> {
        private boolean enumDetected = false;
        private boolean companionDetected = false;

        ModifierDetector() {
        }

        @Override
        public void consume(IElementType item) {
            if (item == KtTokens.ENUM_KEYWORD) {
                this.enumDetected = true;
            } else if (item == KtTokens.COMPANION_KEYWORD) {
                this.companionDetected = true;
            }
        }

        public boolean isEnumDetected() {
            return this.enumDetected;
        }

        public boolean isCompanionDetected() {
            return this.companionDetected;
        }
    }

    private static enum PropertyComponentKind {
        GET,
        SET,
        FIELD;


        static class Collector {
            private final boolean[] collected = new boolean[]{false, false, false};

            Collector() {
            }

            public void collect(PropertyComponentKind kind) {
                this.collected[kind.ordinal()] = true;
            }

            public boolean contains(PropertyComponentKind kind) {
                return this.collected[kind.ordinal()];
            }
        }
    }

    static enum DeclarationParsingMode {
        MEMBER_OR_TOPLEVEL(false, true, true),
        LOCAL(true, false, false),
        SCRIPT_TOPLEVEL(true, true, false);

        public final boolean destructuringAllowed;
        public final boolean accessorsAllowed;
        public final boolean canBeEnumUsedAsSoftKeyword;

        private DeclarationParsingMode(boolean destructuringAllowed, boolean accessorsAllowed, boolean canBeEnumUsedAsSoftKeyword) {
            this.destructuringAllowed = destructuringAllowed;
            this.accessorsAllowed = accessorsAllowed;
            this.canBeEnumUsedAsSoftKeyword = canBeEnumUsedAsSoftKeyword;
        }
    }

    private static enum ParseEnumEntryResult {
        FAILED,
        NO_DELIMITER,
        COMMA_DELIMITER,
        SEMICOLON_DELIMITER;

    }

    public static enum NameParsingMode {
        REQUIRED,
        ALLOWED,
        PROHIBITED;

    }
}

