/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirPropertyInitializationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirPropertyInitializationChecker INSTANCE = new FirPropertyInitializationChecker();

    private FirPropertyInitializationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Set declaredLater = new LinkedHashSet();
        FirVisitorVoid visitor2 = new FirVisitorVoid(declaredLater, reporter, context2){
            final /* synthetic */ Set<FirPropertySymbol> $declaredLater;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            {
                this.$declaredLater = $declaredLater;
                this.$reporter = $reporter;
                this.$context = $context;
            }

            public void visitElement(FirElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }

            public void visitConstructor(FirConstructor constructor) {
                Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            }

            public void visitSimpleFunction(FirSimpleFunction simpleFunction) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            }

            public void visitPropertyAccessor(FirPropertyAccessor propertyAccessor) {
                Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
            }

            public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction) {
                Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
            }

            public void visitRegularClass(FirRegularClass regularClass) {
                Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            }

            public void visitEnumEntry(FirEnumEntry enumEntry) {
                Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            }

            public void visitVariableAssignment(FirVariableAssignment variableAssignment) {
                Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
                variableAssignment.acceptChildren(this);
                FirReference firReference = ReferenceUtilsKt.getCalleeReference(variableAssignment);
                FirCallableSymbol firCallableSymbol = firReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null) : null;
                FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
                if (firPropertySymbol == null) {
                    return;
                }
                FirPropertySymbol propertySymbol = firPropertySymbol;
                if (!this.$declaredLater.contains(propertySymbol)) {
                    return;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)variableAssignment.getLValue().getSource(), FirErrors.INSTANCE.getINITIALIZATION_BEFORE_DECLARATION(), (Object)propertySymbol, (DiagnosticContext)this.$context, null, 16, null);
            }
        };
        for (FirDeclaration member : CollectionsKt.asReversed(declaration2.getDeclarations())) {
            if (!((Collection)declaredLater).isEmpty()) {
                member.accept(visitor2);
            }
            if (!(member instanceof FirProperty)) continue;
            declaredLater.add(((FirProperty)member).getSymbol());
        }
    }
}

