/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

class Limiter<T>
extends AbstractCollection<T> {
    private T[] data;
    private final int limit;
    private final Comparator<? super T> comparator;
    private int size;
    private boolean initial = true;

    public Limiter(int limit, Comparator<? super T> comparator) {
        this.limit = limit;
        this.comparator = comparator;
        this.data = new Object[Math.min(1000, limit) * 2];
    }

    public boolean put(T t2) {
        if (this.initial) {
            if (this.size == this.data.length) {
                if (this.size < this.limit * 2) {
                    Object[] newData = new Object[Math.min(this.limit, this.size) * 2];
                    System.arraycopy(this.data, 0, newData, 0, this.size);
                    this.data = newData;
                } else {
                    Arrays.sort(this.data, this.comparator);
                    this.initial = false;
                    this.size = this.limit;
                }
                this.put(t2);
            } else {
                this.data[this.size++] = t2;
            }
            return true;
        }
        if (this.size == this.data.length) {
            this.sortTail();
        }
        if (this.comparator.compare(t2, this.data[this.limit - 1]) < 0) {
            this.data[this.size++] = t2;
            return true;
        }
        return false;
    }

    public Limiter<T> putAll(Limiter<T> ls) {
        int i2;
        if (!ls.initial) {
            for (i2 = 0; i2 < this.limit && this.put(ls.data[i2]); ++i2) {
            }
            i2 = this.limit;
        }
        while (i2 < ls.size) {
            this.put(ls.data[i2]);
            ++i2;
        }
        return this;
    }

    private void sortTail() {
        T[] d2 = this.data;
        int l2 = this.limit;
        int s2 = this.size;
        Comparator<T> cmp = this.comparator;
        Arrays.sort(d2, l2, s2, cmp);
        if (cmp.compare(d2[s2 - 1], d2[0]) < 0) {
            System.arraycopy(d2, 0, d2, s2 - l2, 2 * l2 - s2);
            System.arraycopy(d2, l2, d2, 0, s2 - l2);
        } else {
            Object[] buf = new Object[l2];
            int i2 = 0;
            int j2 = l2;
            int k2 = 0;
            while (i2 < l2 - 1 && k2 < l2 && j2 < s2) {
                if (cmp.compare(d2[i2], d2[j2]) <= 0) {
                    buf[k2++] = d2[i2++];
                    continue;
                }
                buf[k2++] = d2[j2++];
            }
            if (k2 < l2) {
                System.arraycopy(d2, i2 < l2 - 1 ? i2 : j2, d2, k2, l2 - k2);
            }
            System.arraycopy(buf, 0, d2, 0, k2);
        }
        this.size = l2;
    }

    public void sort() {
        if (this.initial) {
            Arrays.sort(this.data, 0, this.size, this.comparator);
        } else if (this.size > this.limit) {
            this.sortTail();
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOfRange(this.data, 0, this.size());
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.data).subList(0, this.size()).iterator();
    }

    @Override
    public int size() {
        return this.initial && this.size < this.limit ? this.size : this.limit;
    }
}

