/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.DynamicBundle;
import com.intellij.openapi.util.io.FileUtil;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001e\u0010\u0016\u001a\u00020\f*\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u001c\u0010\u0019\u001a\u00020\f*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/LocalizationUtil;", "", "()V", "LOCALIZATION_FOLDER_NAME", "", "isL10nPluginInitialized", "", "()Z", "setL10nPluginInitialized", "(Z)V", "getFolderLocalizedPaths", "", "Ljava/nio/file/Path;", "path", "specialLocale", "Ljava/util/Locale;", "getLocalizedPaths", "getPluginClassLoader", "Ljava/lang/ClassLoader;", "getResourceAsStream", "Ljava/io/InputStream;", "defaultLoader", "convertPathToLocaleSuffixUsage", "locale", "withRegion", "convertToLocalizationFolderUsage", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalizationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/util/LocalizationUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class LocalizationUtil {
    @NotNull
    public static final LocalizationUtil INSTANCE = new LocalizationUtil();
    private static volatile boolean isL10nPluginInitialized;
    @NotNull
    private static final String LOCALIZATION_FOLDER_NAME = "localization";

    private LocalizationUtil() {
    }

    public final boolean isL10nPluginInitialized() {
        return isL10nPluginInitialized;
    }

    public final void setL10nPluginInitialized(boolean bl2) {
        isL10nPluginInitialized = bl2;
    }

    private final ClassLoader getPluginClassLoader() {
        Object object = DynamicBundle.findLanguageBundle();
        return object != null && (object = ((DynamicBundle.LanguageBundleEP)object).pluginDescriptor) != null ? object.getPluginClassLoader() : null;
    }

    private final Path convertToLocalizationFolderUsage(Path $this$convertToLocalizationFolderUsage, Locale locale, boolean withRegion) {
        Path path = Paths.get(LOCALIZATION_FOLDER_NAME, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path result2 = path.resolve(locale.getLanguage());
        if (withRegion) {
            String string2 = locale.getCountry();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCountry(...)");
            if (((CharSequence)string2).length() > 0) {
                result2 = result2.resolve(locale.getCountry());
            }
        }
        Path path2 = result2 = result2.resolve($this$convertToLocalizationFolderUsage);
        Intrinsics.checkNotNull((Object)path2);
        return path2;
    }

    private final Path convertPathToLocaleSuffixUsage(Path $this$convertPathToLocaleSuffixUsage, Locale locale, boolean withRegion) {
        Path path;
        if (locale == null) {
            return $this$convertPathToLocaleSuffixUsage;
        }
        StringBuilder fileName2 = new StringBuilder(PathsKt.getNameWithoutExtension((Path)$this$convertPathToLocaleSuffixUsage));
        String extension = PathsKt.getExtension((Path)$this$convertPathToLocaleSuffixUsage);
        Path path2 = $this$convertPathToLocaleSuffixUsage.getParent();
        if (path2 == null) {
            Path path3 = Paths.get("", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else {
            path = path2;
        }
        Path foldersPath = path;
        String language = locale.getLanguage();
        Intrinsics.checkNotNull((Object)language);
        if (!(((CharSequence)language).length() == 0)) {
            fileName2.append('_').append(language);
            String country = locale.getCountry();
            Intrinsics.checkNotNull((Object)country);
            if (((CharSequence)country).length() > 0 && withRegion) {
                fileName2.append('_').append(country);
            }
        }
        if (((CharSequence)extension).length() > 0) {
            fileName2.append(".").append(extension);
        }
        Path result2 = foldersPath.resolve(fileName2.toString());
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    @JvmOverloads
    @Nullable
    public final InputStream getResourceAsStream(@Nullable ClassLoader defaultLoader, @NotNull Path path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Locale locale = specialLocale;
        if (locale == null) {
            Locale locale2 = DynamicBundle.getLocale();
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getLocale(...)");
        }
        Locale locale3 = locale;
        List<Path> localizedPaths = this.getLocalizedPaths(path, locale3);
        for (Path localizedPath : localizedPaths) {
            String pathString;
            InputStream inputStream;
            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName(((Object)localizedPath).toString()), (String)"toSystemIndependentName(...)");
            Object object = this.getPluginClassLoader();
            if (object != null && (inputStream = ((ClassLoader)object).getResourceAsStream(pathString)) != null) {
                InputStream it = inputStream;
                boolean bl2 = false;
                return it;
            }
            if (defaultLoader == null || (object = defaultLoader.getResourceAsStream(pathString)) == null) continue;
            Object it = object;
            boolean bl3 = false;
            return it;
        }
        return null;
    }

    public static /* synthetic */ InputStream getResourceAsStream$default(LocalizationUtil localizationUtil, ClassLoader classLoader, Path path, Locale locale, int n2, Object object) {
        if ((n2 & 4) != 0) {
            locale = null;
        }
        return localizationUtil.getResourceAsStream(classLoader, path, locale);
    }

    @JvmOverloads
    @NotNull
    public final List<Path> getLocalizedPaths(@NotNull Path path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Locale locale = specialLocale;
        if (locale == null) {
            Locale locale2 = DynamicBundle.getLocale();
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getLocale(...)");
        }
        Locale locale3 = locale;
        Object[] objectArray = new Path[]{this.convertToLocalizationFolderUsage(path, locale3, true), this.convertPathToLocaleSuffixUsage(path, locale3, true), this.convertToLocalizationFolderUsage(path, locale3, false), this.convertPathToLocaleSuffixUsage(path, locale3, false), path};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static /* synthetic */ List getLocalizedPaths$default(LocalizationUtil localizationUtil, Path path, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getLocalizedPaths(path, locale);
    }

    @JvmOverloads
    @NotNull
    public final List<Path> getFolderLocalizedPaths(@NotNull Path path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Locale locale = specialLocale;
        if (locale == null) {
            Locale locale2 = DynamicBundle.getLocale();
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getLocale(...)");
        }
        Locale locale3 = locale;
        Object[] objectArray = new Path[]{this.convertToLocalizationFolderUsage(path, locale3, true), this.convertToLocalizationFolderUsage(path, locale3, false)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static /* synthetic */ List getFolderLocalizedPaths$default(LocalizationUtil localizationUtil, Path path, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getFolderLocalizedPaths(path, locale);
    }

    @JvmOverloads
    @Nullable
    public final InputStream getResourceAsStream(@Nullable ClassLoader defaultLoader, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalizationUtil.getResourceAsStream$default(this, defaultLoader, path, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final List<Path> getLocalizedPaths(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalizationUtil.getLocalizedPaths$default(this, path, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final List<Path> getFolderLocalizedPaths(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalizationUtil.getFolderLocalizedPaths$default(this, path, null, 2, null);
    }
}

